ALTER TABLE `{dbpre}ptx_item` ADD COLUMN `color` VARCHAR(20) NULL DEFAULT '';
ALTER TABLE `{dbpre}ptx_item` ADD KEY `idx_color` (`color`);


ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `from_user_id` int(11) NOT NULL DEFAULT '0';
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `from_nickname` varchar(80) NOT NULL DEFAULT 'system';
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `to_nickname` varchar(80) NOT NULL DEFAULT '';
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `share_id` int(11) NULL;
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `share_title` varchar(255) NULL;
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `album_id` int(11) NULL;
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `album_title` varchar(255) NULL;
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `related_id` int(11) NULL;
ALTER TABLE `{dbpre}ptx_event_log` ADD COLUMN `related_title` varchar(255) NULL;

ALTER TABLE `{dbpre}ptx_event_log` ADD  KEY `idx_from_user_id` (`from_user_id`);
ALTER TABLE `{dbpre}ptx_event_log` ADD KEY `idx_share_id` (`share_id`);
ALTER TABLE `{dbpre}ptx_event_log` ADD KEY `idx_album_id` (`album_id`);

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_topic` (
  `topic_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` INT(11) NULL DEFAULT 0 ,
  `topic_title` VARCHAR(255) NOT NULL ,
  `topic_desc` text NULL,
  `create_time` int(10) NOT NULL,
  `user_id` INT(11) NOT NULL ,
  `keyword` TEXT NULL ,
  `keyword_search` TEXT NULL ,
  `total_share` INT(11) NULL DEFAULT 0 ,
  `total_like` INT(11) NULL DEFAULT 0 ,
  PRIMARY KEY (`topic_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`category_id`),
  FULLTEXT KEY `idx_keyword_search` (`keyword_search`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_favorite_topic` (
  `favorite_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `topic_id` int(11) NOT NULL,
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`favorite_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_topic_id` (`topic_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_group` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` INT(11) NULL DEFAULT 0 ,
  `group_title` VARCHAR(255) NOT NULL ,
  `group_desc` text NULL,
  `create_time` int(10) NOT NULL,
  `user_id` INT(11) NOT NULL ,
  `keyword` TEXT NULL ,
  `keyword_search` TEXT NULL ,
  `total_member` INT(11) NULL DEFAULT 0 ,
  PRIMARY KEY (`group_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`category_id`),
  FULLTEXT KEY `idx_keyword_search` (`keyword_search`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_user_group` (
  `user_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `is_admin` tinyint(2) NOT NULL DEFAULT '0',
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`user_group_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_group_id` (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;


CREATE TABLE IF NOT EXISTS `{dbpre}ptx_medal` (
  `medal_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `available` tinyint(1) NOT NULL DEFAULT '0',
  `image` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL,
  `credit` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `price` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`medal_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_user_medal` (
  `user_id` mediumint(8) unsigned NOT NULL,
  `medal_id` smallint(6) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`medal_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_store_category` (
  `store_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_category_name` varchar(80) NOT NULL,
  `is_open` tinyint(4) NULL DEFAULT '1',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `display_order` int(11) NOT NULL DEFAULT '100',
  PRIMARY KEY (`store_category_id`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

INSERT INTO `{dbpre}ptx_store_category` (`store_category_id`, `store_category_name`, `is_open`, `parent_id`, `display_order`) VALUES
(1, '生活服务', '1', 0, 100),
(2, '网络购物', '1', 0, 100),
(3, '美食餐饮', '1', 0, 100),
(4, '家居建材', '1', 0, 100),
(5, '休闲娱乐', '1', 0, 100),

(6, '婚嫁', '1', 1, 100),
(7, '母婴', '1', 1, 100),
(8, '美容美发', '1', 1, 100),
(9, '摄影写真', '1', 1, 100),
(10, '宠物', '1', 1, 100),

(11, '服装服饰', '1', 2, 100),
(12, '数码家电', '1', 2, 100),
(13, '虚拟产品', '1', 2, 100),
(14, '食品', '1', 2, 100),
(15, '家居日用', '1', 2, 100),

(16, '自助', '1', 3, 100),
(17, '料理', '1', 3, 100),
(18, '餐厅', '1', 3, 100),
(19, '茶室', '1', 3, 100),
(20, '咖啡馆', '1', 3, 100),

(21, '装修装饰', '1', 4, 100),
(22, '家政保姆', '1', 4, 100),
(23, '家具', '1', 4, 100),
(24, '建材', '1', 4, 100),
(25, '家装设计', '1', 4, 100),

(26, '酒吧', '1', 5, 100),
(27, 'KTV', '1', 5, 100),
(28, '健身', '1', 5, 100),
(29, '旅游度假', '1', 5, 100),
(30, '户外', '1', 5, 100);



ALTER TABLE `{dbpre}ptx_staruser` CHANGE COLUMN `category_id` `medal_id` INT(11) NOT NULL  ;
ALTER TABLE `{dbpre}ptx_apply`  ADD COLUMN `medal_id` INT(11) NULL;
ALTER TABLE `{dbpre}ptx_apply`  ADD COLUMN `store_category_id` INT(11) NULL;
ALTER TABLE `{dbpre}ptx_album` ADD COLUMN `album_desc` TEXT NULL;

ALTER TABLE `{dbpre}ptx_goodshop` ADD COLUMN `store_name` VARCHAR(100) NULL , 
ADD COLUMN `province` VARCHAR(20) NULL, 
ADD COLUMN `city` VARCHAR(20) NULL, 
ADD COLUMN `location` VARCHAR(20) NULL, 
ADD COLUMN `address` VARCHAR(255) NULL, 
ADD COLUMN `phone` VARCHAR(45) NULL, 
ADD COLUMN `shop_time` VARCHAR(45) NULL,
CHANGE COLUMN `category_id` `store_category_id` INT(11) NOT NULL;


ALTER TABLE `{dbpre}ptx_message` ADD COLUMN `is_read` TINYINT NULL DEFAULT 0 ;
ALTER TABLE `{dbpre}ptx_user` DROP COLUMN `total_messages` ;
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `domain` VARCHAR(80) NULL;
ALTER TABLE `{dbpre}ptx_user` ADD KEY `idx_domain` (`domain`);