CREATE TABLE `{dbpre}ptx_usergroup` (
  `usergroup_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `usergroup_type` enum('system','special','member') NOT NULL DEFAULT 'member',
  `usergroup_title` varchar(255) NOT NULL DEFAULT '',
  `credits_lower` int(10) NOT NULL DEFAULT '0',
  `credits_higher` int(10) NOT NULL DEFAULT '0',
  `stars` tinyint(3) NOT NULL DEFAULT '0',
  `color` varchar(255) NOT NULL DEFAULT '',
  `icon` varchar(255) NOT NULL DEFAULT '',
  `allow_visit` tinyint(1) NOT NULL DEFAULT '1',
  `allow_share` tinyint(1) NOT NULL DEFAULT '1',
  `need_verify` tinyint(1) NOT NULL DEFAULT '1',
  `other_permission` TEXT NULL,
  PRIMARY KEY (`usergroup_id`),
  KEY `idx_credits_range` (`credits_higher`,`credits_lower`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;


INSERT INTO `{dbpre}ptx_usergroup` (`usergroup_id`,`usergroup_type`,`usergroup_title`,`credits_lower`,`credits_higher`,`stars`,`color`,`icon`,`allow_visit`,`allow_share`,`need_verify`,`other_permission`) VALUES 
(1,'system','admin','0','0','9','','','1','1','1',NULL),
(2,'system','editer','0','0','8','','','1','1','1',NULL),
(3,'system','banned_visit','0','0','0','','','1','1','1',NULL),
(4,'system','banned_post','0','0','0','','','1','1','1',NULL),
(5,'system','waiting_verify','0','0','0','','','1','1','1',NULL),
(6,'system','guest','0','0','0','','','1','1','1',NULL),
(7,'member','level_1','0','50','1','','','1','1','1',NULL),
(8,'member','level_2','50','200','2','','','1','1','1',NULL),
(9,'member','level_3','200','500','3','','','1','1','1',NULL),
(10,'member','level_4','500','1000','4','','','1','1','1',NULL),
(11,'member','level_5','1000','3000','6','','','1','1','1',NULL),
(12,'member','level_6','3000','9999999','8','','','1','1','1',NULL);


CREATE TABLE IF NOT EXISTS `{dbpre}ptx_event_log` (
  `event_log_id` int(11) NOT NULL AUTO_INCREMENT,
  `event_type` enum('warn','alert','reward') NOT NULL DEFAULT 'alert',
  `event_code` varchar(50) NOT NULL DEFAULT '',
  `to_user_id` int(11) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`event_log_id`),
  KEY `idx_event_log_id` (`event_log_id`),
  KEY `idx_event_code` (`event_code`),
  KEY `idx_is_read` (`is_read`),
  KEY `idx_to_user_id` (`to_user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

ALTER TABLE `{dbpre}ptx_category` ADD COLUMN `is_home` tinyint(1) NULL DEFAULT '1';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `last_login_time` int(10) NULL;
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `usergroup_id` SMALLINT(6) NULL DEFAULT '7';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `credits` INT(10) NULL DEFAULT '0';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `ext_credits_1` INT(10) NULL DEFAULT '0';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `ext_credits_2` INT(10) NULL DEFAULT '0';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `ext_credits_3` INT(10) NULL DEFAULT '0';