<?php
/**
 *      [PinTuXiu] (C)2001-2099 ONightjar.com Pintuxiu.com.
 *      This is NOT a freeware, use is subject to license terms
 */
class welcome extends basecontroller
{

	public function __construct() {
		parent::__construct();
	}

	public function index(){
		$this->albums = $this->getHotestAlbum();
		$ptx_staruser = spClass('ptx_staruser');
		$staruser_cachetime = $this->settings['optimizer_setting']['cache_time_star'];
		$this->starusers = $ptx_staruser->get_staruser_cache($staruser_cachetime);
		$ptx_goodshop = spClass('ptx_goodshop');
		$this->goodshops = $ptx_goodshop->get_goodshop_cache();
		//if($this->settings['ui_layout']['count_or_lastest']=='lastest'){
			$this->shares = $this->getLastest20();
		//}else{
			$this->count = $this->getPtxCount();
		//}
		$this->topics = $this->getLastestTopics();
		$this->hotusers = $this->getHotestUser();
		$this->today_stars = $this->getTodayStarUser();
		$this->prepareView();
		$this->output("welcome/index");
	}

	private function prepareView(){
		$categories = $this->categories;
		foreach ($categories as $key=>$category){
			if($category['is_home']){
				$this->category = $category;
				$style = $category['style']?$category['style']:'home_1';
				$categories[$key]['home_view'] = $this->render('common/'.$style);
			}
		}
		$this->categories = $categories;
	}
	
	private function getLastestTopics(){
		$topics = spAccess('r', 'lastest_topics');
		if(!$topics){
			$ptx_topic = spClass("ptx_topic");
			$topics = $ptx_topic->search(null,1,4,null," ptx_topic.create_time DESC ");
			$time = $this->settings['optimizer_setting']['cache_time_topic'];
			$time = $time?$time:3600;
			spAccess('w','lastest_topics',$topics,$time);
		}
		return $topics;
		
	}

	private function getPtxCount(){
		$result = spAccess('r', 'ptx_count');
		if(!$result){
			$this->update_count();
			$result = spAccess('r', 'ptx_count');
		}
		return $result;
	}

	private function getLastest20(){
		$result = spAccess('r', 'lastest_shares');
		if(!$result){
			$ptx_share = spClass('ptx_share');
			$conditions['orgin_post']=1;
			$conditions['type']='noarticle';
			$result = $ptx_share->search($conditions,1,20);
			spAccess('w','lastest_shares',$result,300);
		}
		return $result;
	}

	private function getHotestAlbum(){
		$result = spAccess('r', 'hotest_album');
		if(!$result){
			$ptx_album = spClass('ptx_album');
			$result = $ptx_album->search(NULL,1,4,NULL,' ptx_album.total_like DESC ');
			$time = $this->settings['optimizer_setting']['cache_time_album'];
			spAccess('w','hotest_album',$result,$time);
		}
		return $result;
	}
	
	private function getHotestUser(){
		$users = spAccess('r', 'hotest_user');
		if(!$users){
			$users = spClass('ptx_user')->searchWithShare(null,1,4,null,' ptx_user.total_followers DESC ');
			$time = $this->settings['optimizer_setting']['cache_time_user'];
			$time = $time?$time:3600;
			spAccess('w','hotest_user',$users,$time);
		}
		return $users;
	}
	
	private function getTodayStarUser(){
		$result = spAccess('r', 'today_star');
		if(!$result){
			$ptx_share = spClass('ptx_share');
			$result = $ptx_share->get_today_star();
			$time = 300;
			spAccess('w','today_star',$result,$time);
		}
		return $result;
	}

}