<?php
if (!defined('APP_PATH')) exit('No direct script access allowed');

class VerifyCode {
	protected $width = 60; //宽度
	protected $height = 20; //高度
	protected $length = 4; //字符长度
	protected $bgcolor = '#FFFFFF'; //背景色
	protected $bordercolor = null; //边框色
	protected $noisenum = NULL ; //杂点数量

	protected $fontsize = 22; //字体大小
	protected $font = "font.ttf"; //自定义字体
	protected $format = 'png'; //输出图片格式
	protected $imagename;
	protected $image;
	protected $backcolorRGB;
	protected $bordercolorRGB = NULL;
	protected $size;
	protected $sizestr2str;
	
	private $vcode = NULL; //验证码内容(数字)
	private $session = null;

	public function  __construct() {
		$this->font = APP_PATH.'/assets/font.ttf';
		$this->session = spClass('Session');
		$this->vcode = $this->session->get_data('verifycode');
		
		$params = spExt('verifyCode');
		if(is_array($params)){
		
			foreach (array('width', 'height', 'length', 'bgcolor', 'noisenum', 'fontsize', 'font', 'format') as $key)
			{
				$this->$key = (isset($params[$key])) ? $params[$key] : $this->$key;
			}
		}
	}

	public function display() {
		$this->make_img();
		$this->session->set_data('verifycode',$this->vcode);
		//$this->vc_session = $this->vcode;
		$this->show_img();
		exit();
	}

	public function verify($var, $is_clear = TRUE) {
		$result = FALSE;
		if($var == $this->vcode) {
			$result = TRUE;
		}
		if($is_clear) $this->vcode = '';
		return $result;
	}

	public function show_img() {
		@header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		@header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
		@header("Cache-Control: no-store, no-cache, must-revalidate");
		@header("Pragma: no-cache");
		if($this->format == 'png') {
			@header("Content-type: image/png");
			imagepng($this->image);
		}elseif($this->format == 'jpg') {
			@header("Content-type: image/jpeg");
			imagejpeg($this->image);
		}else{
			@header("Content-type: image/gif");
			imagegif($this->image);
		}
		imagedestroy($this->image);
	}

	public function make_img() {
		$this->vcode = '';
		$this->image = imageCreate($this->width, $this->height); //创建图片
		$this->backcolorRGB = $this->getcolor($this->bgcolor);   //将#ffffff格式的背景色转换成RGB格式
		imageFilledRectangle($this->image, 0, 0, $this->width, $this->height, $this->backcolorRGB); //画一矩形 并填充
		$this->size = $this->width/$this->length; //宽度除以字符数 = 每个字符需要的宽度
		if($this->size>$this->height) $this->size=$this->height; //如果 每个字符需要的宽度 大于图片高度 则 单字符宽度=高度(正方块)
		$this->sizestr2str = $this->size/10 ; //以每个字符的1/10宽度为 字符间距
		$left = ($this->width-$this->length*($this->size+$this->sizestr2str))/$this->size;   // (验证码图片宽度 - 实际需要的宽度)/每个字符的宽度 = 距离左边的宽度
		for($i = 0; $i < 3; $i++) {  //生成干扰线
			$linecolor = imagecolorallocate($this->image, rand(0,255), rand(0,255), rand(0,255));
			imageline($this->image, rand(0,30), rand(0,30), rand(30,80), rand(0,30), $linecolor);
		}
		$pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		for($i=0; $i<$this->length; $i++) {
			$randtext = substr($pool, mt_rand(0, strlen($pool) -1), 1);
			$this->vcode .= $randtext; //写入session的数字
			$textColor = imageColorAllocate($this->image, 0,0,0); //图片文字颜色
			if (!isset($this->fontsize) ) $this->fontsize = rand(($this->size-$this->size/10), ($this->size + $this->size/10)); //如果未定义字体大小 则取随机大小
			$location = $left + ($i*$this->size+$this->size/10);
			imagettftext($this->image, $this->fontsize, rand(-18,18), $location, rand($this->size-$this->size/10, $this->size+$this->size/10), $textColor, $this->font, $randtext); //生成单个字体图象
		}
		if(isset($this->noisenum)) $this->setnoise(); //杂点处理

		if(isset($this->bordercolor)){
			$this->bordercolorRGB = $this->getcolor($this->bordercolor);
			imageRectangle($this->image, 0, 0, $this->width-1, $this->height-1, $this->bordercolorRGB);
		}
	}

	protected function getcolor($color) {
		$color = eregi_replace ("^#","",$color);
		$r = $color[0].$color[1];
		$r = hexdec ($r);
		$b = $color[2].$color[3];
		$b = hexdec ($b);
		$g = $color[4].$color[5];
		$g = hexdec ($g);
		$color = imagecolorallocate ($this->image, $r, $b, $g);
		return $color;
	}

	protected function setnoise() {
		for ($i=0; $i<$this->noisenum; $i++) {
			$randColor = imageColorAllocate($this->image, rand(0, 255), rand(0, 255), rand(0, 255));
			imageSetPixel($this->image, rand(0, $this->width), rand(0, $this->height), $randColor);
		}
	}
}
?>