<?php
include_once APP_PATH.'/extensions/connectors/oauth/OAuth_Facebook.php';
class Driver_Facebook
{
	private $vendor='Facebook';
	protected $oauth;
	protected $client;
	protected $info;
	function __construct($info)
	{
		$this->info = $info;
		$this->oauth = new Facebook(array(
  				'appId'  => $this->info['social_api_info']['APPKEY'],
  				'secret' => $this->info['social_api_info']['APPSECRET'],
		));
	}


	function goto_loginpage($state=NULL,$display=NULL)
	{
		$url = $this->oauth->getLoginUrl($this->info['social_api_info']['CALLBACK']);
		header('Location: '.$url);
		die;
	}

	function get_accesstoken()
	{
		return false;
	}


	function get_userinfo()
	{
		$social_vendor_info = 'social_'.$this->vendor.'_info';
		try {
			$user_profile = $this->oauth->api('/me');
			$userinfo = array();
			$userinfo['uid'] = $user_profile['id'];
			$userinfo['screen_name'] = $user_profile['username'];
			$userinfo['name'] = $user_profile['name'];
			$userinfo['avatar'] = "https://graph.facebook.com/".$user_profile['id']."/picture";
			$userinfo['location'] = $user_profile['location']?$user_profile['location']['name']:'';
			$userinfo['description'] = $user_profile['bio'];
			$userinfo['url'] = $user_profile['link'];
			if($user_profile['gender']=='male'){
				$userinfo['gender'] = 'male';
			}elseif ($temp['gender']=='female'){
				$userinfo['gender'] = 'female';
			}else{
				$userinfo['gender'] = 'none';
			}
			return $userinfo;

		} catch (FacebookApiException $e) {
			$user = null;
		}

		return null;

	}

}
