<?php
include_once APP_PATH.'/extensions/connectors/oauth/OAuth_Twitter.php';
class Driver_Twitter
{
	private $vendor='Twitter';
	protected $oauth;
	protected $client;
	protected $info;
	function __construct($info)
	{
		$this->info = $info;
		$this->session = spClass('Session');
		$this->oauth = new TwitterOAuth($this->info['social_api_info']['APPKEY'],$this->info['social_api_info']['APPSECRET']);
	}


	function goto_loginpage($state=NULL,$display=NULL)
	{
		$request_token = $this->oauth->getRequestToken($this->info['social_api_info']['CALLBACK']);
		$this->session->set_data('oauth_token',$request_token['oauth_token']);
		$this->session->set_data('oauth_token_secret',$request_token['oauth_token_secret']);
		/* If last connection failed don't display authorization link. */
		switch ($this->oauth->http_code) {
			case 200:
				/* Build authorize URL and redirect user to Twitter. */
				$url = $this->oauth->getAuthorizeURL($request_token['oauth_token']);
				header('Location: ' . $url);
				break;
			default:
				/* Show notification if something went wrong. */
				echo 'Could not connect to Twitter. Refresh the page or try again later.';
		}
		die;
	}

	function get_accesstoken()
	{
		$oauth_token = $this->session->get_data('oauth_token');
		$oauth_token_secret = $this->session->get_data('oauth_token_secret');
		/* Create TwitteroAuth object with app key/secret and token key/secret from default phase */
		$connection = new TwitterOAuth($this->info['social_api_info']['APPKEY'],$this->info['social_api_info']['APPSECRET'], $oauth_token, $oauth_token_secret);
		/* Request access tokens from twitter */
		$access_token = $connection->getAccessToken($_REQUEST['oauth_verifier']);
		/* Save the access tokens. Normally these would be saved in a database for future use. */
		$_SESSION['access_token'] = $access_token;
		/* Remove no longer needed request tokens */
		$this->session->set_data('oauth_token','');
		$this->session->set_data('oauth_token_secret','');
		$token = array();
		$social_vendor_info = 'social_'.$this->vendor.'_info';
		$token[$social_vendor_info]['ACCESSTOKEN'] = $access_token;
		return $token;
	}


	function get_userinfo()
	{
		$social_vendor_info = 'social_'.$this->vendor.'_info';
		if(!empty($this->info[$social_vendor_info]['ACCESSTOKEN'])){
			/* Get user access tokens out of the session. */
			$access_token = $this->info[$social_vendor_info]['ACCESSTOKEN'];

			/* Create a TwitterOauth object with consumer/user tokens. */
			$connection = new TwitterOAuth($this->info['social_api_info']['APPKEY'],$this->info['social_api_info']['APPSECRET'], $access_token['oauth_token'], $access_token['oauth_token_secret']);

			/* If method is set change API call made. Test is called by default. */
			$user_profile = $connection->get('account/verify_credentials');
			$userinfo = array();
			$userinfo['uid'] = $user_profile->id;
			$userinfo['screen_name'] = $user_profile->screen_name;
			$userinfo['name'] = $user_profile->name;
			$userinfo['avatar'] = $user_profile->profile_image_url;
			$userinfo['location'] = $user_profile->location;
			$userinfo['description'] = $user_profile->description;
			$userinfo['url'] = $user_profile->url;
			$userinfo['gender'] = 'none';
				
			return $userinfo;

		}
		return null;

	}

}
