<?php 
function dhtmlspecialchars($string, $flags = null) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = dhtmlspecialchars($val, $flags);
		}
	} else {
		if($flags === null) {
			$string = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $string);
			if(strpos($string, '&amp;#') !== false) {
				$string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4}));)/', '&\\1', $string);
			}
		} else {
			if(PHP_VERSION < '5.4.0') {
				$string = htmlspecialchars($string, $flags);
			} else {
				if(strtolower(CHARSET) == 'utf-8') {
					$charset = 'UTF-8';
				} else {
					$charset = 'ISO-8859-1';
				}
				$string = htmlspecialchars($string, $flags, $charset);
			}
		}
	}
	return $string;
}
function parsesmiles(&$message) {
	$ptx_smile = spClass('ptx_smile');
	$smiles = $ptx_smile->getSmilies();
	$message = preg_replace($smiles['searcharray'], $smiles['replacearray'], $message, 5);
	return $message;
}

function deparse_message(&$message,$needbr=false) {
	$message = str_replace(array('[/at]'), array(''),preg_replace(array("/\[at=(\d+?)\]/i"),array(""), $message));
	return $message;
}

function parseurl($url, $text, $scheme) {
	if(!$url && preg_match("/((https?|ftp|gopher|news|telnet|rtsp|mms|callto|bctp|thunder|qqdl|synacast){1}:\/\/|www\.)[^\[\"']+/i", trim($text), $matches)) {
		$url = $matches[0];
		$length = 65;
		if(strlen($url) > $length) {
			$text = substr($url, 0, intval($length * 0.5)).' ... '.substr($url, - intval($length * 0.3));
		}
		return '<a href="'.(substr(strtolower($url), 0, 4) == 'www.' ? 'http://'.$url : $url).'" target="_blank">'.$text.'</a>';
	} else {
		$url = substr($url, 1);
		if(substr(strtolower($url), 0, 4) == 'www.') {
			$url = 'http://'.$url;
		}
		$url = !$scheme ? base_url($url) : $url;
		return '<a href="'.$url.'" target="_blank">'.$text.'</a>';
	}
}

function parse_tag($category_id,$message){
	$tags = get_tags($category_id);
	$reg = array();
	foreach ($tags as $tag){
		if($tag&&$tag!='')
			$reg[] = '/'.trim($tag).'/i';
	}
	return preg_replace($reg, "#\\0#", $message,10);
}

function get_tags($category_id){
	$result = spAccess('r', 'category_tags_'.$category_id);
	if(!$result){
		$ptx_tag = spClass('ptx_tag');
		$tag_groups = $ptx_tag->get_tag_group(" ptx_tag.category_id='".$category_id."' ");
		$tags = "";
		foreach ($tag_groups as $key=>$tag_group){
			$tags .= ','.$tag_group['tags'];
		}
		$tags = explode(',',trim($tags));
		$result = array_values(array_unique($tags));
		spAccess('w','category_tags_'.$category_id,$result);
	}
	return $result;
}

function parse_plain_message($message) {
	$msglower = strtolower($message);
	$message = dhtmlspecialchars($message);

	if(strpos($msglower, '[/url]') !== FALSE) {
		$message = preg_replace("/\[url(=((https?|ftp|gopher|news|telnet|rtsp|mms|callto|bctp|thunder|qqdl|synacast){1}:\/\/|www\.|mailto:)?([^\r\n\[\"']+?))?\](.+?)\[\/url\]/ies", "", $message);
	}

	$message = str_replace(array('[/at]'), array(''),preg_replace(array("/\[at=(\d+?)\]/i"),array(""), $message));


	$message = str_replace(array(
			'[/color]', '[/backcolor]', '[/size]', '[/font]', '[/align]', '[b]', '[/b]', '[s]', '[/s]', '[hr]', '[/p]',
			'[i=s]', '[i]', '[/i]', '[u]', '[/u]', '[list]', '[list=1]', '[list=a]',
			'[list=A]', "\r\n[*]", '[*]', '[/list]', '[indent]', '[/indent]', '[/float]'
	), array(
			'', '', '', '', '', '', '', '', '', '', '', '', '',
			'', '', '', '', '', '',
			'', '', '', '', '', '', ''
	), preg_replace(array(
			"/\[color=([#\w]+?)\]/i",
			"/\[color=(rgb\([\d\s,]+?\))\]/i",
			"/\[backcolor=([#\w]+?)\]/i",
			"/\[backcolor=(rgb\([\d\s,]+?\))\]/i",
			"/\[size=(\d{1,2}?)\]/i",
			"/\[size=(\d{1,2}(\.\d{1,2}+)?(px|pt)+?)\]/i",
			"/\[font=([^\[\<]+?)\]/i",
			"/\[align=(left|center|right)\]/i",
			"/\[p=(\d{1,2}|null), (\d{1,2}|null), (left|center|right)\]/i",
			"/\[float=left\]/i",
			"/\[float=right\]/i"

	), array(
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			""
	), $message));

	if(strpos($msglower, '[/quote]') !== FALSE) {
		$message = preg_replace("/\s?\[quote\][\n\r]*(.+?)[\n\r]*\[\/quote\]\s?/is", "", $message);
	}
	if(strpos($msglower, '[/free]') !== FALSE) {
		$message = preg_replace("/\s*\[free\][\n\r]*(.+?)[\n\r]*\[\/free\]\s*/is", "", $message);
	}
	if(strpos($msglower, '[/media]') !== FALSE) {
		$message = preg_replace("/\[media=([\w,]+)\]\s*([^\[\<\r\n]+?)\s*\[\/media\]/ies", "", $message);
	}
	if(strpos($msglower, '[/audio]') !== FALSE) {
		$message = preg_replace("/\[audio(=1)*\]\s*([^\[\<\r\n]+?)\s*\[\/audio\]/ies","", $message);
	}
	if(strpos($msglower, '[/flash]') !== FALSE) {
		$message = preg_replace("/\[flash(=(\d+),(\d+))?\]\s*([^\[\<\r\n]+?)\s*\[\/flash\]/ies", "", $message);
	}

	$attrsrc = 'src';
	if(strpos($msglower, '[/img]') !== FALSE) {
		$message = preg_replace(array(
				"/\[img\]\s*([^\[\<\r\n]+?)\s*\[\/img\]/ies",
				"/\[img=(\d{1,4})[x|\,](\d{1,4})\]\s*([^\[\<\r\n]+?)\s*\[\/img\]/ies"
		), array(
				"",
				""
		), $message);
	}

	unset($msglower);
	return str_replace(array("\t", '   ', '  '), array('', '', ''), $message);
}


function parse_message($message,$needbr=false) {
	$msglower = strtolower($message);
	$message = dhtmlspecialchars($message);
	$message = parsesmiles($message);

	if(strpos($msglower, '[/url]') !== FALSE) {
		$message = preg_replace("/\[url(=((https?|ftp|gopher|news|telnet|rtsp|mms|callto|bctp|thunder|qqdl|synacast){1}:\/\/|www\.|mailto:)?([^\r\n\[\"']+?))?\](.+?)\[\/url\]/ies", "parseurl('\\1', '\\5', '\\2')", $message);
	}

	$userlink = spUrl('pub','index',array('uid'=>'\\1'));
	$taglink = spUrl('pin','index',array('tag'=>'\\1'));
	$message = preg_replace("/#([^#\r\n\]]+?)#/i", "<a href=\"$taglink\" target=\"_blank\">#\\1#</a>", $message, 5);
	$message = str_replace(array('[/at]'), array('</a>'),preg_replace(array("/\[at=(\d+?)\]/i"),array("<a href=\"$userlink\"  data-user-id=\"\\1\" data-user-profile=\"1\" target=\"_blank\">"), $message));
	
	$nest = 0;
	while(strpos($msglower, '[table') !== FALSE && strpos($msglower, '[/table]') !== FALSE){
		$message = preg_replace("/\[table(?:=(\d{1,4}%?)(?:,([\(\)%,#\w ]+))?)?\]\s*(.+?)\s*\[\/table\]/ies", "parsetable('\\1', '\\2', '\\3')", $message);
		if(++$nest > 4) break;
	}
	$message = str_replace(array(
			'[/color]', '[/backcolor]', '[/size]', '[/font]', '[/align]', '[b]', '[/b]', '[s]', '[/s]', '[hr]', '[/p]',
			'[i=s]', '[i]', '[/i]', '[u]', '[/u]', '[list]', '[list=1]', '[list=a]',
			'[list=A]', "\r\n[*]", '[*]', '[/list]', '[indent]', '[/indent]', '[/float]'
	), array(
			'</font>', '</font>', '</font>', '</font>', '</div>', '<strong>', '</strong>', '<strike>', '</strike>', '<hr class="l" />', '</p>', '<i class="pstatus">', '<i>',
			'</i>', '<u>', '</u>', '<ul>', '<ul type="1" class="litype_1">', '<ul type="a" class="litype_2">',
			'<ul type="A" class="litype_3">', '<li>', '<li>', '</ul>', '<blockquote>', '</blockquote>', '</span>'
	), preg_replace(array(
			"/\[color=([#\w]+?)\]/i",
			"/\[color=(rgb\([\d\s,]+?\))\]/i",
			"/\[backcolor=([#\w]+?)\]/i",
			"/\[backcolor=(rgb\([\d\s,]+?\))\]/i",
			"/\[size=(\d{1,2}?)\]/i",
			"/\[size=(\d{1,2}(\.\d{1,2}+)?(px|pt)+?)\]/i",
			"/\[font=([^\[\<]+?)\]/i",
			"/\[align=(left|center|right)\]/i",
			"/\[p=(\d{1,2}|null), (\d{1,2}|null), (left|center|right)\]/i",
			"/\[float=left\]/i",
			"/\[float=right\]/i"

	), array(
			"<font color=\"\\1\">",
			"<font style=\"color:\\1\">",
			"<font style=\"background-color:\\1\">",
			"<font style=\"background-color:\\1\">",
			"<font size=\"\\1\">",
			"<font style=\"font-size:\\1\">",
			"<font face=\"\\1\">",
			"<div align=\"\\1\">",
			"<p style=\"line-height:\\1px;text-indent:\\2em;text-align:\\3\">",
			"<span style=\"float:left;margin-right:5px\">",
			"<span style=\"float:right;margin-left:5px\">"
	), $message));

	if(strpos($msglower, '[/quote]') !== FALSE) {
		$message = preg_replace("/\s?\[quote\][\n\r]*(.+?)[\n\r]*\[\/quote\]\s?/is", tpl_quote(), $message);
	}
	if(strpos($msglower, '[/free]') !== FALSE) {
		$message = preg_replace("/\s*\[free\][\n\r]*(.+?)[\n\r]*\[\/free\]\s*/is", tpl_free(), $message);
	}
	if(strpos($msglower, '[/media]') !== FALSE) {
		$message = preg_replace("/\[media=([\w,]+)\]\s*([^\[\<\r\n]+?)\s*\[\/media\]/ies", $allowmediacode ? "parsemedia('\\1', '\\2')" : "bbcodeurl('\\2', '<a href=\"{url}\" target=\"_blank\">{url}</a>')", $message);
	}
	if(strpos($msglower, '[/audio]') !== FALSE) {
		$message = preg_replace("/\[audio(=1)*\]\s*([^\[\<\r\n]+?)\s*\[\/audio\]/ies", $allowmediacode ? "parseaudio('\\2', 400)" : "bbcodeurl('\\2', '<a href=\"{url}\" target=\"_blank\">{url}</a>')", $message);
	}
	if(strpos($msglower, '[/flash]') !== FALSE) {
		$message = preg_replace("/\[flash(=(\d+),(\d+))?\]\s*([^\[\<\r\n]+?)\s*\[\/flash\]/ies", $allowmediacode ? "parseflash('\\2', '\\3', '\\4');" : "bbcodeurl('\\4', '<a href=\"{url}\" target=\"_blank\">{url}</a>')", $message);
	}

	$attrsrc = 'src';
	if(strpos($msglower, '[/img]') !== FALSE) {
		$message = preg_replace(array(
				"/\[img\]\s*([^\[\<\r\n]+?)\s*\[\/img\]/ies",
				"/\[img=(\d{1,4})[x|\,](\d{1,4})\]\s*([^\[\<\r\n]+?)\s*\[\/img\]/ies"
		), array(
				"parseimg(0, 0, '\\1', '')",
				"parseimg('\\1', '\\2', '\\3', '')"
		), $message);
	}

	unset($msglower);
	if($needbr){
		return nl2br($message);
	}else{
		return str_replace(array("\t", '   ', '  '), array('&nbsp; &nbsp; &nbsp; &nbsp; ', '&nbsp; &nbsp;', '&nbsp;&nbsp;'), $message);
	}
}
function parsetable($width, $bgcolor, $message) {
	if(strpos($message, '[/tr]') === FALSE && strpos($message, '[/td]') === FALSE) {
		$rows = explode("\n", $message);
		$s = '<table cellspacing="0" class="t_table" '.
				($width == '' ? NULL : 'style="width:'.$width.'"').
				($bgcolor ? ' bgcolor="'.$bgcolor.'">' : '>');
		foreach($rows as $row) {
			$s .= '<tr><td>'.str_replace(array('\|', '|', '\n'), array('&#124;', '</td><td>', "\n"), $row).'</td></tr>';
		}
		$s .= '</table>';
		return $s;
	} else {
		if(!preg_match("/^\[tr(?:=([\(\)\s%,#\w]+))?\]\s*\[td([=\d,%]+)?\]/", $message) && !preg_match("/^<tr[^>]*?>\s*<td[^>]*?>/", $message)) {
			return str_replace('\\"', '"', preg_replace("/\[tr(?:=([\(\)\s%,#\w]+))?\]|\[td([=\d,%]+)?\]|\[\/td\]|\[\/tr\]/", '', $message));
		}
		if(substr($width, -1) == '%') {
			$width = substr($width, 0, -1) <= 98 ? intval($width).'%' : '98%';
		} else {
			$width = intval($width);
			$width = $width ? ($width <= 560 ? $width.'px' : '98%') : '';
		}
		return '<table cellspacing="0" class="t_table" '.
				($width == '' ? NULL : 'style="width:'.$width.'"').
				($bgcolor ? ' bgcolor="'.$bgcolor.'">' : '>').
				str_replace('\\"', '"', preg_replace(array(
						"/\[tr(?:=([\(\)\s%,#\w]+))?\]\s*\[td(?:=(\d{1,4}%?))?\]/ie",
						"/\[\/td\]\s*\[td(?:=(\d{1,4}%?))?\]/ie",
						"/\[tr(?:=([\(\)\s%,#\w]+))?\]\s*\[td(?:=(\d{1,2}),(\d{1,2})(?:,(\d{1,4}%?))?)?\]/ie",
						"/\[\/td\]\s*\[td(?:=(\d{1,2}),(\d{1,2})(?:,(\d{1,4}%?))?)?\]/ie",
						"/\[\/td\]\s*\[\/tr\]\s*/i"
				), array(
						"parsetrtd('\\1', '0', '0', '\\2')",
						"parsetrtd('td', '0', '0', '\\1')",
						"parsetrtd('\\1', '\\2', '\\3', '\\4')",
						"parsetrtd('td', '\\1', '\\2', '\\3')",
						'</td></tr>'
				), $message)
				).'</table>';
	}
}

function parsetrtd($bgcolor, $colspan, $rowspan, $width) {
	return ($bgcolor == 'td' ? '</td>' : '<tr'.($bgcolor ? ' style="background-color:'.$bgcolor.'"' : '').'>').'<td'.($colspan > 1 ? ' colspan="'.$colspan.'"' : '').($rowspan > 1 ? ' rowspan="'.$rowspan.'"' : '').($width ? ' width="'.$width.'"' : '').'>';
}


function parseimg($width, $height, $src, $extra = '') {
	if(strstr($src, 'file:') || substr($src, 1, 1) == ':') {
		return $src;
	}
	if($width > 400) {
		$height = intval(400 * $height / $width);
		$width = 400;

		$extra = 'style="cursor:pointer"';

	}
	$attrsrc = 'src';
	$rimg_id = random(5);
	return bbcodeurl($src, '<img '.($width > 0 ? ' width="'.$width.'"' : '').($height > 0 ? ' height="'.$height.'"' : '').' '.$attrsrc.'="'.$src.'" '.($extra ? $extra.' ' : '').'border="0" alt="" />');
}

function random($length, $numeric = 0) {
	$seed = base_convert(md5(microtime().$_SERVER['DOCUMENT_ROOT']), 16, $numeric ? 10 : 35);
	$seed = $numeric ? (str_replace('0', '', $seed).'012340567890') : ($seed.'zZ'.strtoupper($seed));
	$hash = '';
	$max = strlen($seed) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $seed{mt_rand(0, $max)};
	}
	return $hash;
}

function bbcodeurl($url, $tags) {
	if(!preg_match("/<.+?>/s", $url)) {
		if(!in_array(strtolower(substr($url, 0, 6)), array('http:/', 'https:', 'ftp://', 'rtsp:/', 'mms://')) && !preg_match('/^static\//', $url) && !preg_match('/^data\//', $url)) {
			$url = 'http://'.$url;
		}
		return str_replace(array('submit', spUrl('webuser','login')), array('', ''), str_replace('{url}', addslashes($url), $tags));
	} else {
		return '&nbsp;'.$url;
	}
}
?>