<?php
class ptx_store_category extends spModelMulti
{
	public $pk = 'store_category_id';
	public $table = 'ptx_store_category';

	var $linker = array();

	var $select_fields = " ptx_store_category.store_category_id,ptx_store_category.store_category_name,ptx_store_category.parent_id ";


	public function get_store_category($conditions = null, $sort = null, $fields = null, $limit = null){
		if(!$sort){
			$sort = ' display_order ASC ';
		}
		$results = parent::findAll($conditions,$sort, $fields, $limit);
		return $results;
	}

	public function find_one($conditions=NULL){
		$fields = $this->select_fields;
		return $this->findJoin($conditions,null,$fields);
	}

	public function getStoreCategories($refresh=false){
		$storeCategories = spAccess('r','store_category');
		if(!$storeCategories||$refresh){
			$storeCategories = $this->get_store_category(array("parent_id"=>0));
			foreach ($storeCategories as $key=>$storeCategorie){
				$subCategories = $this->get_store_category(array("parent_id"=>$storeCategorie['store_category_id']));
				$storeCategories[$key]['children'] = $subCategories;
			}
			spAccess('w','store_category',$storeCategories,1000);
		}
		return $storeCategories;
	}
}
