<?php echo $setting_header;?>
<div class="tablebox">
   <table class="table table-striped">
        <thead>
          <tr>
            <th>ID</th>
            <th><?php echo T('medal_name');?></th>
            <th><?php echo T('description');?></th>
            <th><?php echo T('picture');?></th>
            <th><?php echo T('th_type');?></th>
            <th><?php echo T('price');?></th>
            <th><?php echo T('credits');?></th>
            <th><?php echo T('open');?></th>
            <th><?php echo T('th_operation');?></th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($medals as $medal):?>
          <tr>
            <td><?php echo $medal['medal_id'];?></td>
            <td><?php echo $medal['name'];?></td>
            <td style="word-wrap:break-word;width: 300px;"><?php echo $medal['description'];?></td>
            <td><img src="<?php echo base_url().'assets/img/medal/'.$medal['image'];?>"/></td>
            <td><?php echo T($medal_type[$medal['type']]);?></td>
            <td><?php echo $medal['price'];?></td>
            <td><?php echo $medal['credit'];?></td>
            <td><?php echo $medal['available']?T('yes'):T('no');?></td>
            <td>
           		<a href="<?php echo spUrl('admin','medal',array('act'=>'edit','medalid'=>$medal['medal_id']));?>"><?php echo T('edit');?></a>
            </td>
          </tr>
        <?php endforeach;?>
        </tbody>
      </table>

</div>

<div class="tablebox_footer">
   <form action="<?php echo spUrl('admin','medal',array('act'=>'add'));?>" method="post" class="form-horizontal">
   <fieldset>
   
   <div class="control-group">
      <label class="control-label" for="input01"><?php echo T('medal_name');?></label>
      <div class="controls">
        <input type="text" class="input-xlarge" id="name" name="name" />
      </div>
    </div>
    <div class="control-group">
      <label class="control-label" for="input01"><?php echo T('picture');?></label>
      <div class="controls">
        <input type="text" class="input-xlarge" id="image" name="image" />
		<p class="help-block"><?php echo T('medal_image_tip');?></p>
      </div>
    </div>
    <div class="control-group">
      <label class="control-label" for="input01"><?php echo T('credits');?></label>
      <div class="controls">
        <input type="text" class="input-xlarge" id="credit" name="credit"/>
      </div>
    </div>
    <div class="control-group">
      <label class="control-label" for="input01"><?php echo T('price');?></label>
      <div class="controls">
        <input type="text" class="input-xlarge" id="price" name="price" />
      </div>
    </div>
    <div class="control-group">
            <label class="control-label" for="type"><?php echo T('th_type');?></label>
            <div class="controls">
	             <select class="span2" id="type" name="type">
	             		<?php foreach ($medal_type as $key=>$type):?>
			            <option value="<?php echo $key;?>"><?php echo T($type);?></option>
			           	<?php endforeach;?>
	              </select>
            </div>
    </div>
    <div class="control-group">
            <label class="control-label" for="available"><?php echo T('open');?></label>
            <div class="controls">
              <input type="radio" name="available" class="input-xlarge" value="1" checked><?php echo T('yes');?></input>
              <input type="radio" name="available" class="input-xlarge" value="0"><?php echo T('no');?></input>
            </div>
    </div>
    <div class="control-group">
      <label class="control-label" for="input01"><?php echo T('description');?></label>
      <div class="controls">
        <textarea id="description" name="description" rows="4" class="span3"></textarea>
      </div>
    </div>
    <div class="form-actions">
  <button type="submit" class="btn"><?php echo T('save');?></button>
  </div>
  </fieldset>
</form>
</div>

</body>
</html>