CREATE TABLE IF NOT EXISTS `{dbpre}ptx_album` (
  `album_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` INT(11) NULL DEFAULT 0 ,
  `album_title` VARCHAR(255) NOT NULL ,
  `create_time` int(10) NOT NULL,
  `user_id` INT(11) NOT NULL ,
  `album_cover` TEXT NULL ,
  `total_share` INT(11) NULL DEFAULT 0 ,
  `total_like` INT(11) NULL DEFAULT 0 ,
  PRIMARY KEY (`album_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_subscription` (
  `subscibe_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `subscibe_user_id` int(11) NOT NULL,
  `subscibe_status` int(11) NOT NULL,
  PRIMARY KEY (`subscibe_id`),
  KEY `idx_subscibe_user_id` (`subscibe_user_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_subscibe_status` (`subscibe_status`),
  KEY `idx_noduplicate` (`user_id`,`subscibe_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_staruser` (
  `star_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `star_cover` TEXT NULL ,
  `star_reason` TEXT NULL ,
  `display_order` int(11) NOT NULL DEFAULT '100',
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`star_id`),
  KEY `idx_star_id` (`star_id`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_goodshop` (
  `shop_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `shop_cover` TEXT NULL ,
  `shop_desc` TEXT NULL ,
  `display_order` int(11) NOT NULL DEFAULT '100',
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`shop_id`),
  KEY `idx_shop_id` (`shop_id`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_comment` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `share_id` int(11) NOT NULL,
  `comment_txt` TEXT NULL ,
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `idx_comment_id` (`comment_id`),
  KEY `idx_share_id` (`share_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_message` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `from_user_id` int(11) NOT NULL,
  `to_user_id` int(11) NOT NULL,
  `message_txt` TEXT NULL ,
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `idx_message_id` (`message_id`),
  KEY `idx_from_user_id` (`from_user_id`),
  KEY `idx_to_user_id` (`to_user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_favorite_album` (
  `favorite_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `album_id` int(11) NOT NULL,
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`favorite_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_album_id` (`album_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_relationship` (
  `relation_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `friend_id` int(11) NOT NULL,
  `relation_status` tinyint(2) NOT NULL ,
  PRIMARY KEY (`relation_id`),
  KEY `idx_relation_id` (`relation_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_friend_id` (`friend_id`),
  KEY `idx_user_friend_id` (`user_id`,`friend_id`),
  KEY `idx_user_id_status` (`user_id`,`relation_status`),
  KEY `idx_friend_id_status` (`friend_id`,`relation_status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;


CREATE TABLE IF NOT EXISTS `{dbpre}ptx_apply` (
  `apply_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `message_txt` TEXT NULL ,
  `apply_type` tinyint(2) DEFAULT '0',
  `status` tinyint(1) DEFAULT '0',
  `create_time` int(10) NOT NULL,
  PRIMARY KEY (`apply_id`),
  KEY `idx_apply_id` (`apply_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

CREATE TABLE IF NOT EXISTS `{dbpre}ptx_settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `set_key` varchar(100) NOT NULL,
  `set_value` text NOT NULL,
  PRIMARY KEY (`setting_id`),
  KEY `idx_setting_id` (`setting_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;

ALTER TABLE `{dbpre}ptx_item` ADD COLUMN `total_images` tinyint(2) DEFAULT '0' ;
ALTER TABLE `{dbpre}ptx_share` ADD COLUMN `album_id` int(11) DEFAULT '0' ;
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `total_likes` int(11) DEFAULT '0';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `is_star` tinyint(4) DEFAULT '0';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `is_shop` tinyint(4) DEFAULT '0';
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `uc_id` INT(11) NULL DEFAULT NULL;
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `total_messages` INT(11) NULL DEFAULT 0;
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `uc_nickname` varchar(80) DEFAULT NULL,

ALTER TABLE `{dbpre}ptx_favorite_sharing` CHANGE COLUMN `create_time` `create_time_old` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP  ;
ALTER TABLE `{dbpre}ptx_item` CHANGE COLUMN `create_time` `create_time_old` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP  ;
ALTER TABLE `{dbpre}ptx_share` CHANGE COLUMN `create_time` `create_time_old` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP  ;
ALTER TABLE `{dbpre}ptx_user` CHANGE COLUMN `create_time` `create_time_old` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP  ;

ALTER TABLE `{dbpre}ptx_favorite_sharing` ADD COLUMN `create_time` INT(10) NOT NULL ;
ALTER TABLE `{dbpre}ptx_item` ADD COLUMN `create_time` INT(10) NOT NULL ;
ALTER TABLE `{dbpre}ptx_share` ADD COLUMN `create_time` INT(10) NOT NULL ;
ALTER TABLE `{dbpre}ptx_user` ADD COLUMN `create_time` INT(10) NOT NULL ;

UPDATE `{dbpre}ptx_favorite_sharing` SET `create_time`=UNIX_TIMESTAMP(`create_time_old`) WHERE favorite_id>0;
UPDATE `{dbpre}ptx_item` SET `create_time`=UNIX_TIMESTAMP(`create_time_old`) WHERE item_id>0;
UPDATE `{dbpre}ptx_share` SET `create_time`=UNIX_TIMESTAMP(`create_time_old`) WHERE share_id>0;
UPDATE `{dbpre}ptx_user` SET `create_time`=UNIX_TIMESTAMP(`create_time_old`) WHERE user_id>0;
