<!--{subtemplate common/header}-->
<div class="container mt20">
	<div class="span9 main">
		<!--{subtemplate goodshop/storenav}-->
		
		<div class="span9 main ml0 mt10">
			<ul class="store-category">
			<?php foreach ($storeCategories as $storeCategory):?>
				<li class="store-category-item">
					<h3><?php echo $storeCategory['store_category_name'];?></h3>
					<div class="sub-category">
						<?php foreach ($storeCategory['children'] as $sub):?>
						<a href="<?php echo spUrl('goodshop','listing',array('scid'=>$sub['store_category_id']));?>"><?php echo $sub['store_category_name'];?></a>
						<?php endforeach;?>
					</div>
				</li>
			<?php endforeach;?>
			</ul>
		</div>
	</div>
	<div class="span3 secondary">
		<div class="span3 ml0  clearfix">
			<h4>{lang about} <span class="meta">{lang goodshop}</span></h4>
			<?php if($current_user['is_shop']):?>
    		<div class="alert alert-info">
			{lang tip_goodshop_settings_long}
			</div>
			<?php else:?>
			<div class="apply-container">
				<a href="javascript:;" data-action="applyStoreOpen" data-params="shop" class="apply-button"><span>{lang apply_goodshop}</span></a>
			</div>
			<?php endif;?>
		</div>
		<div class="span3 ml0 mt20 clearfix">
			<h4>{lang lastest} <span class="meta">{lang goodshop}</span></h4>
			<ol class="lists">
				<?php foreach ($newest10 as $top):?>
				<li>
					<a href="<?php echo spUrl('group','show',array('groupid'=>$top['group_id']));?>">
						<span class="topic-img">
						<img src="<?php echo groupbanner($top['group_id']);?>" onerror="this.src=base_url+'assets/img/default_group_banner.gif';" title="<?php echo $top['group_title'];?>">
						</span>
						<strong><?php echo $top['group_title'];?></strong>
						<span class="list-meta">
							<?php echo $top['total_member'];?> {lang group_member}
						</span>
						<span class="list-meta">{lang created} <?php echo friendlyDate($top['create_time']);?></span>
					</a>
				</li>
				<?php endforeach;?>
			</ol>
		</div>
	</div>
</div>

<!--{subtemplate common/footer}-->
