<!--{subtemplate common/header}-->
<div class="container mt20">
	<div class="span9 main">
		<div class="group-header cls clearfix">
			<div class="group-image">
				<img src="<?php echo groupbanner($group['group_id']);?>" onerror="this.src=base_url+'assets/img/default_group_banner.gif';">
			</div>
			<div class="group-desc">
				<h2><?php echo $group['group_title'].$group['group_id'];?></h2>
				<p><?php echo $group['group_desc'];?></p>
				<div class="group-join">
					<?php if($joined):?>
						<a class="btn btn-success" data-action="postTGShare" data-params="group,<?php echo $group['group_id'];?>">{lang post_share}</a> 
					<?php else:?>
						<a class="btn btn-info" data-action="joinGroup" data-params="<?php echo $group['group_id'];?>">{lang join_group}</a> 
						{lang join_group_tip}
					<?php endif;?>
				</div>
			</div>
		</div>
		<div class="group-member mt20">
			<div class="admin span2 ml0">
				<h3>{lang admin}</h3>
				<a href="<?php echo spUrl('pub','index',array('uid'=>$group['user_id']));?>" data-user-id="<?php echo $group['user_id'];?>" data-user-profile="1">
					<img src="<?php echo useravatar($group['user_id'], 'middle');?>" class="avatar-mid photo-middle">
				</a>
				<a href="javascript:;" rel="contact" title="{lang apply_admin}" class="apply-admin" data-action="applyGroupAdmin" data-params="<?php echo $group['group_id'];?>">
					{lang apply_admin}
				</a>
			</div>
			<div class="member span7">
				<h3>{lang group_member}</h3>
				<?php foreach ($members as $member):?>
				<a href="<?php echo spUrl('pub','index',array('uid'=>$member['user_id']));?>" data-user-id="<?php echo $member['user_id'];?>" data-user-profile="1">
					<img alt="<?php echo $member['nickname'];?>" src="<?php echo useravatar($member['user_id'], 'middle');?>" class="avatar photo-middle">
				</a>
				<?php endforeach;?>
			</div>
		</div>
	</div>
	<div class="span3 secondary">
		<div class="span3 ml0 mb20">
			<ul class="profile-tabs unstyled group-meta">
				<li class="followers">
					<a href="<?php echo spUrl("my","fans",array('uid'=>$user['user_id']));?>">
						<span class="count"><?php echo $group['total_member'];?></span>
						<span class="meta">{lang group_member}</span>
					</a>
				</li>
				<li class="shares">
					<a href="javascript:;">
						<span class="count"><?php echo $total_shares;?></span>
						<span class="meta">{lang share}</span>
					</a>
				</li>
			</ul>
		</div>
		<!--{subtemplate common/secondary}-->
	</div>
</div>
<div class="container mt20">
		<div class="clearfix tab-nav clearfix">
			<ul class="tabs unstyled">
				<li class="tab <?php echo $current_action=='lastest'?'active':'';?>">
					<a href="<?php echo spUrl('group','lastest',array('groupid'=>$group['group_id']));?>" class="parent">
						<span class="meta">{lang lastest}</span>
					</a>
				</li>
				<li class="tab <?php echo $current_action=='hot'?'active':'';?>">
					<a href="<?php echo spUrl('group','hot',array('groupid'=>$group['group_id']));?>" class="parent">
						<span class="meta">{lang hotest}</span>
					</a>
				</li>
				<li class="tab <?php echo $current_action=='share'?'active':'';?>">
					<a href="<?php echo spUrl('group','share',array('groupid'=>$group['group_id']));?>" class="parent">
						<span class="meta">{lang share}</span>
					</a>
				</li>
				<li class="tab <?php echo $current_action=='goods'?'active':'';?>">
					<a href="<?php echo spUrl('group','goods',array('groupid'=>$group['group_id']));?>" class="parent">
						<span class="meta">{lang goods}</span>
					</a>
				</li>
				<li class="tab <?php echo $current_action=='article'?'active':'';?>">
					<a href="<?php echo spUrl('group','article',array('groupid'=>$group['group_id']));?>" class="parent">
						<span class="meta">{lang article}</span>
					</a>
				</li>
				<li class="tab <?php echo $current_action=='video'?'active':'';?>">
					<a href="<?php echo spUrl('group','video',array('groupid'=>$group['group_id']));?>" class="parent">
						<span class="meta">{lang video}</span>
					</a>
				</li>
			</ul>
			<ul class="tabs unstyled pull-right">
				<li class="tab">
					<a href="javascript:;" class="parent">
						<span class="meta">{lang total} <?php echo $total_shares;?> {lang share}</span>
					</a>
				</li>
			</ul>
		</div>
</div>

<div id="waterfall_outer" data-fullscreen="0" class="container">
	<div class="span12 ml0" id="waterfall" data-pin-width="235" data-animated="0">
		<?php echo $tpl_waterfall; ?>
	</div>
</div>

<div class="container">
	<div id="loadingPins" class="span12 text_c"><img src="<?php echo base_url()?>themes/puzzing/img/puzzle32.gif"></div>
</div>
<div id="page-nav" class="mt20 container hide">
	<a id="page-next" href="<?php echo $nextpage_url; ?>"></a>
</div>
<div class="hide">
	<?php echo $pages;?>
</div>
<!--{subtemplate common/footer}-->