var Screenshot = {
	Like: {
		// Like or unlike a screenshot or comment
		Shot: {
			toggle: function() {
				if ($('.fav a.fav-toggle.processing').length == 0) {
					var $link = $(".fav a.fav-toggle");
					var url = $link.attr('href');
					var data = $link.hasClass('current-user-likes') ? {_method: 'delete'} : {}
					
					$.ajax({
						type: 'POST',
						url: url,
						data: data,
						beforeSend: function() {
							$('.fav-toggle').addClass('processing');
							$link.text('Wait...');
						},
						success: function(responseHtml) {
							$('#like-section').replaceWith(responseHtml);
						}
					});
				}

				return false;
			}
		},
		Comment: {
				toggle: function() {
					var link = $(this);
					var data = link.hasClass('liked-by-current-user') ? {_method: 'delete'} : null;
					$.ajax({
						type: 'POST',
						url: this.href,
						data: data,
						success: function(responseHtml) {
							link.closest('.comment').replaceWith(responseHtml);
						}
					});

					return false;
			}
		}
	},
	Flag: {
		// Flag a screenshot as inappropriate or Appropriate
		flag: function(){
			var link = $(this);
			var screenshotId = link.modelId();
			if(!confirm("Are you sure you want to flag this shot?"))
				return false;

			$.ajax({
				type: 'POST',
				url: this.href,
				data: {
					screenshot_id: screenshotId
				},
				success: function(responseHtml) {
					$('#flag-section').html(responseHtml);
				}
			});

			return false;
		},
		unflag: function() {
			var link = $(this);
			var screenshotId = link.modelId();
			$.ajax({
				type: 'POST',
				url: this.href,
				data: {
					_method: 'delete',
					screenshot_id: screenshotId
				},
				success: function(responseHtml) {
					$('#flag-section').html(responseHtml);
				}
			});

			return false;
		}
	},
	Keyboard: {
		// Key Constants
		b_key: 66,
		f_key: 70,
		l_key: 76,
		esc: 27,
		left_arrow: 37,
		right_arrow: 39,

		handle: function(e) {
			if(Screenshot.Keyboard.is_valid_event(e)){
				var code = e.which;

				switch(code){
					case Screenshot.Keyboard.f_key: // l and f do the same thing
					case Screenshot.Keyboard.l_key:
						if($('.logged-in').length > 0)
							Screenshot.Like.Shot.toggle();
						break;
					case Screenshot.Keyboard.b_key:
						Bucket.toggleOverlay();
						break;
					case Screenshot.Keyboard.esc:
						Bucket.hideOverlay();
						break;
					case Screenshot.Keyboard.left_arrow:
						Screenshot.Page.prev();
						break;
					case Screenshot.Keyboard.right_arrow:
						Screenshot.Page.next();
						break;
				}
			}
		},
		is_valid_event: function(e) {
			// Check if the target is the main page. This prevents an
			// event from firing when a person is typing a comment,
			// or in the search bar.
			if (e.target.localName == 'body' || e.target.localName == 'html')
				if (!e.ctrlKey && !e.altKey && !e.shiftKey && !e.metaKey)
				return true;

			return false;
		}
	},
	Page: {
		next: function() {
			var href = $('#kbd-legend a.next').attr('href');
			if (href && href != newLocation) {
				document.location = href;
				newLocation = href;
			}
		},
		prev: function() {
			var href = $('#kbd-legend a.prev').attr('href');
			if (href && href != newLocation) {
				document.location = href;
				newLocation = href;
			}
		}
	}
};
var newLocation;
// Keyboard shortcut for faving screenshot
$(document).keyup(Screenshot.Keyboard.handle);
