// JavaScript Document

function load_image(url,func) {
	var img = new Image(); 
	img.src = url;
	func.call(img);
}

(function($){
	$.fn.fadeable = function(options){
		var settings = {
			target: this,
			duration: 'fast'
		};
		$.extend(settings, options);
		$(this).live('hover', function(event) {
			switch(event.type){
				case 'mouseenter':
					$(this).find(settings.target).stop().fadeTo(settings.duration, 1);
					break;
				case 'mouseleave':
					$(this).find(settings.target).stop().fadeTo(settings.duration, 0);
					break;
			}
		});
	};
})(jQuery);
(function($) {
	$.fn.gallary = function(options){
		var settings = {
			target: this,
			viewpoint: null,
			thumbs:null
		};
		$.extend(settings, options);
		var lis = settings.thumbs.find("li");
		var k = lis.size();
		var f = new Array(k),fancy = new Array(k),i = 1,cover_index=0;
		lis.each(function(r) {
			var q = $(this).attr("url");
			var t = $(this).attr("title");
			loadimg(q,t,r);
			if($(this).hasClass("on")){
				cover_index = r;
			}
			$(this).bind("click",
			function() {
				i = r + 1;
				next_shot();
			}).bind("mouseover",
			function() {
				$(this).css({
					opacity: 0.8
				});
			}).bind("mouseout",
			function() {
				$(this).css({
					opacity: 1
				});
			});
		});

		settings.viewpoint.find("img").bind("click",
				function() {
					$.fancybox(fancy, {
								'index'             : cover_index,
								'transitionIn'		: 'none',
								'transitionOut'		: 'none',
								'titlePosition' 	: 'over',
								'type'              : 'image'
							});
		});
		function loadimg(q,t,r) {
			load_image(q,
			function(s) {
				f[r] = this;
				fancy[r] = {'href'	: q,
							'title'	: t};
			});
		}
		function next_shot() {
			var s = lis.eq(i - 1);
			if (f[i - 1] && f[i - 1].src) {
				settings.viewpoint.empty();
				//settings.viewpoint.append(f[i - 1]);
				var r = f[i - 1].src;
				var t = '<img src="' + r + '"/>';
				settings.viewpoint.html(t);
			} else {
				var r = s.attr("url");
				var t = '<img src="' + r + '" width="' + s.attr("width") + '" height="' + s.attr("height") + '"/>';
				settings.viewpoint.html(t);
			}
			settings.thumbs.find("li.on").removeClass("on");
			settings.viewpoint.find("img").bind("click",
			function() {
				$.fancybox(fancy, {
							'index'             : i - 1,
							'transitionIn'		: 'none',
							'transitionOut'		: 'none',
							'type'              : 'image',
							'titlePosition' 	: 'over'
						});
			});
			lis.eq(i - 1).addClass("on");
		}
	};
	
})(jQuery);



$(document).ready(function() {
	$('.puzzing').fadeable({target: '.puzzing-txt'});
	$('[rel=tooltip]').tooltip({animation: true});
	$('[rel=contact]').tooltip({placement:'bottom',animation: true});
	$('img.avatar').error(function() {
		 $(this).attr("src", base_url+'assets/img/avatar_large.jpg');
	});
	$('img.avatar-mid').error(function() {
		 $(this).attr("src", base_url+'assets/img/avatar_large.jpg');
	});
	$('img.avatar-small').error(function() {
		 $(this).attr("src", base_url+'assets/img/avatar_large.jpg');
	});
	$('.puzz-thumb a.puzzing-txt').each(function() {
		var link = $(this);
		link.tooltip({
			placement:'bottom',
			gravity: 'n',
			html: true,
			title: function() { return link.closest('li').find('div.tooltip-player').html(); }
		});
	});
});