<!--{subtemplate common/header}-->
<div class="container banner round-shadow mt20">
	<div id="slideshow" class="slide">
		<div class="slideshow">
			<?php foreach ($settings['homeslide'] as $slide):?>
			<div class="slide-item">
				<a target="_blank" href="<?php echo $slide['link_url'];?>">
				<img alt="<?php echo $slide['title'];?>" src="<?php echo base_url($slide['image_url']);?>" onerror="javascript:this.src="""/>
				</a>
				<div class="slide-item-txt">
					<h3><?php echo $slide['title'];?></h3>
					<p><?php echo $slide['desc'];?></p>
				</div>
			</div>
			<?php endforeach;?>
		</div>
			<a href="#" id="prev" class="prev hide">Prev</a>
			<a href="#" id="next" class="next hide">Next</a>
	</div>
</div>


<div class="container home-title">
	<h3 class="special">
		<span class="special-flag special-featured">{lang hot}{lang topic}</span>
		     <a href="<?php echo spUrl("topic","listing"); ?>" class="date-more pull-right">{lang more_tip_2}</a>
	</h3>
</div>
<div class="container home-threads">
	<?php foreach ($topics as $topic):?>
	<div class="span3 round-shadow home-thread puzzing">
		<a href="<?php echo spUrl('topic','show',array('topicid'=>$topic['topic_id']));?>" class="puzzing-img">
		<img alt="<?php echo $topic['topic_title'];?>" src="<?php echo topicbanner($topic['topic_id']);?>" onerror="javascript:this.src = base_url + 'assets/img/default_topic_banner.jpg';"/>
		</a>
		<a href="<?php echo spUrl('topic','show',array('topicid'=>$topic['topic_id']));?>" class="puzzing-txt">
			<strong><?php echo $topic['topic_title'];?></strong>
			<span class="txt"><?php echo $topic['topic_desc'];?></span>
		</a>
	</div>
	<?php endforeach;?>
</div>

<?php foreach ($categories as $category):?>
<?php if($category['is_home']):?>
<div class="container home-title home-category">
	<h3 class="special">
		<span class="special-flag special-featured"><?php echo $category['category_name_cn'];?></span>
	</h3>
	<?php echo $category['home_view'];?>
</div>
<?php endif;?>
<?php endforeach;?>


<!--{subtemplate welcome/hot_album}-->

<!--{subtemplate welcome/popular_user}-->

<!--{subtemplate common/footer}-->