/**
 * at页面常用功能方法
 * 
 **/

//at对象定义
at = {};
;(function(){
    var iscss3 = /webkit|gecko/i.test(navigator.userAgent) ? true : false,
        ie6 = !window.XMLHttpRequest && window.ActiveXObject ? true : false,
        $ = function(id,tag){
            if(!id) return null;
            var obj = typeof id == 'string' ? document.getElementById(id) : id;
            if(!tag){
                return obj
            }else{
                return obj.getElementsByTagName(tag);
            }
        }

    function setBtns(id){
        var obj = document.getElementById(id),
            dls = null;
        if(!obj) return;
        dls = obj.getElementsByTagName('dl');
        for(var i=0,l=dls.length;i<l;i++){
            handle(i);
        }
        function handle(n){
            var timer = null;
            Event.add(dls[n],'mouseover',function(){
                clearTimeout(timer);
                timer = null;
                Element.addClass(dls[n],'on');
            });
            Event.add(dls[n],'mouseout',function(){
                if(timer) return;
                timer = setTimeout(function(){
                    Element.removeClass(dls[n],'on');
                },50)
            })
        }
        
    }
    
    /**
     * at顶部导航功能
     * @param {string} id 菜单元素id
     * @param {string} tar 下拉菜单内容容器id
     * @param {number} n 序号
     * @param {number} leftPx 元素居左侧距离
     */
    function multiMenu(id,tar,n,leftPx){
        n=n||0;
        var obj = document.getElementById(id),
            tarObj = document.getElementById(tar);
        if(!obj || !tarObj){return;}
        var size = [ (obj.offsetWidth - tarObj.offsetWidth)/2, obj.offsetHeight],
            position = Element.getPosition(obj),
            timer = null;
        function init(){
            switch(n){
                case 0:
                    tarObj.style.cssText = 'display:none;left:'+leftPx+'px;top:47px;';
                    break;
                case 1:
                    tarObj.style.cssText = 'display:none;left:'+leftPx+'px;top:47px;';
                    break;
                case 2:
                    tarObj.style.cssText = 'display:none;left:'+leftPx+'px;top:47px;';
                    break;
                 case 3:
                    tarObj.style.cssText = 'display:none;right:'+leftPx+'px;top:47px;';
                    break;
                default:
                 return false;
            }
        }
        Event.add(obj,'mouseover',function(){
            clear();
            tarObj.style.display = 'block';
            if(n==2){Element.addClass(obj,'hoverCre');}  //增加滑动样式
        });
        Event.add(obj,'mouseout',function(){
            if(timer) return;
            timer = setTimeout(function(){
                tarObj.style.display = 'none';
                if(n==2){Element.removeClass(obj,'hoverCre');}  //增加滑动样式
            },100)
        });
        Event.add(tarObj,'mouseover',function(){
            clear();
            tarObj.style.display = 'block';
            if(n==2){Element.addClass(obj,'hoverCre');}  //增加滑动样式
        });
        Event.add(tarObj,'mouseout',function(){
            if(timer) return;
            timer = setTimeout(function(){
                tarObj.style.display = 'none';
                if(n==2){Element.removeClass(obj,'hoverCre');}  //增加滑动样式
            },100)
        });
        function clear(){
            if(timer){
                clearTimeout(timer);
                timer = null;
            }
        }
        init();
    }
    
    /**
     *  杂志页面 分享功能
     * @param {object} obj 元素对象
     * @param {string} className 样式名称
     */
    function magShare(obj,className,pic){
        var o = document.getElementById(obj),
            timer = null,
            t = document.title,
            link = encodeURIComponent(location.href),
            where = {
                'sina' : '新浪微博',
                'qqblog' : '腾讯微博'
            };

        if(!o) return;
        Event.add(o,'mouseover',function(e){
            if(timer){
                clearTimeout(timer);
                timer = null;
            }
            e = e || window.event;
            var tar = e.target || e.srcElement;
            Element.addClass(tar,'on');
            if(className) Element.addClass(o,className);
        });
        Event.add(o,'mouseout',function(e){
            if(timer) return;
            e = e || window.event;
            var tar = e.target || e.srcElement;
            Element.removeClass(tar,'on');
            timer = setTimeout(function(){
                if(className) Element.removeClass(o,className);
            },100);
        });
    }


    function scrollHelp(opt){
        if(!opt){
            opt = {}
        }
        var btn_show = opt.btn_show || null,
            btn_close = opt.btn_close || null,
            currentBox = opt.currentBox || null,
            nav = opt.topNav || null,
            sideBar = opt.sideBar || null,
            sideStyle = null,
            nextBox = opt.nextBox,
            winSize = [document.body.clientWidth || document.documentElement.clientWidth,document.documentElement.clientHeight || document.body.clientHeight ],
            top = 0,
            anima = null,
            show = false,
            currentBoxHeight = 0,
            from = 0,
            to = 0,
            c = 0,
            step = 24,
            timer = null;
    

        function init(){
            currentBoxHeight = currentBox.offsetHeight;
            currentBoxHeight +=nav ? nav.offsetHeight:0;
            if(winSize[1]>860){
                nextBox.style.height = winSize[1] + 'px';
            }
            sideBar && (sideStyle = sideBar.style.cssText);
            Event.add(window,'resize',function(){
                winSize = [document.body.clientWidth || document.documentElement.clientWidth,document.documentElement.clientHeight || document.body.clientHeight ];
            })
        }
        Event.add(btn_show,'click',function(){
            show = true;
            currentBoxHeight = currentBox.offsetHeight;
            nextBox.style.cssText += ';display:block;';
            sideBar&&(sideBar.style.cssText += ';display:none');
            top = document.body.scrollTop || document.documentElement.scrollTop;
            from = top;
            to = from + winSize[1];
            n=0;
            clearInterval(timer)
            timer = null;
            timer = setInterval(move,15);
        });
        Event.add(btn_close,'click',function(){
            show = false;
            currentBox.style.cssText += ';display:block';
            nav.style.cssText += ';display:block';
            window.scrollTo(0,currentBoxHeight);
            from = currentBoxHeight;
            to = currentBoxHeight-winSize[1];
            clearInterval(timer)
            timer = null;
            timer = setInterval(move,15);
        });
        function move(){
            n++;
            c = trans(n/step)*(to-from) + from;
            window.scrollTo(0,c);
            if(n==step){
                clearInterval(timer);
                timer = null;
                n=0;
                callback();
                return;
            }
        }

        function callback(){
            if(show){
                currentBox.style.display = 'none';
                nav.style.display = 'none';
                nextBox.style.width = '100%';
                window.scrollTo(0,0);
            }else{
                nextBox.style.display = 'none';
                sideBar && (sideBar.style.cssText = sideStyle);
                window.scrollTo(0,currentBoxHeight-winSize[1]);
            }
        }

        function trans(m){
             return (1-Math.cos(Math.PI*m))/2
        }
        

        Event.add(btn_show,'mouseover',function(){
            btn_show.className = 'on';
        })
        Event.add(btn_show,'mouseout',function(){
            btn_show.className = '';
        })
        Event.add(btn_close,'mouseover',function(){
            btn_close.className = 'on';
        })
        Event.add(btn_close,'mouseout',function(){
            btn_close.className = '';
        })
        init();
    }

    function _tools(){
        var obj = null,
            divs = [],
            spans = null,
            list = null,
            listCon = null,
            listBox = null,
            closeBtn = null,
            leftBtn = null,
            rightBtn = null,
            single = 114,
            fix = 118,
            len = 0,
            num = 0,
            cons = null,
            mask = null,
            winSize = [ 0,0 ],
            max = null,
            top = 0,
            body = null,
            html = null,
            ie6 = !window.XMLHttpRequest && window.ActiveXObject ? true : false,
            oldStyle = null,
            an_mask = null,
            anima = null,
            moveState = false;
        
        function init(id,m){
            if(!document.getElementById(id)) return;
            winSize = [ document.documentElement.clientWidth || document.body.clientWidth , document.documentElement.clientHeight || document.body.clientHeight ];
            obj = document.getElementById(id);
            spans = obj.getElementsByTagName('span');
            divs[0] = obj.getElementsByTagName('div');

            
            
            cons = divs[0][0];
            mask = divs[0][divs[0].length-1];
            closeBtn = spans[spans.length-1];
            

            max = m || 300;
            body = document.getElementsByTagName('body')[0];
            html = document.getElementsByTagName('html')[0];
            

            reset();
            anima = new Anima(cons,{time:400});
            an_mask = new Anima(mask,{time:240});
            oldStyle = [body.style.cssText,html.style.cssText];

            Event.add(closeBtn,'click',function(){
                if(moveState) return;
                close();
            })
            
            Event.add(mask,'click',function(){
                if(moveState) return;
                close();
            })
            
            Event.add(window,'resize',function(){
                winSize = [ document.documentElement.clientWidth || document.body.clientWidth , document.documentElement.clientHeight || document.body.clientHeight ];
                reset();
            })
            Event.add(window,'scroll',function(){
                if(ie6) top = document.documentElement.scrollTop || document.body.scrollTop;
            })
        }
        function reset(){
            obj.style.cssText += ';width:100%;height:' + winSize[1] + 'px;top:'+ top + 'px;';
            mask.style.cssText += ';width:100%;height:' + winSize[1] + 'px;';
            cons.style.top = (winSize[1] - cons.offsetHeight)/2 + 'px';
        }

        function show(callback){
            obj.style.cssText += ';display:block;';
            cons.style.height = '0';
            mask.style.cssText += ';opacity:0.6;filter:alpha(opacity=60);';
            window.at['_toolsing'] = true;
            reset();
            body.style.cssText += ';overflow:hidden;';
            if(ie6){
                html.style.cssText += ';overflow:hidden;';
            }
            moveState = true;
            anima.start({
                height:max,
                top:(winSize[1]-max)/2
            })
            complete(anima,callback);
            
        }

        function close(callback){
            moveState = true;
            anima.start({
                height:0,
                top:winSize[1]/2
            })
            
            complete(anima,function(){
                moveState = true;
                an_mask.start({
                    opacity:0
                });

                complete(an_mask,function(){
                    obj.style.display = 'none';
                    window.at['_toolsing'] = false;
                    body.style.cssText = oldStyle[0];
                    if(ie6){
                        html.style.cssText = oldStyle[1];
                    }
                    if(typeof callback === 'function'){
                        callback();
                    }
                })
            })
        }

        function complete(name,fn){
            name.complete = function(){
                if(typeof fn === 'function'){
                    fn();
                }
                moveState = false;
                name.complete = null;
            }
        }

        return {
            show : show,
            close : close,
            init : init
        }
    }

    function setWidth(conBoxId,atBoxId,helpId,atopNavId){
        var conBox = document.getElementById(conBoxId),
            atBox = document.getElementById(atBoxId),
            help = document.getElementById(helpId),
            atopNav = document.getElementById(atopNavId),
            w = document.documentElement.clientWidth || document.body.clientWidth;
        
        function set(){
            if(w<1150){
                conBox.style.padding = '0';
                conBox.style.backgroundPosition ='left top';
                conBox.style.width = '1065px';
                atBox.style.width = '1065px';
                help.style.pdding = '0';
                atopNav.style.padding = '0';
                return;
            }
            atBox.style.width = '100%';
            conBox.style.backgroundPosition = 'center top';
            conBox.style.padding = '0 0 0 ' + (w-980)/2 + 'px';
            conBox.style.width = (w+980)/2 + 'px';
            help.style.padding = '0 0 0 ' + (w-980)/2 + 'px';
            atopNav&&(atopNav.style.padding = '0 0 0 ' + (w-980)/2 + 'px');
            
        }
        var widthTimer=null;
        if(document.all){
            widthTimer=setInterval(function(){
                if(!window.at['sideBarDoing'] || !window.at['_toolsing']){
                    var Temw = document.documentElement.clientWidth || document.body.clientWidth;
                    if(w!=Temw){
                        w=Temw;
                        set();
                    }
                }
            },100);
        };
        //Event.add(window,'load',function(){widthTimer&&clearInterval(widthTimer);widthTimer=null;});
        Event.add(window,'resize',function(){
            if(widthTimer){
                clearInterval(widthTimer);
                widthTimer=null;
            }
            if(!window.at['sideBarDoing'] || !window.at['_toolsing']){
                w = document.documentElement.clientWidth || document.body.clientWidth;
                set();
            }
        });
        set();
    }

    window.at = {
        setBtns : setBtns,
        scrollHelp : scrollHelp,
        tools : _tools(),
        setWidth : setWidth,
        multiMenu : multiMenu,
        magShare : magShare
    }
})();