
/*
 * DOM元素单体类
 */
var Element = {
    /**
     * 判断是否有某种样式
     * @param {object} obj 元素对象
     * @param {string} name 样式名称
     */
	hasClass:function(obj,name){
		return (' '+obj.className+' ').indexOf(' '+name+' ') > -1 ? true : false;
	},
	/**
     * 添加样式
     * @param {object} obj 元素对象
     * @param {string} name 样式名称
     */
	addClass : function(obj,name){
		if(this.hasClass(obj,name)) return;
		obj.className += ' ' + name;
	},
	/**
     * 删除样式
     * @param {object}  obj 元素对象
     * @param {string} name 样式名
     */
	removeClass : function(obj,name){
		obj.className = obj.className.replace(new RegExp('(^|\\s)' +name+ '(?:\\s|$)'),'$1').replace(/\s{1,}/g,' ');
	},
	/**
     * 获取取样式值
     * @param {object} obj 元素对象
     * @param {style} style 样式内容对象{style名称:值}
     */
	getStyle : function(obj,style){
		var result;
		if(style == 'padding' || style=='margin'){
			result = '';
			for(var key in {top:0,right:0,bottom:0,left:0}){
				result += Element.getStyle(obj,style+'-'+key) + ' ';
			}
			result = result.replace(/\s$/,'');
			return result;
		}
		function getComStyle(property){
			if(obj.currentStyle) return obj.currentStyle[property.camelCase()];
			var computed = window.getComputedStyle(obj, null);
			return (computed) ? computed.getPropertyValue(property.hyphenate()) : null;
		}
		if(style == 'opacity'){
			if(window.ActiveXObject){
				result = getComStyle('filter').replace(/[^0-9\.]/g,'');
				result = result== '' ? 1 : parseInt(result*100)/10000;
				return result;
			}
			result = parseFloat(getComStyle(style));
			result = !result && result != 0 ? 1 : result; 
			
			return result;
		}
		style = style.camelCase();
		
		result = obj.style[style];

		if(!result&&result!==0){
			result = getComStyle(style);
		}
		if(result){
			if(/^(width)|(height)$/.test(style)){
				var path = style == 'width' ? ['left','right'] : ['top','bottom'],
					size =0;
				size = (parseInt(this.getStyle(obj,'padding-'+path[0])) || 0) + (parseInt(this.getStyle(obj,'padding-'+path[1])) || 0) + 
					   (parseInt(this.getStyle(obj,'border-'+path[0]+'-width')) || 0 ) + (parseInt(this.getStyle(obj,'border-'+path[1]+'-width')) || 0);
				result = obj['offset'+style.replace(/\b[a-z]/,function(m){return m.toUpperCase();})]-size;
				return result;
			}
			if(result == 'auto' && style == 'zIndex'){
				result = 0;
				return result;
			}
		}
		return result;
	},
	/**
     * 设置样式值
     * @param {object} obj 元素对象
     * @param {object} values 样式值对象{style名称:样式值}
     */
	setStyle : function(obj,values){
		var str = ';';
		for(var key in values){
			if(values.hasOwnProperty(key)){
				if(key == 'opacity'){
					str += key + ':' + values[key] + ';filter:alpha(opacity='+ values[key]*100 +');';
					continue;
				}
				if(/(rgb)|(#)/i.test(values[key]) || !parseInt(values[key])){
					str += key +':'+ values[key] +  ';';
					continue;
				}
				str += key +':'+ Math.round(values[key])  + 'px;';
			}
		}
		obj.style.cssText += str;
		str = null;
		return ;
	},
	/**
     * 返回元素距页面的坐标，{x:坐标值,y:坐标值}
     * @param {object}|{string} 元素id或者元素对象
     */
	getPosition:function(obj){
		var o = typeof obj === 'string' ? document.getElementById(obj) : obj,
			x=0,
			y=0;
		while(o){
			x+=o.offsetLeft;
			y+=o.offsetTop;
			o = o.offsetParent;
		}
		return {x:x,y:y}
	},
	/**
     * 得元素距页面的坐标(针对覆层上名片位置做单独处理),返回{x:坐标值,y:坐标值}
     * @param {object}|{string} id或者DOM对象
     */
	getPositions:function(obj){
        var o = typeof obj === 'string' ? document.getElementById(obj) : obj,
            x=0,
            y=0;
        while(o){
            x+=o.offsetLeft;
            y+=o.offsetTop;
            if(o.style.position.toLowerCase() == "fixed" || o.className == "win_contBox"){
                var t = document.getElementsByTagName("body")[0].scrollTop || document.documentElement.scrollTop;
                t = t-document.getElementById("win_contBox").scrollTop; //减去覆层的卷去的高度
                y+=t;
            }
            o = o.offsetParent;
        }
        return {x:x,y:y}
    },
    /**
     * 得到孩子集合
     * @param {object}|{string} obj 元素id或者元素对象
     * @param {node} node 标签名
     */
	getChild:function(obj,node){
		var o = typeof obj === 'string' ? document.getElementById(obj) : obj,
			list = o.childNodes,
			nodes = [];
		for(var i=0,l=list.length;i<l;i++){
			if(node){
				if(list[i].nodeName == node.toUpperCase()){
					nodes.push(list[i]);
				}
			}else{
				if(list[i].nodeType == 1) nodes.push(list[i])
			}
		}
		o=null;list=null;
		return nodes;
	},
	/**
     * 通过id寻找下面的class元素,返回的是第一个元素
     * @param {string} arguments 形式为"#id>.className>.className"
     */
	getElement:function(){
	    var ele = arguments[0].split(">"),i=0,target;
	    while( i < ele.length){
	        if(/^#/g.test(ele[i])){
	            target = document.getElementById(ele[i].substr(1,ele[i].length-1));
	        }else if(/^./g.test(ele[i])){
	            var child = target.children;
	            for(var j = 0,len = child.length;j<len;j++){
	                if(child[j].className.indexOf(ele[i].substr(1,ele[i].length-1))>0){
	                    target = child[j][0];
	                    break;
	                }
	            }
	        }else{
	             var child = target.document.getElementsByTagName(ele[i]);
                for(var j = 0,len = child.length;j<len;j++){
                    if(child[j].className.indexOf(ele[i].substr(1,ele[i].length-1)>0)){
                        target = child[j][0];
                        break;
                    }
                }
	        }
	        i++;
	    }
	    return target;
	},
	/**
     * 对象的简单继承,返回完整对象
     * @param {object} a 
     * @param {object} b
     */
	extend:function(obj1,obj2){
	    for(var i in obj2){
	        obj1[i] = obj2[i];
	    }
	    return obj1;
	},
	/**
     * 超出给定的字节数显示，返回截取完的文本内容
     * @param {string} str 文本内容
     * @param {number} num 要截取的字节个数
     * @param {string} chars 省略的形式，默认为"..."
     */
	fixStr: function(str, num, chars) {
	    //参数说明：(str:文本内容 | num:要截取的字节个数 | chars:省略的形式，默认为"...")
        var resStr,newStr,diLen,that = this;
        newStr = str.toString();
        if (!chars) {
            chars = "..."
        }
        diLen = that.getTextlength(newStr) - num;
        if (diLen > 0) {
            resStr = cutStr(newStr, num) + chars
        } else {
            resStr = newStr
        }
        return resStr;
        function cutStr(str, num) {
            var n = 0,p = [];
            for (var i = 0,
            len = str.length; i < len; i++) {
                if (n > num - 1) {
                    break
                }
                if (str.charCodeAt(i) > 255) {
                    p.push(str.charAt(i));
                    n += 2
                } else {
                    p.push(str.charAt(i));
                    n++
                }
            }
            return p.join("");
        }
    },
    /**
     * 计算字节数，英文0.5，中文为1个字节
     * @param {string} str 文本内容
     */
    getbytelength: function(str) {
        //参数说明：(str:文本内容)
        if (str == undefined || str.length < 1) {
            return 0
        }
        var n = 0;
        for (var i = 0; i < str.length; i++) {
            if (str.charCodeAt(i) > 255) {
                n = n + 1
            } else {
                n = n + 0.5
            }
        }
        return Math.round(n);
    },
    /**
     * 计算字数，英文1，中文为2个字节
     * @param {string} str 文本内容
     */
    getTextlength: function(str) {
        //参数说明：(str:文本内容)
        var n = 0;
        for (var i = 0; i < str.length; i++) {
            if (str.charCodeAt(i) > 255) {
                n += 2
            } else {
                n++
            }
        }
        return n;
    }
}


/**
 * 事件单体类
 */
var Event = {
    /**
     * 给元素添加事件
     * @param {object} obj 元素对象
     * @param {string} type 事件类型
     * @param {function} fn 回调函数
     */
	add : (function(){
		if(document.addEventListener){
			return function(obj,type,fn){ obj.addEventListener(type,fn,false)}
		}
		return function(obj,type,fn){ obj.attachEvent('on'+type,fn)}
	})(),
	/**
     * 给元素移除事件
     * @param {object} obj 元素对象
     * @param {string} type 事件类型
     * @param {function} fn 回调函数
     */
	remove : (function(){
		if(document.removeEventListener){
			return function(obj,type,fn){ obj.removeEventListener(type,fn,false)}
		}
		return  function(obj,type,fn){ obj.detachEvent('on'+type,fn)}
	})(),
	/**
     * 阻止事件冒泡
     * @param {object} e 事件对象event
     */
	stop:function(e){
		if(e&&e.stopPropagation){
			e.stopPropagation();
			e.preventDefault();
		}else{
			window.event.cancelBubble = true;
			window.event.returnValue = false;
		}
	}
}

