﻿using System;
using System.Collections;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Data;

using ShoveEL.Database;

public partial class Lottery
{
    public class LotteryBuyType
    {
        public int BuyType_id;
        public string BuyType_Name;

        public LotteryBuyType(int buytype_id, string buytype_name)
        {
            BuyType_id = buytype_id;
            BuyType_Name = buytype_name;
        }
    }

    public class LotteryBase
    {
        public int id;
        public int buytype_c;
        public string name;
        public string code;

        #region 虚拟方法
        public virtual bool CheckBuyType(int buy_type)
        {
            return false;
        }

        public virtual string BuildNumber(int Num)
        {
            return "";
        }
        public virtual string BuildNumber(int Num, int Type)
        {
            return "";
        }
        public virtual string BuildNumber(int Red, int Blue, int Num)
        {
            return "";
        }

        public virtual string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)
        {
            return null;
        }

        public virtual double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            return 0;
        }
        public virtual double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, int ExtType, params double[] WinMoneyList)
        {
            return 0;
        }
        //足彩单场专用
        public virtual double ComputeWin(string Scheme, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, int CompetitionCount, string NoSignificance)
        {
            return 0;
        }

        //足彩单场专用
        public virtual bool GetSchemeSplit(string Scheme, ref string BuyContent, ref string CnLocateWaysAndMultiples)
        {
            return true;
        }

        public virtual string AnalyseScheme(string Content, int BuyType)
        {
            return "";
        }
        public virtual string AnalyseScheme(string Content, int BuyType, int ExtType)
        {
            return "";
        }

        public virtual bool AnalyseWinNumber(string Number)
        {
            return true;
        }
        //足彩单场专用
        public virtual bool AnalyseWinNumber(string Number, int CompetitionCount)
        {
            return true;
        }

        public virtual string ShowNumber(string Number)
        {
            return "";
        }

        public virtual LotteryBuyType[] GetBuyTypeList()
        {
            return null;
        }

        public virtual string GetPrintKeyList(string Number, int BuyType_id, string LotteryMachine)
        {
            return "";
        }
        #endregion

        protected class CompareToAscii : IComparer
        {
            int IComparer.Compare(Object x, Object y)
            {
                return ((new CaseInsensitiveComparer()).Compare(x, y));
            }
        }

        protected bool isExistBall(ArrayList al, int Ball)
        {
            if (al.Count == 0)
                return false;
            for (int i = 0; i < al.Count; i++)
                if (int.Parse(al[i].ToString()) == Ball)
                    return true;
            return false;
        }

        protected string Sort(string str)
        {
            char[] ch = str.ToCharArray();
            Array.Sort(ch, new CompareToAscii());
            return new string(ch);
        }

        protected string[] SplitLotteryNumber(string Number)
        {
            string[] s = Number.Split('\n');
            if (s.Length == 0)
                return null;
            for (int i = 0; i < s.Length; i++)
                s[i] = s[i].Trim();
            return s;
        }

        /// <summary>
        /// 将开奖好按一定的格式输出给表现层,有些彩种会原样输出，有些彩种会增加空格等等。
        /// </summary>
        /// <param name="Number"></param>
        /// <returns></returns>
        public string ShowNumber(string Number, string SpaceMark)
        {
            if (SpaceMark == "")
                return Number;

            Number = Number.Replace(" ", "");
            string Result = "";
            for (int i = 0; i < Number.Length; i++)
                Result += Number[i].ToString() + SpaceMark;

            return Result.Trim();
        }

        //检查此买类型是否是代购类型
        public bool isSurrogateBuyType(int BuyType)
        {
            return (((BuyType % 2) == 1) && (BuyType != buytype_c));
        }
    }

    public LotteryBase this[int Index]
    {
        get
        {
            switch (Index)
            {
                case 1:
                    return new SFC();
                case 2:
                    return new JQC();
                case 3:
                    return new QXC();
                case 4:
                    return new SZPL();
                case 5:
                    return new SSQ();
                case 6:
                    return new FC3D();
                case 7:
                    return new LJ36X7();
                case 8:
                    return new LJP62();
                case 9:
                    return new TC22X5();
                case 10:
                    return new FZ36X7();
                case 11:
                    return new CTFC32X7();
                case 12:
                    return new CTFC22X5();
                case 13:
                    return new QLC();
                case 14:
                    return new TC29X7();
                case 15:
                    return new LCBQC();
                case 16:
                    return new NYFC36X7();
                case 17:
                    return new NYFC26X5();
                case 18:
                    return new SJFC21X5();
                case 19:
                    return new LCDC();
                case 20:
                    return new SZFC35X7();
                case 21:
                    return new ZJ15X5();
                case 22:
                    return new ZJFC4J1();
                case 23:
                    return new HNFC22X5();
                case 24:
                    return new DFDLT();
                case 25:
                    return new AHFC25X5();
                case 26:
                    return new AHFC15X5();
                case 27:
                    return new QLFC23X5();
                case 28:
                    return new CQSSC();
                case 29:
                    return new SHSSL();
                case 30:
                    return new FJFC20X5();
                case 31:
                    return new AHFC5WS();
                case 32:
                    return new SZKL8();
                case 33:
                    return new BJKL8();
                case 34:
                    return new SHKeno();
                case 35:
                    return new FJTC31X7();
                case 36:
                    return new FJTC36X7();
                case 37:
                    return new FJTC22X5();
                case 38:
                    return new LNFC35X7();
                case 39:
                    return new TCCJDLT();
                case 40:
                    return new ZJTC20X5();
                case 41:
                    return new ZJTC6J1();
                case 42:
                    return new LJFC22X5();
                case 43:
                    return new LJTC6J1();
                case 44:
                    return new TTL22X5();
                case 45:
                    return new ZCDC();
                case 46:
                    return new TJFC15X5();
            }
            return null;
        }
    }

    public LotteryBase this[string Name_or_Code_or_ID]
    {
        get
        {
            LotteryBase[] lotterys = GetLotterys();

            foreach (LotteryBase lottery in lotterys)
            {
                if ((lottery.name == Name_or_Code_or_ID) || (lottery.code == Name_or_Code_or_ID) || (lottery.id.ToString() == Name_or_Code_or_ID))
                {
                    return lottery;
                }
            }

            return null;
        }
    }

    public LotteryBase[] GetLotterys()
    {
        int LotteryCount = 1;

        while (this[LotteryCount] != null)
        {
            LotteryCount++;
        }

        LotteryBase[] Lotterys = new LotteryBase[LotteryCount - 1];

        for (int i = 0; i < Lotterys.Length; i++)
        {
            Lotterys[i] = this[i + 1];
        }

        return Lotterys;
    }

    public string GetChaseBuyTypeName(int BuyType)
    {
        if (BuyType == 1)
        {
            return "自选号码";
        }

        if (BuyType == 2)
        {
            return "机选号码";
        }

        return "";
    }

    public string GetBuyTypeName(int BuyType)
    {
        LotteryBase[] lotterys = GetLotterys();

        foreach (LotteryBase lb in lotterys)
        {
            LotteryBuyType[] lbts = lb.GetBuyTypeList();

            foreach (LotteryBuyType lbt in lbts)
            {
                if (lbt.BuyType_id == BuyType)
                {
                    return lbt.BuyType_Name;
                }
            }
        }

        return "";
    }

    public bool GetIsUsed(int Lottery_id)
    {
        object Result = MSSQL.ExecuteFunction("F_GetLotteryIsused", new MSSQL.Parameter("id", SqlDbType.Int, 0, ParameterDirection.Input, Lottery_id));

        return System.Convert.ToBoolean(Result);
    }

    public int GetFirstUsedLotteryID()
    {
        DataTable dt = MSSQL.Select("select top 1 [id] from Lottery where isUsed=1 order by [Sort]");
        if ((dt == null) || (dt.Rows.Count < 1))
            return -1;

        return int.Parse(dt.Rows[0]["id"].ToString());
    }

    public int GetMaxLotteryID()
    {
        return this[GetLotterys().Length].id;
    }

    public string GetFirstUsedLotteryPlayPageForBuyQuick()
    {
        int Lottery_id = this["SZPL"].id;
        if (GetIsUsed(Lottery_id))
            return "MemberBuyQuick/SZPL3_ZhiF.aspx";

        Lottery_id = this["FC3D"].id;
        if (GetIsUsed(Lottery_id))
            return "MemberBuyQuick/FC3D_ZhiF.aspx";

        Lottery_id = this["SSQ"].id;
        if (GetIsUsed(Lottery_id))
            return "MemberBuyQuick/SSQ_F.aspx";

        Lottery_id = this["FJFC20X5"].id;
        if (GetIsUsed(Lottery_id))
            return "MemberBuyQuick/FJFC20X5_F.aspx";

        Lottery_id = this["FJTC22X5"].id;
        if (GetIsUsed(Lottery_id))
            return "MemberBuyQuick/FJTC22X5_F.aspx";

        Lottery_id = this["FJTC31X7"].id;
        if (GetIsUsed(Lottery_id))
            return "MemberBuyQuick/FJTC31X7_F.aspx";

        Lottery_id = this["FJTC36X7"].id;
        if (GetIsUsed(Lottery_id))
            return "MemberBuyQuick/FJTC36X7_F.aspx";

        return "Error2.aspx?ErrorNumber=01";
    }

    public string GetBasePlayPage(int Lottery_id)
    {
        DataTable dt = MSSQL.Select("select BasePlayPage from Lottery where [id]=" + Lottery_id.ToString());
        if ((dt == null) || (dt.Rows.Count < 1))
            return "";

        return dt.Rows[0]["BasePlayPage"].ToString();
    }

    public bool GetBasePlayPage(int Lottery_id, ref string D_Surrogate, ref string D_Join, ref string D_Initiate, ref string F_Surrogate, ref string F_Join, ref string F_Initiate)
    {
        D_Surrogate = "";
        D_Join = "";
        D_Initiate = "";
        F_Surrogate = "";
        F_Join = "";
        F_Initiate = "";

        string BasePlayPage = GetBasePlayPage(Lottery_id);
        if (BasePlayPage == "")
            return false;

        string[] strs = BasePlayPage.Split(',');
        if ((strs == null) || (strs.Length != 4))
            return false;

        DataTable dt = MSSQL.Select("select * from LotteryBuyType where Lottery_id = " + Lottery_id.ToString() + " order by [id]");
        if (dt == null)
        {
            return false;
        }

        DataRow[] dr = null;

        dr = dt.Select("id=" + Lottery_id.ToString() + strs[0]);
        if (dr.Length > 0)
        {
            D_Surrogate = dr[0]["BuyFileName"].ToString().Replace("[Lottery]", Lottery_id.ToString()).Replace("[BuyType]", dr[0]["id"].ToString());
        }

        dr = dt.Select("id=" + Lottery_id.ToString() + strs[1]);
        if (dr.Length > 0)
        {
            D_Join = dr[0]["BuyFileName"].ToString().Replace("[Lottery]", Lottery_id.ToString()).Replace("[BuyType]", dr[0]["id"].ToString());
            D_Initiate = D_Join.Replace("Join.aspx", "Initiate.aspx");
        }

        dr = dt.Select("id=" + Lottery_id.ToString() + strs[2]);
        if (dr.Length > 0)
        {
            F_Surrogate = dr[0]["BuyFileName"].ToString().Replace("[Lottery]", Lottery_id.ToString()).Replace("[BuyType]", dr[0]["id"].ToString());
        }

        dr = dt.Select("id=" + Lottery_id.ToString() + strs[3]);
        if (dr.Length > 0)
        {
            F_Join = dr[0]["BuyFileName"].ToString().Replace("[Lottery]", Lottery_id.ToString()).Replace("[BuyType]", dr[0]["id"].ToString());
            F_Initiate = D_Join.Replace("Join.aspx", "Initiate.aspx");
        }

        return true;
    }

    public string GetIntervalType(int Lottery_id)
    {
        DataTable dt = MSSQL.Select("select IntervalType from Lottery where [id]=" + Lottery_id.ToString());
        if ((dt == null) || (dt.Rows.Count < 1))
            return "";

        return dt.Rows[0]["IntervalType"].ToString();
    }

    public string GetOpenAfficheTemplate(int Lottery_id)
    {
        DataTable dt = MSSQL.Select("select OpenAfficheTemplate from Lottery where [id]=" + Lottery_id.ToString());
        if ((dt == null) || (dt.Rows.Count < 1))
            return "";

        string OpenAfficheTemplate = "";
        try
        {
            OpenAfficheTemplate = ShoveEL._String.Decompress((byte[])dt.Rows[0]["OpenAfficheTemplate"]);
        }
        catch { }

        return OpenAfficheTemplate;
    }

    public bool ValidID(int Lottery_id)
    {
        if ((Lottery_id < 1) || (Lottery_id > GetMaxLotteryID()))
            return false;

        if (!GetIsUsed(Lottery_id))
            return false;

        return true;
    }

    /// <summary>
    /// 胜负彩
    /// </summary>
    public partial class SFC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 101;
        public const int BuyType_D_H = 102;
        public const int BuyType_F_D = 103;
        public const int BuyType_F_H = 104;
        public const int BuyType_9_D_D = 105;
        public const int BuyType_9_D_H = 106;
        public const int BuyType_9_F_D = 107;
        public const int BuyType_9_F_H = 108;

        public const int ID = 1;
        public const string sID = "1";
        public const string Name = "胜负彩";
        public const string Code = "SFC";
        public const double MaxMoney = 20000;
        #endregion

        public SFC()
        {
            id = 1;
            buytype_c = -1;
            name = "胜负彩";
            code = "SFC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 101) && (buy_type <= 108));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[8];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_9_D_D, "任九场单式代购");
            Result[5] = new LotteryBuyType(BuyType_9_D_H, "任九场单式合买");
            Result[6] = new LotteryBuyType(BuyType_9_F_D, "任九场复式代购");
            Result[7] = new LotteryBuyType(BuyType_9_F_H, "任九场复式合买");

            return Result;
        }

        public override string BuildNumber(int Num, int Type)	//id = 1,  Type = 14 表示14场 , = 9 表示任选9
        {
            if ((Type != 14) && (Type != 9))
                Type = 14;

            if (Type == 14)
                return BuildNumber_14(Num);

            if (Type == 9)
                return BuildNumber_9(Num);

            return "";
        }
        #region BuildNumber 的具体方法
        private string BuildNumber_14(int Num)
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 14; j++)
                    LotteryNumber += "310"[rd.Next(0, 2 + 1)].ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string BuildNumber_9(int Num)
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = BuildNumber_14(1);
                for (int j = 0; j < 5; j++)
                {
                    int Locate = 0;
                    do
                    {
                        Locate = rd.Next(0, 13 + 1);
                    } while (LotteryNumber[Locate] == '-');

                    LotteryNumber = LotteryNumber.Remove(Locate, 1);
                    LotteryNumber = LotteryNumber.Insert(Locate, "-");
                }

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public string[,] SplitLotteryNumberForGrid(string Number)
        {
            string[] s = Number.Split('\n');
            if (s.Length == 0)
                return null;

            ArrayList[] al = new ArrayList[s.Length];

            for (int i = 0; i < al.Length; i++)
            {
                al[i] = new ArrayList();
                int start = 0;
                string temp = s[i];
                if (temp.Length < 14)
                    temp = temp.PadRight(14, ' ');
                while ((start < temp.Length) && (al[i].Count < 14))
                {
                    if (temp.Substring(start, 1) != "(")
                    {
                        al[i].Add(temp.Substring(start, 1));
                        start++;
                        continue;
                    }
                    int end = start + 1;
                    while (temp.Substring(end, 1) != ")")
                        end++;
                    string str = temp.Substring(start, end - start);
                    al[i].Add(str.Substring(1, str.Length - 1));
                    start = end + 1;
                }
            }

            string[,] Result = new string[al.Length, 14];
            for (int i = 0; i < al.Length; i++)
                for (int j = 0; ((j < al[i].Count) && (j < 14)); j++)
                    Result[i, j] = al[i][j].ToString();
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H))
                return ToSingle_14(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_9_D_D) || (BuyType == BuyType_9_D_H) || (BuyType == BuyType_9_F_D) || (BuyType == BuyType_9_F_H))
                return ToSingle_9(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_14(string Number, ref string CanonicalNumber)
        {
            string[] Locate = new string[14];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>([\d])|([(][\d]+?[)]))(?<L1>([\d])|([(][\d]+?[)]))(?<L2>([\d])|([(][\d]+?[)]))(?<L3>([\d])|([(][\d]+?[)]))(?<L4>([\d])|([(][\d]+?[)]))(?<L5>([\d])|([(][\d]+?[)]))(?<L6>([\d])|([(][\d]+?[)]))(?<L7>([\d])|([(][\d]+?[)]))(?<L8>([\d])|([(][\d]+?[)]))(?<L9>([\d])|([(][\d]+?[)]))(?<L10>([\d])|([(][\d]+?[)]))(?<L11>([\d])|([(][\d]+?[)]))(?<L12>([\d])|([(][\d]+?[)]))(?<L13>([\d])|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 14; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Locate[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Locate[5][i_5].ToString();
                                    for (int i_6 = 0; i_6 < Locate[6].Length; i_6++)
                                    {
                                        string str_6 = str_5 + Locate[6][i_6].ToString();
                                        for (int i_7 = 0; i_7 < Locate[7].Length; i_7++)
                                        {
                                            string str_7 = str_6 + Locate[7][i_7].ToString();
                                            for (int i_8 = 0; i_8 < Locate[8].Length; i_8++)
                                            {
                                                string str_8 = str_7 + Locate[8][i_8].ToString();
                                                for (int i_9 = 0; i_9 < Locate[9].Length; i_9++)
                                                {
                                                    string str_9 = str_8 + Locate[9][i_9].ToString();
                                                    for (int i_10 = 0; i_10 < Locate[10].Length; i_10++)
                                                    {
                                                        string str_10 = str_9 + Locate[10][i_10].ToString();
                                                        for (int i_11 = 0; i_11 < Locate[11].Length; i_11++)
                                                        {
                                                            string str_11 = str_10 + Locate[11][i_11].ToString();
                                                            for (int i_12 = 0; i_12 < Locate[12].Length; i_12++)
                                                            {
                                                                string str_12 = str_11 + Locate[12][i_12].ToString();
                                                                for (int i_13 = 0; i_13 < Locate[13].Length; i_13++)
                                                                {
                                                                    string str_13 = str_12 + Locate[13][i_13].ToString();
                                                                    al.Add(str_13);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_9(string Number, ref string CanonicalNumber)
        {
            string[] Locate = new string[14];
            CanonicalNumber = "";

            // 任9场,有5个“-”
            if (ShoveEL._String.StringAt(Number, '-') != 5)
            {
                CanonicalNumber = "";
                return null;
            }

            Regex regex = new Regex(@"(?<L0>([\d-])|([(][\d]+?[)]))(?<L1>([\d-])|([(][\d]+?[)]))(?<L2>([\d-])|([(][\d]+?[)]))(?<L3>([\d-])|([(][\d]+?[)]))(?<L4>([\d-])|([(][\d]+?[)]))(?<L5>([\d-])|([(][\d]+?[)]))(?<L6>([\d-])|([(][\d]+?[)]))(?<L7>([\d-])|([(][\d]+?[)]))(?<L8>([\d-])|([(][\d]+?[)]))(?<L9>([\d-])|([(][\d]+?[)]))(?<L10>([\d-])|([(][\d]+?[)]))(?<L11>([\d-])|([(][\d]+?[)]))(?<L12>([\d-])|([(][\d]+?[)]))(?<L13>([\d-])|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 14; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Locate[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Locate[5][i_5].ToString();
                                    for (int i_6 = 0; i_6 < Locate[6].Length; i_6++)
                                    {
                                        string str_6 = str_5 + Locate[6][i_6].ToString();
                                        for (int i_7 = 0; i_7 < Locate[7].Length; i_7++)
                                        {
                                            string str_7 = str_6 + Locate[7][i_7].ToString();
                                            for (int i_8 = 0; i_8 < Locate[8].Length; i_8++)
                                            {
                                                string str_8 = str_7 + Locate[8][i_8].ToString();
                                                for (int i_9 = 0; i_9 < Locate[9].Length; i_9++)
                                                {
                                                    string str_9 = str_8 + Locate[9][i_9].ToString();
                                                    for (int i_10 = 0; i_10 < Locate[10].Length; i_10++)
                                                    {
                                                        string str_10 = str_9 + Locate[10][i_10].ToString();
                                                        for (int i_11 = 0; i_11 < Locate[11].Length; i_11++)
                                                        {
                                                            string str_11 = str_10 + Locate[11][i_11].ToString();
                                                            for (int i_12 = 0; i_12 < Locate[12].Length; i_12++)
                                                            {
                                                                string str_12 = str_11 + Locate[12][i_12].ToString();
                                                                for (int i_13 = 0; i_13 < Locate[13].Length; i_13++)
                                                                {
                                                                    string str_13 = str_12 + Locate[13][i_13].ToString();
                                                                    al.Add(str_13);
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))    // 奖金参数排列顺序 14场1等，2等, 任9场1等
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H))
                return ComputeWin_14(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3]);

            if ((BuyType == BuyType_9_D_D) || (BuyType == BuyType_9_D_H) || (BuyType == BuyType_9_F_D) || (BuyType == BuyType_9_F_H))
                return ComputeWin_9(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[4], WinMoneyList[5]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_14(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_14(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    int Right = 0;
                    for (int j = 0; j < 14; j++)
                    {
                        if ((WinNumber[j] == '*') || (Lottery[i][j] == WinNumber[j]))
                            Right++;
                    }

                    if (Right == 14)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                    else if (Right == 13)
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_9(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_9(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    int Right = 0;
                    for (int j = 0; j < 14; j++)
                    {
                        if ((WinNumber[j] == '*') || (Lottery[i][j] == WinNumber[j]) || (Lottery[i][j] == '-'))
                            Right++;
                    }

                    if (Right == 14)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H))
                return AnalyseScheme_14(Content, BuyType);

            if ((BuyType == BuyType_9_D_D) || (BuyType == BuyType_9_D_H) || (BuyType == BuyType_9_F_D) || (BuyType == BuyType_9_F_H))
                return AnalyseScheme_9(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_14(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H))
                RegexString = @"([013]){14}";
            else
                RegexString = @"(([013])|([(][013]{1,3}[)])){14}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_14(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_9(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_9_D_D) || (BuyType == BuyType_9_D_H))
                RegexString = @"([013-]){14}";
            else
                RegexString = @"(([013-])|([(][013]{1,3}[)])){14}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_9(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_9_D_D) || (BuyType == BuyType_9_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            Number = Number.Replace("*", "0");  // * 表示比赛取消，什么结果都算对。

            string t_str = "";
            string[] WinLotteryNumber = ToSingle_14(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("013-".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 四场进球彩
    /// </summary>
    public partial class JQC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 201;
        public const int BuyType_D_H = 202;
        public const int BuyType_F_D = 203;
        public const int BuyType_F_H = 204;

        public const int ID = 2;
        public const string sID = "2";
        public const string Name = "四场进球彩";
        public const string Code = "JQC";
        public const double MaxMoney = 20000;
        #endregion

        public JQC()
        {
            id = 2;
            buytype_c = -1;
            name = "四场进球彩";
            code = "JQC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 201) && (buy_type <= 204));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[4];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 2
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 8; j++)
                {
                    LotteryNumber += rd.Next(0, 3 + 1).ToString();
                }
                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public string[,] SplitLotteryNumberForGrid(string Number)
        {
            string[] s = Number.Split('\n');
            if (s.Length == 0)
                return null;

            ArrayList[] al = new ArrayList[s.Length];

            for (int i = 0; i < al.Length; i++)
            {
                al[i] = new ArrayList();
                int start = 0;
                string temp = s[i];
                if (temp.Length < 8)
                    temp = temp.PadRight(8, ' ');
                while ((start < temp.Length) && (al[i].Count < 8))
                {
                    if (temp.Substring(start, 1) != "(")
                    {
                        al[i].Add(temp.Substring(start, 1));
                        start++;
                        continue;
                    }
                    int end = start + 1;
                    while (temp.Substring(end, 1) != ")")
                        end++;
                    string str = temp.Substring(start, end - start);
                    al[i].Add(str.Substring(1, str.Length - 1));
                    start = end + 1;
                }
            }

            string[,] Result = new string[al.Length, 8];
            for (int i = 0; i < al.Length; i++)
                for (int j = 0; ((j < al[i].Count) && (j < 8)); j++)
                    Result[i, j] = al[i][j].ToString();
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            string[] Locate = new string[8];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))(?<L5>(\d)|([(][\d]+?[)]))(?<L6>(\d)|([(][\d]+?[)]))(?<L7>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 8; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Locate[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Locate[5][i_5].ToString();
                                    for (int i_6 = 0; i_6 < Locate[6].Length; i_6++)
                                    {
                                        string str_6 = str_5 + Locate[6][i_6].ToString();
                                        for (int i_7 = 0; i_7 < Locate[7].Length; i_7++)
                                        {
                                            string str_7 = str_6 + Locate[7][i_7].ToString();
                                            al.Add(str_7);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 8)
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 2))
                return -3;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 8)
                        continue;
                    int Right = 0;
                    for (int j = 0; j < 8; j++)
                        if (Lottery[i][j] == WinNumber[j])
                            Right++;

                    if (Right == 8)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H))
                RegexString = @"([0123]){8}";
            else
                RegexString = @"(([0123])|([(][0123]{1,4}[)])){8}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                string CanonicalNumber = "";
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 七星彩
    /// </summary>
    public partial class QXC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 301;
        public const int BuyType_D_H = 302;
        public const int BuyType_F_D = 303;
        public const int BuyType_F_H = 304;
        public const int BuyType_C = 305;

        public const int ID = 3;
        public const string sID = "3";
        public const string Name = "七星彩";
        public const string Code = "QXC";
        public const double MaxMoney = 20000;
        #endregion

        public QXC()
        {
            id = 3;
            buytype_c = 305;
            name = "七星彩";
            code = "QXC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 301) && (buy_type <= 305));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 3
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 7; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：123(445)(11)... 变成123(45)1...
        {
            string[] Locate = new string[7];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))(?<L5>(\d)|([(][\d]+?[)]))(?<L6>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 7; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Locate[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Locate[5][i_5].ToString();
                                    for (int i_6 = 0; i_6 < Locate[6].Length; i_6++)
                                    {
                                        string str_6 = str_5 + Locate[6][i_6].ToString();
                                        al.Add(str_6);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 7)
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 12))
                return -3;

            int Description0 = 0, Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 7)
                        continue;
                    if (Lottery[i] == WinNumber)
                    {
                        Description0++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }

                    int j;
                    bool End = false;
                    for (j = 0; j <= 1; j++)
                    {
                        if (Lottery[i].Substring(j, 6) == WinNumber.Substring(j, 6))
                        {
                            Description1++;
                            WinMoney += WinMoneyList[2];
                            WinMoneyNoWithTax += WinMoneyList[3];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    for (j = 0; j <= 2; j++)
                    {
                        if (Lottery[i].Substring(j, 5) == WinNumber.Substring(j, 5))
                        {
                            Description2++;
                            WinMoney += WinMoneyList[4];
                            WinMoneyNoWithTax += WinMoneyList[5];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    for (j = 0; j <= 3; j++)
                    {
                        if (Lottery[i].Substring(j, 4) == WinNumber.Substring(j, 4))
                        {
                            Description3++;
                            WinMoney += WinMoneyList[6];
                            WinMoneyNoWithTax += WinMoneyList[7];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    for (j = 0; j <= 4; j++)
                    {
                        if (Lottery[i].Substring(j, 3) == WinNumber.Substring(j, 3))
                        {
                            Description4++;
                            WinMoney += WinMoneyList[8];
                            WinMoneyNoWithTax += WinMoneyList[9];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    for (j = 0; j <= 5; j++)
                    {
                        if (Lottery[i].Substring(j, 2) == WinNumber.Substring(j, 2))
                        {
                            Description5++;
                            WinMoney += WinMoneyList[10];
                            WinMoneyNoWithTax += WinMoneyList[11];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;
                }
            }

            if (Description0 > 0)
                Description = "特等奖" + Description0.ToString() + "注";
            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"([\d]){7}";
            else
                RegexString = @"(([\d])|([(][\d]{1,10}[)])){7}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 数字排列
    /// </summary>
    public partial class SZPL : LotteryBase
    {
        #region 静态变量
        public const int BuyType_3_ZhiD_D = 401;
        public const int BuyType_3_ZhiD_H = 402;
        public const int BuyType_3_ZhiF_D = 403;
        public const int BuyType_3_ZhiF_H = 404;
        public const int BuyType_3_ZuD_D = 405;
        public const int BuyType_3_ZuD_H = 406;
        public const int BuyType_3_Zu6F_D = 407;
        public const int BuyType_3_Zu6F_H = 408;
        public const int BuyType_3_Zu3F_D = 409;
        public const int BuyType_3_Zu3F_H = 410;
        public const int BuyType_3_ZhiH_D = 411;
        public const int BuyType_3_ZhiH_H = 412;
        public const int BuyType_3_ZuH_D = 413;
        public const int BuyType_3_ZuH_H = 414;
        public const int BuyType_5_D_D = 415;
        public const int BuyType_5_D_H = 416;
        public const int BuyType_5_F_D = 417;
        public const int BuyType_5_F_H = 418;
        public const int BuyType_C = 419;

        public const int ID = 4;
        public const string sID = "4";
        public const string Name = "数字排列";
        public const string Code = "SZPL";
        public const double MaxMoney = 20000;
        #endregion

        public SZPL()
        {
            id = 4;
            buytype_c = 419;
            name = "数字排列";
            code = "SZPL";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 401) && (buy_type <= 419));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[19];

            Result[0] = new LotteryBuyType(BuyType_3_ZhiD_D, "排列3直选单式代购");
            Result[1] = new LotteryBuyType(BuyType_3_ZhiD_H, "排列3直选单式合买");
            Result[2] = new LotteryBuyType(BuyType_3_ZhiF_D, "排列3直选复式代购");
            Result[3] = new LotteryBuyType(BuyType_3_ZhiF_H, "排列3直选复式合买");
            Result[4] = new LotteryBuyType(BuyType_3_ZuD_D, "排列3组选单式代购");
            Result[5] = new LotteryBuyType(BuyType_3_ZuD_H, "排列3组选单式合买");
            Result[6] = new LotteryBuyType(BuyType_3_Zu6F_D, "排列3组选6复式代购");
            Result[7] = new LotteryBuyType(BuyType_3_Zu6F_H, "排列3组选6复式合买");
            Result[8] = new LotteryBuyType(BuyType_3_Zu3F_D, "排列3组选3复式代购");
            Result[9] = new LotteryBuyType(BuyType_3_Zu3F_H, "排列3组选3复式合买");
            Result[10] = new LotteryBuyType(BuyType_3_ZhiH_D, "排列3直选和值代购");
            Result[11] = new LotteryBuyType(BuyType_3_ZhiH_H, "排列3直选和值合买");
            Result[12] = new LotteryBuyType(BuyType_3_ZuH_D, "排列3组选和值代购");
            Result[13] = new LotteryBuyType(BuyType_3_ZuH_H, "排列3组选和值合买");
            Result[14] = new LotteryBuyType(BuyType_5_D_D, "排列5单式代购");
            Result[15] = new LotteryBuyType(BuyType_5_D_H, "排列5单式合买");
            Result[16] = new LotteryBuyType(BuyType_5_F_D, "排列5复式代购");
            Result[17] = new LotteryBuyType(BuyType_5_F_H, "排列5复式合买");
            Result[18] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num, int Type)	//id = 4, Type = 3 表示排列3, = 5 表示排列5
        {
            if ((Type != 3) && (Type != 5))
                Type = 5;

            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < Type; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)
        {
            if ((BuyType == BuyType_3_ZhiD_D) || (BuyType == BuyType_3_ZhiD_H) || (BuyType == BuyType_3_ZhiF_D) || (BuyType == BuyType_3_ZhiF_H))
                return ToSingle_3(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_3_ZuD_D) || (BuyType == BuyType_3_ZuD_H) || (BuyType == BuyType_3_Zu6F_D) || (BuyType == BuyType_3_Zu6F_H))
                return ToSingle_ZuD_Zu6F(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_3_Zu3F_D) || (BuyType == BuyType_3_Zu3F_H))
                return ToSingle_Zu3F(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_3_ZhiH_D) || (BuyType == BuyType_3_ZhiH_H))
                return ToSingle_ZhiH(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_3_ZuH_D) || (BuyType == BuyType_3_ZuH_H))
                return ToSingle_ZuH(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_5_D_D) || (BuyType == BuyType_5_D_H) || (BuyType == BuyType_5_F_D) || (BuyType == BuyType_5_F_H))
                return ToSingle_5(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_3(string Number, ref string CanonicalNumber)	//复式取单式, 后面 ref 参数是将彩票规范化，如：10(223) 变成10(23)
        {
            string[] Locate = new string[3];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 3; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        al.Add(str_2);
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_ZuD_Zu6F(string Number, ref string CanonicalNumber)	//复式取单式, 后面 ref 参数是将彩票规范化，如：10223) 变成1023
        {
            CanonicalNumber = FilterRepeated(Number.Trim());
            if (CanonicalNumber.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            char[] strs = CanonicalNumber.ToCharArray();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;

            if (n == 2)
            {
                for (int i = 0; i < n - 1; i++)
                    for (int j = i + 1; j < n; j++)
                    {
                        al.Add(strs[i].ToString() + strs[i].ToString() + strs[j].ToString());
                        al.Add(strs[i].ToString() + strs[j].ToString() + strs[j].ToString());
                    }

            }
            else
            {
                for (int i = 0; i < n - 2; i++)
                    for (int j = i + 1; j < n - 1; j++)
                        for (int k = j + 1; k < n; k++)
                            al.Add(strs[i].ToString() + strs[j].ToString() + strs[k].ToString());
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_Zu3F(string Number, ref string CanonicalNumber)	//组选3取单式,后面 ref 参数是将彩票规范化，如：10223) 变成1023，由于单式是3个数，复式可以是2个数，所以，这个函数不同于其他彩种的类似函数，单式不能使用这个函数转换。
        {
            CanonicalNumber = FilterRepeated(Number.Trim());
            if (CanonicalNumber.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            char[] strs = CanonicalNumber.ToCharArray();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                {
                    al.Add(strs[i].ToString() + strs[i].ToString() + strs[j].ToString());
                    al.Add(strs[i].ToString() + strs[j].ToString() + strs[j].ToString());
                }

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_ZhiH(string sBall, ref string CanonicalNumber)	//直选和值取单式,后面 ref 参数是将彩票规范化，如：05) 变成 5
        {
            int Ball = ShoveEL._Convert.StrToInt(sBall, -1);
            CanonicalNumber = "";

            if ((Ball < 0) || (Ball > 27))
            {
                CanonicalNumber = "";
                return null;
            }

            CanonicalNumber = Ball.ToString();

            ArrayList al = new ArrayList();

            #region 循环取单式

            for (int i = 0; i <= 9; i++)
                for (int j = 0; j <= 9; j++)
                    for (int k = 0; k <= 9; k++)
                        if (i + j + k == Ball)
                            al.Add(i.ToString() + j.ToString() + k.ToString());

            #endregion

            if (al.Count == 0)
                return null;

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_ZuH(string sBall, ref string CanonicalNumber)	//组选3、6和值取单式,后面 ref 参数是将彩票规范化，如：05) 变成 5
        {
            int Ball = ShoveEL._Convert.StrToInt(sBall, -1);
            CanonicalNumber = "";

            ArrayList al = new ArrayList();

            #region 循环取单式

            if ((Ball < 1) || (Ball > 26))
            {
                CanonicalNumber = "";
                return null;
            }
            else
            {
                for (int i = 0; i <= 9; i++)
                    for (int j = 0; j <= 9; j++)
                    {
                        if (i == j)
                            continue;
                        if (i + i + j == Ball)
                            al.Add(i.ToString() + i.ToString() + j.ToString());
                    }
            }

            if ((Ball >= 3) && (Ball <= 24))
            {
                for (int i = 0; i <= 7; i++)
                    for (int j = i + 1; j <= 8; j++)
                        for (int k = j + 1; k <= 9; k++)
                            if (i + j + k == Ball)
                                al.Add(i.ToString() + j.ToString() + k.ToString());
            }

            #endregion

            CanonicalNumber = Ball.ToString();

            if (al.Count == 0)
                return null;

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_5(string Number, ref string CanonicalNumber)	//复式取单式, 后面 ref 参数是将彩票规范化，如：10(223)45 变成10(23)45
        {
            string[] Locate = new string[5];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 5; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                al.Add(str_4);
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, int ExtType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 8))    // 奖金参数排列顺序 zhi, zu3 zu6, 排列5
                return -3;

            if ((BuyType == BuyType_3_ZhiD_D) || (BuyType == BuyType_3_ZhiD_H) || (BuyType == BuyType_3_ZhiF_D) || (BuyType == BuyType_3_ZhiF_H))
                return ComputeWin_3(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);

            if ((BuyType == BuyType_3_ZuD_D) || (BuyType == BuyType_3_ZuD_H) || (BuyType == BuyType_3_Zu6F_D) || (BuyType == BuyType_3_Zu6F_H))
                return ComputeWin_ZuD_Zu6F(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_3_Zu3F_D) || (BuyType == BuyType_3_Zu3F_H))
                return ComputeWin_Zu3F(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3]);

            if ((BuyType == BuyType_3_ZhiH_D) || (BuyType == BuyType_3_ZhiH_H))
                return ComputeWin_ZhiH(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);

            if ((BuyType == BuyType_3_ZuH_D) || (BuyType == BuyType_3_ZuH_H))
                return ComputeWin_ZuH(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_5_D_D) || (BuyType == BuyType_5_D_H) || (BuyType == BuyType_5_F_D) || (BuyType == BuyType_5_F_H))
                return ComputeWin_5(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[6], WinMoneyList[7]);

            if (BuyType == BuyType_C)
            {
                if ((ExtType == 1) || (ExtType == 2))
                {
                    return ComputeWin_5(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[6], WinMoneyList[7]);
                }
                else
                {
                    return ComputeWin_3(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);
                }
            }

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_3(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(0, 3);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_3(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "单选奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_ZuD_Zu6F(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(0, 3);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";

                if (Lotterys[ii].Length < 3)
                    continue;

                if (FilterRepeated(Sort(Lotterys[ii])).Length == 2)
                {
                    if (Sort(Lotterys[ii]) == Sort(WinNumber))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }

                    continue;
                }

                string[] Lottery = ToSingle_ZuD_Zu6F(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                    }
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";
            if (Description2 > 0)
                Description = "组选6奖" + Description2.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Zu3F(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "223"
                return -1;
            WinNumber = WinNumber.Substring(0, 3);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zu3F(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_ZhiH(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(0, 3);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_ZhiH(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "单选奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_ZuH(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(0, 3);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_ZuH(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        if (FilterRepeated(Lottery[i]).Length == 2)
                        {
                            Description1++;
                            WinMoney += WinMoney1;
                            WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        }
                        else
                        {
                            Description2++;
                            WinMoney += WinMoney2;
                            WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        }
                    }
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";
            if (Description2 > 0)
                Description = "组选6奖" + Description2.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_5(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 5)	//3: "12345"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_5(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 5)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "排列5直选奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_3_ZhiD_D) || (BuyType == BuyType_3_ZhiD_H) || (BuyType == BuyType_3_ZhiF_D) || (BuyType == BuyType_3_ZhiF_H))
                return AnalyseScheme_3(Content, BuyType);

            if ((BuyType == BuyType_3_ZuD_D) || (BuyType == BuyType_3_ZuD_H) || (BuyType == BuyType_3_Zu6F_D) || (BuyType == BuyType_3_Zu6F_H))
                return AnalyseScheme_ZuD_Zu6F(Content, BuyType);

            if ((BuyType == BuyType_3_Zu3F_D) || (BuyType == BuyType_3_Zu3F_H))
                return AnalyseScheme_Zu3F(Content, BuyType);

            if ((BuyType == BuyType_3_ZhiH_D) || (BuyType == BuyType_3_ZhiH_H))
                return AnalyseScheme_ZhiH(Content, BuyType);

            if ((BuyType == BuyType_3_ZuH_D) || (BuyType == BuyType_3_ZuH_H))
                return AnalyseScheme_ZuH(Content, BuyType);

            if ((BuyType == BuyType_5_D_D) || (BuyType == BuyType_5_D_H) || (BuyType == BuyType_5_F_D) || (BuyType == BuyType_5_F_H))
                return AnalyseScheme_5(Content, BuyType);

            return "";
        }
        public override string AnalyseScheme(string Content, int BuyType, int ExtType)
        {
            if (ExtType == 3)
                return AnalyseScheme_3(Content, BuyType);
            else
                return AnalyseScheme_5(Content, BuyType);
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_3(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_3_ZhiD_D) || (BuyType == BuyType_3_ZhiD_H))
                RegexString = @"([\d]){3}";
            else
                RegexString = @"(([\d])|([(][\d]{1,10}[)])){3}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_3(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_3_ZhiD_D) || (BuyType == BuyType_3_ZhiD_H) || (BuyType == BuyType_C)) ? 1 : 2))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZuD_Zu6F(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_3_ZuD_D) || (BuyType == BuyType_3_ZuD_H))
                RegexString = @"([\d]){3}";
            else
                RegexString = @"([\d]){3,10}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_ZuD_Zu6F(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_3_ZuD_D) || (BuyType == BuyType_3_ZuD_H)) ? 1 : 2))
                    {
                        if (FilterRepeated(Sort(m.Value)).Length == 2)
                        {
                            if ((BuyType != BuyType_3_Zu6F_D) && (BuyType != BuyType_3_Zu6F_H))
                            {
                                Result += m.Value + "|1\n";
                            }
                        }
                        else
                        {
                            Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                        }
                    }
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_Zu3F(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"([\d]){2,}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zu3F(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 2)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZhiH(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"([\d]){1,2}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_ZhiH(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZuH(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"([\d]){1,2}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_ZuH(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_5(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_5_D_D) || (BuyType == BuyType_5_D_H))
                RegexString = @"([\d]){5}";
            else
                RegexString = @"(([\d])|([(][\d]{1,10}[)])){5}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_5(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_5_D_D) || (BuyType == BuyType_5_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle_5(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 双色球
    /// </summary>
    public partial class SSQ : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 501;
        public const int BuyType_D_H = 502;
        public const int BuyType_F_D = 503;
        public const int BuyType_F_H = 504;
        public const int BuyType_C = 505;

        public const int ID = 5;
        public const string sID = "5";
        public const string Name = "双色球";
        public const string Code = "SSQ";
        public const double MaxMoney = 3720960;
        #endregion

        public SSQ()
        {
            id = 5;
            buytype_c = 505;
            name = "双色球";
            code = "SSQ";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 501) && (buy_type <= 505));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Red, int Blue, int Num)	//id = 5
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al_r = new ArrayList();
            ArrayList al_b = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al_r.Clear();
                al_b.Clear();
                for (int j = 0; j < Red; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al_r, Ball))
                        Ball = rd.Next(1, 33 + 1);
                    al_r.Add(Ball.ToString().PadLeft(2, '0'));
                }

                for (int j = 0; j < Blue; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al_b, Ball))
                        Ball = rd.Next(1, 16 + 1);
                    al_b.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al_r.Sort(compare);
                al_b.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al_r.Count; j++)
                    LotteryNumber += al_r[j].ToString() + " ";
                LotteryNumber += "+ ";
                for (int j = 0; j < al_b.Count; j++)
                    LotteryNumber += al_b[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = Number.Split('+');
            CanonicalNumber = "";

            if (strs.Length != 2)
            {
                CanonicalNumber = "";
                return null;
            }

            string[] Red = FilterRepeated(strs[0].Trim().Split(' '), 33);
            string[] Blue = FilterRepeated(strs[1].Trim().Split(' '), 16);

            if ((Red.Length < 6) || (Blue.Length < 1))
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < Red.Length; i++)
                CanonicalNumber += (Red[i] + " ");
            CanonicalNumber += "+ ";
            for (int i = 0; i < Blue.Length; i++)
                CanonicalNumber += (Blue[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = Red.Length;
            for (int i = 0; i < n - 5; i++)
                for (int j = i + 1; j < n - 4; j++)
                    for (int k = j + 1; k < n - 3; k++)
                        for (int x = k + 1; x < n - 2; x++)
                            for (int y = x + 1; y < n - 1; y++)
                                for (int z = y + 1; z < n; z++)
                                    for (int b = 0; b < Blue.Length; b++)
                                        al.Add(Red[i] + " " + Red[j] + " " + Red[k] + " " + Red[x] + " " + Red[y] + " " + Red[z] + " + " + Blue[b]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 06 + 01" 快乐星期天: "01 02 03 04 05 06 + 01 02" 重大节日: "01 02 03 04 05 06 + 01 02 03 04"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 14))
                return -3;

            string WinNumber_Red = WinNumber.Substring(0, 18);
            string WinNumber_Blue = WinNumber.Substring(20, WinNumber.Length - 20).Trim();

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, DescriptionSunday = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 22)
                        continue;

                    string[] Red = new string[6];
                    string Blue;
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)[+]\s(?<B0>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool BlueRightSunday = false;
                    bool Full = true;

                    for (int j = 0; j < 6; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber_Red.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    Blue = m.Groups["B0"].ToString().Trim();
                    if (Blue == "")
                        continue;

                    if (Blue == WinNumber_Blue.Substring(0, 2))
                        BlueRight = true;
                    if (WinNumber_Blue.IndexOf(" " + Blue) >= 0)
                        BlueRightSunday = true;

                    if ((RedRight == 6) && BlueRight)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) || ((RedRight == 4) && BlueRight))
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];

                        if ((RedRight == 5) && BlueRightSunday)	//快乐星期天
                        {
                            DescriptionSunday++;
                            WinMoney += WinMoneyList[12];
                            WinMoneyNoWithTax += WinMoneyList[13];
                        }
                        continue;
                    }
                    if ((RedRight == 4) || ((RedRight == 3) && BlueRight))
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if (BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (DescriptionSunday > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "快乐星期天特别奖" + DescriptionSunday.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}[+]\s\d\d";
            else
                RegexString = @"(\d\d\s){6,33}[+](\s\d\d){1,16}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){6}[+](\s\d\d){1,4}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length < 1) || (WinLotteryNumber.Length > 4))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart, int MaxBall)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= MaxBall) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 福彩3D
    /// </summary>
    public partial class FC3D : LotteryBase
    {
        #region 静态变量
        public const int BuyType_ZhiD_D = 601;
        public const int BuyType_ZhiD_H = 602;
        public const int BuyType_ZhiF_D = 603;
        public const int BuyType_ZhiF_H = 604;
        public const int BuyType_ZuD_D = 605;
        public const int BuyType_ZuD_H = 606;
        public const int BuyType_Zu6F_D = 607;
        public const int BuyType_Zu6F_H = 608;
        public const int BuyType_Zu3F_D = 609;
        public const int BuyType_Zu3F_H = 610;
        public const int BuyType_ZhiB_D = 611;
        public const int BuyType_ZhiB_H = 612;
        public const int BuyType_ZuB_D = 613;
        public const int BuyType_ZuB_H = 614;
        public const int BuyType_C = 615;

        public const int ID = 6;
        public const string sID = "6";
        public const string Name = "福彩3D";
        public const string Code = "FC3D";
        public const double MaxMoney = 20000;
        #endregion

        public FC3D()
        {
            id = 6;
            buytype_c = 615;
            name = "福彩3D";
            code = "FC3D";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 601) && (buy_type <= 615));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[15];

            Result[0] = new LotteryBuyType(BuyType_ZhiD_D, "直选单式代购");
            Result[1] = new LotteryBuyType(BuyType_ZhiD_H, "直选单式合买");
            Result[2] = new LotteryBuyType(BuyType_ZhiF_D, "直选复式代购");
            Result[3] = new LotteryBuyType(BuyType_ZhiF_H, "直选复式合买");
            Result[4] = new LotteryBuyType(BuyType_ZuD_D, "组选单式代购");
            Result[5] = new LotteryBuyType(BuyType_ZuD_H, "组选单式合买");
            Result[6] = new LotteryBuyType(BuyType_Zu6F_D, "组选6复式代购");
            Result[7] = new LotteryBuyType(BuyType_Zu6F_H, "组选6复式合买");
            Result[8] = new LotteryBuyType(BuyType_Zu3F_D, "组选3复式代购");
            Result[9] = new LotteryBuyType(BuyType_Zu3F_H, "组选3复式合买");
            Result[10] = new LotteryBuyType(BuyType_ZhiB_D, "直选包点代购");
            Result[11] = new LotteryBuyType(BuyType_ZhiB_H, "直选包点合买");
            Result[12] = new LotteryBuyType(BuyType_ZuB_D, "组选包点代购");
            Result[13] = new LotteryBuyType(BuyType_ZuB_H, "组选包点合买");
            Result[14] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }


        public override string BuildNumber(int Num)	//id = 6
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 3; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)
        {
            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_ZhiF_D) || (BuyType == BuyType_ZhiF_H) || (BuyType == BuyType_C))
                return ToSingle_Zhi(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_ZuD_D) || (BuyType == BuyType_ZuD_H) || (BuyType == BuyType_Zu6F_D) || (BuyType == BuyType_Zu6F_H))
                return ToSingle_ZuD_Zu6F(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_Zu3F_D) || (BuyType == BuyType_Zu3F_H))
                return ToSingle_Zu3F(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_ZhiB_D) || (BuyType == BuyType_ZhiB_H))
                return ToSingle_ZhiB(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_ZuB_D) || (BuyType == BuyType_ZuB_H))
                return ToSingle_ZuB(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_Zhi(string Number, ref string CanonicalNumber)	//复式取单式, 后面 ref 参数是将彩票规范化，如：10(122) 变成10(12)
        {
            string[] Locate = new string[3];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 3; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        al.Add(str_2);
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_ZuD_Zu6F(string Number, ref string CanonicalNumber)	//复式取单式, 后面 ref 参数是将彩票规范化，如：(10223) 变成1023
        {
            CanonicalNumber = FilterRepeated(Number.Trim());
            if (CanonicalNumber.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            char[] strs = CanonicalNumber.ToCharArray();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;

            if (n == 2)
            {
                for (int i = 0; i < n - 1; i++)
                    for (int j = i + 1; j < n; j++)
                    {
                        al.Add(strs[i].ToString() + strs[i].ToString() + strs[j].ToString());
                        al.Add(strs[i].ToString() + strs[j].ToString() + strs[j].ToString());
                    }

            }
            else
            {

                for (int i = 0; i < n - 2; i++)
                    for (int j = i + 1; j < n - 1; j++)
                        for (int k = j + 1; k < n; k++)
                            al.Add(strs[i].ToString() + strs[j].ToString() + strs[k].ToString());
            }

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_Zu3F(string Number, ref string CanonicalNumber)	//组选3取单式,后面 ref 参数是将彩票规范化，如：(10223) 变成1023，由于单式是3个数，复式可以是2个数，所以，这个函数不同于其他彩种的类似函数，单式不能使用这个函数转换。
        {
            CanonicalNumber = FilterRepeated(Number.Trim());
            if (CanonicalNumber.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            char[] strs = CanonicalNumber.ToCharArray();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                {
                    al.Add(strs[i].ToString() + strs[i].ToString() + strs[j].ToString());
                    al.Add(strs[i].ToString() + strs[j].ToString() + strs[j].ToString());
                }

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_ZhiB(string sBall, ref string CanonicalNumber)	//直选包点取单式,后面 ref 参数是将彩票规范化，如：05) 变成 5
        {
            int Ball = ShoveEL._Convert.StrToInt(sBall, -1);
            CanonicalNumber = "";

            if ((Ball < 0) || (Ball > 27))
            {
                CanonicalNumber = "";
                return null;
            }

            CanonicalNumber = Ball.ToString();

            ArrayList al = new ArrayList();

            #region 循环取单式

            for (int i = 0; i <= 9; i++)
                for (int j = 0; j <= 9; j++)
                    for (int k = 0; k <= 9; k++)
                        if (i + j + k == Ball)
                            al.Add(i.ToString() + j.ToString() + k.ToString());

            #endregion

            if (al.Count == 0)
                return null;

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_ZuB(string sBall, ref string CanonicalNumber)	//组选6包点取单式,后面 ref 参数是将彩票规范化，如：05) 变成 5
        {
            int Ball = ShoveEL._Convert.StrToInt(sBall, -1);
            CanonicalNumber = "";

            ArrayList al = new ArrayList();

            #region 循环取单式

            if ((Ball < 1) || (Ball > 26))
            {
                CanonicalNumber = "";
                return null;
            }
            else
            {
                for (int i = 0; i <= 9; i++)
                    for (int j = 0; j <= 9; j++)
                    {
                        if (i == j)
                            continue;
                        if (i + i + j == Ball)
                            al.Add(i.ToString() + i.ToString() + j.ToString());
                    }
            }

            if ((Ball >= 3) && (Ball <= 24))
            {
                for (int i = 0; i <= 7; i++)
                    for (int j = i + 1; j <= 8; j++)
                        for (int k = j + 1; k <= 9; k++)
                            if (i + j + k == Ball)
                                al.Add(i.ToString() + j.ToString() + k.ToString());
            }

            CanonicalNumber = Ball.ToString();


            #endregion

            if (al.Count == 0)
                return null;

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))    // 奖金参数排列顺序 zhi, zu3 zu6
                return -3;

            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_ZhiF_D) || (BuyType == BuyType_ZhiF_H))
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);

            if ((BuyType == BuyType_ZuD_D) || (BuyType == BuyType_ZuD_H) || (BuyType == BuyType_Zu6F_D) || (BuyType == BuyType_Zu6F_H))
                return ComputeWin_ZuD_Zu6F(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_Zu3F_D) || (BuyType == BuyType_Zu3F_H))
                return ComputeWin_Zu3F(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3]);

            if ((BuyType == BuyType_ZhiB_D) || (BuyType == BuyType_ZhiB_H))
                return ComputeWin_ZhiB(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);

            if ((BuyType == BuyType_ZuB_D) || (BuyType == BuyType_ZuB_H))
                return ComputeWin_ZuB(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5]);

            if (BuyType == BuyType_C)
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_Zhi(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zhi(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "单选奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_ZuD_Zu6F(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";

                if (Lotterys[ii].Length < 3)
                    continue;
                if (FilterRepeated(Sort(Lotterys[ii])).Length == 2)
                {
                    if (Sort(Lotterys[ii]) == Sort(WinNumber))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }

                    continue;
                }

                string[] Lottery = ToSingle_ZuD_Zu6F(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;
                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                    }
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";
            if (Description2 > 0)
                Description = "组选6奖" + Description2.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Zu3D(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "223"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                if (Lotterys[ii].Length < 3)
                    continue;
                if (Sort(Lotterys[ii]) == Sort(WinNumber))
                {
                    Description1++;
                    WinMoney += WinMoney1;
                    WinMoneyNoWithTax += WinMoneyNoWithTax1;
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Zu3F(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "223"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zu3F(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_ZhiB(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_ZhiB(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "单选奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_ZuB(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_ZuB(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        if (FilterRepeated(Lottery[i]).Length == 2)
                        {
                            Description1++;
                            WinMoney += WinMoney1;
                            WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        }
                        else
                        {
                            Description2++;
                            WinMoney += WinMoney2;
                            WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        }
                    }

                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";
            if (Description2 > 0)
                Description = "组选6奖" + Description2.ToString() + "注。";


            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_ZhiF_D) || (BuyType == BuyType_ZhiF_H) || (BuyType == BuyType_C))
                return AnalyseScheme_Zhi(Content, BuyType);

            if ((BuyType == BuyType_ZuD_D) || (BuyType == BuyType_ZuD_H) || (BuyType == BuyType_Zu6F_D) || (BuyType == BuyType_Zu6F_H))
                return AnalyseScheme_ZuD_Zu6F(Content, BuyType);

            if ((BuyType == BuyType_Zu3F_D) || (BuyType == BuyType_Zu3F_H))
                return AnalyseScheme_Zu3F(Content, BuyType);

            if ((BuyType == BuyType_ZhiB_D) || (BuyType == BuyType_ZhiB_H))
                return AnalyseScheme_ZhiB(Content, BuyType);

            if ((BuyType == BuyType_ZuB_D) || (BuyType == BuyType_ZuB_H))
                return AnalyseScheme_ZuB(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_Zhi(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_C))
                RegexString = @"([\d]){3}";
            else
                RegexString = @"(([\d])|([(][\d]{1,10}[)])){3}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zhi(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_C)) ? 1 : 2))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZuD_Zu6F(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_ZuD_D) || (BuyType == BuyType_ZuD_H))
                RegexString = @"([\d]){3}";
            else
                RegexString = @"([\d]){3,10}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_ZuD_Zu6F(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_ZuD_D) || (BuyType == BuyType_ZuD_H)) ? 1 : 2))
                    {
                        if (FilterRepeated(Sort(m.Value)).Length == 2)
                        {
                            if ((BuyType != BuyType_Zu6F_D) && (BuyType != BuyType_Zu6F_H))
                            {
                                Result += m.Value + "|1\n";
                            }
                            continue;
                        }
                        else
                        {
                            Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                        }
                    }
                }

            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_Zu3F(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"([\d]){2,}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zu3F(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 2)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZhiB(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"([\d]){1,2}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_ZhiB(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZuB(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"([\d]){1,2}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_ZuB(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle_Zhi(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 龙江36选7
    /// </summary>
    public partial class LJ36X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 701;
        public const int BuyType_D_H = 702;
        public const int BuyType_F_D = 703;
        public const int BuyType_F_H = 704;
        public const int BuyType_C = 705;

        public const int ID = 7;
        public const string sID = "7";
        public const string Name = "龙江36选7";
        public const string Code = "LJ36X7";
        public const double MaxMoney = 22880;
        #endregion

        public LJ36X7()
        {
            id = 7;
            buytype_c = 705;
            name = "龙江36选7";
            code = "LJ36X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 701) && (buy_type <= 705));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 7
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 36 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 16))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                    if ((RedRight == 3) && BlueRight)
                    {
                        Description8++;
                        WinMoney += WinMoneyList[14];
                        WinMoneyNoWithTax += WinMoneyList[15];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "八等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,35}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 36) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 龙江P62
    /// </summary>
    public partial class LJP62 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 801;
        public const int BuyType_D_H = 802;
        public const int BuyType_F_D = 803;
        public const int BuyType_F_H = 804;
        public const int BuyType_C = 805;

        public const int ID = 8;
        public const string sID = "8";
        public const string Name = "龙江P62";
        public const string Code = "LJP62";
        public const double MaxMoney = 20000;
        #endregion

        public LJP62()
        {
            id = 8;
            buytype_c = 805;
            name = "龙江P62";
            code = "LJP62";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 801) && (buy_type <= 805));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 8
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 6; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();
                LotteryNumber += "+" + rd.Next(0, 1 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            string[] strs = Number.Split('+');
            CanonicalNumber = "";

            if (strs.Length != 2)
            {
                CanonicalNumber = "";
                return null;
            }

            string[] Red = new string[6];
            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))(?<L5>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(strs[0].Trim());
            for (int i = 0; i < 6; i++)
            {
                Red[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Red[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Red[i].Length > 1)
                {
                    Red[i] = Red[i].Substring(1, Red[i].Length - 2);
                    if (Red[i].Length > 1)
                        Red[i] = FilterRepeated(Red[i]);
                    if (Red[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Red[i].Length > 1)
                    CanonicalNumber += "(" + Red[i] + ")";
                else
                    CanonicalNumber += Red[i];
            }

            CanonicalNumber += "+";

            string Blue = strs[1].Trim();
            if (Blue.Length > 1)
            {
                Blue = Blue.Substring(1, Blue.Length - 2);
                if (Blue.Length > 1)
                    Blue = FilterRepeated(Blue);
                if (Blue == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Blue.Length > 2)
                {
                    CanonicalNumber = "";
                    return null;
                }
            }
            for (int i = 0; i < Blue.Length; i++)
            {
                if ((Blue[i] != '0') && (Blue[i] != '1'))
                {
                    CanonicalNumber = "";
                    return null;
                }
            }
            if (Blue.Length > 1)
                CanonicalNumber += "(" + Blue + ")";
            else
                CanonicalNumber += Blue;

            ArrayList al = new ArrayList();

            #region 循环取单式

            for (int i_0 = 0; i_0 < Red[0].Length; i_0++)
            {
                string str_0 = Red[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Red[1].Length; i_1++)
                {
                    string str_1 = str_0 + Red[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Red[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Red[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Red[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Red[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Red[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Red[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Red[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Red[5][i_5].ToString();
                                    for (int j = 0; j < Blue.Length; j++)
                                        al.Add(str_5 + "+" + Blue[j].ToString());
                                }
                            }
                        }
                    }
                }
            }

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 8)	//8: 123456+1
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 12))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 8)
                        continue;
                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }

                    if (Lottery[i].Substring(0, 6) == WinNumber.Substring(0, 6))
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }

                    int j;
                    bool End = false;
                    for (j = 0; j <= 1; j++)
                    {
                        if (Lottery[i].Substring(j, 5) == WinNumber.Substring(j, 5))
                        {
                            Description3++;
                            WinMoney += WinMoneyList[4];
                            WinMoneyNoWithTax += WinMoneyList[5];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    for (j = 0; j <= 2; j++)
                    {
                        if (Lottery[i].Substring(j, 4) == WinNumber.Substring(j, 4))
                        {
                            Description4++;
                            WinMoney += WinMoneyList[6];
                            WinMoneyNoWithTax += WinMoneyList[7];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    for (j = 0; j <= 3; j++)
                    {
                        if (Lottery[i].Substring(j, 3) == WinNumber.Substring(j, 3))
                        {
                            Description5++;
                            WinMoney += WinMoneyList[8];
                            WinMoneyNoWithTax += WinMoneyList[9];
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    int Right = 0;
                    for (j = 0; j < 6; j++)
                    {
                        if (Lottery[i][j] == WinNumber[j])
                            Right++;
                    }
                    if (Right >= 2)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d){6}[+][01]";
            else
                RegexString = @"((\d)|([(]\d{1,10}[)])){6}[+](([01])|([(]([01]){1,2}[)]))";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"([0123456789]){6}[+][01]", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 体彩22选5
    /// </summary>
    public partial class TC22X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 901;
        public const int BuyType_D_H = 902;
        public const int BuyType_F_D = 903;
        public const int BuyType_F_H = 904;
        public const int BuyType_C = 905;

        public const int ID = 9;
        public const string sID = "9";
        public const string Name = "体彩22选5";
        public const string Code = "TC22X5";
        public const double MaxMoney = 20000;
        #endregion

        public TC22X5()
        {
            id = 9;
            buytype_c = 905;
            name = "体彩22选5";
            code = "TC22X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 901) && (buy_type <= 905));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 9
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 22 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,21}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 22) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 泛珠36选7
    /// </summary>
    public partial class FZ36X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1001;
        public const int BuyType_D_H = 1002;
        public const int BuyType_F_D = 1003;
        public const int BuyType_F_H = 1004;
        public const int BuyType_C = 1005;

        public const int ID = 10;
        public const string sID = "10";
        public const string Name = "泛珠36选7";
        public const string Code = "FZ36X7";
        public const double MaxMoney = 20000;
        #endregion

        public FZ36X7()
        {
            id = 10;
            buytype_c = 1005;
            name = "泛珠36选7";
            code = "FZ36X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1001) && (buy_type <= 1005));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 10
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 36 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 06 + 07"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 12))
                return -3;

            string Blue = WinNumber.Substring(20, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if ((RedRight == 6) && BlueRight)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) || ((RedRight == 3) && BlueRight))
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,35}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){6}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Replace("+ ", ""), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 36) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 楚天风采32选7
    /// </summary>
    public partial class CTFC32X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1101;
        public const int BuyType_D_H = 1102;
        public const int BuyType_F_D = 1103;
        public const int BuyType_F_H = 1104;
        public const int BuyType_C = 1105;

        public const int ID = 11;
        public const string sID = "11";
        public const string Name = "楚天风采32选7";
        public const string Code = "CTFC32X7";
        public const double MaxMoney = 22880;
        #endregion

        public CTFC32X7()
        {
            id = 11;
            buytype_c = 1105;
            name = "楚天风采32选7";
            code = "CTFC32X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1101) && (buy_type <= 1105));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 11
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 32 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 16))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                    if ((RedRight == 3) && BlueRight)
                    {
                        Description8++;
                        WinMoney += WinMoneyList[14];
                        WinMoneyNoWithTax += WinMoneyList[15];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "八等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,31}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 32) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 楚天风采22选5
    /// </summary>
    public partial class CTFC22X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1201;
        public const int BuyType_D_H = 1202;
        public const int BuyType_F_D = 1203;
        public const int BuyType_F_H = 1204;
        public const int BuyType_C = 1205;

        public const int ID = 12;
        public const string sID = "12";
        public const string Name = "楚天风采22选5";
        public const string Code = "CTFC22X5";
        public const double MaxMoney = 20000;
        #endregion

        public CTFC22X5()
        {
            id = 12;
            buytype_c = 1205;
            name = "楚天风采22选5";
            code = "CTFC22X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1201) && (buy_type <= 1205));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 12
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 22 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,21}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 22) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 福彩30选7(七乐彩)
    /// </summary>
    public partial class QLC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1301;
        public const int BuyType_D_H = 1302;
        public const int BuyType_F_D = 1303;
        public const int BuyType_F_H = 1304;
        public const int BuyType_C = 1305;

        public const int ID = 13;
        public const string sID = "13";
        public const string Name = "七乐彩";
        public const string Code = "QLC";
        public const double MaxMoney = 20000;
        #endregion

        public QLC()
        {
            id = 13;
            buytype_c = 1305;
            name = "七乐彩";
            code = "QLC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1301) && (buy_type <= 1305));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 13
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 30 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 14))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,29}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 30) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 体彩29选7
    /// </summary>
    public partial class TC29X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1401;
        public const int BuyType_D_H = 1402;
        public const int BuyType_F_D = 1403;
        public const int BuyType_F_H = 1404;
        public const int BuyType_C = 1405;

        public const int ID = 14;
        public const string sID = "14";
        public const string Name = "体彩29选7";
        public const string Code = "TC29X7";
        public const double MaxMoney = 20000;
        #endregion

        public TC29X7()
        {
            id = 14;
            buytype_c = 1405;
            name = "体彩29选7";
            code = "TC29X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1401) && (buy_type <= 1405));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 14
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 29 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 14))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,28}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 29) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 六场半全场胜负
    /// </summary>
    public partial class LCBQC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1501;
        public const int BuyType_D_H = 1502;
        public const int BuyType_F_D = 1503;
        public const int BuyType_F_H = 1504;

        public const int ID = 15;
        public const string sID = "15";
        public const string Name = "六场半全场";
        public const string Code = "LCBQC";
        public const double MaxMoney = 20000;
        #endregion

        public LCBQC()
        {
            id = 15;
            buytype_c = -1;
            name = "六场半全场";
            code = "LCBQC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1501) && (buy_type <= 1504));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[4];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 15
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 12; j++)
                    LotteryNumber += "310"[rd.Next(0, 2 + 1)].ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public string[,] SplitLotteryNumberForGrid(string Number)
        {
            string[] s = Number.Split('\n');
            if (s.Length == 0)
                return null;

            ArrayList[] al = new ArrayList[s.Length];

            for (int i = 0; i < al.Length; i++)
            {
                al[i] = new ArrayList();
                int start = 0;
                string temp = s[i];
                if (temp.Length < 12)
                    temp = temp.PadRight(12, ' ');
                while ((start < temp.Length) && (al[i].Count < 12))
                {
                    if (temp.Substring(start, 1) != "(")
                    {
                        al[i].Add(temp.Substring(start, 1));
                        start++;
                        continue;
                    }
                    int end = start + 1;
                    while (temp.Substring(end, 1) != ")")
                        end++;
                    string str = temp.Substring(start, end - start);
                    al[i].Add(str.Substring(1, str.Length - 1));
                    start = end + 1;
                }
            }

            string[,] Result = new string[al.Length, 12];
            for (int i = 0; i < al.Length; i++)
                for (int j = 0; ((j < al[i].Count) && (j < 12)); j++)
                    Result[i, j] = al[i][j].ToString();
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            string[] Locate = new string[12];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))(?<L5>(\d)|([(][\d]+?[)]))(?<L6>(\d)|([(][\d]+?[)]))(?<L7>(\d)|([(][\d]+?[)]))(?<L8>(\d)|([(][\d]+?[)]))(?<L9>(\d)|([(][\d]+?[)]))(?<L10>(\d)|([(][\d]+?[)]))(?<L11>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 12; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Locate[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Locate[5][i_5].ToString();
                                    for (int i_6 = 0; i_6 < Locate[6].Length; i_6++)
                                    {
                                        string str_6 = str_5 + Locate[6][i_6].ToString();
                                        for (int i_7 = 0; i_7 < Locate[7].Length; i_7++)
                                        {
                                            string str_7 = str_6 + Locate[7][i_7].ToString();
                                            for (int i_8 = 0; i_8 < Locate[8].Length; i_8++)
                                            {
                                                string str_8 = str_7 + Locate[8][i_8].ToString();
                                                for (int i_9 = 0; i_9 < Locate[9].Length; i_9++)
                                                {
                                                    string str_9 = str_8 + Locate[9][i_9].ToString();
                                                    for (int i_10 = 0; i_10 < Locate[10].Length; i_10++)
                                                    {
                                                        string str_10 = str_9 + Locate[10][i_10].ToString();
                                                        for (int i_11 = 0; i_11 < Locate[11].Length; i_11++)
                                                        {
                                                            string str_11 = str_10 + Locate[11][i_11].ToString();
                                                            al.Add(str_11);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 12)
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 2))
                return -3;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 12)
                        continue;

                    int Right = 0;
                    for (int j = 0; j < 12; j++)
                    {
                        if ((WinNumber[j] == '*') || (Lottery[i][j] == WinNumber[j]))
                            Right++;
                    }

                    if (Right == 12)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H))
                RegexString = @"([013]){12}";
            else
                RegexString = @"(([013])|([(][013]{1,3}[)])){12}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Number = Number.Replace("*", "0");  // * 表示比赛取消，什么结果都算对。

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("013".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 南粤风采36选7
    /// </summary>
    public partial class NYFC36X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1601;
        public const int BuyType_D_H = 1602;
        public const int BuyType_F_D = 1603;
        public const int BuyType_F_H = 1604;

        public const int BuyType_HC1_D_D = 1605;
        public const int BuyType_HC1_D_H = 1606;
        public const int BuyType_HC1_F_D = 1607;
        public const int BuyType_HC1_F_H = 1608;

        public const int BuyType_HC2_D_D = 1609;
        public const int BuyType_HC2_D_H = 1610;
        public const int BuyType_HC2_F_D = 1611;
        public const int BuyType_HC2_F_H = 1612;

        public const int BuyType_HC3_D_D = 1613;
        public const int BuyType_HC3_D_H = 1614;
        public const int BuyType_HC3_F_D = 1615;
        public const int BuyType_HC3_F_H = 1616;

        public const int BuyType_C = 1617;

        public const int ID = 16;
        public const string sID = "16";
        public const string Name = "南粤风采36选7";
        public const string Code = "NYFC36X7";
        public const double MaxMoney = 245157;
        #endregion

        public NYFC36X7()
        {
            id = 16;
            buytype_c = 1617;
            name = "南粤风采36选7";
            code = "NYFC36X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1601) && (buy_type <= 1617));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[17];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_HC1_D_D, "好彩一单式代购");
            Result[5] = new LotteryBuyType(BuyType_HC1_D_H, "好彩一单式合买");
            Result[6] = new LotteryBuyType(BuyType_HC1_F_D, "好彩一复式代购");
            Result[7] = new LotteryBuyType(BuyType_HC1_F_H, "好彩一复式合买");
            Result[8] = new LotteryBuyType(BuyType_HC2_D_D, "好彩二单式代购");
            Result[9] = new LotteryBuyType(BuyType_HC2_D_H, "好彩二单式合买");
            Result[10] = new LotteryBuyType(BuyType_HC2_F_D, "好彩二复式代购");
            Result[11] = new LotteryBuyType(BuyType_HC2_F_H, "好彩二复式合买");
            Result[12] = new LotteryBuyType(BuyType_HC3_D_D, "好彩三单式代购");
            Result[13] = new LotteryBuyType(BuyType_HC3_D_H, "好彩三单式合买");
            Result[14] = new LotteryBuyType(BuyType_HC3_F_D, "好彩三复式代购");
            Result[15] = new LotteryBuyType(BuyType_HC3_F_H, "好彩三复式合买");
            Result[16] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 16
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 36 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ToSingle_Zhi(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HC1_D_D) || (BuyType == BuyType_HC1_D_H) || (BuyType == BuyType_HC1_F_D) || (BuyType == BuyType_HC1_F_H))
                return ToSingle_HC1(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H) || (BuyType == BuyType_HC2_F_D) || (BuyType == BuyType_HC2_F_H))
                return ToSingle_HC2(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H) || (BuyType == BuyType_HC3_F_D) || (BuyType == BuyType_HC3_F_H))
                return ToSingle_HC3(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_Zhi(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HC1(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 1)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            return strs;
        }
        private string[] ToSingle_HC2(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                    al.Add(strs[i] + " " + strs[j]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HC3(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 3)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 2; i++)
                for (int j = i + 1; j < n - 1; j++)
                    for (int k = j + 1; k < n; k++)
                        al.Add(strs[i] + " " + strs[j] + " " + strs[k]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 18))   //奖金顺序 1-6等奖，好彩1-3
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7], WinMoneyList[8], WinMoneyList[9], WinMoneyList[10], WinMoneyList[11]);

            if ((BuyType == BuyType_HC1_D_D) || (BuyType == BuyType_HC1_D_H) || (BuyType == BuyType_HC1_F_D) || (BuyType == BuyType_HC1_F_H))
                return ComputeWin_HC1(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[12], WinMoneyList[13]);

            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H) || (BuyType == BuyType_HC2_F_D) || (BuyType == BuyType_HC2_F_H))
                return ComputeWin_HC2(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[14], WinMoneyList[15]);

            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H) || (BuyType == BuyType_HC3_F_D) || (BuyType == BuyType_HC3_F_H))
                return ComputeWin_HC3(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[16], WinMoneyList[17]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_Zhi(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3, double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 06 + 07"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string Blue = WinNumber.Substring(20, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zhi(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if ((RedRight == 6) && BlueRight)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description3++;
                        WinMoney += WinMoney3;
                        WinMoneyNoWithTax += WinMoneyNoWithTax3;
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description4++;
                        WinMoney += WinMoney4;
                        WinMoneyNoWithTax += WinMoneyNoWithTax4;
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description5++;
                        WinMoney += WinMoney5;
                        WinMoneyNoWithTax += WinMoneyNoWithTax5;
                        continue;
                    }
                    if ((RedRight == 4) || ((RedRight == 3) && BlueRight))
                    {
                        Description6++;
                        WinMoney += WinMoney6;
                        WinMoneyNoWithTax += WinMoneyNoWithTax6;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HC1(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 06 + 07"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string Blue = WinNumber.Substring(20, 2);

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HC1(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 2)	//2: "01"、"02"...单个号
                        continue;

                    if (Lottery[i] == Blue)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好彩一奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HC2(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 06 + 07"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string RedNumber = WinNumber.Substring(0, 18);

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HC2(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 5)	//5: "01 02"
                        continue;

                    string[] Red = new string[2];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 2; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (RedNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 2)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好彩二奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HC3(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 06 + 07"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string RedNumber = WinNumber.Substring(0, 18);

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HC3(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 8)	//5: "01 02 03"
                        continue;

                    string[] Red = new string[3];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 3; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (RedNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 3)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好彩三奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return AnalyseScheme_Zhi(Content, BuyType);

            if ((BuyType == BuyType_HC1_D_D) || (BuyType == BuyType_HC1_D_H) || (BuyType == BuyType_HC1_F_D) || (BuyType == BuyType_HC1_F_H))
                return AnalyseScheme_HC1(Content, BuyType);

            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H) || (BuyType == BuyType_HC2_F_D) || (BuyType == BuyType_HC2_F_H))
                return AnalyseScheme_HC2(Content, BuyType);

            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H) || (BuyType == BuyType_HC3_F_D) || (BuyType == BuyType_HC3_F_H))
                return AnalyseScheme_HC3(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_Zhi(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,35}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zhi(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H)) ? 1 : 2) || (BuyType == BuyType_C)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HC1(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HC1_D_D) || (BuyType == BuyType_HC1_D_H))
                RegexString = @"(\d\d)";
            else
                RegexString = @"((\d\d\s){1,35}\d\d)|(\d\d)";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HC1(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HC1_D_D) || (BuyType == BuyType_HC1_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HC2(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H))
                RegexString = @"(\d\d\s\d\d)";
            else
                RegexString = @"(\d\d\s){1,35}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HC2(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HC3(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H))
                RegexString = @"(\d\d\s){2}\d\d";
            else
                RegexString = @"(\d\d\s){2,35}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HC3(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){6}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle_Zhi(Number.Replace("+ ", ""), ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 36) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 南粤风采26选5
    /// </summary>
    public partial class NYFC26X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1701;
        public const int BuyType_D_H = 1702;
        public const int BuyType_F_D = 1703;
        public const int BuyType_F_H = 1704;

        public const int BuyType_HC2_D_D = 1705;
        public const int BuyType_HC2_D_H = 1706;
        public const int BuyType_HC2_F_D = 1707;
        public const int BuyType_HC2_F_H = 1708;

        public const int BuyType_HC3_D_D = 1709;
        public const int BuyType_HC3_D_H = 1710;
        public const int BuyType_HC3_F_D = 1711;
        public const int BuyType_HC3_F_H = 1712;

        public const int BuyType_C = 1713;

        public const int ID = 17;
        public const string sID = "17";
        public const string Name = "南粤风采26选5";
        public const string Code = "NYFC26X5";
        public const double MaxMoney = 65780;
        #endregion

        public NYFC26X5()
        {
            id = 17;
            buytype_c = 1713;
            name = "南粤风采26选5";
            code = "NYFC26X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1701) && (buy_type <= 1713));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[13];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_HC2_D_D, "好彩二单式代购");
            Result[5] = new LotteryBuyType(BuyType_HC2_D_H, "好彩二单式合买");
            Result[6] = new LotteryBuyType(BuyType_HC2_F_D, "好彩二复式代购");
            Result[7] = new LotteryBuyType(BuyType_HC2_F_H, "好彩二复式合买");
            Result[8] = new LotteryBuyType(BuyType_HC3_D_D, "好彩三单式代购");
            Result[9] = new LotteryBuyType(BuyType_HC3_D_H, "好彩三单式合买");
            Result[10] = new LotteryBuyType(BuyType_HC3_F_D, "好彩三复式代购");
            Result[11] = new LotteryBuyType(BuyType_HC3_F_H, "好彩三复式合买");
            Result[12] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 17
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 26 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ToSingle_Zhi(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H) || (BuyType == BuyType_HC2_F_D) || (BuyType == BuyType_HC2_F_H))
                return ToSingle_HC2(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H) || (BuyType == BuyType_HC3_F_D) || (BuyType == BuyType_HC3_F_H))
                return ToSingle_HC3(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_Zhi(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HC2(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                    al.Add(strs[i] + " " + strs[j]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HC3(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 3)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 2; i++)
                for (int j = i + 1; j < n - 1; j++)
                    for (int k = j + 1; k < n; k++)
                        al.Add(strs[i] + " " + strs[j] + " " + strs[k]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 8))   //奖金顺序 1-2等奖，好彩2-3
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3]);

            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H) || (BuyType == BuyType_HC2_F_D) || (BuyType == BuyType_HC2_F_H))
                return ComputeWin_HC2(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H) || (BuyType == BuyType_HC3_F_D) || (BuyType == BuyType_HC3_F_H))
                return ComputeWin_HC3(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[6], WinMoneyList[7]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_Zhi(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zhi(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HC2(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HC2(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 5)	//5: "01 02"
                        continue;

                    string[] Red = new string[2];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 2; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 2)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好彩二奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HC3(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HC3(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 8)	//5: "01 02 03"
                        continue;

                    string[] Red = new string[3];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 3; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 3)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好彩三奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return AnalyseScheme_Zhi(Content, BuyType);

            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H) || (BuyType == BuyType_HC2_F_D) || (BuyType == BuyType_HC2_F_H))
                return AnalyseScheme_HC2(Content, BuyType);

            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H) || (BuyType == BuyType_HC3_F_D) || (BuyType == BuyType_HC3_F_H))
                return AnalyseScheme_HC3(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_Zhi(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,25}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zhi(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HC2(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H))
                RegexString = @"(\d\d\s\d\d)";
            else
                RegexString = @"(\d\d\s){1,25}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HC2(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HC2_D_D) || (BuyType == BuyType_HC2_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HC3(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H))
                RegexString = @"(\d\d\s){2}\d\d";
            else
                RegexString = @"(\d\d\s){2,25}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HC3(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HC3_D_D) || (BuyType == BuyType_HC3_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle_Zhi(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 26) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 三晋风采21选5
    /// </summary>
    public partial class SJFC21X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1801;
        public const int BuyType_D_H = 1802;
        public const int BuyType_F_D = 1803;
        public const int BuyType_F_H = 1804;
        public const int BuyType_C = 1805;

        public const int ID = 18;
        public const string sID = "18";
        public const string Name = "三晋风采21选5";
        public const string Code = "SJFC21X5";
        public const double MaxMoney = 20000;
        #endregion

        public SJFC21X5()
        {
            id = 18;
            buytype_c = 1805;
            name = "三晋风采21选5";
            code = "SJFC21X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1801) && (buy_type <= 1805));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 18
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 21 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 8))
                return -3;

            int Description0 = 0, Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        if (isThreeContinuum(WinNumber))
                        {
                            Description0++;
                            WinMoney += WinMoneyList[0];
                            WinMoneyNoWithTax += WinMoneyList[1];
                            continue;
                        }
                        else
                        {
                            Description1++;
                            WinMoney += WinMoneyList[2];
                            WinMoneyNoWithTax += WinMoneyList[3];
                            continue;
                        }
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                }
            }

            if (Description0 > 0)
                Description = "特等奖" + Description0.ToString() + "注";
            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,20}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 21) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        private bool isThreeContinuum(string Number)
        {
            string[] strs = FilterRepeated(Number.Split(' '));
            if (strs.Length < 5)
                return false;

            int[] Red = new int[5];
            for (int i = 0; i < 5; i++)
                Red[i] = int.Parse(strs[i]);

            for (int i = 0; i < 3; i++)
            {
                if (((Red[i] + 1) == Red[i + 1]) && ((Red[i] + 2) == Red[i + 2]))
                    return true;
            }

            return false;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 篮彩
    /// </summary>
    public partial class LCDC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 1901;
        public const int BuyType_D_H = 1902;
        public const int BuyType_F_D = 1903;
        public const int BuyType_F_H = 1904;

        public const int ID = 19;
        public const string sID = "19";
        public const string Name = "篮彩";
        public const string Code = "LCDC";
        public const double MaxMoney = 20000;
        #endregion

        public LCDC()
        {
            id = 19;
            buytype_c = -1;
            name = "篮彩";
            code = "LCDC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 1901) && (buy_type <= 1904));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[4];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 19
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 4; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public string[,] SplitLotteryNumberForGrid(string Number)
        {
            string[] s = Number.Split('\n');
            if (s.Length == 0)
                return null;

            ArrayList[] al = new ArrayList[s.Length];

            for (int i = 0; i < al.Length; i++)
            {
                al[i] = new ArrayList();
                int start = 0;
                string temp = s[i];
                if (temp.Length < 4)
                    temp = temp.PadRight(4, ' ');
                while ((start < temp.Length) && (al[i].Count < 4))
                {
                    if (temp.Substring(start, 1) != "(")
                    {
                        al[i].Add(temp.Substring(start, 1));
                        start++;
                        continue;
                    }
                    int end = start + 1;
                    while (temp.Substring(end, 1) != ")")
                        end++;
                    string str = temp.Substring(start, end - start);
                    al[i].Add(str.Substring(1, str.Length - 1));
                    start = end + 1;
                }
            }

            string[,] Result = new string[al.Length, 4];
            for (int i = 0; i < al.Length; i++)
                for (int j = 0; ((j < al[i].Count) && (j < 4)); j++)
                    Result[i, j] = al[i][j].ToString();
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：123(445)(11)... 变成123(45)1...
        {
            string[] Locate = new string[4];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 4; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            al.Add(str_3);
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 4)
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 2))
                return -3;

            int Description0 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 4)
                        continue;
                    if (Lottery[i] == WinNumber)
                    {
                        Description0++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                }
            }

            if (Description0 > 0)
                Description = "一等奖" + Description0.ToString() + "注";
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H))
                RegexString = @"([\d]){4}";
            else
                RegexString = @"(([\d])|([(][\d]{1,10}[)])){4}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 深圳风采35选7
    /// </summary>
    public partial class SZFC35X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2001;
        public const int BuyType_D_H = 2002;
        public const int BuyType_F_D = 2003;
        public const int BuyType_F_H = 2004;
        public const int BuyType_C = 2005;

        public const int ID = 20;
        public const string sID = "20";
        public const string Name = "深圳风采35选7";
        public const string Code = "SZFC35X7";
        public const double MaxMoney = 12870;
        #endregion

        public SZFC35X7()
        {
            id = 20;
            buytype_c = 2005;
            name = "深圳风采35选7";
            code = "SZFC35X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2001) && (buy_type <= 2005));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 20
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 35 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 16))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                    if ((RedRight == 3) && BlueRight)
                    {
                        Description8++;
                        WinMoney += WinMoneyList[14];
                        WinMoneyNoWithTax += WinMoneyList[15];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "八等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,34}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 35) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 浙江15选5
    /// </summary>
    public partial class ZJ15X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2101;
        public const int BuyType_D_H = 2102;
        public const int BuyType_F_D = 2103;
        public const int BuyType_F_H = 2104;
        public const int BuyType_C = 2105;

        public const int ID = 21;
        public const string sID = "21";
        public const string Name = "浙江15选5";
        public const string Code = "ZJ15X5";
        public const double MaxMoney = 48202;
        #endregion

        public ZJ15X5()
        {
            id = 21;
            buytype_c = 2105;
            name = "浙江15选5";
            code = "ZJ15X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2101) && (buy_type <= 2105));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 21
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 15 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))
                return -3;

            int Description0 = 0, Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        if (isThreeContinuum(WinNumber))
                        {
                            Description0++;
                            WinMoney += WinMoneyList[0];
                            WinMoneyNoWithTax += WinMoneyList[1];
                            continue;
                        }
                        else
                        {
                            Description1++;
                            WinMoney += WinMoneyList[2];
                            WinMoneyNoWithTax += WinMoneyList[3];
                            continue;
                        }
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description0 > 0)
                Description = "特等奖" + Description0.ToString() + "注";
            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,14}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 15) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        private bool isThreeContinuum(string Number)
        {
            string[] strs = FilterRepeated(Number.Split(' '));
            if (strs.Length < 5)
                return false;

            int[] Red = new int[5];
            for (int i = 0; i < 5; i++)
                Red[i] = int.Parse(strs[i]);

            for (int i = 0; i < 2; i++)
            {
                if (((Red[i] + 1) == Red[i + 1]) && ((Red[i] + 2) == Red[i + 2]) && ((Red[i] + 3) == Red[i + 3]))
                    return true;
            }

            return false;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 浙江风采4+1
    /// </summary>
    public partial class ZJFC4J1 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2201;
        public const int BuyType_D_H = 2202;
        public const int BuyType_F_D = 2203;
        public const int BuyType_F_H = 2204;
        public const int BuyType_C = 2205;

        public const int ID = 22;
        public const string sID = "22";
        public const string Name = "浙江风采4+1";
        public const string Code = "ZJFC4J1";
        public const double MaxMoney = 20000;
        #endregion

        public ZJFC4J1()
        {
            id = 22;
            buytype_c = 2205;
            name = "浙江风采4+1";
            code = "ZJFC4J1";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2201) && (buy_type <= 2205));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 22
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 5; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            string[] Locate = new string[5];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 5; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                al.Add(str_4);
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 5)	//5: 12345
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 8))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 5)
                        continue;
                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }

                    if (Lottery[i].Substring(0, 4) == WinNumber.Substring(0, 4))
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }

                    bool Blue = (Lottery[i][4] == WinNumber[4]);
                    bool End = false;

                    for (int j = 0; j <= 1; j++)
                    {
                        if (Lottery[i].Substring(j, 3) == WinNumber.Substring(j, 3))
                        {
                            if (Blue)
                            {
                                Description2++;
                                WinMoney += WinMoneyList[2];
                                WinMoneyNoWithTax += WinMoneyList[3];
                            }
                            else
                            {
                                Description3++;
                                WinMoney += WinMoneyList[4];
                                WinMoneyNoWithTax += WinMoneyList[5];
                            }
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    for (int j = 0; j <= 2; j++)
                    {
                        if (Lottery[i].Substring(j, 2) == WinNumber.Substring(j, 2))
                        {
                            if (Blue)
                            {
                                Description3++;
                                WinMoney += WinMoneyList[4];
                                WinMoneyNoWithTax += WinMoneyList[5];
                            }
                            else
                            {
                                Description4++;
                                WinMoney += WinMoneyList[6];
                                WinMoneyNoWithTax += WinMoneyList[7];
                            }
                            End = true;
                            break;
                        }
                    }
                    if (End)
                        continue;

                    if (!Blue)
                        continue;

                    for (int j = 0; j <= 3; j++)
                    {
                        if (Lottery[i].Substring(j, 1) == WinNumber.Substring(j, 1))
                        {
                            Description4++;
                            WinMoney += WinMoneyList[6];
                            WinMoneyNoWithTax += WinMoneyList[7];
                        }
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d){5}";
            else
                RegexString = @"((\d)|([(]\d{1,10}[)])){5}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"([\d]){5}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 湖南风采22选5
    /// </summary>
    public partial class HNFC22X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2301;
        public const int BuyType_D_H = 2302;
        public const int BuyType_F_D = 2303;
        public const int BuyType_F_H = 2304;

        public const int BuyType_HY1_D_D = 2305;
        public const int BuyType_HY1_D_H = 2306;
        public const int BuyType_HY1_F_D = 2307;
        public const int BuyType_HY1_F_H = 2308;

        public const int BuyType_HY2_D_D = 2309;
        public const int BuyType_HY2_D_H = 2310;
        public const int BuyType_HY2_F_D = 2311;
        public const int BuyType_HY2_F_H = 2312;

        public const int BuyType_HY3_D_D = 2313;
        public const int BuyType_HY3_D_H = 2314;
        public const int BuyType_HY3_F_D = 2315;
        public const int BuyType_HY3_F_H = 2316;

        public const int BuyType_HY4_D_D = 2317;
        public const int BuyType_HY4_D_H = 2318;
        public const int BuyType_HY4_F_D = 2319;
        public const int BuyType_HY4_F_H = 2320;

        public const int BuyType_C = 2321;

        public const int ID = 23;
        public const string sID = "23";
        public const string Name = "湖南风采22选5";
        public const string Code = "HNFC22X5";
        public const double MaxMoney = 52668;
        #endregion

        public HNFC22X5()
        {
            id = 23;
            buytype_c = 2321;
            name = "湖南风采22选5";
            code = "HNFC22X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2301) && (buy_type <= 2321));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[21];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_HY1_D_D, "好运一单式代购");
            Result[5] = new LotteryBuyType(BuyType_HY1_D_H, "好运一单式合买");
            Result[6] = new LotteryBuyType(BuyType_HY1_F_D, "好运一复式代购");
            Result[7] = new LotteryBuyType(BuyType_HY1_F_H, "好运一复式合买");
            Result[8] = new LotteryBuyType(BuyType_HY2_D_D, "好运二单式代购");
            Result[9] = new LotteryBuyType(BuyType_HY2_D_H, "好运二单式合买");
            Result[10] = new LotteryBuyType(BuyType_HY2_F_D, "好运二复式代购");
            Result[11] = new LotteryBuyType(BuyType_HY2_F_H, "好运二复式合买");
            Result[12] = new LotteryBuyType(BuyType_HY3_D_D, "好运三单式代购");
            Result[13] = new LotteryBuyType(BuyType_HY3_D_H, "好运三单式合买");
            Result[14] = new LotteryBuyType(BuyType_HY3_F_D, "好运三复式代购");
            Result[15] = new LotteryBuyType(BuyType_HY3_F_H, "好运三复式合买");
            Result[16] = new LotteryBuyType(BuyType_HY4_D_D, "好运四单式代购");
            Result[17] = new LotteryBuyType(BuyType_HY4_D_H, "好运四单式合买");
            Result[18] = new LotteryBuyType(BuyType_HY4_F_D, "好运四复式代购");
            Result[19] = new LotteryBuyType(BuyType_HY4_F_H, "好运四复式合买");
            Result[20] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 23
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 22 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ToSingle_Zhi(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HY1_D_D) || (BuyType == BuyType_HY1_D_H) || (BuyType == BuyType_HY1_F_D) || (BuyType == BuyType_HY1_F_H))
                return ToSingle_HY1(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HY2_D_D) || (BuyType == BuyType_HY2_D_H) || (BuyType == BuyType_HY2_F_D) || (BuyType == BuyType_HY2_F_H))
                return ToSingle_HY2(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HY3_D_D) || (BuyType == BuyType_HY3_D_H) || (BuyType == BuyType_HY3_F_D) || (BuyType == BuyType_HY3_F_H))
                return ToSingle_HY3(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HY4_D_D) || (BuyType == BuyType_HY4_D_H) || (BuyType == BuyType_HY4_F_D) || (BuyType == BuyType_HY4_F_H))
                return ToSingle_HY4(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_Zhi(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HY1(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 1)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            return strs;
        }
        private string[] ToSingle_HY2(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                    al.Add(strs[i] + " " + strs[j]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HY3(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 3)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 2; i++)
                for (int j = i + 1; j < n - 1; j++)
                    for (int k = j + 1; k < n; k++)
                        al.Add(strs[i] + " " + strs[j] + " " + strs[k]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HY4(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 4)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 3; i++)
                for (int j = i + 1; j < n - 2; j++)
                    for (int k = j + 1; k < n - 1; k++)
                        for (int m = k + 1; m < n; m++)
                            al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[m]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 14))   //奖金顺序 1-3等奖，好运1-4
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_HY1_D_D) || (BuyType == BuyType_HY1_D_H) || (BuyType == BuyType_HY1_F_D) || (BuyType == BuyType_HY1_F_H))
                return ComputeWin_HY1(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[6], WinMoneyList[7]);

            if ((BuyType == BuyType_HY2_D_D) || (BuyType == BuyType_HY2_D_H) || (BuyType == BuyType_HY2_F_D) || (BuyType == BuyType_HY2_F_H))
                return ComputeWin_HY2(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[8], WinMoneyList[9]);

            if ((BuyType == BuyType_HY3_D_D) || (BuyType == BuyType_HY3_D_H) || (BuyType == BuyType_HY3_F_D) || (BuyType == BuyType_HY3_F_H))
                return ComputeWin_HY3(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[10], WinMoneyList[11]);

            if ((BuyType == BuyType_HY4_D_D) || (BuyType == BuyType_HY4_D_H) || (BuyType == BuyType_HY4_F_D) || (BuyType == BuyType_HY4_F_H))
                return ComputeWin_HY4(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[12], WinMoneyList[13]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_Zhi(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zhi(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HY1(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//22: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string Blue = WinNumber.Substring(0, 2);    //第一个开出的号

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HY1(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 2)	//2: "01"、"02"...单个号
                        continue;

                    if (Lottery[i] == Blue)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好运一奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HY2(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HY2(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 5)	//5: "01 02"
                        continue;

                    string[] Red = new string[2];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 2; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 2)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好运二奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HY3(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HY3(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 8)	//5: "01 02 03"
                        continue;

                    string[] Red = new string[3];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 3; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 3)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好运三奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HY4(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HY4(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 11)	//5: "01 02 03 04"
                        continue;

                    string[] Red = new string[4];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 4; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 4)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好运四奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return AnalyseScheme_Zhi(Content, BuyType);

            if ((BuyType == BuyType_HY1_D_D) || (BuyType == BuyType_HY1_D_H) || (BuyType == BuyType_HY1_F_D) || (BuyType == BuyType_HY1_F_H))
                return AnalyseScheme_HY1(Content, BuyType);

            if ((BuyType == BuyType_HY2_D_D) || (BuyType == BuyType_HY2_D_H) || (BuyType == BuyType_HY2_F_D) || (BuyType == BuyType_HY2_F_H))
                return AnalyseScheme_HY2(Content, BuyType);

            if ((BuyType == BuyType_HY3_D_D) || (BuyType == BuyType_HY3_D_H) || (BuyType == BuyType_HY3_F_D) || (BuyType == BuyType_HY3_F_H))
                return AnalyseScheme_HY3(Content, BuyType);

            if ((BuyType == BuyType_HY4_D_D) || (BuyType == BuyType_HY4_D_H) || (BuyType == BuyType_HY4_F_D) || (BuyType == BuyType_HY4_F_H))
                return AnalyseScheme_HY4(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_Zhi(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,25}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zhi(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HY1(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HY1_D_D) || (BuyType == BuyType_HY1_D_H))
                RegexString = @"(\d\d)";
            else
                RegexString = @"((\d\d\s){1,21}\d\d)|(\d\d)";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HY1(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HY1_D_D) || (BuyType == BuyType_HY1_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HY2(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HY2_D_D) || (BuyType == BuyType_HY2_D_H))
                RegexString = @"(\d\d\s\d\d)";
            else
                RegexString = @"(\d\d\s){1,25}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HY2(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HY2_D_D) || (BuyType == BuyType_HY2_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HY3(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HY3_D_D) || (BuyType == BuyType_HY3_D_H))
                RegexString = @"(\d\d\s){2}\d\d";
            else
                RegexString = @"(\d\d\s){2,25}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HY3(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HY3_D_D) || (BuyType == BuyType_HY3_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HY4(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HY4_D_D) || (BuyType == BuyType_HY4_D_H))
                RegexString = @"(\d\d\s){3}\d\d";
            else
                RegexString = @"(\d\d\s){3,21}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HY4(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HY4_D_D) || (BuyType == BuyType_HY4_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle_Zhi(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 22) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 东方大乐透(37选7)
    /// </summary>
    public partial class DFDLT : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2401;
        public const int BuyType_D_H = 2402;
        public const int BuyType_F_D = 2403;
        public const int BuyType_F_H = 2404;
        public const int BuyType_C = 2405;

        public const int ID = 24;
        public const string sID = "24";
        public const string Name = "东方大乐透";
        public const string Code = "DFDLT";
        public const double MaxMoney = 22880;
        #endregion

        public DFDLT()
        {
            id = 24;
            buytype_c = 2405;
            name = "东方大乐透";
            code = "DFDLT";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2401) && (buy_type <= 2405));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 24
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 37 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 14))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if ((RedRight == 4) || ((RedRight == 3) && BlueRight))
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,36}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 37) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 安徽风采25选5
    /// </summary>
    public partial class AHFC25X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2501;
        public const int BuyType_D_H = 2502;
        public const int BuyType_F_D = 2503;
        public const int BuyType_F_H = 2504;
        public const int BuyType_C = 2505;

        public const int ID = 25;
        public const string sID = "25";
        public const string Name = "安徽风采25选5";
        public const string Code = "AHFC25X5";
        public const double MaxMoney = 53130;
        #endregion

        public AHFC25X5()
        {
            id = 25;
            buytype_c = 2505;
            name = "安徽风采25选5";
            code = "AHFC25X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2501) && (buy_type <= 2505));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 25
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 25 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,24}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 25) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 安徽风采15选5
    /// </summary>
    public partial class AHFC15X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2601;
        public const int BuyType_D_H = 2602;
        public const int BuyType_F_D = 2603;
        public const int BuyType_F_H = 2604;
        public const int BuyType_C = 2605;

        public const int ID = 26;
        public const string sID = "26";
        public const string Name = "安徽风采15选5";
        public const string Code = "AHFC15X5";
        public const double MaxMoney = 6006;
        #endregion

        public AHFC15X5()
        {
            id = 26;
            buytype_c = 2605;
            name = "安徽风采15选5";
            code = "AHFC15X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2601) && (buy_type <= 2605));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 26
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 15 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 4))
                return -3;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,14}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 15) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 齐鲁风采23选5
    /// </summary>
    public partial class QLFC23X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2701;
        public const int BuyType_D_H = 2702;
        public const int BuyType_F_D = 2703;
        public const int BuyType_F_H = 2704;

        public const int BuyType_HYC2_D_D = 2705;
        public const int BuyType_HYC2_D_H = 2706;
        public const int BuyType_HYC2_F_D = 2707;
        public const int BuyType_HYC2_F_H = 2708;

        public const int BuyType_C = 2709;

        public const int ID = 27;
        public const string sID = "27";
        public const string Name = "齐鲁风采23选5";
        public const string Code = "QLFC23X5";
        public const double MaxMoney = 12376;
        #endregion

        public QLFC23X5()
        {
            id = 27;
            buytype_c = 2709;
            name = "齐鲁风采23选5";
            code = "QLFC23X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2701) && (buy_type <= 2709));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[9];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_HYC2_D_D, "好运二单式代购");
            Result[5] = new LotteryBuyType(BuyType_HYC2_D_H, "好运二单式合买");
            Result[6] = new LotteryBuyType(BuyType_HYC2_F_D, "好运二复式代购");
            Result[7] = new LotteryBuyType(BuyType_HYC2_F_H, "好运二复式合买");
            Result[8] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 27
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 23 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ToSingle_Zhi(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_HYC2_D_D) || (BuyType == BuyType_HYC2_D_H) || (BuyType == BuyType_HYC2_F_D) || (BuyType == BuyType_HYC2_F_H))
                return ToSingle_HYC2(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_Zhi(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_HYC2(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                    al.Add(strs[i] + " " + strs[j]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 8))   //奖金顺序 1-3等奖，好运彩2奖
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_HYC2_D_D) || (BuyType == BuyType_HYC2_D_H) || (BuyType == BuyType_HYC2_F_D) || (BuyType == BuyType_HYC2_F_H))
                return ComputeWin_HYC2(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[6], WinMoneyList[7]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_Zhi(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zhi(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoney3;
                        WinMoneyNoWithTax += WinMoneyNoWithTax3;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_HYC2(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_HYC2(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 5)	//5: "01 02"
                        continue;

                    string[] Red = new string[2];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool Full = true;
                    for (int j = 0; j < 2; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 2)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "好运二奖" + Description1.ToString() + "注";

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return AnalyseScheme_Zhi(Content, BuyType);

            if ((BuyType == BuyType_HYC2_D_D) || (BuyType == BuyType_HYC2_D_H) || (BuyType == BuyType_HYC2_F_D) || (BuyType == BuyType_HYC2_F_H))
                return AnalyseScheme_HYC2(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_Zhi(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,22}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zhi(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_HYC2(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_HYC2_D_D) || (BuyType == BuyType_HYC2_D_H))
                RegexString = @"(\d\d\s\d\d)";
            else
                RegexString = @"(\d\d\s){1,22}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_HYC2(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_HYC2_D_D) || (BuyType == BuyType_HYC2_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle_Zhi(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 23) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 重庆时时彩
    /// </summary>
    public partial class CQSSC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 2801;  //常规买法,注意，5星复式表示含5星，3星，2星，1星共4注，复式的概念和传统彩票不同
        public const int BuyType_D_H = 2802;
        public const int BuyType_F_D = 2803;
        public const int BuyType_F_H = 2804;

        public const int BuyType_ZH_D = 2805;  //组合玩法，和传统彩票复式概念一样
        public const int BuyType_ZH_H = 2806;

        public const int BuyType_DX_D = 2807;  //猜大小
        public const int BuyType_DX_H = 2808;

        public const int BuyType_C = 2809;  //追号

        public const int ID = 28;
        public const string sID = "28";
        public const string Name = "重庆时时彩";
        public const string Code = "SHSSL";
        public const double MaxMoney = 200000;
        #endregion

        public CQSSC()
        {
            id = 28;
            buytype_c = 2809;
            name = "重庆时时彩";
            code = "CQSSC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2801) && (buy_type <= 2809));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[9];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_ZH_D, "组合玩法代购");
            Result[5] = new LotteryBuyType(BuyType_ZH_H, "组合玩法合买");
            Result[6] = new LotteryBuyType(BuyType_DX_D, "猜大小代购");
            Result[7] = new LotteryBuyType(BuyType_DX_H, "猜大小合买");
            Result[8] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num, int Type)       //Type: 5 = 5星, 3 = 3星, 2 = 2星, 1 = 1星, -1 = 大小单双
        {
            if ((Type != 5) && (Type != 3) && (Type != 2) && (Type != 1) && (Type != -1))
                Type = 5;

            if (Type == -1) //大小单双
            {
                return BuildNumber_DX(Num);
            }

            return BuildNumber_5321(Num, Type);
        }
        #region BuilderNumber 的具体方法
        private string BuildNumber_5321(int Num, int Type)
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";

                for (int j = Type; j < 5; j++)
                    LotteryNumber += "-";

                for (int j = 0; j < Type; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);

            return Result;

        }
        private string BuildNumber_DX(int Num)   //大小单双
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";

                for (int j = 0; j < 2; j++)
                    LotteryNumber += "大小单双".Substring(rd.Next(0, 3 + 1), 1);

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);

            return Result;
        }
        #endregion

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)   //复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                return ToSingle_D(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_F_D) || (BuyType == BuyType_F_H))
                return ToSingle_F(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_ZH_D) || (BuyType == BuyType_ZH_H))
                return ToSingle_ZH(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_DX_D) || (BuyType == BuyType_DX_H))
                return ToSingle_DX(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_D(string Number, ref string CanonicalNumber)
        {
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|(-))(?<L1>(\d)|(-))(?<L2>(\d)|(-))(?<L3>(\d)|(-))(?<L4>(\d))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 5; i++)
            {
                string Locate = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate == "")
                {
                    CanonicalNumber = "";
                    return null;
                }

                CanonicalNumber += Locate;
            }

            Regex[] regex5321 = new Regex[4];
            regex5321[0] = new Regex(@"(\d){5}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            regex5321[1] = new Regex(@"--(\d){3}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            regex5321[2] = new Regex(@"---(\d){2}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            regex5321[3] = new Regex(@"----\d", RegexOptions.IgnoreCase | RegexOptions.Compiled);

            bool isMatch = false;
            for (int i = 0; i < 4; i++)
            {
                if (regex5321[i].IsMatch(CanonicalNumber))
                {
                    isMatch = true;
                    break;
                }
            }

            if (!isMatch)
                return null;

            string[] Result = new string[1];
            Result[0] = CanonicalNumber;

            return Result;
        }
        private string[] ToSingle_F(string Number, ref string CanonicalNumber)
        {
            string[] t_strs = ToSingle_D(Number, ref CanonicalNumber);

            if ((t_strs == null) || (t_strs.Length != 1))
                return null;

            Regex[] regex5321 = new Regex[4];
            regex5321[0] = new Regex(@"(\d){5}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            regex5321[1] = new Regex(@"--(\d){3}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            regex5321[2] = new Regex(@"---(\d){2}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            regex5321[3] = new Regex(@"----\d", RegexOptions.IgnoreCase | RegexOptions.Compiled);

            string[] Result = null;

            if (regex5321[0].IsMatch(CanonicalNumber))
            {
                Result = new string[4];

                Result[0] = CanonicalNumber;
                Result[1] = "--" + CanonicalNumber.Substring(2, 3);
                Result[2] = "---" + CanonicalNumber.Substring(3, 2);
                Result[3] = "----" + CanonicalNumber.Substring(4, 1);
            }

            else if (regex5321[1].IsMatch(CanonicalNumber))
            {
                Result = new string[3];

                Result[0] = CanonicalNumber;
                Result[1] = "---" + CanonicalNumber.Substring(3, 2);
                Result[2] = "----" + CanonicalNumber.Substring(4, 1);
            }

            else if (regex5321[2].IsMatch(CanonicalNumber))
            {
                Result = new string[2];

                Result[0] = CanonicalNumber;
                Result[1] = "----" + CanonicalNumber.Substring(4, 1);
            }

            else if (regex5321[3].IsMatch(CanonicalNumber))
            {
                Result = new string[1];

                Result[0] = CanonicalNumber;
            }

            return Result;
        }
        private string[] ToSingle_ZH(string Number, ref string CanonicalNumber)
        {
            string[] Locate = new string[5];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>([\d-])|([(][\d]+?[)]))(?<L1>([\d-])|([(][\d]+?[)]))(?<L2>([\d-])|([(][\d]+?[)]))(?<L3>([\d-])|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 5; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();

                                string str_4_Canonical = "";
                                string[] strs_4 = ToSingle_D(str_4, ref str_4_Canonical);

                                if ((strs_4 == null) || (strs_4.Length < 1))
                                    continue;

                                al.Add(str_4);
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        private string[] ToSingle_DX(string Number, ref string CanonicalNumber)	//猜大小
        {
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>([大小单双]))(?<L1>([大小单双]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 2; i++)
            {
                string Locate = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate == "")
                {
                    CanonicalNumber = "";
                    return null;
                }

                CanonicalNumber += Locate;
            }

            string[] Result = new string[1];
            Result[0] = CanonicalNumber;

            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 10)) //奖金参数星5、3、2、1，猜大小1个
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H))
                return ComputeWin_D(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7]);

            if ((BuyType == BuyType_F_D) || (BuyType == BuyType_F_H))
                return ComputeWin_F(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7]);

            if ((BuyType == BuyType_ZH_D) || (BuyType == BuyType_ZH_H))
                return ComputeWin_ZH(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7]);

            if ((BuyType == BuyType_DX_D) || (BuyType == BuyType_DX_H))
                return ComputeWin_DX(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[8], WinMoneyList[9]);

            if (BuyType == BuyType_C)  //追号
            {
                return ComputeWin_D(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3], WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7]);
            }

            return -4;
        }
        #region ComputeWin  的具体方法
        private double ComputeWin_D(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3, double WinMoney4, double WinMoneyNoWithTax4)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 5)	//3: "12345"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_D(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                Regex[] regex5321 = new Regex[4];
                regex5321[0] = new Regex(@"(\d){5}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[1] = new Regex(@"--(\d){3}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[2] = new Regex(@"---(\d){2}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[3] = new Regex(@"----\d", RegexOptions.IgnoreCase | RegexOptions.Compiled);

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (regex5321[0].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i] == WinNumber)
                        {
                            Description1++;
                            WinMoney += WinMoney1;
                            WinMoneyNoWithTax += WinMoneyNoWithTax1;

                            continue;
                        }
                    }

                    if (regex5321[1].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(2, 3) == WinNumber.Substring(2, 3))
                        {
                            Description2++;
                            WinMoney += WinMoney2;
                            WinMoneyNoWithTax += WinMoneyNoWithTax2;

                            continue;
                        }
                    }

                    if (regex5321[2].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(3, 2) == WinNumber.Substring(3, 2))
                        {
                            Description3++;
                            WinMoney += WinMoney3;
                            WinMoneyNoWithTax += WinMoneyNoWithTax3;

                            continue;
                        }
                    }

                    if (regex5321[3].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(4, 1) == WinNumber.Substring(4, 1))
                        {
                            Description4++;
                            WinMoney += WinMoney4;
                            WinMoneyNoWithTax += WinMoneyNoWithTax4;

                            continue;
                        }
                    }
                }
            }

            if (Description1 > 0)
                Description = "五星奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三星奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二星奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一星奖" + Description4.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_F(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3, double WinMoney4, double WinMoneyNoWithTax4)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 5)	//3: "12345"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_F(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                Regex[] regex5321 = new Regex[4];
                regex5321[0] = new Regex(@"(\d){5}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[1] = new Regex(@"--(\d){3}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[2] = new Regex(@"---(\d){2}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[3] = new Regex(@"----\d", RegexOptions.IgnoreCase | RegexOptions.Compiled);

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (regex5321[0].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i] == WinNumber)
                        {
                            Description1++;
                            WinMoney += WinMoney1;
                            WinMoneyNoWithTax += WinMoneyNoWithTax1;

                            continue;
                        }
                    }

                    if (regex5321[1].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(2, 3) == WinNumber.Substring(2, 3))
                        {
                            Description2++;
                            WinMoney += WinMoney2;
                            WinMoneyNoWithTax += WinMoneyNoWithTax2;

                            continue;
                        }
                    }

                    if (regex5321[2].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(3, 2) == WinNumber.Substring(3, 2))
                        {
                            Description3++;
                            WinMoney += WinMoney3;
                            WinMoneyNoWithTax += WinMoneyNoWithTax3;

                            continue;
                        }
                    }

                    if (regex5321[3].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(4, 1) == WinNumber.Substring(4, 1))
                        {
                            Description4++;
                            WinMoney += WinMoney4;
                            WinMoneyNoWithTax += WinMoneyNoWithTax4;

                            continue;
                        }
                    }
                }
            }

            if (Description1 > 0)
                Description = "五星奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三星奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二星奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一星奖" + Description4.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_ZH(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3, double WinMoney4, double WinMoneyNoWithTax4)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 5)	//3: "12345"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_ZH(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                Regex[] regex5321 = new Regex[4];
                regex5321[0] = new Regex(@"(\d){5}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[1] = new Regex(@"--(\d){3}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[2] = new Regex(@"---(\d){2}", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                regex5321[3] = new Regex(@"----\d", RegexOptions.IgnoreCase | RegexOptions.Compiled);

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (regex5321[0].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i] == WinNumber)
                        {
                            Description1++;
                            WinMoney += WinMoney1;
                            WinMoneyNoWithTax += WinMoneyNoWithTax1;

                            continue;
                        }
                    }

                    if (regex5321[1].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(2, 3) == WinNumber.Substring(2, 3))
                        {
                            Description2++;
                            WinMoney += WinMoney2;
                            WinMoneyNoWithTax += WinMoneyNoWithTax2;

                            continue;
                        }
                    }

                    if (regex5321[2].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(3, 2) == WinNumber.Substring(3, 2))
                        {
                            Description3++;
                            WinMoney += WinMoney3;
                            WinMoneyNoWithTax += WinMoneyNoWithTax3;

                            continue;
                        }
                    }

                    if (regex5321[3].IsMatch(Lottery[i]))
                    {
                        if (Lottery[i].Substring(4, 1) == WinNumber.Substring(4, 1))
                        {
                            Description4++;
                            WinMoney += WinMoney4;
                            WinMoneyNoWithTax += WinMoneyNoWithTax4;

                            continue;
                        }
                    }
                }
            }

            if (Description1 > 0)
                Description = "五星奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三星奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二星奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一星奖" + Description4.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        private double ComputeWin_DX(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 5)	//12345
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string WinNumber_1 = "", WinNumber_2 = "";
            int Num = ShoveEL._Convert.StrToInt(WinNumber.Substring(3, 1), 0);
            WinNumber_1 += (Num <= 4) ? "小" : "大";
            WinNumber_1 += ((Num % 2) == 0) ? "双" : "单";
            Num = ShoveEL._Convert.StrToInt(WinNumber.Substring(4, 1), 0);
            WinNumber_2 += (Num <= 4) ? "小" : "大";
            WinNumber_2 += ((Num % 2) == 0) ? "双" : "单";

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_DX(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 2)
                        continue;

                    if ((WinNumber_1.IndexOf(Lottery[i][0]) >= 0) && (WinNumber_2.IndexOf(Lottery[i][1]) >= 0))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "猜大小奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                return AnalyseScheme_D(Content, BuyType);

            if ((BuyType == BuyType_F_D) || (BuyType == BuyType_F_H))
                return AnalyseScheme_F(Content, BuyType);

            if ((BuyType == BuyType_ZH_D) || (BuyType == BuyType_ZH_H))
                return AnalyseScheme_ZH(Content, BuyType);

            if ((BuyType == BuyType_DX_D) || (BuyType == BuyType_DX_H))
                return AnalyseScheme_DX(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_D(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString = @"(([\d])|([-])){4}[\d]";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_D(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_F(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString = @"(([\d])|([-])){4}[\d]";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_F(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZH(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString = @"([\d-])|([(][\d]+?[)]){4}([\d])|([(][\d]+?[)])";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_ZH(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 2)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_DX(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString = @"([大小单双]){2}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_DX(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"([\d]){5}", RegexOptions.Compiled | RegexOptions.IgnoreCase);

            return regex.IsMatch(Number);
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789-".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 上海时时乐
    /// </summary>
    public partial class SHSSL : LotteryBase
    {
        #region 静态变量
        public const int BuyType_ZhiD_D = 2901;//单选3
        public const int BuyType_ZhiD_H = 2902;
        public const int BuyType_ZhiF_D = 2903;
        public const int BuyType_ZhiF_H = 2904;

        public const int BuyType_Zu6D_D = 2905;//组选6
        public const int BuyType_Zu6D_H = 2906;
        public const int BuyType_Zu6F_D = 2907;
        public const int BuyType_Zu6F_H = 2908;

        public const int BuyType_Zu3D_D = 2909;//组选3
        public const int BuyType_Zu3D_H = 2910;
        public const int BuyType_Zu3F_D = 2911;
        public const int BuyType_Zu3F_H = 2912;

        public const int BuyType_Q2D_D = 2913;//前2
        public const int BuyType_Q2D_H = 2914;
        public const int BuyType_Q2F_D = 2915;
        public const int BuyType_Q2F_H = 2916;

        public const int BuyType_H2D_D = 2917;//后2
        public const int BuyType_H2D_H = 2918;
        public const int BuyType_H2F_D = 2919;
        public const int BuyType_H2F_H = 2920;

        public const int BuyType_Q1D_D = 2921;//前1
        public const int BuyType_Q1D_H = 2922;
        public const int BuyType_Q1F_D = 2923;
        public const int BuyType_Q1F_H = 2924;

        public const int BuyType_H1D_D = 2925;//后1
        public const int BuyType_H1D_H = 2926;
        public const int BuyType_H1F_D = 2927;
        public const int BuyType_H1F_H = 2928;

        public const int BuyType_C = 2929;

        public const int ID = 29;
        public const string sID = "29";
        public const string Name = "上海时时乐";
        public const string Code = "SHSSL";
        public const double MaxMoney = 20000;
        #endregion

        public SHSSL()
        {
            id = 29;
            buytype_c = 2929;
            name = "上海时时乐";
            code = "SHSSL";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 2901) && (buy_type <= 2929));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[29];

            Result[0] = new LotteryBuyType(BuyType_ZhiD_D, "单选3单式代购");
            Result[1] = new LotteryBuyType(BuyType_ZhiD_H, "单选3单式合买");
            Result[2] = new LotteryBuyType(BuyType_ZhiF_D, "单选3复式代购");
            Result[3] = new LotteryBuyType(BuyType_ZhiF_H, "单选3复式合买");
            Result[4] = new LotteryBuyType(BuyType_Zu6D_D, "组选6单式代购");
            Result[5] = new LotteryBuyType(BuyType_Zu6D_H, "组选6单式合买");
            Result[6] = new LotteryBuyType(BuyType_Zu6F_D, "组选6复式代购");
            Result[7] = new LotteryBuyType(BuyType_Zu6F_H, "组选6复式合买");
            Result[8] = new LotteryBuyType(BuyType_Zu3D_D, "组选3单式代购");
            Result[9] = new LotteryBuyType(BuyType_Zu3D_H, "组选3单式合买");
            Result[10] = new LotteryBuyType(BuyType_Zu3F_D, "组选3复式代购");
            Result[11] = new LotteryBuyType(BuyType_Zu3F_H, "组选3复式合买");
            Result[12] = new LotteryBuyType(BuyType_Q2D_D, "前2单式代购");
            Result[13] = new LotteryBuyType(BuyType_Q2D_H, "前2单式合买");
            Result[14] = new LotteryBuyType(BuyType_Q2F_D, "前2复式代购");
            Result[15] = new LotteryBuyType(BuyType_Q2F_H, "前2复式合买");
            Result[16] = new LotteryBuyType(BuyType_H2D_D, "后2单式代购");
            Result[17] = new LotteryBuyType(BuyType_H2D_H, "后2单式合买");
            Result[18] = new LotteryBuyType(BuyType_H2F_D, "后2复式代购");
            Result[19] = new LotteryBuyType(BuyType_H2F_H, "后2复式合买");
            Result[20] = new LotteryBuyType(BuyType_Q1D_D, "前1单式代购");
            Result[21] = new LotteryBuyType(BuyType_Q1D_H, "前1单式合买");
            Result[22] = new LotteryBuyType(BuyType_Q1F_D, "前1复式代购");
            Result[23] = new LotteryBuyType(BuyType_Q1F_H, "前1复式合买");
            Result[24] = new LotteryBuyType(BuyType_H1D_D, "后1单式代购");
            Result[25] = new LotteryBuyType(BuyType_H1D_H, "后1单式合买");
            Result[26] = new LotteryBuyType(BuyType_H1F_D, "后1复式代购");
            Result[27] = new LotteryBuyType(BuyType_H1F_H, "后1复式合买");
            Result[28] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 29
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 3; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)
        {
            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_ZhiF_D) || (BuyType == BuyType_ZhiF_H))   //单选3
                return ToSingle_Zhi(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_Zu6D_D) || (BuyType == BuyType_Zu6D_H) || (BuyType == BuyType_Zu6F_D) || (BuyType == BuyType_Zu6F_H))   //组选6
                return ToSingle_Zu6(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_Zu3D_D) || (BuyType == BuyType_Zu3D_H) || (BuyType == BuyType_Zu3F_D) || (BuyType == BuyType_Zu3F_H))   //组选3
                return ToSingle_Zu3(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_Q2D_D) || (BuyType == BuyType_Q2D_H) || (BuyType == BuyType_Q2F_D) || (BuyType == BuyType_Q2F_H))   //前2
                return ToSingle_2(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_H2D_D) || (BuyType == BuyType_H2D_H) || (BuyType == BuyType_H2F_D) || (BuyType == BuyType_H2F_H))   //后2
                return ToSingle_2(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_Q1D_D) || (BuyType == BuyType_Q1D_H) || (BuyType == BuyType_Q1F_D) || (BuyType == BuyType_Q1F_H))   //前1
                return ToSingle_1(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_H1D_D) || (BuyType == BuyType_H1D_H) || (BuyType == BuyType_H1F_D) || (BuyType == BuyType_H1F_H))   //后1
                return ToSingle_1(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_Zhi(string Number, ref string CanonicalNumber)	//直选复式取单式, 后面 ref 参数是将彩票规范化，如：10(223) 变成10(23)
        {
            string[] Locate = new string[3];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 3; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        al.Add(str_2);
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_Zu6(string Number, ref string CanonicalNumber)    //组选6取单式, 后面 ref 参数是将彩票规范化，如：(10223) 变成1023
        {
            CanonicalNumber = FilterRepeated(Number.Trim());
            if (CanonicalNumber.Length < 3)
            {
                CanonicalNumber = "";
                return null;
            }

            char[] strs = CanonicalNumber.ToCharArray();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 2; i++)
                for (int j = i + 1; j < n - 1; j++)
                    for (int k = j + 1; k < n; k++)
                        al.Add(strs[i].ToString() + strs[j].ToString() + strs[k].ToString());

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_Zu3(string Number, ref string CanonicalNumber)    //组选3取单式,后面 ref 参数是将彩票规范化，如：(10223) 变成1023，由于单式是3个数，复式可以是2个数，所以，这个函数不同于其他彩种的类似函数，单式不能使用这个函数转换。
        {
            CanonicalNumber = FilterRepeated(Number.Trim());
            if (CanonicalNumber.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            char[] strs = CanonicalNumber.ToCharArray();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                {
                    al.Add(strs[i].ToString() + strs[i].ToString() + strs[j].ToString());
                    al.Add(strs[i].ToString() + strs[j].ToString() + strs[j].ToString());
                }

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_2(string Number, ref string CanonicalNumber)      //前2后2复式取单式, 后面 ref 参数是将彩票规范化，如：1(223) 变成1(23)
        {
            string[] Locate = new string[2];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 2; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式

            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    al.Add(str_1);
                }
            }

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_1(string Number, ref string CanonicalNumber)      //前1后1复式取单式, 后面 ref 参数是将彩票规范化，如：10223 变成1023
        {
            char[] chars = FilterRepeated(Number.Trim()).ToCharArray();
            CanonicalNumber = "";

            if (chars.Length < 1)
            {
                CanonicalNumber = "";
                return null;
            }

            string[] strs = new string[chars.Length];
            for (int i = 0; i < chars.Length; i++)
            {
                strs[i] = chars[i].ToString();
                CanonicalNumber += chars[i].ToString();
            }

            return strs;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 14)) //奖金参数排列顺序zhi(0,1),zu6(2,3),zu3(4,6) 前2(7,8)后2(9,10),前1(11,12)后1(13,14) 
                return -3;

            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_ZhiF_D) || (BuyType == BuyType_ZhiF_H))   //单选3
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);

            if ((BuyType == BuyType_Zu6D_D) || (BuyType == BuyType_Zu6D_H) || (BuyType == BuyType_Zu6F_D) || (BuyType == BuyType_Zu6F_H))   //组选6
                return ComputeWin_Zu6(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3]);

            if ((BuyType == BuyType_Zu3D_D) || (BuyType == BuyType_Zu3D_H))     //组选3单式
                return ComputeWin_Zu3D(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_Zu3F_D) || (BuyType == BuyType_Zu3F_H))     //组选3复式
                return ComputeWin_Zu3F(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[4], WinMoneyList[5]);

            if ((BuyType == BuyType_Q2D_D) || (BuyType == BuyType_Q2D_H) || (BuyType == BuyType_Q2F_D) || (BuyType == BuyType_Q2F_H))   //前2
                return ComputeWin_Q2(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[6], WinMoneyList[7]);

            if ((BuyType == BuyType_H2D_D) || (BuyType == BuyType_H2D_H) || (BuyType == BuyType_H2F_D) || (BuyType == BuyType_H2F_H))   //后2
                return ComputeWin_H2(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[8], WinMoneyList[9]);

            if ((BuyType == BuyType_Q1D_D) || (BuyType == BuyType_Q1D_H) || (BuyType == BuyType_Q1F_D) || (BuyType == BuyType_Q1F_H))   //前1
                return ComputeWin_Q1(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[10], WinMoneyList[11]);

            if ((BuyType == BuyType_H1D_D) || (BuyType == BuyType_H1D_H) || (BuyType == BuyType_H1F_D) || (BuyType == BuyType_H1F_H))   //后1
                return ComputeWin_H1(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[12], WinMoneyList[13]);

            if (BuyType == BuyType_C)  //追号
            {
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1]);
            }
            return -4;
        }
        #region ComputeWin  的具体方法
        private double ComputeWin_Zhi(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zhi(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "单选奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Zu6(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zu6(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;
                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "组选6奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Zu3D(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "223"
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                if (Lotterys[ii].Length < 3)
                    continue;
                if (Sort(Lotterys[ii]) == Sort(WinNumber))
                {
                    Description1++;
                    WinMoney += WinMoney1;
                    WinMoneyNoWithTax += WinMoneyNoWithTax1;
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Zu3F(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "223"
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zu3(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 3)
                        continue;

                    if (Sort(Lottery[i]) == Sort(WinNumber))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "组选3奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Q2(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(0, 2);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_2(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 2)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "前2奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_H2(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(1, 2);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_2(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 2)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "后2奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_Q1(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(0, 1);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_1(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 1)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "前1奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        private double ComputeWin_H1(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 3)	//3: "123"
                return -1;
            WinNumber = WinNumber.Substring(2, 1);

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_1(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 1)
                        continue;

                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                    }
                }
            }

            if (Description1 > 0)
                Description = "后1奖" + Description1.ToString() + "注。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_ZhiF_D) || (BuyType == BuyType_ZhiF_H) || (BuyType == BuyType_C))   //直选 3
                return AnalyseScheme_Zhi(Content, BuyType);

            if ((BuyType == BuyType_Zu6D_D) || (BuyType == BuyType_Zu6D_H) || (BuyType == BuyType_Zu6F_D) || (BuyType == BuyType_Zu6F_H))   //组选6
                return AnalyseScheme_Zu6(Content, BuyType);

            if ((BuyType == BuyType_Zu3D_D) || (BuyType == BuyType_Zu3D_H))     //组3单式
                return AnalyseScheme_Zu3D(Content, BuyType);

            if ((BuyType == BuyType_Zu3F_D) || (BuyType == BuyType_Zu3F_H))     //组3复式
                return AnalyseScheme_Zu3F(Content, BuyType);

            if ((BuyType == BuyType_Q2D_D) || (BuyType == BuyType_Q2D_H) || (BuyType == BuyType_Q2F_D) || (BuyType == BuyType_Q2F_H))       //前2
                return AnalyseScheme_2(Content, BuyType);

            if ((BuyType == BuyType_H2D_D) || (BuyType == BuyType_H2F_H) || (BuyType == BuyType_H2F_H) || (BuyType == BuyType_H2F_H))       //后2
                return AnalyseScheme_2(Content, BuyType);

            if ((BuyType == BuyType_Q1D_D) || (BuyType == BuyType_Q1D_H) || (BuyType == BuyType_Q1F_D) || (BuyType == BuyType_Q1F_H))       //前1
                return AnalyseScheme_1(Content, BuyType);

            if ((BuyType == BuyType_H1D_D) || (BuyType == BuyType_H1F_H) || (BuyType == BuyType_H1F_H) || (BuyType == BuyType_H1F_H))       //后1
                return AnalyseScheme_1(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_Zhi(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_C))
                RegexString = @"([\d]){3}";
            else
                RegexString = @"(([\d])|([(][\d]{1,10}[)])){3}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zhi(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_ZhiD_D) || (BuyType == BuyType_ZhiD_H) || (BuyType == BuyType_C)) ? 1 : 2))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_Zu6(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_Zu6D_D) || (BuyType == BuyType_Zu6D_H))
                RegexString = @"([\d]){3}";
            else
                RegexString = @"([\d]){3,10}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zu6(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_Zu6D_D) || (BuyType == BuyType_Zu6D_H)) ? 1 : 2))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_Zu3D(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"(\d){3}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string t1 = Sort(m.Value);
                    string t2 = FilterRepeated(t1);
                    if (t2.Length != 2)
                        continue;
                    Result += t1 + "|1\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_Zu3F(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";
            Regex regex = new Regex(@"([\d]){2,}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zu3(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= 2)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_2(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_Q2D_D) || (BuyType == BuyType_Q2D_H) || (BuyType == BuyType_H2D_D) || (BuyType == BuyType_H2D_H))
                RegexString = @"([\d]){2}";
            else
                RegexString = @"(([\d])|([(][\d]{1,10}[)])){2}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_2(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_Q2D_D) || (BuyType == BuyType_Q2D_H)) ? 1 : 2))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_1(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_Q1D_D) || (BuyType == BuyType_Q1D_H) || (BuyType == BuyType_H1D_D) || (BuyType == BuyType_H1D_H))
                RegexString = @"([\d]){1}";
            else
                RegexString = @"([\d]){1,}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_1(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if (singles.Length >= (((BuyType == BuyType_Q1D_D) || (BuyType == BuyType_Q1D_H)) ? 1 : 2))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle_Zhi(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 福建风采20选5
    /// </summary>
    public partial class FJFC20X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 3001;
        public const int BuyType_D_H = 3002;
        public const int BuyType_F_D = 3003;
        public const int BuyType_F_H = 3004;
        public const int BuyType_C = 3005;

        public const int ID = 30;
        public const string sID = "30";
        public const string Name = "福建风采20选5";
        public const string Code = "FJFC20X5";
        public const double MaxMoney = 4004;
        #endregion

        public FJFC20X5()
        {
            id = 30;
            buytype_c = 3005;
            name = "福建风采20选5";
            code = "FJFC20X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 3001) && (buy_type <= 3005));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num) //id = 30
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 20 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))   //奖金顺序 1-3等奖
                return -3;

            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,19}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 20) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 安徽风采5位数
    /// </summary>
    public partial class AHFC5WS : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 3101;
        public const int BuyType_D_H = 3102;
        public const int BuyType_F_D = 3103;
        public const int BuyType_F_H = 3104;
        public const int BuyType_C = 3105;

        public const int ID = 31;
        public const string sID = "31";
        public const string Name = "安徽风采5位数";
        public const string Code = "AHFC5WS";
        public const double MaxMoney = 200000;
        #endregion

        public AHFC5WS()
        {
            id = 31;
            buytype_c = 3105;
            name = "安徽风采5位数";
            code = "AHFC5WS";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 3101) && (buy_type <= 3105));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 31
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 5; j++)
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            string[] Locate = new string[5];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 5; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }
                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }
                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                al.Add(str_4);
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 5)	//5: 12345
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 8))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 5)
                        continue;
                    if (Lottery[i] == WinNumber)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }

                    for (int j = 0; j <= 1; j++)
                    {
                        if (Lottery[i].Substring(j, 4) == WinNumber.Substring(j, 4))
                        {
                            Description2++;
                            WinMoney += WinMoneyList[2];
                            WinMoneyNoWithTax += WinMoneyList[3];
                            continue;
                        }
                    }

                    for (int j = 0; j <= 2; j++)
                    {
                        if (Lottery[i].Substring(j, 3) == WinNumber.Substring(j, 3))
                        {
                            Description3++;
                            WinMoney += WinMoneyList[4];
                            WinMoneyNoWithTax += WinMoneyList[5];
                            continue;
                        }
                    }

                    for (int j = 0; j <= 3; j++)
                    {
                        if (Lottery[i].Substring(j, 2) == WinNumber.Substring(j, 2))
                        {
                            Description4++;
                            WinMoney += WinMoneyList[6];
                            WinMoneyNoWithTax += WinMoneyList[7];
                            continue;
                        }
                    }
                }
            }

            if (Description1 > 0)
            {
                Description = "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d){5}";
            else
                RegexString = @"((\d)|([(]\d{1,10}[)])){5}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"([\d]){5}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 深圳快乐8
    /// </summary>
    public partial class SZKL8 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D = 3201;
        public const int BuyType_H = 3202;
        public const int BuyType_C = 3203;

        public const int ID = 32;
        public const string sID = "32";
        public const string Name = "深圳快乐8";
        public const string Code = "SZKL8";
        public const double MaxMoney = 2;
        #endregion

        public SZKL8()
        {
            id = 32;
            buytype_c = 3203;
            name = "深圳快乐8";
            code = "SZKL8";
        }

        public override bool CheckBuyType(int buy_type) // id = 32
        {
            return ((buy_type >= 3201) && (buy_type <= 3203));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[3];

            Result[0] = new LotteryBuyType(BuyType_D, "代购");
            Result[1] = new LotteryBuyType(BuyType_H, "合买");
            Result[2] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num, int Type)//  Type: 8 = 选8,7 = 选7,6 = 选6,5 = 选5, 4 = 选4,3 = 选3,2 = 选2,1 = 选1 
        {
            if ((Type != 8) && (Type != 7) && (Type != 6) && (Type != 5) && (Type != 4) && (Type != 3) && (Type != 2) && (Type != 1))
                Type = 8;

            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < Type; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 80 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }
                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	// 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 1)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; ((i < strs.Length) && (i < 8)); i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            string[] Result = new string[1];
            Result[0] = CanonicalNumber;

            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 59)	//59: "01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20"
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            if ((WinMoneyList == null) || (WinMoneyList.Length < 50)) //奖金参数排列顺序X8(0-11),X7(12,21),X6(22,29) X5(30,35)X4(36,41),X3(42,45),X2(46,47),X1(48,49) 
                return -3;

            int Description8_1 = 0, Description8_2 = 0, Description8_3 = 0, Description8_4 = 0, Description8_5 = 0, Description8_6 = 0;
            int Description7_1 = 0, Description7_2 = 0, Description7_3 = 0, Description7_4 = 0, Description7_5 = 0;
            int Description6_1 = 0, Description6_2 = 0, Description6_3 = 0, Description6_4 = 0;
            int Description5_1 = 0, Description5_2 = 0, Description5_3 = 0;
            int Description4_1 = 0, Description4_2 = 0, Description4_3 = 0;
            int Description3_1 = 0, Description3_2 = 0;
            int Description2_1 = 0;
            int Description1_1 = 0;

            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType_D);
                if ((Lottery == null) || (Lottery.Length < 1))
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    int t_Description8_1 = 0, t_Description8_2 = 0, t_Description8_3 = 0, t_Description8_4 = 0, t_Description8_5 = 0, t_Description8_6 = 0;
                    int t_Description7_1 = 0, t_Description7_2 = 0, t_Description7_3 = 0, t_Description7_4 = 0, t_Description7_5 = 0;
                    int t_Description6_1 = 0, t_Description6_2 = 0, t_Description6_3 = 0, t_Description6_4 = 0;
                    int t_Description5_1 = 0, t_Description5_2 = 0, t_Description5_3 = 0;
                    int t_Description4_1 = 0, t_Description4_2 = 0, t_Description4_3 = 0;
                    int t_Description3_1 = 0, t_Description3_2 = 0;
                    int t_Description2_1 = 0;
                    int t_Description1_1 = 0;

                    double t_WinMoney = 0;
                    double t_WinMoneyNoWithTax = 0;

                    switch (ShoveEL._String.StringAt(Lottery[i], ' ') + 1)
                    {
                        case 8:
                            t_WinMoney = ComputeWin_8(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3],
                                WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7], WinMoneyList[8], WinMoneyList[9], WinMoneyList[10], WinMoneyList[11],
                                ref t_Description8_1, ref t_Description8_2, ref t_Description8_3, ref t_Description8_4, ref t_Description8_5, ref t_Description8_6);
                            break;
                        case 7:
                            t_WinMoney = ComputeWin_7(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[12], WinMoneyList[13], WinMoneyList[14], WinMoneyList[15],
                                WinMoneyList[16], WinMoneyList[17], WinMoneyList[18], WinMoneyList[19], WinMoneyList[20], WinMoneyList[21],
                                ref t_Description7_1, ref t_Description7_2, ref t_Description7_3, ref t_Description7_4, ref t_Description7_5);
                            break;
                        case 6:
                            t_WinMoney = ComputeWin_6(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[22], WinMoneyList[23], WinMoneyList[24], WinMoneyList[25],
                                WinMoneyList[26], WinMoneyList[27], WinMoneyList[28], WinMoneyList[29],
                                ref t_Description6_1, ref t_Description6_2, ref t_Description6_3, ref t_Description6_4);
                            break;
                        case 5:
                            t_WinMoney = ComputeWin_5(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[30], WinMoneyList[31], WinMoneyList[32], WinMoneyList[33],
                                WinMoneyList[34], WinMoneyList[35],
                                ref t_Description5_1, ref t_Description5_2, ref t_Description5_3);
                            break;
                        case 4:
                            t_WinMoney = ComputeWin_4(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[36], WinMoneyList[37], WinMoneyList[38], WinMoneyList[39],
                                WinMoneyList[40], WinMoneyList[41],
                                ref t_Description4_1, ref t_Description4_2, ref t_Description4_3);
                            break;
                        case 3:
                            t_WinMoney = ComputeWin_3(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[42], WinMoneyList[43], WinMoneyList[44], WinMoneyList[45],
                                ref t_Description3_1, ref t_Description3_2);
                            break;
                        case 2:
                            t_WinMoney = ComputeWin_2(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[46], WinMoneyList[47],
                                ref t_Description2_1);
                            break;
                        case 1:
                            t_WinMoney = ComputeWin_1(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[48], WinMoneyList[49],
                                ref t_Description1_1);
                            break;
                        default:
                            continue;
                    }

                    Description8_1 += t_Description8_1; Description8_2 += t_Description8_2; Description8_3 += t_Description8_3; Description8_4 += t_Description8_4; Description8_5 += t_Description8_5; Description8_6 += t_Description8_6;
                    Description7_1 += t_Description7_1; Description7_2 += t_Description7_2; Description7_3 += t_Description7_3; Description7_4 += t_Description7_4; Description7_5 += t_Description7_5;
                    Description6_1 += t_Description6_1; Description6_2 += t_Description6_2; Description6_3 += t_Description6_3; Description6_4 += t_Description6_4;
                    Description5_1 += t_Description5_1; Description5_2 += t_Description5_2; Description5_3 += t_Description5_3;
                    Description4_1 += t_Description4_1; Description4_2 += t_Description4_2; Description4_3 += t_Description4_3;
                    Description3_1 += t_Description3_1; Description3_2 += t_Description3_2;
                    Description2_1 += t_Description2_1;
                    Description1_1 += t_Description1_1;

                    WinMoney += t_WinMoney;
                    WinMoneyNoWithTax += t_WinMoneyNoWithTax;
                }
            }

            Description = "";
            #region 组合 Description
            if (Description8_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中8奖" + Description8_1.ToString() + "注";
            }
            if (Description8_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中7奖" + Description8_2.ToString() + "注";
            }
            if (Description8_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中6奖" + Description8_3.ToString() + "注";
            }
            if (Description8_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中5奖" + Description8_4.ToString() + "注";
            }
            if (Description8_5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中4奖" + Description8_5.ToString() + "注";
            }
            if (Description8_6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中0奖" + Description8_6.ToString() + "注";
            }

            if (Description7_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中7奖" + Description7_1.ToString() + "注";
            }
            if (Description7_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中6奖" + Description7_2.ToString() + "注";
            }
            if (Description7_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中5奖" + Description7_3.ToString() + "注";
            }
            if (Description7_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中4奖" + Description7_4.ToString() + "注";
            }
            if (Description7_5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中0奖" + Description7_5.ToString() + "注";
            }

            if (Description6_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中6奖" + Description6_1.ToString() + "注";
            }
            if (Description6_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中5奖" + Description6_2.ToString() + "注";
            }
            if (Description6_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中4奖" + Description6_3.ToString() + "注";
            }
            if (Description6_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中3奖" + Description6_4.ToString() + "注";
            }

            if (Description5_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中5奖" + Description5_1.ToString() + "注";
            }
            if (Description5_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中4奖" + Description5_2.ToString() + "注";
            }
            if (Description5_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中3奖" + Description5_3.ToString() + "注";
            }

            if (Description4_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中4奖" + Description4_1.ToString() + "注";
            }
            if (Description4_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中3奖" + Description4_2.ToString() + "注";
            }
            if (Description4_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中2奖" + Description4_3.ToString() + "注";
            }

            if (Description3_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选3中3奖" + Description3_1.ToString() + "注";
            }
            if (Description3_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选3中2奖" + Description3_2.ToString() + "注";
            }

            if (Description2_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选2中2奖" + Description2_1.ToString() + "注";
            }

            if (Description1_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选2中2奖" + Description1_1.ToString() + "注";
            }

            if (Description != "")
                Description += "。";
            #endregion

            return WinMoney;
        }
        #region ComputeWin  的具体方法
        private Double ComputeWin_8(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4, ref int Description5, ref int Description6)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0; Description5 = 0; Description6 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[8];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d\s)(?<R7>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 8; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 8)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 7)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 6)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 5)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            else if (RedRight == 4)
            {
                Description5++;
                WinMoney += WinMoney5;
                WinMoneyNoWithTax += WinMoneyNoWithTax5;
            }

            else if (RedRight == 0)
            {
                Description6++;
                WinMoney += WinMoney6;
                WinMoneyNoWithTax += WinMoneyNoWithTax6;
            }

            return WinMoney;
        }
        private Double ComputeWin_7(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4, ref int Description5)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0; Description5 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[7];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 7; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 7)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 6)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 5)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 4)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            else if (RedRight == 0)
            {
                Description5++;
                WinMoney += WinMoney5;
                WinMoneyNoWithTax += WinMoneyNoWithTax5;
            }

            return WinMoney;
        }
        private Double ComputeWin_6(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[6];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 6; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 6)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 5)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 4)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 3)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            return WinMoney;
        }
        private Double ComputeWin_5(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            ref int Description1, ref int Description2, ref int Description3)
        {
            Description1 = 0; Description2 = 0; Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[5];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 5; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 5)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 4)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 3)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            return WinMoney;
        }
        private Double ComputeWin_4(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            ref int Description1, ref int Description2, ref int Description3)
        {
            Description1 = 0; Description2 = 0; Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[4];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 4; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 4)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 3)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 2)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            return WinMoney;
        }
        private Double ComputeWin_3(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2,
            ref int Description1, ref int Description2)
        {
            Description1 = 0; Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[3];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 3; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 3)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 2)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            return WinMoney;
        }
        private Double ComputeWin_2(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1,
            ref int Description1)
        {
            Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[2];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 2; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 2)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            return WinMoney;
        }
        private Double ComputeWin_1(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1,
            ref int Description1)
        {
            Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            if (WinNumber.IndexOf(Number) >= 0)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            Regex regex = new Regex(@"(\d\d\s){0,7}\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);

                    if (singles == null)
                        continue;

                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);

            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string[] WinLotteryNumber = FilterRepeated(Number.Split(' '));

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 20))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 80) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 北京快乐8
    /// </summary>
    public partial class BJKL8 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D = 3301;
        public const int BuyType_H = 3302;
        public const int BuyType_C = 3303;

        public const int ID = 33;
        public const string sID = "33";
        public const string Name = "北京快乐8";
        public const string Code = "BJKL8";
        public const double MaxMoney = 2;
        #endregion

        public BJKL8()
        {
            id = 33;
            buytype_c = 3303;
            name = "北京快乐8";
            code = "BJKL8";
        }

        public override bool CheckBuyType(int buy_type) //id = 33
        {
            return ((buy_type >= 3301) && (buy_type <= 3303));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[3];

            Result[0] = new LotteryBuyType(BuyType_D, "代购");
            Result[1] = new LotteryBuyType(BuyType_H, "合买");
            Result[2] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num, int Type)//  Type: 8 = 选8,7 = 选7,6 = 选6,5 = 选5, 4 = 选4,3 = 选3,2 = 选2,1 = 选1 
        {
            if ((Type != 8) && (Type != 7) && (Type != 6) && (Type != 5) && (Type != 4) && (Type != 3) && (Type != 2) && (Type != 1))
                Type = 8;

            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < Type; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 80 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }
                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	// 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 1)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; ((i < strs.Length) && (i < 8)); i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            string[] Result = new string[1];
            Result[0] = CanonicalNumber;

            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 59)	//59: "01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20"
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            if ((WinMoneyList == null) || (WinMoneyList.Length < 50)) //奖金参数排列顺序X8(0-11),X7(12,21),X6(22,29) X5(30,35)X4(36,41),X3(42,45),X2(46,47),X1(48,49) 
                return -3;

            int Description8_1 = 0, Description8_2 = 0, Description8_3 = 0, Description8_4 = 0, Description8_5 = 0, Description8_6 = 0;
            int Description7_1 = 0, Description7_2 = 0, Description7_3 = 0, Description7_4 = 0, Description7_5 = 0;
            int Description6_1 = 0, Description6_2 = 0, Description6_3 = 0, Description6_4 = 0;
            int Description5_1 = 0, Description5_2 = 0, Description5_3 = 0;
            int Description4_1 = 0, Description4_2 = 0, Description4_3 = 0;
            int Description3_1 = 0, Description3_2 = 0;
            int Description2_1 = 0;
            int Description1_1 = 0;

            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType_D);
                if ((Lottery == null) || (Lottery.Length < 1))
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    int t_Description8_1 = 0, t_Description8_2 = 0, t_Description8_3 = 0, t_Description8_4 = 0, t_Description8_5 = 0, t_Description8_6 = 0;
                    int t_Description7_1 = 0, t_Description7_2 = 0, t_Description7_3 = 0, t_Description7_4 = 0, t_Description7_5 = 0;
                    int t_Description6_1 = 0, t_Description6_2 = 0, t_Description6_3 = 0, t_Description6_4 = 0;
                    int t_Description5_1 = 0, t_Description5_2 = 0, t_Description5_3 = 0;
                    int t_Description4_1 = 0, t_Description4_2 = 0, t_Description4_3 = 0;
                    int t_Description3_1 = 0, t_Description3_2 = 0;
                    int t_Description2_1 = 0;
                    int t_Description1_1 = 0;

                    double t_WinMoney = 0;
                    double t_WinMoneyNoWithTax = 0;

                    switch (ShoveEL._String.StringAt(Lottery[i], ' ') + 1)
                    {
                        case 8:
                            t_WinMoney = ComputeWin_8(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3],
                                WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7], WinMoneyList[8], WinMoneyList[9], WinMoneyList[10], WinMoneyList[11],
                                ref t_Description8_1, ref t_Description8_2, ref t_Description8_3, ref t_Description8_4, ref t_Description8_5, ref t_Description8_6);
                            break;
                        case 7:
                            t_WinMoney = ComputeWin_7(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[12], WinMoneyList[13], WinMoneyList[14], WinMoneyList[15],
                                WinMoneyList[16], WinMoneyList[17], WinMoneyList[18], WinMoneyList[19], WinMoneyList[20], WinMoneyList[21],
                                ref t_Description7_1, ref t_Description7_2, ref t_Description7_3, ref t_Description7_4, ref t_Description7_5);
                            break;
                        case 6:
                            t_WinMoney = ComputeWin_6(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[22], WinMoneyList[23], WinMoneyList[24], WinMoneyList[25],
                                WinMoneyList[26], WinMoneyList[27], WinMoneyList[28], WinMoneyList[29],
                                ref t_Description6_1, ref t_Description6_2, ref t_Description6_3, ref t_Description6_4);
                            break;
                        case 5:
                            t_WinMoney = ComputeWin_5(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[30], WinMoneyList[31], WinMoneyList[32], WinMoneyList[33],
                                WinMoneyList[34], WinMoneyList[35],
                                ref t_Description5_1, ref t_Description5_2, ref t_Description5_3);
                            break;
                        case 4:
                            t_WinMoney = ComputeWin_4(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[36], WinMoneyList[37], WinMoneyList[38], WinMoneyList[39],
                                WinMoneyList[40], WinMoneyList[41],
                                ref t_Description4_1, ref t_Description4_2, ref t_Description4_3);
                            break;
                        case 3:
                            t_WinMoney = ComputeWin_3(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[42], WinMoneyList[43], WinMoneyList[44], WinMoneyList[45],
                                ref t_Description3_1, ref t_Description3_2);
                            break;
                        case 2:
                            t_WinMoney = ComputeWin_2(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[46], WinMoneyList[47],
                                ref t_Description2_1);
                            break;
                        case 1:
                            t_WinMoney = ComputeWin_1(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[48], WinMoneyList[49],
                                ref t_Description1_1);
                            break;
                        default:
                            continue;
                    }

                    Description8_1 += t_Description8_1; Description8_2 += t_Description8_2; Description8_3 += t_Description8_3; Description8_4 += t_Description8_4; Description8_5 += t_Description8_5; Description8_6 += t_Description8_6;
                    Description7_1 += t_Description7_1; Description7_2 += t_Description7_2; Description7_3 += t_Description7_3; Description7_4 += t_Description7_4; Description7_5 += t_Description7_5;
                    Description6_1 += t_Description6_1; Description6_2 += t_Description6_2; Description6_3 += t_Description6_3; Description6_4 += t_Description6_4;
                    Description5_1 += t_Description5_1; Description5_2 += t_Description5_2; Description5_3 += t_Description5_3;
                    Description4_1 += t_Description4_1; Description4_2 += t_Description4_2; Description4_3 += t_Description4_3;
                    Description3_1 += t_Description3_1; Description3_2 += t_Description3_2;
                    Description2_1 += t_Description2_1;
                    Description1_1 += t_Description1_1;

                    WinMoney += t_WinMoney;
                    WinMoneyNoWithTax += t_WinMoneyNoWithTax;
                }
            }

            Description = "";
            #region 组合 Description
            if (Description8_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中8奖" + Description8_1.ToString() + "注";
            }
            if (Description8_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中7奖" + Description8_2.ToString() + "注";
            }
            if (Description8_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中6奖" + Description8_3.ToString() + "注";
            }
            if (Description8_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中5奖" + Description8_4.ToString() + "注";
            }
            if (Description8_5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中4奖" + Description8_5.ToString() + "注";
            }
            if (Description8_6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中0奖" + Description8_6.ToString() + "注";
            }

            if (Description7_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中7奖" + Description7_1.ToString() + "注";
            }
            if (Description7_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中6奖" + Description7_2.ToString() + "注";
            }
            if (Description7_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中5奖" + Description7_3.ToString() + "注";
            }
            if (Description7_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中4奖" + Description7_4.ToString() + "注";
            }
            if (Description7_5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中0奖" + Description7_5.ToString() + "注";
            }

            if (Description6_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中6奖" + Description6_1.ToString() + "注";
            }
            if (Description6_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中5奖" + Description6_2.ToString() + "注";
            }
            if (Description6_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中4奖" + Description6_3.ToString() + "注";
            }
            if (Description6_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中3奖" + Description6_4.ToString() + "注";
            }

            if (Description5_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中5奖" + Description5_1.ToString() + "注";
            }
            if (Description5_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中4奖" + Description5_2.ToString() + "注";
            }
            if (Description5_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中3奖" + Description5_3.ToString() + "注";
            }

            if (Description4_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中4奖" + Description4_1.ToString() + "注";
            }
            if (Description4_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中3奖" + Description4_2.ToString() + "注";
            }
            if (Description4_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中2奖" + Description4_3.ToString() + "注";
            }

            if (Description3_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选3中3奖" + Description3_1.ToString() + "注";
            }
            if (Description3_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选3中2奖" + Description3_2.ToString() + "注";
            }

            if (Description2_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选2中2奖" + Description2_1.ToString() + "注";
            }

            if (Description1_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选2中2奖" + Description1_1.ToString() + "注";
            }

            if (Description != "")
                Description += "。";
            #endregion

            return WinMoney;
        }
        #region ComputeWin  的具体方法
        private Double ComputeWin_8(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4, ref int Description5, ref int Description6)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0; Description5 = 0; Description6 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[8];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d\s)(?<R7>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 8; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 8)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 7)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 6)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 5)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            else if (RedRight == 4)
            {
                Description5++;
                WinMoney += WinMoney5;
                WinMoneyNoWithTax += WinMoneyNoWithTax5;
            }

            else if (RedRight == 0)
            {
                Description6++;
                WinMoney += WinMoney6;
                WinMoneyNoWithTax += WinMoneyNoWithTax6;
            }

            return WinMoney;
        }
        private Double ComputeWin_7(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4, ref int Description5)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0; Description5 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[7];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 7; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 7)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 6)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 5)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 4)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            else if (RedRight == 0)
            {
                Description5++;
                WinMoney += WinMoney5;
                WinMoneyNoWithTax += WinMoneyNoWithTax5;
            }

            return WinMoney;
        }
        private Double ComputeWin_6(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[6];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 6; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 6)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 5)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 4)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 3)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            return WinMoney;
        }
        private Double ComputeWin_5(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            ref int Description1, ref int Description2, ref int Description3)
        {
            Description1 = 0; Description2 = 0; Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[5];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 5; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 5)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 4)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 3)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            return WinMoney;
        }
        private Double ComputeWin_4(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            ref int Description1, ref int Description2, ref int Description3)
        {
            Description1 = 0; Description2 = 0; Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[4];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 4; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 4)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 3)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 2)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            return WinMoney;
        }
        private Double ComputeWin_3(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2,
            ref int Description1, ref int Description2)
        {
            Description1 = 0; Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[3];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 3; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 3)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 2)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            return WinMoney;
        }
        private Double ComputeWin_2(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1,
            ref int Description1)
        {
            Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[2];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 2; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 2)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            return WinMoney;
        }
        private Double ComputeWin_1(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1,
            ref int Description1)
        {
            Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            if (WinNumber.IndexOf(Number) >= 0)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            Regex regex = new Regex(@"(\d\d\s){0,7}\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);

                    if (singles == null)
                        continue;

                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);

            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string[] WinLotteryNumber = FilterRepeated(Number.Split(' '));

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 20))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 80) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 上海Keno游戏
    /// </summary>
    public partial class SHKeno : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D = 3401;
        public const int BuyType_H = 3402;
        public const int BuyType_C = 3403;

        public const int ID = 34;
        public const string sID = "34";
        public const string Name = "上海Keno游戏";
        public const string Code = "SHKeno";
        public const double MaxMoney = 2;
        #endregion

        public SHKeno()
        {
            id = 34;
            buytype_c = 3403;
            name = "上海Keno游戏";
            code = "SHKeno";
        }

        public override bool CheckBuyType(int buy_type) //id = 34
        {
            return ((buy_type >= 3401) && (buy_type <= 3403));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[3];

            Result[0] = new LotteryBuyType(BuyType_D, "代购");
            Result[1] = new LotteryBuyType(BuyType_H, "合买");
            Result[2] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num, int Type)//  Type: 10 = 选10, 9 = 选9, 8 = 选8,7 = 选7,6 = 选6,5 = 选5, 4 = 选4,3 = 选3,2 = 选2,1 = 选1 
        {
            if ((Type != 10) && (Type != 9) && (Type != 8) && (Type != 7) && (Type != 6) && (Type != 5) && (Type != 4) && (Type != 3) && (Type != 2) && (Type != 1))
                Type = 10;

            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < Type; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 80 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }
                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	// 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 1)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; ((i < strs.Length) && (i < 10)); i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            string[] Result = new string[1];
            Result[0] = CanonicalNumber;

            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 59)	//59: "01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20"
                return -1;

            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            if ((WinMoneyList == null) || (WinMoneyList.Length < 74)) //奖金参数排列顺序 X10(0,13),X9(14,25),X8(26-37),X7(38,45),X6(46,53) X5(54,59)X4(60,65),X3(66,69),X2(70,71),X1(72,73) 
                return -3;

            int Description10_1 = 0, Description10_2 = 0, Description10_3 = 0, Description10_4 = 0, Description10_5 = 0, Description10_6 = 0, Description10_7 = 0;
            int Description9_1 = 0, Description9_2 = 0, Description9_3 = 0, Description9_4 = 0, Description9_5 = 0, Description9_6 = 0;
            int Description8_1 = 0, Description8_2 = 0, Description8_3 = 0, Description8_4 = 0, Description8_5 = 0, Description8_6 = 0;
            int Description7_1 = 0, Description7_2 = 0, Description7_3 = 0, Description7_4 = 0;
            int Description6_1 = 0, Description6_2 = 0, Description6_3 = 0, Description6_4 = 0;
            int Description5_1 = 0, Description5_2 = 0, Description5_3 = 0;
            int Description4_1 = 0, Description4_2 = 0, Description4_3 = 0;
            int Description3_1 = 0, Description3_2 = 0;
            int Description2_1 = 0;
            int Description1_1 = 0;

            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType_D);
                if ((Lottery == null) || (Lottery.Length < 1))
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    int t_Description10_1 = 0, t_Description10_2 = 0, t_Description10_3 = 0, t_Description10_4 = 0, t_Description10_5 = 0, t_Description10_6 = 0, t_Description10_7 = 0;
                    int t_Description9_1 = 0, t_Description9_2 = 0, t_Description9_3 = 0, t_Description9_4 = 0, t_Description9_5 = 0, t_Description9_6 = 0;
                    int t_Description8_1 = 0, t_Description8_2 = 0, t_Description8_3 = 0, t_Description8_4 = 0, t_Description8_5 = 0, t_Description8_6 = 0;
                    int t_Description7_1 = 0, t_Description7_2 = 0, t_Description7_3 = 0, t_Description7_4 = 0;
                    int t_Description6_1 = 0, t_Description6_2 = 0, t_Description6_3 = 0, t_Description6_4 = 0;
                    int t_Description5_1 = 0, t_Description5_2 = 0, t_Description5_3 = 0;
                    int t_Description4_1 = 0, t_Description4_2 = 0, t_Description4_3 = 0;
                    int t_Description3_1 = 0, t_Description3_2 = 0;
                    int t_Description2_1 = 0;
                    int t_Description1_1 = 0;

                    double t_WinMoney = 0;
                    double t_WinMoneyNoWithTax = 0;

                    switch (ShoveEL._String.StringAt(Lottery[i], ' ') + 1)
                    {
                        case 10:
                            t_WinMoney = ComputeWin_10(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3],
                                WinMoneyList[4], WinMoneyList[5], WinMoneyList[6], WinMoneyList[7], WinMoneyList[8], WinMoneyList[9], WinMoneyList[10], WinMoneyList[11], WinMoneyList[12], WinMoneyList[13],
                                ref t_Description10_1, ref t_Description10_2, ref t_Description10_3, ref t_Description10_4, ref t_Description10_5, ref t_Description10_6, ref t_Description10_7);
                            break;
                        case 9:
                            t_WinMoney = ComputeWin_9(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[14], WinMoneyList[15], WinMoneyList[16], WinMoneyList[17],
                                WinMoneyList[18], WinMoneyList[19], WinMoneyList[20], WinMoneyList[21], WinMoneyList[22], WinMoneyList[23], WinMoneyList[24], WinMoneyList[25],
                                ref t_Description9_1, ref t_Description9_2, ref t_Description9_3, ref t_Description9_4, ref t_Description9_5, ref t_Description9_6);
                            break;
                        case 8:
                            t_WinMoney = ComputeWin_8(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[26], WinMoneyList[27], WinMoneyList[28], WinMoneyList[29],
                                WinMoneyList[30], WinMoneyList[31], WinMoneyList[32], WinMoneyList[33], WinMoneyList[34], WinMoneyList[35], WinMoneyList[36], WinMoneyList[37],
                                ref t_Description8_1, ref t_Description8_2, ref t_Description8_3, ref t_Description8_4, ref t_Description8_5, ref t_Description8_6);
                            break;
                        case 7:
                            t_WinMoney = ComputeWin_7(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[38], WinMoneyList[39], WinMoneyList[40], WinMoneyList[41],
                                WinMoneyList[42], WinMoneyList[43], WinMoneyList[44], WinMoneyList[45],
                                ref t_Description7_1, ref t_Description7_2, ref t_Description7_3, ref t_Description7_4);
                            break;
                        case 6:
                            t_WinMoney = ComputeWin_6(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[46], WinMoneyList[47], WinMoneyList[48], WinMoneyList[49],
                                WinMoneyList[50], WinMoneyList[51], WinMoneyList[52], WinMoneyList[53],
                                ref t_Description6_1, ref t_Description6_2, ref t_Description6_3, ref t_Description6_4);
                            break;
                        case 5:
                            t_WinMoney = ComputeWin_5(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[54], WinMoneyList[55], WinMoneyList[56], WinMoneyList[57],
                                WinMoneyList[58], WinMoneyList[59],
                                ref t_Description5_1, ref t_Description5_2, ref t_Description5_3);
                            break;
                        case 4:
                            t_WinMoney = ComputeWin_4(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[60], WinMoneyList[61], WinMoneyList[62], WinMoneyList[63],
                                WinMoneyList[64], WinMoneyList[65],
                                ref t_Description4_1, ref t_Description4_2, ref t_Description4_3);
                            break;
                        case 3:
                            t_WinMoney = ComputeWin_3(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[66], WinMoneyList[67], WinMoneyList[68], WinMoneyList[69],
                                ref t_Description3_1, ref t_Description3_2);
                            break;
                        case 2:
                            t_WinMoney = ComputeWin_2(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[70], WinMoneyList[71],
                                ref t_Description2_1);
                            break;
                        case 1:
                            t_WinMoney = ComputeWin_1(Lottery[i], WinNumber, ref t_WinMoneyNoWithTax, WinMoneyList[72], WinMoneyList[73],
                                ref t_Description1_1);
                            break;
                        default:
                            continue;
                    }

                    Description10_1 += t_Description10_1; Description10_2 += t_Description10_2; Description10_3 += t_Description10_3; Description10_4 += t_Description10_4; Description10_5 += t_Description10_5; Description10_6 += t_Description10_6; Description10_7 += t_Description10_7;
                    Description9_1 += t_Description9_1; Description9_2 += t_Description9_2; Description9_3 += t_Description9_3; Description9_4 += t_Description9_4; Description9_5 += t_Description9_5; Description9_6 += t_Description9_6;
                    Description8_1 += t_Description8_1; Description8_2 += t_Description8_2; Description8_3 += t_Description8_3; Description8_4 += t_Description8_4; Description8_5 += t_Description8_5; Description8_6 += t_Description8_6;
                    Description7_1 += t_Description7_1; Description7_2 += t_Description7_2; Description7_3 += t_Description7_3; Description7_4 += t_Description7_4;
                    Description6_1 += t_Description6_1; Description6_2 += t_Description6_2; Description6_3 += t_Description6_3; Description6_4 += t_Description6_4;
                    Description5_1 += t_Description5_1; Description5_2 += t_Description5_2; Description5_3 += t_Description5_3;
                    Description4_1 += t_Description4_1; Description4_2 += t_Description4_2; Description4_3 += t_Description4_3;
                    Description3_1 += t_Description3_1; Description3_2 += t_Description3_2;
                    Description2_1 += t_Description2_1;
                    Description1_1 += t_Description1_1;

                    WinMoney += t_WinMoney;
                    WinMoneyNoWithTax += t_WinMoneyNoWithTax;
                }
            }

            Description = "";
            #region 组合 Description
            if (Description10_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选10中10奖" + Description10_1.ToString() + "注";
            }
            if (Description10_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选10中9奖" + Description10_2.ToString() + "注";
            }
            if (Description10_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选10中8奖" + Description10_3.ToString() + "注";
            }
            if (Description10_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选10中7奖" + Description10_4.ToString() + "注";
            }
            if (Description10_5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选10中6奖" + Description10_5.ToString() + "注";
            }
            if (Description10_6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选10中5奖" + Description10_6.ToString() + "注";
            }
            if (Description10_7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选10中0奖" + Description10_7.ToString() + "注";
            }

            if (Description9_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选9中9奖" + Description9_1.ToString() + "注";
            }
            if (Description9_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选9中8奖" + Description9_2.ToString() + "注";
            }
            if (Description9_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选9中7奖" + Description9_3.ToString() + "注";
            }
            if (Description9_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选9中6奖" + Description9_4.ToString() + "注";
            }
            if (Description9_5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选9中5奖" + Description9_5.ToString() + "注";
            }
            if (Description9_6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选9中0奖" + Description9_6.ToString() + "注";
            }

            if (Description8_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中8奖" + Description8_1.ToString() + "注";
            }
            if (Description8_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中7奖" + Description8_2.ToString() + "注";
            }
            if (Description8_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中6奖" + Description8_3.ToString() + "注";
            }
            if (Description8_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中5奖" + Description8_4.ToString() + "注";
            }
            if (Description8_5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中4奖" + Description8_5.ToString() + "注";
            }
            if (Description8_6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选8中0奖" + Description8_6.ToString() + "注";
            }

            if (Description7_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中7奖" + Description7_1.ToString() + "注";
            }
            if (Description7_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中6奖" + Description7_2.ToString() + "注";
            }
            if (Description7_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中5奖" + Description7_3.ToString() + "注";
            }
            if (Description7_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选7中4奖" + Description7_4.ToString() + "注";
            }

            if (Description6_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中6奖" + Description6_1.ToString() + "注";
            }
            if (Description6_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中5奖" + Description6_2.ToString() + "注";
            }
            if (Description6_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中4奖" + Description6_3.ToString() + "注";
            }
            if (Description6_4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选6中3奖" + Description6_4.ToString() + "注";
            }

            if (Description5_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中5奖" + Description5_1.ToString() + "注";
            }
            if (Description5_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中4奖" + Description5_2.ToString() + "注";
            }
            if (Description5_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选5中3奖" + Description5_3.ToString() + "注";
            }

            if (Description4_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中4奖" + Description4_1.ToString() + "注";
            }
            if (Description4_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中3奖" + Description4_2.ToString() + "注";
            }
            if (Description4_3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选4中2奖" + Description4_3.ToString() + "注";
            }

            if (Description3_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选3中3奖" + Description3_1.ToString() + "注";
            }
            if (Description3_2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选3中2奖" + Description3_2.ToString() + "注";
            }

            if (Description2_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选2中2奖" + Description2_1.ToString() + "注";
            }

            if (Description1_1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "选2中2奖" + Description1_1.ToString() + "注";
            }

            if (Description != "")
                Description += "。";
            #endregion

            return WinMoney;
        }
        #region ComputeWin  的具体方法
        private Double ComputeWin_10(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6, double WinMoney7, double WinMoneyNoWithTax7,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4, ref int Description5, ref int Description6, ref int Description7)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0; Description5 = 0; Description6 = 0; Description7 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[10];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d\s)(?<R7>\d\d\s)(?<R8>\d\d\s)(?<R9>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 10; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 10)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 9)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 8)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 7)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            else if (RedRight == 6)
            {
                Description5++;
                WinMoney += WinMoney5;
                WinMoneyNoWithTax += WinMoneyNoWithTax5;
            }

            else if (RedRight == 5)
            {
                Description6++;
                WinMoney += WinMoney6;
                WinMoneyNoWithTax += WinMoneyNoWithTax6;
            }

            else if (RedRight == 0)
            {
                Description7++;
                WinMoney += WinMoney7;
                WinMoneyNoWithTax += WinMoneyNoWithTax7;
            }

            return WinMoney;
        }
        private Double ComputeWin_9(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4, ref int Description5, ref int Description6)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0; Description5 = 0; Description6 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[9];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d\s)(?<R7>\d\d\s)(?<R8>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 9; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 9)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 8)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 7)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 6)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            else if (RedRight == 5)
            {
                Description5++;
                WinMoney += WinMoney5;
                WinMoneyNoWithTax += WinMoneyNoWithTax5;
            }

            else if (RedRight == 0)
            {
                Description6++;
                WinMoney += WinMoney6;
                WinMoneyNoWithTax += WinMoneyNoWithTax6;
            }

            return WinMoney;
        }
        private Double ComputeWin_8(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4, ref int Description5, ref int Description6)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0; Description5 = 0; Description6 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[8];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d\s)(?<R7>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 8; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 8)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 7)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 6)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 5)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            else if (RedRight == 4)
            {
                Description5++;
                WinMoney += WinMoney5;
                WinMoneyNoWithTax += WinMoneyNoWithTax5;
            }

            else if (RedRight == 0)
            {
                Description6++;
                WinMoney += WinMoney6;
                WinMoneyNoWithTax += WinMoneyNoWithTax6;
            }

            return WinMoney;
        }
        private Double ComputeWin_7(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[7];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 7; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 7)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 6)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 5)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 4)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            return WinMoney;
        }
        private Double ComputeWin_6(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            double WinMoney4, double WinMoneyNoWithTax4,
            ref int Description1, ref int Description2, ref int Description3, ref int Description4)
        {
            Description1 = 0; Description2 = 0; Description3 = 0; Description4 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[6];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 6; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 6)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 5)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 4)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            else if (RedRight == 3)
            {
                Description4++;
                WinMoney += WinMoney4;
                WinMoneyNoWithTax += WinMoneyNoWithTax4;
            }

            return WinMoney;
        }
        private Double ComputeWin_5(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            ref int Description1, ref int Description2, ref int Description3)
        {
            Description1 = 0; Description2 = 0; Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[5];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 5; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 5)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 4)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 3)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            return WinMoney;
        }
        private Double ComputeWin_4(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3,
            ref int Description1, ref int Description2, ref int Description3)
        {
            Description1 = 0; Description2 = 0; Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[4];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 4; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 4)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 3)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            else if (RedRight == 2)
            {
                Description3++;
                WinMoney += WinMoney3;
                WinMoneyNoWithTax += WinMoneyNoWithTax3;
            }

            return WinMoney;
        }
        private Double ComputeWin_3(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2,
            ref int Description1, ref int Description2)
        {
            Description1 = 0; Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[3];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 3; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 3)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            else if (RedRight == 2)
            {
                Description2++;
                WinMoney += WinMoney2;
                WinMoneyNoWithTax += WinMoneyNoWithTax2;
            }

            return WinMoney;
        }
        private Double ComputeWin_2(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1,
            ref int Description1)
        {
            Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            string[] Red = new string[2];

            Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);

            int RedRight = 0;

            for (int j = 0; j < 2; j++)
            {
                Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();

                if (WinNumber.IndexOf(Red[j]) >= 0)
                    RedRight++;
            }

            if (RedRight == 2)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            return WinMoney;
        }
        private Double ComputeWin_1(string Number, string WinNumber, ref double WinMoneyNoWithTax,
            double WinMoney1, double WinMoneyNoWithTax1,
            ref int Description1)
        {
            Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;

            if (WinNumber.IndexOf(Number) >= 0)
            {
                Description1++;
                WinMoney += WinMoney1;
                WinMoneyNoWithTax += WinMoneyNoWithTax1;
            }

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            Regex regex = new Regex(@"(\d\d\s){0,9}\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);

                    if (singles == null)
                        continue;

                    if (singles.Length >= 1)
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);

            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string[] WinLotteryNumber = FilterRepeated(Number.Split(' '));

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 20))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 80) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 福建体彩31选7
    /// </summary>
    public partial class FJTC31X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 3501;
        public const int BuyType_D_H = 3502;
        public const int BuyType_F_D = 3503;
        public const int BuyType_F_H = 3504;
        public const int BuyType_C = 3505;

        public const int ID = 35;
        public const string sID = "35";
        public const string Name = "福建体彩31选7";
        public const string Code = "FJTC31X7";
        public const double MaxMoney = 155040;
        #endregion

        public FJTC31X7()
        {
            id = 35;
            buytype_c = 3505;
            name = "福建体彩31选7";
            code = "FJTC31X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 3501) && (buy_type <= 3505));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 35
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 31 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 16))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                // 幸运奖
                if (Lottery.Length > 1)
                {
                    int Right = 0;
                    string[] LotteryList = Lotterys[ii].Split(' ');

                    for (int i = 0; i < LotteryList.Length; i++)
                    {
                        if (WinNumber.IndexOf(LotteryList[i]) >= 0)
                            Right++;
                    }

                    if (Right == 8)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                    }
                }

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description8++;
                        WinMoney += WinMoneyList[14];
                        WinMoneyNoWithTax += WinMoneyList[15];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "幸运奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "特等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,19}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 31) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 福建体彩36选7
    /// </summary>
    public partial class FJTC36X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 3601;
        public const int BuyType_D_H = 3602;
        public const int BuyType_F_D = 3603;
        public const int BuyType_F_H = 3604;
        public const int BuyType_C = 3605;

        public const int ID = 36;
        public const string sID = "36";
        public const string Name = "福建体彩36选7";
        public const string Code = "FJTC36X7";
        public const double MaxMoney = 155040;
        #endregion

        public FJTC36X7()
        {
            id = 36;
            buytype_c = 3605;
            name = "福建体彩36选7";
            code = "FJTC36X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 3601) && (buy_type <= 3605));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 36
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 36 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 16))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                // 幸运奖
                if (Lottery.Length > 1)
                {
                    int Right = 0;
                    string[] LotteryList = Lotterys[ii].Split(' ');

                    for (int i = 0; i < LotteryList.Length; i++)
                    {
                        if (WinNumber.IndexOf(LotteryList[i]) >= 0)
                            Right++;
                    }

                    if (Right == 8)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                    }
                }

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                    if ((RedRight == 4) || ((RedRight == 3) && BlueRight))
                    {
                        Description8++;
                        WinMoney += WinMoneyList[14];
                        WinMoneyNoWithTax += WinMoneyList[15];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "幸运奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "特等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,19}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 36) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 福建体彩22选5
    /// </summary>
    public partial class FJTC22X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 3701;
        public const int BuyType_D_H = 3702;
        public const int BuyType_F_D = 3703;
        public const int BuyType_F_H = 3704;
        public const int BuyType_C = 3705;

        public const int ID = 37;
        public const string sID = "37";
        public const string Name = "福建体彩22选5";
        public const string Code = "FJTC22X5";
        public const double MaxMoney = 4004;
        #endregion

        public FJTC22X5()
        {
            id = 37;
            buytype_c = 3705;
            name = "福建体彩22选5";
            code = "FJTC22X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 3701) && (buy_type <= 3705));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 37
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 22 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,13}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 22) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 辽宁风采35选7
    /// </summary>
    public partial class LNFC35X7 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 3801;
        public const int BuyType_D_H = 3802;
        public const int BuyType_F_D = 3803;
        public const int BuyType_F_H = 3804;
        public const int BuyType_C = 3805;

        public const int ID = 38;
        public const string sID = "38";
        public const string Name = "辽宁风采35选7";
        public const string Code = "LNFC35X7";
        public const double MaxMoney = 22880;
        #endregion

        public LNFC35X7()
        {
            id = 38;
            buytype_c = 3805;
            name = "辽宁风采35选7";
            code = "LNFC35X7";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 3801) && (buy_type <= 3805));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 38
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                int Ball;
                for (int j = 0; j < 7; j++)
                {
                    Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 35 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 7)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 6; i++)
                for (int j = i + 1; j < n - 5; j++)
                    for (int k = j + 1; k < n - 4; k++)
                        for (int x = k + 1; x < n - 3; x++)
                            for (int y = x + 1; y < n - 2; y++)
                                for (int z = y + 1; z < n - 1; z++)
                                    for (int a = z + 1; a < n; a++)
                                        al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y] + " " + strs[z] + " " + strs[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 25)	//25: "01 02 03 04 05 06 07 + 08"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 16))
                return -3;

            string Blue = WinNumber.Substring(23, 2);

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 20)	//20: "01 02 03 04 05 06 07"
                        continue;

                    string[] Red = new string[7];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)(?<R5>\d\d\s)(?<R6>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    bool BlueRight = false;
                    bool Full = true;
                    for (int j = 0; j < 7; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }

                        if (WinNumber.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;

                        if (Blue == Red[j])
                            BlueRight = true;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 7)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if ((RedRight == 6) && BlueRight)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 6)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                    if ((RedRight == 5) && BlueRight)
                    {
                        Description4++;
                        WinMoney += WinMoneyList[6];
                        WinMoneyNoWithTax += WinMoneyList[7];
                        continue;
                    }
                    if (RedRight == 5)
                    {
                        Description5++;
                        WinMoney += WinMoneyList[8];
                        WinMoneyNoWithTax += WinMoneyList[9];
                        continue;
                    }
                    if ((RedRight == 4) && BlueRight)
                    {
                        Description6++;
                        WinMoney += WinMoneyList[10];
                        WinMoneyNoWithTax += WinMoneyList[11];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description7++;
                        WinMoney += WinMoneyList[12];
                        WinMoneyNoWithTax += WinMoneyList[13];
                        continue;
                    }
                    if ((RedRight == 3) && BlueRight)
                    {
                        Description8++;
                        WinMoney += WinMoneyList[14];
                        WinMoneyNoWithTax += WinMoneyList[15];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "八等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){6}\d\d";
            else
                RegexString = @"(\d\d\s){6,34}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){7}[+]\s\d\d", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number.Substring(0, 20), ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 35) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 体彩超级大乐透
    /// </summary>
    public partial class TCCJDLT : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 3901;
        public const int BuyType_D_H = 3902;
        public const int BuyType_F_D = 3903;
        public const int BuyType_F_H = 3904;
        public const int BuyType_ZJ_D_D = 3905;
        public const int BuyType_ZJ_D_H = 3906;
        public const int BuyType_ZJ_F_D = 3907;
        public const int BuyType_ZJ_F_H = 3908;
        public const int BuyType_2_D_D = 3909;
        public const int BuyType_2_D_H = 3910;
        public const int BuyType_2_F_D = 3911;
        public const int BuyType_2_F_H = 3912;
        public const int BuyType_C = 3913;

        public const int ID = 39;
        public const string sID = "39";
        public const string Name = "体彩超级大乐透";
        public const string Code = "TCCJDLT";
        public const double MaxMoney = 30000;
        #endregion

        public TCCJDLT()
        {
            id = 39;
            buytype_c = 3913;
            name = "体彩超级大乐透";
            code = "TCCJDLT";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 3901) && (buy_type <= 3913));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[13];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_ZJ_D_D, "追加单式代购");
            Result[5] = new LotteryBuyType(BuyType_ZJ_D_H, "追加单式合买");
            Result[6] = new LotteryBuyType(BuyType_ZJ_F_D, "追加复式代购");
            Result[7] = new LotteryBuyType(BuyType_ZJ_F_H, "追加复式合买");
            Result[8] = new LotteryBuyType(BuyType_2_D_D, "12选2单式代购");
            Result[9] = new LotteryBuyType(BuyType_2_D_H, "12选2单式合买");
            Result[10] = new LotteryBuyType(BuyType_2_F_D, "12选2复式代购");
            Result[11] = new LotteryBuyType(BuyType_2_F_H, "12选2复式合买");
            Result[12] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Red, int Blue, int Num)	//id = 39
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al_r = new ArrayList();
            ArrayList al_b = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al_r.Clear();
                al_b.Clear();
                for (int j = 0; j < Red; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al_r, Ball))
                        Ball = rd.Next(1, 35 + 1);
                    al_r.Add(Ball.ToString().PadLeft(2, '0'));
                }

                for (int j = 0; j < Blue; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al_b, Ball))
                        Ball = rd.Next(1, 12 + 1);
                    al_b.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al_r.Sort(compare);
                al_b.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al_r.Count; j++)
                {
                    LotteryNumber += al_r[j].ToString() + " ";
                }

                if (LotteryNumber != "")
                {
                    LotteryNumber += "+ ";
                }

                for (int j = 0; j < al_b.Count; j++)
                {
                    LotteryNumber += al_b[j].ToString() + " ";
                }

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C) ||
                (BuyType == BuyType_ZJ_D_D) || (BuyType == BuyType_ZJ_D_H) || (BuyType == BuyType_ZJ_F_D) || (BuyType == BuyType_ZJ_F_H))
                return ToSingle_0(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_2_D_D) || (BuyType == BuyType_2_D_H) || (BuyType == BuyType_2_F_D) || (BuyType == BuyType_2_F_H))
                return ToSingle_12X2(Number, ref CanonicalNumber);
            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_0(string Number, ref string CanonicalNumber)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = Number.Split('+');
            CanonicalNumber = "";

            if (strs.Length != 2)
            {
                CanonicalNumber = "";
                return null;
            }

            string[] Red = FilterRepeated(strs[0].Trim().Split(' '), 35);
            string[] Blue = FilterRepeated(strs[1].Trim().Split(' '), 12);

            if ((Red.Length < 5) || (Blue.Length < 2))
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < Red.Length; i++)
                CanonicalNumber += (Red[i] + " ");
            CanonicalNumber += "+ ";
            for (int i = 0; i < Blue.Length; i++)
                CanonicalNumber += (Blue[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = Red.Length;
            int m = Blue.Length;

            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)

                                for (int z = 0; z < m - 1; z++)
                                    for (int a = z + 1; a < m; a++)
                                        al.Add(Red[i] + " " + Red[j] + " " + Red[k] + " " + Red[x] + " " + Red[y] + " + " + Blue[z] + " " + Blue[a]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_12X2(string Number, ref string CanonicalNumber)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '), 12);
            CanonicalNumber = "";

            if (strs.Length < 2)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 1; i++)
                for (int j = i + 1; j < n; j++)
                    al.Add(strs[i] + " " + strs[j]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 22))
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ComputeWin_0(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[4], WinMoneyList[5], WinMoneyList[8], WinMoneyList[9], WinMoneyList[12], WinMoneyList[13], WinMoneyList[14], WinMoneyList[15], WinMoneyList[16], WinMoneyList[17], WinMoneyList[18], WinMoneyList[19], WinMoneyList[20], WinMoneyList[21]);

            if ((BuyType == BuyType_ZJ_D_D) || (BuyType == BuyType_ZJ_D_H) || (BuyType == BuyType_ZJ_F_D) || (BuyType == BuyType_ZJ_F_H))
                return ComputeWin_ZJ(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[2], WinMoneyList[3], WinMoneyList[6], WinMoneyList[7], WinMoneyList[10], WinMoneyList[11], WinMoneyList[12], WinMoneyList[13], WinMoneyList[14], WinMoneyList[15], WinMoneyList[16], WinMoneyList[17], WinMoneyList[18], WinMoneyList[19], WinMoneyList[20], WinMoneyList[21]);

            if ((BuyType == BuyType_2_D_D) || (BuyType == BuyType_2_D_H) || (BuyType == BuyType_2_F_D) || (BuyType == BuyType_2_F_H))
                return ComputeWin_12X2(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[22], WinMoneyList[23]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_0(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3, double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6, double WinMoney7, double WinMoneyNoWithTax7, double WinMoney8, double WinMoneyNoWithTax8)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 + 01 02" 
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string WinNumber_Red = WinNumber.Substring(0, 15);
            string WinNumber_Blue = WinNumber.Substring(17, 5).Trim();

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_0(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 22)
                        continue;

                    string[] Red = new string[5];
                    string[] Blue = new string[2];

                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)[+]\s(?<B0>\d\d\s)(?<B1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    int BlueRight = 0;
                    bool Full = true;

                    for (int j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber_Red.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                    }

                    for (int k = 0; k < 2; k++)
                    {
                        Blue[k] = m.Groups["B" + k.ToString()].ToString().Trim();
                        if (Blue[k] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber_Blue.IndexOf(Blue[k]) >= 0)
                            BlueRight++;
                    }

                    if (!Full)
                        continue;

                    if ((RedRight == 5) && (BlueRight == 2))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                    if ((RedRight == 5) && (BlueRight == 1))
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        continue;
                    }
                    if ((RedRight == 5))
                    {
                        Description3++;
                        WinMoney += WinMoney3;
                        WinMoneyNoWithTax += WinMoneyNoWithTax3;
                        continue;
                    }
                    if ((RedRight == 4) && (BlueRight == 2))
                    {
                        Description4++;
                        WinMoney += WinMoney4;
                        WinMoneyNoWithTax += WinMoneyNoWithTax4;
                        continue;
                    }
                    if ((RedRight == 4) && (BlueRight == 1))
                    {
                        Description5++;
                        WinMoney += WinMoney5;
                        WinMoneyNoWithTax += WinMoneyNoWithTax5;
                        continue;
                    }
                    if ((RedRight == 4) || ((RedRight == 3) && (BlueRight == 2)))
                    {
                        Description6++;
                        WinMoney += WinMoney6;
                        WinMoneyNoWithTax += WinMoneyNoWithTax6;
                        continue;
                    }
                    if (((RedRight == 3) && (BlueRight == 1)) || ((RedRight == 2) && (BlueRight == 2)))
                    {
                        Description7++;
                        WinMoney += WinMoney7;
                        WinMoneyNoWithTax += WinMoneyNoWithTax7;
                        continue;
                    }
                    if ((RedRight == 3) || ((RedRight == 2) && (BlueRight == 1)) || ((RedRight == 1) && (BlueRight == 2)) || (BlueRight == 2))
                    {
                        Description8++;
                        WinMoney += WinMoney8;
                        WinMoneyNoWithTax += WinMoneyNoWithTax8;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "八等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_ZJ(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2, double WinMoney3, double WinMoneyNoWithTax3, double WinMoney4, double WinMoneyNoWithTax4, double WinMoney5, double WinMoneyNoWithTax5, double WinMoney6, double WinMoneyNoWithTax6, double WinMoney7, double WinMoneyNoWithTax7, double WinMoney8, double WinMoneyNoWithTax8)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 + 01 02" 
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string WinNumber_Red = WinNumber.Substring(0, 15);
            string WinNumber_Blue = WinNumber.Substring(17, 5).Trim();

            int Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0, Description6 = 0, Description7 = 0, Description8 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_0(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 22)
                        continue;

                    string[] Red = new string[5];
                    string[] Blue = new string[2];

                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d\s)[+]\s(?<B0>\d\d\s)(?<B1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int RedRight = 0;
                    int BlueRight = 0;
                    bool Full = true;

                    for (int j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber_Red.IndexOf(Red[j] + " ") >= 0)
                            RedRight++;
                    }

                    for (int k = 0; k < 2; k++)
                    {
                        Blue[k] = m.Groups["B" + k.ToString()].ToString().Trim();
                        if (Blue[k] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber_Blue.IndexOf(Blue[k]) >= 0)
                            BlueRight++;
                    }

                    if (!Full)
                        continue;

                    if ((RedRight == 5) && (BlueRight == 2))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                    if ((RedRight == 5) && (BlueRight == 1))
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        continue;
                    }
                    if ((RedRight == 5))
                    {
                        Description3++;
                        WinMoney += WinMoney3;
                        WinMoneyNoWithTax += WinMoneyNoWithTax3;
                        continue;
                    }
                    if ((RedRight == 4) && (BlueRight == 2))
                    {
                        Description4++;
                        WinMoney += WinMoney4;
                        WinMoneyNoWithTax += WinMoneyNoWithTax4;
                        continue;
                    }
                    if ((RedRight == 4) && (BlueRight == 1))
                    {
                        Description5++;
                        WinMoney += WinMoney5;
                        WinMoneyNoWithTax += WinMoneyNoWithTax5;
                        continue;
                    }
                    if ((RedRight == 4) || ((RedRight == 3) && (BlueRight == 2)))
                    {
                        Description6++;
                        WinMoney += WinMoney6;
                        WinMoneyNoWithTax += WinMoneyNoWithTax6;
                        continue;
                    }
                    if (((RedRight == 3) && (BlueRight == 1)) || ((RedRight == 2) && (BlueRight == 2)))
                    {
                        Description7++;
                        WinMoney += WinMoney7;
                        WinMoneyNoWithTax += WinMoneyNoWithTax7;
                        continue;
                    }
                    if ((RedRight == 3) || ((RedRight == 2) && (BlueRight == 1)) || ((RedRight == 1) && (BlueRight == 2)) || (BlueRight == 2))
                    {
                        Description8++;
                        WinMoney += WinMoney8;
                        WinMoneyNoWithTax += WinMoneyNoWithTax8;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "追加一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "追加二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "追加三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description6 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "六等奖" + Description6.ToString() + "注";
            }
            if (Description7 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "七等奖" + Description7.ToString() + "注";
            }
            if (Description8 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "八等奖" + Description8.ToString() + "注";
            }

            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_12X2(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 22)	//22: "01 02 03 04 05 + 01 02" 
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            string WinNumber_Blue = WinNumber.Substring(17, 5).Trim();

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_12X2(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 2)
                        continue;

                    string[] Blue = new string[2];
                    Regex regex = new Regex(@"(?<B0>\d\d\s)(?<B1>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);

                    int BlueRight = 0;
                    bool Full = true;

                    for (int k = 0; k < 2; k++)
                    {
                        Blue[k] = m.Groups["B" + k.ToString()].ToString().Trim();
                        if (Blue[k] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber_Blue.IndexOf(Blue[k]) >= 0)
                            BlueRight++;
                    }

                    if (!Full)
                        continue;

                    if ((BlueRight == 2))
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "12选2" + Description1.ToString() + "注";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return AnalyseScheme_0(Content, BuyType);

            if ((BuyType == BuyType_ZJ_D_D) || (BuyType == BuyType_ZJ_D_H) || (BuyType == BuyType_ZJ_F_D) || (BuyType == BuyType_ZJ_F_H))
                return AnalyseScheme_ZJ(Content, BuyType);

            if ((BuyType == BuyType_2_D_D) || (BuyType == BuyType_2_D_H) || (BuyType == BuyType_2_F_D) || (BuyType == BuyType_2_F_H))
                return AnalyseScheme_12X2(Content, BuyType);
            return null;
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_0(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){5}[+](\s\d\d){2}";
            else
                RegexString = @"(\d\d\s){5,35}[+](\s\d\d){2,12}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_0(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 3)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_ZJ(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_ZJ_D_D) || (BuyType == BuyType_ZJ_D_H))
                RegexString = @"(\d\d\s){5}[+](\s\d\d){2}";
            else
                RegexString = @"(\d\d\s){5,35}[+](\s\d\d){2,12}";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_0(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_ZJ_D_D) || (BuyType == BuyType_ZJ_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_12X2(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_2_D_D) || (BuyType == BuyType_2_D_H))
                RegexString = @"\d\d\s\d\d";
            else
                RegexString = @"(\d\d\s){2,11}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_12X2(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_2_D_D) || (BuyType == BuyType_2_D_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 3)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"(\d\d\s){5}[+](\s\d\d){2}", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart, int MaxBall)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= MaxBall) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 浙江体彩20选5
    /// </summary>
    public partial class ZJTC20X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 4001;
        public const int BuyType_D_H = 4002;
        public const int BuyType_F_D = 4003;
        public const int BuyType_F_H = 4004;
        public const int BuyType_C = 4005;

        public const int ID = 40;
        public const string sID = "40";
        public const string Name = "浙江体彩20选5";
        public const string Code = "ZJTC20X5";
        public const double MaxMoney = 20000;
        #endregion

        public ZJTC20X5()
        {
            id = 40;
            buytype_c = 4005;
            name = "浙江体彩20选5";
            code = "ZJTC20X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 4001) && (buy_type <= 4005));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num) //id = 40
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 20 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))   //奖金顺序 1-3等奖
                return -3;

            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,19}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 20) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 浙江体彩6+1
    /// </summary>
    public partial class ZJTC6J1 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 4101;
        public const int BuyType_D_H = 4102;
        public const int BuyType_F_D = 4103;
        public const int BuyType_F_H = 4104;
        public const int BuyType_C = 4105;

        public const int ID = 41;
        public const string sID = "41";
        public const string Name = "浙江体彩6+1";
        public const string Code = "ZJTC6J1";
        public const double MaxMoney = 20000;
        #endregion

        public ZJTC6J1()
        {
            id = 41;
            buytype_c = 4105;
            name = "浙江体彩6+1";
            code = "ZJTC6J1";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 4101) && (buy_type <= 4105));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 41
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 6; j++)
                {
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();
                }

                LotteryNumber += "-" + rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            string[] Locate = new string[7];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))(?<L5>(\d)|([(][\d]+?[)]))[-](?<L6>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 7; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }

                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }

                if (i == 6)
                {
                    CanonicalNumber += "-";
                }

                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Locate[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Locate[5][i_5].ToString();
                                    for (int i_6 = 0; i_6 < Locate[6].Length; i_6++)
                                    {
                                        string str_6 = str_5 + "-" + Locate[6][i_6].ToString();
                                        al.Add(str_6);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 8)	//8: 123456-7
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 12))
                return -3;

            int Description0 = 0, Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 8)
                        continue;
                    if (Lottery[i] == WinNumber)
                    {
                        Description0++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }

                    if (Lottery[i].Substring(0, 6) == WinNumber.Substring(0, 6))
                    {
                        Description1++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }

                    int j;
                    bool End = false;

                    for (j = 0; j <= 1; j++)
                    {
                        if (Lottery[i].Substring(j, 5) == WinNumber.Substring(j, 5))
                        {
                            Description2++;
                            WinMoney += WinMoneyList[4];
                            WinMoneyNoWithTax += WinMoneyList[5];
                            End = true;
                            break;
                        }
                    }

                    if (End)
                    {
                        continue;
                    }

                    for (j = 0; j <= 2; j++)
                    {
                        if (Lottery[i].Substring(j, 4) == WinNumber.Substring(j, 4))
                        {

                            Description3++;
                            WinMoney += WinMoneyList[6];
                            WinMoneyNoWithTax += WinMoneyList[7];
                            End = true;
                            break;
                        }
                    }

                    if (End)
                    {
                        continue;
                    }

                    for (j = 0; j <= 3; j++)
                    {
                        if (Lottery[i].Substring(j, 3) == WinNumber.Substring(j, 3))
                        {
                            Description4++;
                            WinMoney += WinMoneyList[8];
                            WinMoneyNoWithTax += WinMoneyList[9];
                            End = true;
                            break;
                        }
                    }

                    if (End)
                    {
                        continue;
                    }

                    for (j = 0; j <= 4; j++)
                    {
                        if (Lottery[i].Substring(j, 2) == WinNumber.Substring(j, 2))
                        {
                            Description5++;
                            WinMoney += WinMoneyList[10];
                            WinMoneyNoWithTax += WinMoneyList[11];
                            End = true;
                            break;
                        }
                    }
                }
            }

            if (Description0 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "特等奖" + Description0.ToString() + "注";
            }
            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d){6}[-][\d]";
            else
                RegexString = @"((\d)|([(]\d{1,10}[)])){6}[-]((\d)|([(]\d{1,10}[)]))";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"([\d]){6}[-][\d]", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 龙江风彩22选5
    /// </summary>
    public partial class LJFC22X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 4201;
        public const int BuyType_D_H = 4202;
        public const int BuyType_F_D = 4203;
        public const int BuyType_F_H = 4204;
        public const int BuyType_C = 4205;

        public const int ID = 42;
        public const string sID = "42";
        public const string Name = "龙江风彩22选5";
        public const string Code = "LJFC22X5";
        public const double MaxMoney = 20000;
        #endregion

        public LJFC22X5()
        {
            id = 42;
            buytype_c = 4205;
            name = "龙江风彩22选5";
            code = "LJFC22X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 4201) && (buy_type <= 4205));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 42
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 22 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,21}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 22) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 龙江体彩6+1
    /// </summary>
    public partial class LJTC6J1 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 4301;
        public const int BuyType_D_H = 4302;
        public const int BuyType_F_D = 4303;
        public const int BuyType_F_H = 4304;
        public const int BuyType_C = 4305;

        public const int ID = 43;
        public const string sID = "43";
        public const string Name = "龙江体彩6+1";
        public const string Code = "LJTC6J1";
        public const double MaxMoney = 20000;
        #endregion

        public LJTC6J1()
        {
            id = 43;
            buytype_c = 4305;
            name = "龙江体彩6加1";
            code = "LJTC6J1";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 4301) && (buy_type <= 4305));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 41
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < Num; i++)
            {
                string LotteryNumber = "";
                for (int j = 0; j < 6; j++)
                {
                    LotteryNumber += rd.Next(0, 9 + 1).ToString();
                }

                LotteryNumber += "-" + rd.Next(0, 9 + 1).ToString();

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：103(00)... 变成1030...
        {
            string[] Locate = new string[7];
            CanonicalNumber = "";

            Regex regex = new Regex(@"(?<L0>(\d)|([(][\d]+?[)]))(?<L1>(\d)|([(][\d]+?[)]))(?<L2>(\d)|([(][\d]+?[)]))(?<L3>(\d)|([(][\d]+?[)]))(?<L4>(\d)|([(][\d]+?[)]))(?<L5>(\d)|([(][\d]+?[)]))[+](?<L6>(\d)|([(][\d]+?[)]))", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Number);
            for (int i = 0; i < 7; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }

                if (Locate[i].Length > 1)
                {
                    Locate[i] = Locate[i].Substring(1, Locate[i].Length - 2);
                    if (Locate[i].Length > 1)
                        Locate[i] = FilterRepeated(Locate[i]);
                    if (Locate[i] == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }

                if (i == 6)
                {
                    CanonicalNumber += "+";
                }

                if (Locate[i].Length > 1)
                    CanonicalNumber += "(" + Locate[i] + ")";
                else
                    CanonicalNumber += Locate[i];
            }

            ArrayList al = new ArrayList();

            #region 循环取单式
            for (int i_0 = 0; i_0 < Locate[0].Length; i_0++)
            {
                string str_0 = Locate[0][i_0].ToString();
                for (int i_1 = 0; i_1 < Locate[1].Length; i_1++)
                {
                    string str_1 = str_0 + Locate[1][i_1].ToString();
                    for (int i_2 = 0; i_2 < Locate[2].Length; i_2++)
                    {
                        string str_2 = str_1 + Locate[2][i_2].ToString();
                        for (int i_3 = 0; i_3 < Locate[3].Length; i_3++)
                        {
                            string str_3 = str_2 + Locate[3][i_3].ToString();
                            for (int i_4 = 0; i_4 < Locate[4].Length; i_4++)
                            {
                                string str_4 = str_3 + Locate[4][i_4].ToString();
                                for (int i_5 = 0; i_5 < Locate[5].Length; i_5++)
                                {
                                    string str_5 = str_4 + Locate[5][i_5].ToString();
                                    for (int i_6 = 0; i_6 < Locate[6].Length; i_6++)
                                    {
                                        string str_6 = str_5 + "+" + Locate[6][i_6].ToString();
                                        al.Add(str_6);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 8)	//8: 123456+7
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 12))
                return -3;

            int Description0 = 0, Description1 = 0, Description2 = 0, Description3 = 0, Description4 = 0, Description5 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 8)
                        continue;
                    if (Lottery[i] == WinNumber)
                    {
                        Description0++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }

                    if (Lottery[i].Substring(0, 6) == WinNumber.Substring(0, 6))
                    {
                        Description1++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }

                    int j;
                    bool End = false;

                    for (j = 0; j <= 1; j++)
                    {
                        if (Lottery[i].Substring(j, 5) == WinNumber.Substring(j, 5))
                        {
                            Description2++;
                            WinMoney += WinMoneyList[4];
                            WinMoneyNoWithTax += WinMoneyList[5];
                            End = true;
                            break;
                        }
                    }

                    if (End)
                    {
                        continue;
                    }

                    for (j = 0; j <= 2; j++)
                    {
                        if (Lottery[i].Substring(j, 4) == WinNumber.Substring(j, 4))
                        {

                            Description3++;
                            WinMoney += WinMoneyList[6];
                            WinMoneyNoWithTax += WinMoneyList[7];
                            End = true;
                            break;
                        }
                    }

                    if (End)
                    {
                        continue;
                    }

                    for (j = 0; j <= 3; j++)
                    {
                        if (Lottery[i].Substring(j, 3) == WinNumber.Substring(j, 3))
                        {
                            Description4++;
                            WinMoney += WinMoneyList[8];
                            WinMoneyNoWithTax += WinMoneyList[9];
                            End = true;
                            break;
                        }
                    }

                    if (End)
                    {
                        continue;
                    }

                    for (j = 0; j <= 4; j++)
                    {
                        if (Lottery[i].Substring(j, 2) == WinNumber.Substring(j, 2))
                        {
                            Description5++;
                            WinMoney += WinMoneyList[10];
                            WinMoneyNoWithTax += WinMoneyList[11];
                            End = true;
                            break;
                        }
                    }
                }
            }

            if (Description0 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "特等奖" + Description0.ToString() + "注";
            }
            if (Description1 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description = "一等奖" + Description1.ToString() + "注";
            }
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description4 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "四等奖" + Description4.ToString() + "注";
            }
            if (Description5 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "五等奖" + Description5.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d){6}[+][\d]";
            else
                RegexString = @"((\d)|([(]\d{1,10}[)])){6}[+]((\d)|([(]\d{1,10}[)]))";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            Regex regex = new Regex(@"([\d]){6}[+][\d]", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
                return false;

            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string FilterRepeated(string NumberPart)
        {
            string Result = "";
            for (int i = 0; i < NumberPart.Length; i++)
            {
                if ((Result.IndexOf(NumberPart.Substring(i, 1)) == -1) && ("0123456789".IndexOf(NumberPart.Substring(i, 1)) >= 0))
                    Result += NumberPart.Substring(i, 1);
            }
            return Sort(Result);
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, " ");
        }
    }

    /// <summary>
    /// 天天乐22选5
    /// </summary>
    public partial class TTL22X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 4401;
        public const int BuyType_D_H = 4402;
        public const int BuyType_F_D = 4403;
        public const int BuyType_F_H = 4404;
        public const int BuyType_C = 4405;

        public const int ID = 44;
        public const string sID = "44";
        public const string Name = "天天乐22选5";
        public const string Code = "TTL22X5";
        public const double MaxMoney = 200000;
        #endregion

        public TTL22X5()
        {
            id = 44;
            name = "天天乐22选5";
            code = "TTL22X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 4401) && (buy_type <= 4405));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 44
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 22 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))
                return -3;

            int Description1 = 0, Description2 = 0, Description3 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle(Lotterys[ii], ref t_str, BuyType);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoneyList[0];
                        WinMoneyNoWithTax += WinMoneyList[1];
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoneyList[2];
                        WinMoneyNoWithTax += WinMoneyList[3];
                        continue;
                    }
                    if (RedRight == 3)
                    {
                        Description3++;
                        WinMoney += WinMoneyList[4];
                        WinMoneyNoWithTax += WinMoneyList[5];
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description3 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "三等奖" + Description3.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }

        public override string AnalyseScheme(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,21}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle(m.Value, ref CanonicalNumber, BuyType);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle(Number, ref t_str, BuyType_D_D);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 22) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 足彩单场
    /// </summary>
    public partial class ZCDC : LotteryBase
    {
        #region 静态变量
        public const int BuyType_SPF = 4501;
        public const int BuyType_ZJQ = 4502;
        public const int BuyType_SXDS = 4503;
        public const int BuyType_ZQBF = 4504;
        public const int BuyType_BQCSPF = 4505;
        public const int ID = 45;
        public const string sID = "45";
        public const string Name = "足彩单场";
        public const string Code = "ZCDC";
        public const double MaxMoney = 20000;
        #endregion

        public ZCDC()
        {
            id = 45;
            buytype_c = -1;
            name = "足彩单场";
            code = "ZCDC";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 4501) && (buy_type <= 4505));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[5];

            Result[0] = new LotteryBuyType(BuyType_SPF, "胜平负");
            Result[1] = new LotteryBuyType(BuyType_ZJQ, "总进球");
            Result[2] = new LotteryBuyType(BuyType_SXDS, "上下单双");
            Result[3] = new LotteryBuyType(BuyType_ZQBF, "正确比分");
            Result[4] = new LotteryBuyType(BuyType_BQCSPF, "半全场胜平负");

            return Result;
        }

        // 复式取单式, 后面 ref 参数是将方案规范化 例如："4501;[5(3)|15(3)|17(0)|19(0)|21(0)];[N2]";
        /*
        * //(Number表示传入的方案，CanonicalNumber表示整理后的方案，BuyType购买类型)复式取单式, 后面 ref 参数是将方案规范化
        * 例如："4501;[5(3)|15(3)|17(0)|19(0)|21(0)];[N2]"(购买方法;[场次1(结果1,结果2)|场次2(结果1)];[购买方式1及其购买倍数1,购买方式2及其购买倍数2])
        * 购买方式中1表示单关，2表示双关，3表示三关，4-9、A-W表示串，购买方式只有一个字符，后面的字符表示倍数
        * 例如：11表示单关的1倍
        */
        public override string[] ToSingle(string Scheme, ref string CanonicalNumber, int CompetitionCount)
        {
            //此方法的CompetitionCount表示本期的比赛的总场数

            //Scheme = "4501;[5(3)|15(3)|17(0)|19(0)|21(0)|22(0)];[11,21,32]"; //"4501;[5(3)|6(3)|7(0)|8(0)|9(0)|10(0)|11(3)|12(3)|13(0)|14(0)|15(0)|16(0)|17(0)|21(0)|22(0)];[11,21,32]";
            //Scheme = "4501;[5(3)|6(3)|7(0)|8(0)|9(0)|10(0)|11(3)|12(3)|13(0)|14(0)|15(0)|16(0)|17(0)|21(0)|22(0)];[11,21,32]";
            //Scheme = "4501;[5(3)|15(3)|17(0)|19(0)|21(0)];[N2]";
            //Scheme = "4501;[1(3,0)];[A2,B1]";
            //string Scheme = Number;  //方案字符串
            CanonicalNumber = "";
            int SchemeLength = Scheme.Split(';').Length;
            if (SchemeLength != 3)
            {
                CanonicalNumber = "";
                return null;
            }

            string strBuyType = Scheme.Trim().Split(';')[0].ToString();
            string BuyNumber = Scheme.Trim().Split(';')[1].ToString();
            string Numbers = BuyNumber.Substring(1, BuyNumber.Length - 1).Substring(0, BuyNumber.Length - 2).ToString().Trim();
            if (Numbers == "")
            {
                CanonicalNumber = "";
                return null;
            }

            string BuyWays = Scheme.Trim().Split(';')[2].ToString().Substring(1, Scheme.Trim().Split(';')[2].ToString().Length - 1).Substring(0, Scheme.Trim().Split(';')[2].ToString().Length - 2).ToString().Trim();
            if (BuyWays == "")
            {
                CanonicalNumber = "";
                return null;
            }

            int GamesNumber = Numbers.Split('|').Length;
            int WaysNumber = BuyWays.Split(',').Length;
            string[] Locate = new string[GamesNumber];
            string[] LocateWays = new string[WaysNumber];

            string ConfirmationString = "";
            string BuyResult = "";

            string WaysResult = "";
            string BuyWaysResult = "";
            int TempWaysMultiples = 0;

            if (strBuyType == "4501")    //胜平负
            {
                for (int i = 0; i < GamesNumber; i++)
                {
                    ConfirmationString += @"(?<L" + i.ToString() + @">[\d]{1,2}[(][310]([,][310]){0,2}[)])[|]"; //方案格式：4501;[1(3)|5(3,1)|7(0)];[A2,B1]
                }
                ConfirmationString = ConfirmationString.Substring(0, ConfirmationString.Length - 3);
            }
            else if (strBuyType == "4502")   //总进球
            {
                for (int i = 0; i < GamesNumber; i++)
                {
                    ConfirmationString += @"(?<L" + i.ToString() + @">[\d]{1,2}[(][01234567]([,][01234567]){0,7}[)])[|]";
                }
                ConfirmationString = ConfirmationString.Substring(0, ConfirmationString.Length - 3);
            }
            else if (strBuyType == "4503")   //上下单双
            {
                for (int i = 0; i < GamesNumber; i++)
                {
                    ConfirmationString += @"(?<L" + i.ToString() + @">[\d]{1,2}[(][1234]([,][1234]){0,3}[)])[|]";
                }
                ConfirmationString = ConfirmationString.Substring(0, ConfirmationString.Length - 3);
            }
            else if (strBuyType == "4504")   //正确比分
            {
                for (int i = 0; i < GamesNumber; i++)
                {
                    ConfirmationString += @"(?<L" + i.ToString() + @">[\d]{1,2}[(][\d]{1,2}([,][\d]{1,2}){0,24}[)])[|]";
                }
                ConfirmationString = ConfirmationString.Substring(0, ConfirmationString.Length - 3);
            }
            else if (strBuyType == "4505")   //半全场胜平负
            {
                for (int i = 0; i < GamesNumber; i++)
                {
                    ConfirmationString += @"(?<L" + i.ToString() + @">[\d]{1,2}[(][\d]([,][\d]){0,8}[)])[|]";
                }
                ConfirmationString = ConfirmationString.Substring(0, ConfirmationString.Length - 3);
            }

            Regex regex = new Regex(ConfirmationString, RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match m = regex.Match(Numbers);
            for (int i = 0; i < GamesNumber; i++)
            {
                Locate[i] = m.Groups["L" + i.ToString()].ToString().Trim();
                if (Locate[i] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }

                //判断购买的场次大于当期的总场数
                if ((CompetitionCount) < int.Parse(Locate[i].Substring(0, (Locate[i].IndexOf('('))).ToString()))
                {
                    CanonicalNumber = "";
                    return null;
                }

                BuyResult = Locate[i].Substring(Locate[i].IndexOf('(') + 1, (Locate[i].IndexOf(')') - Locate[i].IndexOf('(') - 1));

                if (BuyResult.Length > 0)
                {
                    BuyResult = FilterRepeated(BuyResult, strBuyType);

                    if (BuyResult == "")
                    {
                        CanonicalNumber = "";
                        return null;
                    }
                }

                if (BuyResult.Length > 0)
                {
                    CanonicalNumber += Locate[i].Substring(0, (Locate[i].IndexOf('('))) + "(" + BuyResult + ")|";
                }
            }

            if (CanonicalNumber.Length < 4)  //方案中至少买有一场比赛 例如：1(3)
            {
                CanonicalNumber = "";
                return null;
            }

            CanonicalNumber = FilterRepeatedScheme(CanonicalNumber.Substring(0, CanonicalNumber.Length - 1));
            GamesNumber = 0;    //将原来的场数清0

            BuyResult = "";
            ConfirmationString = "";
            for (int j = 0; j < WaysNumber; j++)
            {
                ConfirmationString += @"(?<L" + j.ToString() + @">[123456789ABCDEFGHIJKLMNOPQRSTUVW]{1}[\d]{1,2})[,]"; //方案格式：4501;[1(3)|5(3,1)|7(0)];[A2,B1]
            }
            ConfirmationString = ConfirmationString.Substring(0, ConfirmationString.Length - 3);

            Regex regexWays = new Regex(ConfirmationString, RegexOptions.IgnoreCase | RegexOptions.Compiled);
            Match mWays = regexWays.Match(BuyWays);
            for (int k = 0; k < WaysNumber; k++)
            {
                LocateWays[k] = mWays.Groups["L" + k.ToString()].ToString().Trim();
                if (LocateWays[k] == "")
                {
                    CanonicalNumber = "";
                    return null;
                }

                BuyResult = LocateWays[k].Substring(1, (LocateWays[k].Length - 1));

                if (BuyResult.Length > 0)
                {
                    try
                    {
                        TempWaysMultiples = Convert.ToInt32(BuyResult);
                    }
                    catch
                    {
                        TempWaysMultiples = 0;
                    }

                    if (TempWaysMultiples > 0)
                    {
                        BuyWaysResult = BuyResult;
                    }
                    else
                    {
                        BuyWaysResult = "";
                    }
                }
                if (BuyWaysResult.Length > 0)
                {
                    WaysResult += LocateWays[k].Substring(0, 1).ToUpper() + BuyWaysResult.ToString() + ",";
                }
            }

            if (WaysResult.Length < 2)   //至少有一种过关方式 例如：11：表示单关，1倍
            {
                CanonicalNumber = "";
                return null;
            }

            WaysResult = FilterRepeatedWaysResult(WaysResult.Substring(0, WaysResult.Length - 1));
            WaysNumber = 0; //将原来的购买方式倍数清0

            //复式变单式，并取得购买注数和相应的倍数
            ArrayList all = new ArrayList();
            GamesNumber = CanonicalNumber.Split('|').Length;    //重新获取分析过后的比赛场次
            WaysNumber = WaysResult.Split(',').Length;  //重新获取分析过后的购买方式及倍数
            if (GamesNumber == 1)
            {
                string[] LocateBuyResult = new string[GamesNumber];
                string[] Screenings = new string[GamesNumber];

                for (int i = 0; i < GamesNumber; i++)
                {
                    Locate[i] = CanonicalNumber.Split('|')[i].ToString();

                    LocateBuyResult[i] = Locate[i].Substring(Locate[i].IndexOf('(') + 1, (Locate[i].IndexOf(')') - Locate[i].IndexOf('(') - 1));

                    Screenings[i] = Locate[i].Substring(0, Locate[i].IndexOf('('));
                }

                #region 获取买法倍数
                string strWays = WaysResult.Substring(0, 1);
                if (WaysNumber > 1)
                {
                    CanonicalNumber = "";
                    return null;
                }
                else if (strWays != "1")
                {
                    CanonicalNumber = "";
                    return null;
                }

                TempWaysMultiples = 0;
                try
                {
                    TempWaysMultiples = Convert.ToInt32(WaysResult.Substring(1, (WaysResult.Length - 1)));
                }
                catch
                {
                    TempWaysMultiples = 0;
                }

                if (TempWaysMultiples <= 0)
                {
                    CanonicalNumber = "";
                    return null;
                }
                #endregion

                //取1关，并返回购买注数和购买倍数
                string[] sg1 = getAll1G(GamesNumber, Locate, LocateBuyResult, Screenings, TempWaysMultiples);
                for (int i = 0; i < sg1.Length; i++)
                {
                    all.Add(sg1[i].ToString());
                }
            }
            else if (GamesNumber > 1)
            {
                string[] LocateBuyResult = new string[GamesNumber];
                string[] Screenings = new string[GamesNumber];

                for (int i = 0; i < GamesNumber; i++)
                {
                    Locate[i] = CanonicalNumber.Split('|')[i].ToString();

                    LocateBuyResult[i] = Locate[i].Substring(Locate[i].IndexOf('(') + 1, (Locate[i].IndexOf(')') - Locate[i].IndexOf('(') - 1));

                    Screenings[i] = Locate[i].Substring(0, Locate[i].IndexOf('('));
                }

                if ((strBuyType == "4502" || strBuyType == "4503" || strBuyType == "4505") && (GamesNumber > 6))
                {
                    CanonicalNumber = "";
                    return null;
                }

                if ((strBuyType == "4504") && (GamesNumber > 3))
                {
                    CanonicalNumber = "";
                    return null;
                }

                string[] LocateWaysAndMultiples = new string[WaysNumber];   //购买方式及倍数
                string[] LocateWaysType = new string[WaysNumber];   //购买方式
                string[] WaysMultiples = new string[WaysNumber];    //购买倍数

                for (int i = 0; i < WaysNumber; i++)
                {
                    LocateWaysAndMultiples[i] = WaysResult.Split(',')[i].ToString();
                    LocateWaysType[i] = LocateWaysAndMultiples[i].Substring(0, 1);
                    WaysMultiples[i] = LocateWaysAndMultiples[i].Substring(1, (LocateWaysAndMultiples[i].Length - 1));

                    #region     获取方案某一个购买方式的购买注数和倍数
                    switch (LocateWaysType[i])
                    {
                        case "1":   //单关购买注数和对应倍数
                            string[] sg1 = getAll1G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg1.Length; j++)
                            {
                                all.Add(sg1[j].ToString());
                            }
                            break;
                        case "2":   //双关购买注数和对应倍数
                            string[] sg2 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2.Length; j++)
                            {
                                all.Add(sg2[j].ToString());
                            }
                            break;
                        case "3":   //三关购买注数和对应倍数
                            string[] sg3 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3.Length; j++)
                            {
                                all.Add(sg3[j].ToString());
                            }
                            break;
                        case "4":   //2串1购买注数和对应倍数
                            string[] sg2c1 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2c1.Length; j++)
                            {
                                all.Add(sg2c1[j].ToString());
                            }
                            break;
                        case "5":   //2串3购买注数和对应倍数
                            string[] sg1_2c3 = getAll1G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg1_2c3.Length; j++)
                            {
                                all.Add(sg1_2c3[j].ToString());
                            }

                            string[] sg2_2c3 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_2c3.Length; j++)
                            {
                                all.Add(sg2_2c3[j].ToString());
                            }
                            break;
                        case "6":   //3串1购买注数和对应倍数
                            string[] sg3_3c1 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_3c1.Length; j++)
                            {
                                all.Add(sg3_3c1[i].ToString());
                            }
                            break;
                        case "7":   //3串4购买注数和对应倍数
                            string[] sg2_3c4 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_3c4.Length; j++)
                            {
                                all.Add(sg2_3c4[j].ToString());
                            }

                            string[] sg3_3c4 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_3c4.Length; j++)
                            {
                                all.Add(sg3_3c4[j].ToString());
                            }
                            break;
                        case "8":    //3串7购买注数和对应倍数
                            string[] sg1_3c7 = getAll1G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg1_3c7.Length; j++)
                            {
                                all.Add(sg1_3c7[j].ToString());
                            }

                            string[] sg2_3c7 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_3c7.Length; j++)
                            {
                                all.Add(sg2_3c7[j].ToString());
                            }

                            string[] sg3_3c7 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_3c7.Length; j++)
                            {
                                all.Add(sg3_3c7[j].ToString());
                            }
                            break;
                        case "9":    //4串1购买注数和对应倍数
                            string[] sg4_4c1 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_4c1.Length; j++)
                            {
                                all.Add(sg4_4c1[j].ToString());
                            }
                            break;
                        case "A":   //4串5购买注数和对应倍数
                            string[] sg3_4c5 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_4c5.Length; j++)
                            {
                                all.Add(sg3_4c5[j].ToString());
                            }

                            string[] sg4_4c5 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_4c5.Length; j++)
                            {
                                all.Add(sg4_4c5[j].ToString());
                            }
                            break;
                        case "B":   //4串11购买注数和对应倍数
                            string[] sg2_4c11 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_4c11.Length; j++)
                            {
                                all.Add(sg2_4c11[j].ToString());
                            }
                            string[] sg3_4c11 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_4c11.Length; j++)
                            {
                                all.Add(sg3_4c11[j].ToString());
                            }

                            string[] sg4_4c11 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_4c11.Length; j++)
                            {
                                all.Add(sg4_4c11[j].ToString());
                            }
                            break;
                        case "C":   //4串15购买注数和对应倍数
                            string[] sg1_4c15 = getAll1G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg1_4c15.Length; j++)
                            {
                                all.Add(sg1_4c15[j].ToString());
                            }

                            string[] sg2_4c15 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_4c15.Length; j++)
                            {
                                all.Add(sg2_4c15[j].ToString());
                            }

                            string[] sg3_4c15 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_4c15.Length; j++)
                            {
                                all.Add(sg3_4c15[j].ToString());
                            }

                            string[] sg4_4c15 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_4c15.Length; j++)
                            {
                                all.Add(sg4_4c15[j].ToString());
                            }
                            break;
                        case "D":   //5串1购买注数和对应倍数
                            string[] sg5_5c1 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_5c1.Length; j++)
                            {
                                all.Add(sg5_5c1[j].ToString());
                            }
                            break;
                        case "E":   //5串6购买注数和对应倍数
                            string[] sg4_5c6 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_5c6.Length; j++)
                            {
                                all.Add(sg4_5c6[j].ToString());
                            }

                            string[] sg5_5c6 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_5c6.Length; j++)
                            {
                                all.Add(sg5_5c6[j].ToString());
                            }
                            break;
                        case "F":   //5串16购买注数和对应倍数
                            string[] sg3_5c16 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_5c16.Length; j++)
                            {
                                all.Add(sg3_5c16[j].ToString());
                            }

                            string[] sg4_5c16 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_5c16.Length; j++)
                            {
                                all.Add(sg4_5c16[j].ToString());
                            }

                            string[] sg5_5c16 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_5c16.Length; j++)
                            {
                                all.Add(sg5_5c16[j].ToString());
                            }
                            break;
                        case "G":   //5串26购买注数和对应倍数
                            string[] sg2_5c26 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_5c26.Length; j++)
                            {
                                all.Add(sg2_5c26[j].ToString());
                            }

                            string[] sg3_5c26 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_5c26.Length; j++)
                            {
                                all.Add(sg3_5c26[j].ToString());
                            }

                            string[] sg4_5c26 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_5c26.Length; j++)
                            {
                                all.Add(sg4_5c26[j].ToString());
                            }

                            string[] sg5_5c26 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_5c26.Length; j++)
                            {
                                all.Add(sg5_5c26[j].ToString());
                            }
                            break;
                        case "H":   //5串31购买注数和对应倍数
                            string[] sg1_5c31 = getAll1G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg1_5c31.Length; j++)
                            {
                                all.Add(sg1_5c31[j].ToString());
                            }

                            string[] sg2_5c31 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_5c31.Length; j++)
                            {
                                all.Add(sg2_5c31[j].ToString());
                            }

                            string[] sg3_5c31 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_5c31.Length; j++)
                            {
                                all.Add(sg3_5c31[j].ToString());
                            }

                            string[] sg4_5c31 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_5c31.Length; j++)
                            {
                                all.Add(sg4_5c31[j].ToString());
                            }

                            string[] sg5_5c31 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_5c31.Length; j++)
                            {
                                all.Add(sg5_5c31[j].ToString());
                            }
                            break;
                        case "I":   //6串1购买注数和对应倍数
                            string[] sg6_6c1 = getAll6G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg6_6c1.Length; j++)
                            {
                                all.Add(sg6_6c1[j].ToString());
                            }
                            break;
                        case "J":   //6串7购买注数和对应倍数
                            string[] sg5_6c7 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_6c7.Length; j++)
                            {
                                all.Add(sg5_6c7[j].ToString());
                            }

                            string[] sg6_6c7 = getAll6G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg6_6c7.Length; j++)
                            {
                                all.Add(sg6_6c7[j].ToString());
                            }
                            break;
                        case "K":   //6串22购买注数和对应倍数
                            string[] sg4_6c22 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_6c22.Length; j++)
                            {
                                all.Add(sg4_6c22[j].ToString());
                            }

                            string[] sg5_6c22 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_6c22.Length; j++)
                            {
                                all.Add(sg5_6c22[j].ToString());
                            }

                            string[] sg6_6c22 = getAll6G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg6_6c22.Length; j++)
                            {
                                all.Add(sg6_6c22[j].ToString());
                            }
                            break;
                        case "L":   //6串42购买注数和对应倍数
                            string[] sg3_6c42 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_6c42.Length; j++)
                            {
                                all.Add(sg3_6c42[j].ToString());
                            }

                            string[] sg4_6c42 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_6c42.Length; j++)
                            {
                                all.Add(sg4_6c42[j].ToString());
                            }

                            string[] sg5_6c42 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_6c42.Length; j++)
                            {
                                all.Add(sg5_6c42[j].ToString());
                            }

                            string[] sg6_6c42 = getAll6G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg6_6c42.Length; j++)
                            {
                                all.Add(sg6_6c42[j].ToString());
                            }
                            break;
                        case "M":   //6串57购买注数和对应倍数
                            string[] sg2_6c57 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_6c57.Length; j++)
                            {
                                all.Add(sg2_6c57[j].ToString());
                            }

                            string[] sg3_6c57 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_6c57.Length; j++)
                            {
                                all.Add(sg3_6c57[j].ToString());
                            }

                            string[] sg4_6c57 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_6c57.Length; j++)
                            {
                                all.Add(sg4_6c57[j].ToString());
                            }

                            string[] sg5_6c57 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_6c57.Length; j++)
                            {
                                all.Add(sg5_6c57[j].ToString());
                            }

                            string[] sg6_6c57 = getAll6G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg6_6c57.Length; j++)
                            {
                                all.Add(sg6_6c57[j].ToString());
                            }
                            break;
                        case "N":   //6串63购买注数和对应倍数
                            string[] sg1_6c63 = getAll1G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg1_6c63.Length; j++)
                            {
                                all.Add(sg1_6c63[j].ToString());
                            }

                            string[] sg2_6c63 = getAll2G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg2_6c63.Length; j++)
                            {
                                all.Add(sg2_6c63[j].ToString());
                            }

                            string[] sg3_6c63 = getAll3G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg3_6c63.Length; j++)
                            {
                                all.Add(sg3_6c63[j].ToString());
                            }

                            string[] sg4_6c63 = getAll4G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg4_6c63.Length; j++)
                            {
                                all.Add(sg4_6c63[j].ToString());
                            }

                            string[] sg5_6c63 = getAll5G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg5_6c63.Length; j++)
                            {
                                all.Add(sg5_6c63[j].ToString());
                            }

                            string[] sg6_6c63 = getAll6G(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < sg6_6c63.Length; j++)
                            {
                                all.Add(sg6_6c63[j].ToString());
                            }
                            break;
                        default:    //7-15串1购买注数和对应倍数
                            string[] mc1 = getAllMC1(GamesNumber, Locate, LocateBuyResult, Screenings, int.Parse(WaysMultiples[i].ToString()));
                            for (int j = 0; j < mc1.Length; j++)
                            {
                                all.Add(mc1[j].ToString());
                            }
                            break;
                    }
                    #endregion
                }
            }

            string[] Result = new string[all.Count];
            for (int i = 0; i < all.Count; i++)
            {
                Result[i] = all[i].ToString();
            }
            return Result;
        }

        #region 取单关、双关...六关，取M串1

        private string[] getAll1G(int GamesNumber, string[] Locate, string[] LocateBuyResult, string[] Screenings, int TempWaysMultiples)
        {
            ArrayList al = new ArrayList(); //取所有的双关，先存入ArrayList对象
            for (int i = 0; i < GamesNumber; i++)
            {
                for (int j = 0; j < LocateBuyResult[i].Split(',').Length; j++)
                {
                    al.Add(Screenings[i] + "(" + LocateBuyResult[i].Split(',')[j].ToString() + ");" + TempWaysMultiples);
                }
            }

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
            {
                Result[i] = al[i].ToString();
            }

            return Result;
        }

        private string[] getAll2G(int GamesNumber, string[] Locate, string[] LocateBuyResult, string[] Screenings, int TempWaysMultiples)
        {
            ArrayList al = new ArrayList(); //取所有的双关，先存入ArrayList对象
            for (int i = 0; i < GamesNumber; i++)
            {
                for (int i_0 = 0; i_0 < LocateBuyResult[i].Split(',').Length; i_0++)
                {
                    for (int j = i + 1; j < GamesNumber; j++)
                    {
                        for (int j_0 = 0; j_0 < LocateBuyResult[j].Split(',').Length; j_0++)
                        {
                            al.Add(Screenings[i] + "(" + LocateBuyResult[i].Split(',')[i_0].ToString() + ")|" + Screenings[j] + "(" + LocateBuyResult[j].Split(',')[j_0].ToString() + ");" + TempWaysMultiples);
                        }
                    }
                }
            }

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
            {
                Result[i] = al[i].ToString();
            }

            return Result;
        }

        private string[] getAll3G(int GamesNumber, string[] Locate, string[] LocateBuyResult, string[] Screenings, int TempWaysMultiples)
        {
            ArrayList al = new ArrayList(); //取所有的三关，先存入ArrayList对象
            for (int i = 0; i < GamesNumber; i++)
            {
                for (int i_0 = 0; i_0 < LocateBuyResult[i].Split(',').Length; i_0++)
                {
                    for (int j = i + 1; j < GamesNumber; j++)
                    {
                        for (int j_0 = 0; j_0 < LocateBuyResult[j].Split(',').Length; j_0++)
                        {
                            for (int k = j + 1; k < GamesNumber; k++)
                            {
                                for (int k_0 = 0; k_0 < LocateBuyResult[k].Split(',').Length; k_0++)
                                {
                                    al.Add(Screenings[i] + "(" + LocateBuyResult[i].Split(',')[i_0].ToString() + ")|" + Screenings[j] + "(" + LocateBuyResult[j].Split(',')[j_0].ToString() + ")|" + Screenings[k] + "(" + LocateBuyResult[k].Split(',')[k_0].ToString() + ");" + TempWaysMultiples);
                                }
                            }
                        }
                    }
                }
            }

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
            {
                Result[i] = al[i].ToString();
            }

            return Result;
        }

        private string[] getAll4G(int GamesNumber, string[] Locate, string[] LocateBuyResult, string[] Screenings, int TempWaysMultiples)
        {
            ArrayList al = new ArrayList(); //取所有的四关，先存入ArrayList对象
            for (int i = 0; i < GamesNumber; i++)
            {
                for (int i_0 = 0; i_0 < LocateBuyResult[i].Split(',').Length; i_0++)
                {
                    for (int j = i + 1; j < GamesNumber; j++)
                    {
                        for (int j_0 = 0; j_0 < LocateBuyResult[j].Split(',').Length; j_0++)
                        {
                            for (int k = j + 1; k < GamesNumber; k++)
                            {
                                for (int k_0 = 0; k_0 < LocateBuyResult[k].Split(',').Length; k_0++)
                                {
                                    for (int x = k + 1; x < GamesNumber; x++)
                                    {
                                        for (int x_0 = 0; x_0 < LocateBuyResult[x].Split(',').Length; x_0++)
                                        {
                                            al.Add(Screenings[i] + "(" + LocateBuyResult[i].Split(',')[i_0].ToString() + ")|" + Screenings[j] + "(" + LocateBuyResult[j].Split(',')[j_0].ToString() + ")|" + Screenings[k] + "(" + LocateBuyResult[k].Split(',')[k_0].ToString() + ")|" + Screenings[x] + "(" + LocateBuyResult[x].Split(',')[x_0].ToString() + ");" + TempWaysMultiples);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }


            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
            {
                Result[i] = al[i].ToString();
            }

            return Result;
        }

        private string[] getAll5G(int GamesNumber, string[] Locate, string[] LocateBuyResult, string[] Screenings, int TempWaysMultiples)
        {
            ArrayList al = new ArrayList(); //取所有的五关，先存入ArrayList对象
            for (int i = 0; i < GamesNumber; i++)
            {
                for (int i_0 = 0; i_0 < LocateBuyResult[i].Split(',').Length; i_0++)
                {
                    for (int j = i + 1; j < GamesNumber; j++)
                    {
                        for (int j_0 = 0; j_0 < LocateBuyResult[j].Split(',').Length; j_0++)
                        {
                            for (int k = j + 1; k < GamesNumber; k++)
                            {
                                for (int k_0 = 0; k_0 < LocateBuyResult[k].Split(',').Length; k_0++)
                                {
                                    for (int x = k + 1; x < GamesNumber; x++)
                                    {
                                        for (int x_0 = 0; x_0 < LocateBuyResult[x].Split(',').Length; x_0++)
                                        {
                                            for (int y = x + 1; y < GamesNumber; y++)
                                            {
                                                for (int y_0 = 0; y_0 < LocateBuyResult[y].Split(',').Length; y_0++)
                                                {
                                                    al.Add(Screenings[i] + "(" + LocateBuyResult[i].Split(',')[i_0].ToString() + ")|" + Screenings[j] + "(" + LocateBuyResult[j].Split(',')[j_0].ToString() + ")|" + Screenings[k] + "(" + LocateBuyResult[k].Split(',')[k_0].ToString() + ")|" + Screenings[x] + "(" + LocateBuyResult[x].Split(',')[x_0].ToString() + ")|" + Screenings[y] + "(" + LocateBuyResult[y].Split(',')[y_0].ToString() + ");" + TempWaysMultiples);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
            {
                Result[i] = al[i].ToString();
            }

            return Result;
        }

        private string[] getAll6G(int GamesNumber, string[] Locate, string[] LocateBuyResult, string[] Screenings, int TempWaysMultiples)
        {
            ArrayList al = new ArrayList(); //取所有的六关，先存入ArrayList对象
            for (int i = 0; i < GamesNumber; i++)
            {
                for (int i_0 = 0; i_0 < LocateBuyResult[i].Split(',').Length; i_0++)
                {
                    for (int j = i + 1; j < GamesNumber; j++)
                    {
                        for (int j_0 = 0; j_0 < LocateBuyResult[j].Split(',').Length; j_0++)
                        {
                            for (int k = j + 1; k < GamesNumber; k++)
                            {
                                for (int k_0 = 0; k_0 < LocateBuyResult[k].Split(',').Length; k_0++)
                                {
                                    for (int x = k + 1; x < GamesNumber; x++)
                                    {
                                        for (int x_0 = 0; x_0 < LocateBuyResult[x].Split(',').Length; x_0++)
                                        {
                                            for (int y = x + 1; y < GamesNumber; y++)
                                            {
                                                for (int y_0 = 0; y_0 < LocateBuyResult[y].Split(',').Length; y_0++)
                                                {
                                                    for (int z = y + 1; z < GamesNumber; z++)
                                                    {
                                                        for (int z_0 = 0; z_0 < LocateBuyResult[z].Split(',').Length; z_0++)
                                                        {
                                                            al.Add(Screenings[i] + "(" + LocateBuyResult[i].Split(',')[i_0].ToString() + ")|" + Screenings[j] + "(" + LocateBuyResult[j].Split(',')[j_0].ToString() + ")|" + Screenings[k] + "(" + LocateBuyResult[k].Split(',')[k_0].ToString() + ")|" + Screenings[x] + "(" + LocateBuyResult[x].Split(',')[x_0].ToString() + ")|" + Screenings[y] + "(" + LocateBuyResult[y].Split(',')[y_0].ToString() + ")|" + Screenings[z] + "(" + LocateBuyResult[z].Split(',')[z_0].ToString() + ");" + TempWaysMultiples);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
            {
                Result[i] = al[i].ToString();
            }

            return Result;
        }

        private string[] getAllMC1(int GamesNumber, string[] Locate, string[] LocateBuyResult, string[] Screenings, int TempWaysMultiples)
        {
            ArrayList al = new ArrayList(); //取所有的六关，先存入ArrayList对象
            int Temp = 0;
            for (int i_0 = 0; i_0 < LocateBuyResult[Temp].Split(',').Length; i_0++)
            {
                string str_0 = Screenings[Temp] + "(" + LocateBuyResult[Temp].Split(',')[i_0].ToString() + ")|";
                int Temp1 = Temp + 1;
                if (Temp1 < GamesNumber)
                {
                    for (int i_1 = 0; i_1 < LocateBuyResult[Temp1].Split(',').Length; i_1++)
                    {
                        string str_1 = str_0 + Screenings[Temp1] + "(" + LocateBuyResult[Temp1].Split(',')[i_1].ToString() + ")|";
                        int Temp2 = Temp1 + 1;
                        if (Temp2 < GamesNumber)
                        {
                            for (int i_2 = 0; i_2 < LocateBuyResult[Temp2].Split(',').Length; i_2++)
                            {
                                string str_2 = str_1 + Screenings[Temp2] + "(" + LocateBuyResult[Temp2].Split(',')[i_2].ToString() + ")|";
                                int Temp3 = Temp2 + 1;
                                if (Temp3 < GamesNumber)
                                {
                                    for (int i_3 = 0; i_3 < LocateBuyResult[Temp3].Split(',').Length; i_3++)
                                    {
                                        string str_3 = str_2 + Screenings[Temp3] + "(" + LocateBuyResult[Temp3].Split(',')[i_3].ToString() + ")|";
                                        int Temp4 = Temp3 + 1;
                                        if (Temp4 < GamesNumber)
                                        {
                                            for (int i_4 = 0; i_4 < LocateBuyResult[Temp4].Split(',').Length; i_4++)
                                            {
                                                string str_4 = str_3 + Screenings[Temp4] + "(" + LocateBuyResult[Temp4].Split(',')[i_4].ToString() + ")|";
                                                int Temp5 = Temp4 + 1;
                                                if (Temp5 < GamesNumber)
                                                {
                                                    for (int i_5 = 0; i_5 < LocateBuyResult[Temp5].Length; i_5++)
                                                    {
                                                        string str_5 = str_4 + Screenings[Temp5] + "(" + LocateBuyResult[Temp].Split(',')[i_5].ToString() + ")|";
                                                        int Temp6 = Temp5 + 1;
                                                        if (Temp6 < GamesNumber)
                                                        {
                                                            for (int i_6 = 0; i_6 < LocateBuyResult[Temp6].Length; i_6++)
                                                            {
                                                                string str_6 = str_5 + Screenings[Temp6] + "(" + LocateBuyResult[Temp6].Split(',')[i_6].ToString() + ")|";
                                                                int Temp7 = Temp6 + 1;
                                                                if (Temp7 < GamesNumber)
                                                                {
                                                                    for (int i_7 = 0; i_7 < LocateBuyResult[Temp7].Length; i_7++)
                                                                    {
                                                                        string str_7 = str_6 + Screenings[Temp7] + "(" + LocateBuyResult[Temp7].Split(',')[i_7].ToString() + ")|";
                                                                        int Temp8 = Temp7 + 1;
                                                                        if (Temp8 < GamesNumber)
                                                                        {
                                                                            for (int i_8 = 0; i_8 < LocateBuyResult[Temp8].Length; i_8++)
                                                                            {
                                                                                string str_8 = str_7 + Screenings[Temp8] + "(" + LocateBuyResult[Temp8].Split(',')[i_8].ToString() + ")|";
                                                                                int Temp9 = Temp8 + 1;
                                                                                if (Temp9 < GamesNumber)
                                                                                {
                                                                                    for (int i_9 = 0; i_9 < LocateBuyResult[Temp9].Split(',').Length; i_9++)
                                                                                    {
                                                                                        string str_9 = str_8 + Screenings[Temp9] + "(" + LocateBuyResult[Temp9].Split(',')[i_9].ToString() + ")|";
                                                                                        int Temp10 = Temp9 + 1;
                                                                                        if (Temp10 < GamesNumber)
                                                                                        {
                                                                                            for (int i_10 = 0; i_10 < LocateBuyResult[Temp10].Split(',').Length; i_10++)
                                                                                            {
                                                                                                string str_10 = str_9 + Screenings[Temp10] + "(" + LocateBuyResult[Temp10].Split(',')[i_10].ToString() + ")|";
                                                                                                int Temp11 = Temp10 + 1;
                                                                                                if (Temp11 < GamesNumber)
                                                                                                {
                                                                                                    for (int i_11 = 0; i_11 < LocateBuyResult[Temp11].Split(',').Length; i_11++)
                                                                                                    {
                                                                                                        string str_11 = str_10 + Screenings[Temp11] + "(" + LocateBuyResult[Temp11].Split(',')[i_11].ToString() + ")|";
                                                                                                        int Temp12 = Temp11 + 1;
                                                                                                        if (Temp12 < GamesNumber)
                                                                                                        {
                                                                                                            for (int i_12 = 0; i_12 < LocateBuyResult[Temp12].Split(',').Length; i_12++)
                                                                                                            {
                                                                                                                string str_12 = str_11 + Screenings[Temp12] + "(" + LocateBuyResult[Temp12].Split(',')[i_12].ToString() + ")|";
                                                                                                                int Temp13 = Temp12 + 1;
                                                                                                                if (Temp13 < GamesNumber)
                                                                                                                {
                                                                                                                    for (int i_13 = 0; i_13 < LocateBuyResult[Temp13].Split(',').Length; i_13++)
                                                                                                                    {
                                                                                                                        string str_13 = str_12 + Screenings[Temp13] + "(" + LocateBuyResult[Temp13].Split(',')[i_12].ToString() + ")|";
                                                                                                                        int Temp14 = Temp13 + 1;
                                                                                                                        if (Temp14 < GamesNumber)
                                                                                                                        {
                                                                                                                            for (int i_14 = 0; i_14 < LocateBuyResult[Temp14].Split(',').Length; i_14++)
                                                                                                                            {
                                                                                                                                string str_14 = str_13 + Screenings[Temp14] + "(" + LocateBuyResult[Temp14].Split(',')[i_14].ToString() + ")|";
                                                                                                                                al.Add(str_14.Substring(0, str_14.Length - 1) + ";" + TempWaysMultiples);
                                                                                                                            }  //14    
                                                                                                                        }
                                                                                                                        else
                                                                                                                        {
                                                                                                                            al.Add(str_13.Substring(0, str_13.Length - 1) + ";" + TempWaysMultiples);
                                                                                                                        }
                                                                                                                    }   //13
                                                                                                                }
                                                                                                                else
                                                                                                                {
                                                                                                                    al.Add(str_12.Substring(0, str_12.Length - 1) + ";" + TempWaysMultiples);
                                                                                                                }
                                                                                                            }   //12
                                                                                                        }
                                                                                                        else
                                                                                                        {
                                                                                                            al.Add(str_11.Substring(0, str_11.Length - 1) + ";" + TempWaysMultiples);
                                                                                                        }
                                                                                                    }   //11
                                                                                                }
                                                                                                else
                                                                                                {
                                                                                                    al.Add(str_10.Substring(0, str_10.Length - 1) + ";" + TempWaysMultiples);
                                                                                                }
                                                                                            }   //10
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                            al.Add(str_9.Substring(0, str_9.Length - 1) + ";" + TempWaysMultiples);
                                                                                        }
                                                                                    }   //9
                                                                                }
                                                                                else
                                                                                {
                                                                                    al.Add(str_8.Substring(0, str_8.Length - 1) + ";" + TempWaysMultiples);
                                                                                }
                                                                            }   //8
                                                                        }
                                                                        else
                                                                        {
                                                                            al.Add(str_7.Substring(0, str_7.Length - 1) + ";" + TempWaysMultiples);
                                                                        }
                                                                    }   //7
                                                                }
                                                                else
                                                                {
                                                                    al.Add(str_6.Substring(0, str_6.Length - 1) + ";" + TempWaysMultiples);
                                                                }
                                                            }   //6
                                                        }
                                                        else
                                                        {
                                                            al.Add(str_5.Substring(0, str_5.Length - 1) + ";" + TempWaysMultiples);
                                                        }
                                                    }   //5
                                                }
                                                else
                                                {
                                                    al.Add(str_4.Substring(0, str_4.Length - 1) + ";" + TempWaysMultiples);
                                                }
                                            }   //4
                                        }
                                        else
                                        {
                                            al.Add(str_3.Substring(0, str_3.Length - 1) + ";" + TempWaysMultiples);
                                        }
                                    }   //3
                                }
                                else
                                {
                                    al.Add(str_2.Substring(0, str_2.Length - 1) + ";" + TempWaysMultiples);
                                }
                            }   //2
                        }
                        else
                        {
                            al.Add(str_1.Substring(0, str_1.Length - 1) + ";" + TempWaysMultiples);
                        }
                    }   //1
                }
                else
                {
                    al.Add(str_0.Substring(0, str_0.Length - 1) + ";" + TempWaysMultiples);
                }
            }   //0

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
            {
                Result[i] = al[i].ToString();
            }

            return Result;
        }

        #endregion

        //(Number表示传入的方案，CanonicalNumber表示整理后的方案，BuyType购买类型)复式取单式 CompetitionCount 当期比赛的总场数
        public override double ComputeWin(string Scheme, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, int CompetitionCount, string NoSignificance)
        {
            if (Scheme.Length < 16) //每个方案最短长度为 例如：4501;[5(3)];[11]
                return -3;

            if ((BuyType < 4501) || (BuyType > 4505))
            {
                return -2;
            }

            if ((BuyType == 4501) || (BuyType == 4502) || (BuyType == 4503) || (BuyType == 4504) || (BuyType == 4505))
            {
                return ComputeWinMethods(Scheme, WinNumber, ref Description, ref WinMoneyNoWithTax, BuyType, CompetitionCount);
            }

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWinMethods(string Scheme, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, int CompetitionCount)	//计算中奖
        {
            //WinNumber--彩票开奖结果格式为（顺序为－4501(胜平负);4502(总进球);4503(上下单双);4504(正确比分);4505(半全场胜平负)）：场次1(结果,SP值)|场次2(结果,SP值);场次1(结果,SP值)|场次2(结果,SP值) 我们规定结果全部用数字表示
            string CanonicalNumber = "";
            string[] BuyResult = ToSingle(Scheme, ref CanonicalNumber, CompetitionCount);   //ToSingle(string Scheme, ref string CanonicalNumber, int CompetitionCount)
            if (BuyResult == null || BuyResult.Length < 1)
            {
                return -2;
            }

            int WaysMultiples = 0;   //购买倍数
            int ResultLength = 0;    //购买的某注的长度，用来判断是单场还是过关
            double WinMoney = 0;
            double SpIndex = 1.0;    //比赛开奖的SP值
            double TempSpValue = 1.0;     //统计比赛开奖的SP值
            string Lottery = "";     //每场比赛

            bool ComparisonResult = false;
            Description = "";
            int intright = 0;   //中奖场数
            int intRefund = 0;  //退票处理的场数

            for (int ii = 0; ii < BuyResult.Length; ii++)
            {
                ComparisonResult = false;
                Lottery = BuyResult[ii].Split(';')[0];

                try
                {
                    WaysMultiples = int.Parse(BuyResult[ii].Split(';')[1].ToString()); //获得本注的购买倍数
                }
                catch
                {
                    WaysMultiples = 0;
                }

                TempSpValue = 1;
                string[] Result = Lottery.Split('|');
                ResultLength = Result.Length;
                for (int i = 0; i < ResultLength; i++)
                {
                    if (Result[i].Length < 4)
                    {
                        continue;
                    }

                    int BuyNumberOfShowings = 0;
                    try
                    {
                        BuyNumberOfShowings = int.Parse(Result[i].Substring(0, Result[i].IndexOf('(')).ToString());
                    }
                    catch
                    {
                        BuyNumberOfShowings = 0;
                    }

                    string BuyLotteryTicketResult = Result[i].Substring(Result[i].IndexOf('(') + 1, (Result[i].IndexOf(')') - Result[i].IndexOf('(') - 1)).ToString();

                    SpIndex = 1.0;
                    ComparisonResult = ComparedWithResult(BuyNumberOfShowings, BuyLotteryTicketResult, WinNumber, BuyType, ResultLength, ref SpIndex);
                    if (ComparisonResult)
                    {
                        if ((Result.Length == 1) && (SpIndex < 1.538) && (SpIndex > 0))     //保底
                        {
                            SpIndex = 1.538;
                        }

                        TempSpValue = TempSpValue * Math.Round(SpIndex, 4);
                    }
                    else
                    {
                        break;
                    }
                }

                if (ComparisonResult)
                {
                    if ((Result.Length == 1) && (TempSpValue == -1))    //退票相当与中奖保底法返还
                    {
                        WinMoney += 2 * WaysMultiples;
                        intRefund++;
                    }
                    else
                    {
                        intright++;
                        WinMoney += Math.Round(TempSpValue * 0.65, 4) * 2 * WaysMultiples;
                        /*
                         * 税后奖金
                         */
                        if (Math.Round(TempSpValue * 0.65, 4) * 2 >= 10000)
                        {
                            WinMoneyNoWithTax += Math.Round(TempSpValue * 0.65, 4) * 2 * WaysMultiples * 0.8;
                        }
                        else
                        {
                            WinMoneyNoWithTax += Math.Round(TempSpValue * 0.65, 4) * 2 * WaysMultiples;
                        }
                    }
                }
            }

            if (intRefund > 0)
            {
                if (Description != "")
                {
                    Description += "，";
                }
                Description = "退票" + intRefund.ToString() + "注（场）";
            }

            if (intright > 0)
            {
                if (Description != "")
                {
                    Description += "，";
                }
                Description = "中奖" + intright.ToString() + "注";
            }

            WinMoneyNoWithTax = Math.Round(WinMoneyNoWithTax, 2);

            return Math.Round(WinMoney, 2);
        }
        private bool ComparedWithResult(int BuyNumberOfShowings, string BuyLotteryTicketResult, string WinNumber, int BuyType, int ResultLength, ref double SpIndex)
        {
            bool ComparedResult = false;
            string[] Result = WinNumber.Split(';');  //彩票开奖结果格式为（顺序为－4501;4502;4503;4504;4505）：场次1(结果,SP值)|场次2(结果,SP值);场次1(结果,SP值)|场次2(结果,SP值)
            string WinNumberList = "";
            if (BuyType == 4501)
            {
                WinNumberList = Result[0];
            }
            else if (BuyType == 4502)
            {
                WinNumberList = Result[1];
            }
            else if (BuyType == 4503)
            {
                WinNumberList = Result[2];
            }
            else if (BuyType == 4504)
            {
                WinNumberList = Result[3];
            }
            else if (BuyType == 4505)
            {
                WinNumberList = Result[4];
            }
            else
            {
                return ComparedResult;
            }

            string[] NumberOfShowingsData = WinNumberList.Split('|');
            if ((BuyNumberOfShowings - 1) > NumberOfShowingsData.Length)     //如果购买的场次大于当期的总场数SP值返回0
            {
                SpIndex = 0;
                ComparedResult = false;

                return ComparedResult;
            }

            int intNumberOfShowings = int.Parse(NumberOfShowingsData[BuyNumberOfShowings - 1].Substring(0, NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf('(')).ToString());      //获得与某注对应的开奖结果中的比赛场次
            string LotteryTicketResult = NumberOfShowingsData[BuyNumberOfShowings - 1].Substring((NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf('(') + 1), (NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(',') - NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf('(') - 1)).ToString();        //获得与某注对应的开奖结果中的比赛场次对应的开奖结果

            if ((BuyNumberOfShowings == intNumberOfShowings) && ((BuyLotteryTicketResult == LotteryTicketResult) || (LotteryTicketResult == "*")))   //比较购买的某注与开奖的场次和结果是否相同
            {
                /*
                 * 比赛特殊情况处理
                 *（1）在当期单场玩法销售前，部分和全部场次因故发生变化，则更改相应场次变化。
                 *（2）在当期单场玩法销售后，如果部分场次因故提前进行，则该场比赛销售时间相应提前结束，其余场次销售时间不变；
                 * 如果部分场次因故延期，超过原定开奖时间12小时，则该场比赛在过关投注中的所有选项视为选中SP为1；单场投注按推票处理；
                 * 未超过12小时的，按实际比赛结果计奖。
                 *（3）在7日内办理退票手续
                 */
                if ((ResultLength <= 1) && (LotteryTicketResult == "*"))     //单关的退票
                {
                    SpIndex = -1;
                    ComparedResult = true;
                }
                else if ((ResultLength > 1) && (LotteryTicketResult == "*"))
                {
                    SpIndex = 1;
                    ComparedResult = true;
                }
                else
                {
                    //SpIndex = double.Parse(NumberOfShowingsData[BuyNumberOfShowings - 1].Substring((NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(',') + 1), (NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(')') - NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(',') - 1)).ToString().Substring(0, NumberOfShowingsData[BuyNumberOfShowings - 1].Substring((NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(',') + 1), (NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(')') - NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(',') - 1)).ToString().IndexOf('.') + 5));         //获得与某注对应的开奖结果中的比赛场次对应的SP值
                    SpIndex = double.Parse(NumberOfShowingsData[BuyNumberOfShowings - 1].Substring((NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(',') + 1), (NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(')') - NumberOfShowingsData[BuyNumberOfShowings - 1].IndexOf(',') - 1)).ToString());         //获得与某注对应的开奖结果中的比赛场次对应的SP值
                    ComparedResult = true;
                }
            }

            return ComparedResult;
        }
        #endregion

        // 分析开奖号码是否正确
        public override bool AnalyseWinNumber(string Number, int CompetitionCount)
        {
            string ConfirmationString = "";
            string ConfirmationString1 = "";
            string ConfirmationString2 = "";
            string ConfirmationString3 = "";
            string ConfirmationString4 = "";
            string ConfirmationString5 = "";

            //4501
            for (int i = 0; i < CompetitionCount; i++)
            {
                ConfirmationString1 += @"(?<L" + i.ToString() + @">[\d]{1,2}[(][310*][,][\d]{1,}([.][\d]{1,}){0,1}[)])[|]"; //方案格式：4501;[1(3)|5(3,1)|7(0)];[A2,B1]
            }
            ConfirmationString1 = ConfirmationString1.Substring(0, ConfirmationString1.Length - 3);

            //4502
            for (int i = 0; i < CompetitionCount; i++)
            {
                ConfirmationString2 += @"(?<L" + (CompetitionCount + i).ToString() + @">[\d]{1,2}[(][01234567*][,][\d]{1,}([.][\d]{1,}){0,1}[)])[|]";
            }
            ConfirmationString2 = ConfirmationString2.Substring(0, ConfirmationString2.Length - 3);

            //4503
            for (int i = 0; i < CompetitionCount; i++)
            {
                ConfirmationString3 += @"(?<L" + ((CompetitionCount * 2) + i).ToString() + @">[\d]{1,2}[(][1234*][,][\d]{1,}([.][\d]{1,}){0,1}[)])[|]";
            }
            ConfirmationString3 = ConfirmationString3.Substring(0, ConfirmationString3.Length - 3);

            //4504
            for (int i = 0; i < CompetitionCount; i++)
            {
                ConfirmationString4 += @"(?<L" + ((CompetitionCount * 3) + i).ToString() + @">[\d]{1,2}[(]([\d]{1,2}|[*])[,][\d]{1,}([.][\d]{1,}){0,1}[)])[|]";
            }
            ConfirmationString4 = ConfirmationString4.Substring(0, ConfirmationString4.Length - 3);

            //4505
            for (int i = 0; i < CompetitionCount; i++)
            {
                ConfirmationString5 += @"(?<L" + ((CompetitionCount * 4) + i).ToString() + @">[\d]{1,2}[(][123456789*][,][\d]{1,}([.][\d]{1,}){0,1}[)])[|]";
            }
            ConfirmationString5 = ConfirmationString5.Substring(0, ConfirmationString5.Length - 3);

            ConfirmationString = ConfirmationString1 + ";" + ConfirmationString2 + ";" + ConfirmationString3 + ";" + ConfirmationString4 + ";" + ConfirmationString5;

            Regex regex = new Regex(ConfirmationString, RegexOptions.Compiled | RegexOptions.IgnoreCase);
            if (!regex.IsMatch(Number))
            {
                return false;
            }

            return true;
        }

        // 获得方案的方案的总注数
        public int GetBettingNumber(string Scheme, ref string CanonicalNumber, int CompetitionCount) //(Scheme表示传入的方案，CanonicalNumber表示整理后的方案，CompetitionCount 当期比赛的总场数)复式取单式
        {
            string[] BuyResult = ToSingle(Scheme, ref CanonicalNumber, CompetitionCount);
            if (BuyResult == null || BuyResult.Length < 1)
            {
                return -2;
            }

            return BuyResult.Length;
        }

        private string FilterRepeated(string NumberPart, string strBuyType)
        {
            string[] NumberPartSort = NumberPart.Split(',');
            if (NumberPartSort.Length == 1)
            {
                return NumberPart;
            }

            string TemNumberPartSort = "";
            string ReconstructionNumberPart = "";
            int intNumberPartJ = 0;
            int intNumberPartJ1 = 0;
            for (int i = 0; i < NumberPartSort.Length; i++)
            {
                for (int j = 1; j < NumberPartSort.Length - i; j++)
                {
                    try
                    {
                        intNumberPartJ = int.Parse(NumberPartSort[j]);
                    }
                    catch
                    {
                        intNumberPartJ = -1;
                    }

                    try
                    {
                        intNumberPartJ1 = int.Parse(NumberPartSort[j - 1]);
                    }
                    catch
                    {
                        intNumberPartJ1 = -1;
                    }

                    if (intNumberPartJ < intNumberPartJ1)
                    {
                        TemNumberPartSort = NumberPartSort[j - 1];
                        NumberPartSort[j - 1] = NumberPartSort[j];
                        NumberPartSort[j] = TemNumberPartSort;
                    }
                }
            }

            for (int i = 0; i < NumberPartSort.Length; i++)
            {
                if (("013".IndexOf(NumberPartSort[i]) >= 0) && (strBuyType == "4501"))
                {
                    ReconstructionNumberPart += NumberPartSort[i] + ",";
                }
                else if (("01234567".IndexOf(NumberPartSort[i]) >= 0) && (strBuyType == "4502"))     //0-7
                {
                    ReconstructionNumberPart += NumberPartSort[i] + ",";
                }
                else if (("1234".IndexOf(NumberPartSort[i]) >= 0) && (strBuyType == "4503"))     //1-4
                {
                    ReconstructionNumberPart += NumberPartSort[i] + ",";
                }
                else if (strBuyType == "4504") //1-25
                {
                    int TemNumberPart = 0;
                    try
                    {
                        TemNumberPart = int.Parse(NumberPartSort[i]);
                    }
                    catch
                    {
                        TemNumberPart = 0;
                    }
                    if ((TemNumberPart > 0) && (TemNumberPart < 26))
                    {
                        ReconstructionNumberPart += NumberPartSort[i] + ",";
                    }
                }
                else if (("123456789".IndexOf(NumberPartSort[i]) >= 0) && (strBuyType == "4505"))    //1-9
                {
                    ReconstructionNumberPart += NumberPartSort[i] + ",";
                }
            }

            ReconstructionNumberPart = ReconstructionNumberPart.Substring(0, ReconstructionNumberPart.Length - 1);
            return ReconstructionNumberPart;
        }

        // 方案场次排列
        private string FilterRepeatedScheme(string Scheme)
        {
            string[] SchemeSort = Scheme.Split('|');
            if (SchemeSort.Length == 1)
            {
                return Scheme;
            }

            string TemSchemeSort = "";
            string ReconstructionScheme = "";
            int intScreeningsJ = 0;
            int intScreeningsJ1 = 0;
            for (int i = 0; i < SchemeSort.Length; i++)
            {
                for (int j = 1; j < SchemeSort.Length - i; j++)
                {
                    try
                    {
                        intScreeningsJ = int.Parse(SchemeSort[j].Substring(0, (SchemeSort[j].IndexOf('('))));
                    }
                    catch
                    {
                        intScreeningsJ = 0;
                    }

                    try
                    {
                        intScreeningsJ1 = int.Parse(SchemeSort[j - 1].Substring(0, (SchemeSort[j - 1].IndexOf('('))));
                    }
                    catch
                    {
                        intScreeningsJ1 = 0;
                    }

                    if (intScreeningsJ < intScreeningsJ1)
                    {
                        TemSchemeSort = SchemeSort[j - 1];
                        SchemeSort[j - 1] = SchemeSort[j];
                        SchemeSort[j] = TemSchemeSort;
                    }
                }
            }

            for (int i = 0; i < SchemeSort.Length; i++)
            {
                ReconstructionScheme += SchemeSort[i] + "|";
            }

            ReconstructionScheme = ReconstructionScheme.Substring(0, ReconstructionScheme.Length - 1);
            return ReconstructionScheme;
        }

        // 方案购买方式排列
        private string FilterRepeatedWaysResult(string WaysResult)
        {
            string[] WaysResultSort = WaysResult.Split(',');
            if (WaysResultSort.Length == 1)
            {
                return WaysResult;
            }

            string TemWaysResultSort = "";
            string ReconstructionWaysResult = "";
            int intWaysResultJ = 0;
            int intWaysResultJ1 = 0;
            for (int i = 0; i < WaysResultSort.Length; i++)
            {
                for (int j = 1; j < WaysResultSort.Length - i; j++)
                {
                    try
                    {
                        intWaysResultJ = int.Parse(ShoveEL._Convert.Asc(char.Parse(WaysResultSort[j].Substring(0, 1).ToString())).ToString());
                    }
                    catch
                    {
                        intWaysResultJ = 0;
                    }

                    try
                    {
                        intWaysResultJ1 = int.Parse(ShoveEL._Convert.Asc(char.Parse(WaysResultSort[j - 1].Substring(0, 1).ToString())).ToString());
                    }
                    catch
                    {
                        intWaysResultJ1 = 0;
                    }

                    if (intWaysResultJ < intWaysResultJ1)
                    {
                        TemWaysResultSort = WaysResultSort[j - 1];
                        WaysResultSort[j - 1] = WaysResultSort[j];
                        WaysResultSort[j] = TemWaysResultSort;
                    }
                }
            }

            for (int i = 0; i < WaysResultSort.Length; i++)
            {
                ReconstructionWaysResult += WaysResultSort[i] + ",";
            }

            ReconstructionWaysResult = ReconstructionWaysResult.Substring(0, ReconstructionWaysResult.Length - 1);
            return ReconstructionWaysResult;
        }

        /// <summary>
        /// 提取方案的内容和购买方式
        /// </summary>
        /// <param name="Scheme">传入的方案</param>
        /// <param name="BuyContent">购买内容</param>
        /// <param name="CnLocateWaysAndMultiples">购买方式和相应倍数</param>
        /// <returns></returns>
        public override bool GetSchemeSplit(string Scheme, ref string BuyContent, ref string CnLocateWaysAndMultiples)
        {
            int SchemeLength = Scheme.Split(';').Length;
            if (SchemeLength != 3)
            {
                BuyContent = "";
                CnLocateWaysAndMultiples = "";
                return false;
            }

            string strBuyType = Scheme.Trim().Split(';')[0].ToString();
            string BuyNumber = Scheme.Trim().Split(';')[1].ToString();
            BuyContent = BuyNumber.Substring(1, BuyNumber.Length - 1).Substring(0, BuyNumber.Length - 2).ToString().Trim();
            if (BuyContent == "")
            {
                BuyContent = "";
                CnLocateWaysAndMultiples = "";
                return false;
            }

            string BuyWays = Scheme.Trim().Split(';')[2].ToString().Substring(1, Scheme.Trim().Split(';')[2].ToString().Length - 1).Substring(0, Scheme.Trim().Split(';')[2].ToString().Length - 2).ToString().Trim();
            if (BuyWays == "")
            {
                BuyContent = "";
                CnLocateWaysAndMultiples = "";
                return false;
            }

            string[] LocateWaysAndMultiples = BuyWays.Split(',');
            for (int j = 0; j < LocateWaysAndMultiples.Length; j++)
            {
                switch (LocateWaysAndMultiples[j].ToString().Substring(0, 1))
                {
                    case "1":   //单关购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "单关 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "2":   //双关购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "双关 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "3":   //三关购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "三关 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "4":   //2串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "2串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "5":   //2串3购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "2串3 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "6":   //3串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "3串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "7":   //3串4购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "3串4 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "8":    //3串7购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "3串7 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "9":    //4串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "4串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "A":   //4串5购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "4串5 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "B":   //4串11购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "4串11 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "C":   //4串15购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "4串15 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "D":   //5串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "5串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "E":   //5串6购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "5串6 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "F":   //5串16购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "5串16 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "G":   //5串26购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "5串26 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "H":   //5串31购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "5串31 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "I":   //6串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "6串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "J":   //6串7购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "6串7 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "K":   //6串22购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "6串22 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "L":   //6串42购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "6串42 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "M":   //6串57购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "6串57 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "N":   //6串63购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "6串63 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "O":   //7串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "7串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "P":   //8串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "8串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "Q":   //9串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "9串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "R":   //10串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "10串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "S":   //11串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "11串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "T":   //12串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "12串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "U":   //13串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "13串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "V":   //14串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "14串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    case "W":   //15串1购买注数和对应倍数
                        if (CnLocateWaysAndMultiples != "")
                        {
                            CnLocateWaysAndMultiples += "，";
                        }
                        CnLocateWaysAndMultiples += "15串1 " + LocateWaysAndMultiples[j].Substring(1, (LocateWaysAndMultiples[j].Length - 1)) + " 倍";
                        break;
                    default:
                        CnLocateWaysAndMultiples += " <font color='red'>读取错误！</font>";
                        break;
                }
            }

            return true;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }

    /// <summary>
    /// 天津风采15选5
    /// </summary>
    public partial class TJFC15X5 : LotteryBase
    {
        #region 静态变量
        public const int BuyType_D_D = 4601;
        public const int BuyType_D_H = 4602;
        public const int BuyType_F_D = 4603;
        public const int BuyType_F_H = 4604;
        public const int BuyType_D_3_D = 4605;
        public const int BuyType_D_3_H = 4606;
        public const int BuyType_F_3_D = 4607;
        public const int BuyType_F_3_H = 4608;
        public const int BuyType_C = 4609;

        public const int ID = 46;
        public const string sID = "46";
        public const string Name = "天津风采15选5";
        public const string Code = "TJFC15X5";
        public const double MaxMoney = 6006;
        #endregion

        public TJFC15X5()
        {
            id = 46;
            buytype_c = 4609;
            name = "天津风采15选5";
            code = "TJFC15X5";
        }

        public override bool CheckBuyType(int buy_type)
        {
            return ((buy_type >= 4601) && (buy_type <= 4609));
        }

        public override LotteryBuyType[] GetBuyTypeList()
        {
            LotteryBuyType[] Result = new LotteryBuyType[9];

            Result[0] = new LotteryBuyType(BuyType_D_D, "单式代购");
            Result[1] = new LotteryBuyType(BuyType_D_H, "单式合买");
            Result[2] = new LotteryBuyType(BuyType_F_D, "复式代购");
            Result[3] = new LotteryBuyType(BuyType_F_H, "复式合买");
            Result[4] = new LotteryBuyType(BuyType_D_D, "彩中3单式代购");
            Result[5] = new LotteryBuyType(BuyType_D_H, "彩中3单式合买");
            Result[6] = new LotteryBuyType(BuyType_F_D, "彩中3复式代购");
            Result[7] = new LotteryBuyType(BuyType_F_H, "彩中3复式合买");
            Result[8] = new LotteryBuyType(BuyType_C, "追号代购");

            return Result;
        }

        public override string BuildNumber(int Num)	//id = 46
        {
            System.Random rd = new Random();
            StringBuilder sb = new StringBuilder();
            ArrayList al = new ArrayList();

            for (int i = 0; i < Num; i++)
            {
                al.Clear();
                for (int j = 0; j < 5; j++)
                {
                    int Ball = 0;
                    while ((Ball == 0) || isExistBall(al, Ball))
                        Ball = rd.Next(1, 15 + 1);
                    al.Add(Ball.ToString().PadLeft(2, '0'));
                }

                CompareToAscii compare = new CompareToAscii();
                al.Sort(compare);

                string LotteryNumber = "";
                for (int j = 0; j < al.Count; j++)
                    LotteryNumber += al[j].ToString() + " ";

                sb.Append(LotteryNumber.Trim() + "\n");
            }

            string Result = sb.ToString();
            Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }

        public override string[] ToSingle(string Number, ref string CanonicalNumber, int BuyType)	//复式取单式, 后面 ref 参数是将彩票规范化，如：01 01 02... 变成 01 02...
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ToSingle_Zhi(Number, ref CanonicalNumber);

            if ((BuyType == BuyType_D_3_D) || (BuyType == BuyType_D_3_H) || (BuyType == BuyType_F_3_D) || (BuyType == BuyType_F_3_H))
                return ToSingle_3(Number, ref CanonicalNumber);

            return null;
        }
        #region ToSingle 的具体方法
        private string[] ToSingle_Zhi(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 5)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 4; i++)
                for (int j = i + 1; j < n - 3; j++)
                    for (int k = j + 1; k < n - 2; k++)
                        for (int x = k + 1; x < n - 1; x++)
                            for (int y = x + 1; y < n; y++)
                                al.Add(strs[i] + " " + strs[j] + " " + strs[k] + " " + strs[x] + " " + strs[y]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        private string[] ToSingle_3(string Number, ref string CanonicalNumber)
        {
            string[] strs = FilterRepeated(Number.Trim().Split(' '));
            CanonicalNumber = "";

            if (strs.Length < 3)
            {
                CanonicalNumber = "";
                return null;
            }

            for (int i = 0; i < strs.Length; i++)
                CanonicalNumber += (strs[i] + " ");
            CanonicalNumber = CanonicalNumber.Trim();

            ArrayList al = new ArrayList();

            #region 循环取单式

            int n = strs.Length;
            for (int i = 0; i < n - 2; i++)
                for (int j = i + 1; j < n - 1; j++)
                    for (int k = j + 1; k < n; k++)
                        al.Add(strs[i] + " " + strs[j] + " " + strs[k]);

            #endregion

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString();
            return Result;
        }
        #endregion

        public override double ComputeWin(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, int BuyType, params double[] WinMoneyList)
        {
            if ((WinMoneyList == null) || (WinMoneyList.Length < 6))   //奖金顺序 1-2等奖，彩中3奖金
                return -3;

            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return ComputeWin_Zhi(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[0], WinMoneyList[1], WinMoneyList[2], WinMoneyList[3]);

            if ((BuyType == BuyType_D_3_D) || (BuyType == BuyType_D_3_H) || (BuyType == BuyType_F_3_D) || (BuyType == BuyType_F_3_H))
                return ComputeWin_3(Number, WinNumber, ref Description, ref WinMoneyNoWithTax, WinMoneyList[4], WinMoneyList[5]);

            return -4;
        }
        #region ComputeWin 的具体方法
        private double ComputeWin_Zhi(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1, double WinMoney2, double WinMoneyNoWithTax2)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 14)	//14: "01 02 03 04 05"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0, Description2 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_Zhi(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 14)
                        continue;

                    string[] Red = new string[5];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d\s)(?<R3>\d\d\s)(?<R4>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 5; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 5)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                    if (RedRight == 4)
                    {
                        Description2++;
                        WinMoney += WinMoney2;
                        WinMoneyNoWithTax += WinMoneyNoWithTax2;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "一等奖" + Description1.ToString() + "注";
            if (Description2 > 0)
            {
                if (Description != "")
                    Description += "，";
                Description += "二等奖" + Description2.ToString() + "注";
            }
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        private double ComputeWin_3(string Number, string WinNumber, ref string Description, ref double WinMoneyNoWithTax, double WinMoney1, double WinMoneyNoWithTax1)	//计算中奖
        {
            WinNumber = WinNumber.Trim();
            if (WinNumber.Length < 7)	//14: "01 02 03"
                return -1;
            string[] Lotterys = SplitLotteryNumber(Number);
            if (Lotterys == null)
                return -2;
            if (Lotterys.Length < 1)
                return -2;

            int Description1 = 0;
            double WinMoney = 0;
            WinMoneyNoWithTax = 0;
            Description = "";

            for (int ii = 0; ii < Lotterys.Length; ii++)
            {
                string t_str = "";
                string[] Lottery = ToSingle_3(Lotterys[ii], ref t_str);
                if (Lottery == null)
                    continue;
                if (Lottery.Length < 1)
                    continue;

                for (int i = 0; i < Lottery.Length; i++)
                {
                    if (Lottery[i].Length < 7)
                        continue;

                    string[] Red = new string[3];
                    Regex regex = new Regex(@"(?<R0>\d\d\s)(?<R1>\d\d\s)(?<R2>\d\d)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
                    Match m = regex.Match(Lottery[i]);
                    int j;
                    int RedRight = 0;
                    bool Full = true;
                    for (j = 0; j < 3; j++)
                    {
                        Red[j] = m.Groups["R" + j.ToString()].ToString().Trim();
                        if (Red[j] == "")
                        {
                            Full = false;
                            break;
                        }
                        if (WinNumber.IndexOf(Red[j]) >= 0)
                            RedRight++;
                    }
                    if (!Full)
                        continue;

                    if (RedRight == 3)
                    {
                        Description1++;
                        WinMoney += WinMoney1;
                        WinMoneyNoWithTax += WinMoneyNoWithTax1;
                        continue;
                    }
                }
            }

            if (Description1 > 0)
                Description = "彩中3奖" + Description1.ToString() + "注";
            if (Description != "")
                Description += "。";

            return WinMoney;
        }
        #endregion

        public override string AnalyseScheme(string Content, int BuyType)
        {
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_F_D) || (BuyType == BuyType_F_H) || (BuyType == BuyType_C))
                return AnalyseScheme_Zhi(Content, BuyType);

            if ((BuyType == BuyType_D_3_D) || (BuyType == BuyType_D_3_H) || (BuyType == BuyType_F_3_D) || (BuyType == BuyType_F_3_H))
                return AnalyseScheme_3(Content, BuyType);

            return "";
        }
        #region AnalyseScheme 的具体方法
        private string AnalyseScheme_Zhi(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C))
                RegexString = @"(\d\d\s){4}\d\d";
            else
                RegexString = @"(\d\d\s){4,14}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_Zhi(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_D) || (BuyType == BuyType_D_H) || (BuyType == BuyType_C)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        private string AnalyseScheme_3(string Content, int BuyType)
        {
            string[] strs = Content.Split('\n');
            if (strs == null)
                return "";
            if (strs.Length == 0)
                return "";

            string Result = "";

            string RegexString;
            if ((BuyType == BuyType_D_3_D) || (BuyType == BuyType_D_3_H))
                RegexString = @"(\d\d\s){2}\d\d";
            else
                RegexString = @"(\d\d\s){2,14}\d\d";
            Regex regex = new Regex(RegexString, RegexOptions.Compiled | RegexOptions.IgnoreCase);

            for (int i = 0; i < strs.Length; i++)
            {
                Match m = regex.Match(strs[i]);
                if (m.Success)
                {
                    string CanonicalNumber = "";
                    string[] singles = ToSingle_3(m.Value, ref CanonicalNumber);
                    if (singles == null)
                        continue;
                    if ((singles.Length >= (((BuyType == BuyType_D_3_D) || (BuyType == BuyType_D_3_H)) ? 1 : 2)) && (singles.Length <= (MaxMoney / 2)))
                        Result += CanonicalNumber + "|" + singles.Length.ToString() + "\n";
                }
            }

            if (Result.EndsWith("\n"))
                Result = Result.Substring(0, Result.Length - 1);
            return Result;
        }
        #endregion

        public override bool AnalyseWinNumber(string Number)
        {
            string t_str = "";
            string[] WinLotteryNumber = ToSingle_Zhi(Number, ref t_str);

            if ((WinLotteryNumber == null) || (WinLotteryNumber.Length != 1))
                return false;

            return true;
        }

        private string[] FilterRepeated(string[] NumberPart)
        {
            ArrayList al = new ArrayList();
            for (int i = 0; i < NumberPart.Length; i++)
            {
                int Ball = ShoveEL._Convert.StrToInt(NumberPart[i], -1);
                if ((Ball >= 1) && (Ball <= 15) && (!isExistBall(al, Ball)))
                    al.Add(NumberPart[i]);
            }

            CompareToAscii compare = new CompareToAscii();
            al.Sort(compare);

            string[] Result = new string[al.Count];
            for (int i = 0; i < al.Count; i++)
                Result[i] = al[i].ToString().PadLeft(2, '0');

            return Result;
        }

        public override string ShowNumber(string Number)
        {
            return base.ShowNumber(Number, "");
        }
    }
}