﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_About : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        tbAbout.Text = PublicFunction.GetOptionsBin("About");
        tbContact.Text = PublicFunction.GetOptionsBin("Contact");
        tbRightADHtml.Text = PublicFunction.GetOptionsBin("RightADHtml");

        // Logo 文件大小提示
        string Version = PublicFunction.GetVersion();
        if (Version == "1")
            labLogoTip.Text = "(Logo 图片大小提示：请上传尺寸大小为 220(宽) X 80(高) 的 Logo 图片文件，同时，如果 Logo 图片文件是 gif 格式，将会自动更新到论坛中)";
        else
            labLogoTip.Text = "(Logo 图片大小提示：请上传尺寸大小为 220(宽) X 58(高) 的 Logo 图片文件)";
    }

    protected void btnOK_Click(object sender, EventArgs e)
    {
        string Logo = "";

        if (fileLogo.Value.Trim() != "")
        {
            if (ShoveEL._IO.File.UploadFile(this.Page, fileLogo, "../Images/Logo/", ref Logo, true) != 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "Logo 文件上传错误！");
                return;
            }
        }

        if (!PublicFunction.SetOptionsBin("About", tbAbout.Text))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
            return;
        }

        if (!PublicFunction.SetOptionsBin("Contact", tbContact.Text))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
            return;
        }

        if (!PublicFunction.SetOptionsBin("RightADHtml", tbRightADHtml.Text))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
            return;
        }

        if (Logo != "")
        {
            if (!PublicFunction.SetOptions("UserLogo", Logo))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
                return;
            }
        }

        // 门户版本的话，如果是 gif 的格式Logo, 更新到论坛
        if ((PublicFunction.GetVersion() == "1") && (Logo.ToLower().EndsWith(".gif")))
        {
            Logo = this.MapPath("../Images/Logo/" + Logo);

            string BBSLogo = this.MapPath("../bbs/skin/cvbbs5.0/pic/Logo.gif");
            if (System.IO.File.Exists(BBSLogo))
                System.IO.File.Copy(Logo, BBSLogo, true);

            BBSLogo = this.MapPath("../bbs/skin/default/pic/Logo.gif");
            if (System.IO.File.Exists(BBSLogo))
                System.IO.File.Copy(Logo, BBSLogo, true);

            BBSLogo = this.MapPath("../bbs/skin/gray/pic/Logo.gif");
            if (System.IO.File.Exists(BBSLogo))
                System.IO.File.Copy(Logo, BBSLogo, true);
        }

        ShoveEL._Web.JavaScript.Alert(this.Page, "保存成功。");
    }
}
