﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_Celeb : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Views.V_Celeb.Select("", "", "[Sort]");
        if (dt == null)
        {
            GoError();
            return;
        }

        if (dt.Rows.Count == 0)
            return;

        dt.Columns.Add("Intro2", System.Type.GetType("System.String"));
        dt.Columns.Add("Say2", System.Type.GetType("System.String"));
        dt.Columns.Add("Comment2", System.Type.GetType("System.String"));
        dt.Columns.Add("Score2", System.Type.GetType("System.String"));
        foreach (DataRow dr in dt.Rows)
        {
            try
            {
                dr["Intro2"] = ShoveEL._String.Decompress((byte[])dr["Intro"]);
            }
            catch
            {
                dr["Intro2"] = "";
            }
            try
            {
                dr["Say2"] = ShoveEL._String.Decompress((byte[])dr["Say"]);
            }
            catch
            {
                dr["Say2"] = "";
            }
            try
            {
                dr["Comment2"] = ShoveEL._String.Decompress((byte[])dr["Comment"]);
            }
            catch
            {
                dr["Comment2"] = "";
            }
            try
            {
                dr["Score2"] = ShoveEL._String.Decompress((byte[])dr["Score"]);
            }
            catch
            {
                dr["Score2"] = "";
            }
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        ((CheckBox)e.Item.FindControl("cbisAtWinNameList")).Checked = ShoveEL._Convert.StrToBool(((HtmlInputHidden)e.Item.FindControl("tbisAtWinNameList")).Value, true);
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
    {
        int id = ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbID")).Value, 0);

        if (e.CommandName == "btnEdit")
        {
            this.Response.Redirect("CelebEdit.aspx?id=" + id.ToString(), true);
            return;
        }

        if (e.CommandName == "btnDel")
        {
            if (DAL.Tables.Celeb.Delete("[id]=" + id.ToString()) < 0)
            {
                GoError();
                return;
            }

            BindData();
            return;
        }
    }

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("CelebAdd.aspx", true);
        return;
    }
}