﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_CelebAdd : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        ddlPhoto.Items.Clear();
        ddlPhoto.Items.Add("--选择相片--");
        string[] FileList = ShoveEL._IO.File.GetFileList(this.Server.MapPath("../Images/CelebPhoto"));
        if (FileList != null)
        {
            for (int i = 0; i < FileList.Length; i++)
                ddlPhoto.Items.Add(FileList[i]);
        }

        int Sort = 0;
        if (DAL.Procedures.P_GetCelebSort.Call(ref Sort) < 0)
            return;

        tbSort.Text = Sort.ToString();
    }

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        if (tbUserName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户名。");
            return;
        }

        if (tbTitle.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入标题。");
            return;
        }

        if (tbIntro.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入简介。");
            return;
        }

        if (tbSay.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入语录。");
            return;
        }

        if (tbComment.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入评论。");
            return;
        }

        if (tbScore.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入战绩。");
            return;
        }

        int Sort = ShoveEL._Convert.StrToInt(tbSort.Text, -1);
        if (Sort < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的显示顺序。");
            return;
        }

        Users tu = new Users();
        tu.Name = tbUserName.Text.Trim();
        int Result = tu.GetUserInfoByName();

        if ((Result != 0) && (Result != -3))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "用户名不存在。");
            return;
        }

        if (DAL.Tables.Celeb.GetCount("[id]=" + tu.ID.ToString()) > 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, tu.Name + "会员已经在状元榜上。");
            return;
        }

        string Photo = "";
        if (tbPhoto.Value.Trim() != "")
        {
            if (ShoveEL._IO.File.UploadFile(this.Page, tbPhoto, "../Images/CelebPhoto/", ref Photo, true) != 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "相片文件上传错误！");
                return;
            }
        }
        else
        {
            if (ddlPhoto.SelectedIndex > 0)
                Photo = ddlPhoto.SelectedItem.Text;
        }

        if (DAL.Tables.Celeb.Insert(tu.ID, true, tbTitle.Text.Trim(), true, ShoveEL._String.Compress(tbIntro.Text), true, ShoveEL._String.Compress(tbSay.Text), true,
            ShoveEL._String.Compress(tbComment.Text), true, ShoveEL._String.Compress(tbScore.Text), true, Photo, true, Sort, true, cbisAtWinNameList.Checked, true) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("Celeb.aspx", true);
    }
}