﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_CelebEdit : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int id = -1;
            id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id < 0)
            {
                GoError();
                return;
            }
            tbID.Value = id.ToString();

            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        ddlPhoto.Items.Clear();
        ddlPhoto.Items.Add("--选择相片--");
        string[] FileList = ShoveEL._IO.File.GetFileList(this.Server.MapPath("../Images/CelebPhoto"));
        if (FileList != null)
        {
            for (int i = 0; i < FileList.Length; i++)
                ddlPhoto.Items.Add(FileList[i]);
        }

        DataTable dt = DAL.Views.V_Celeb.Select("", "[id] = " + tbID.Value, "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        tbUserName.Text = dt.Rows[0]["Name"].ToString();
        tbTitle.Text = dt.Rows[0]["Title"].ToString();
        try
        {
            tbIntro.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Intro"]);
        }
        catch { }
        try
        {
            tbSay.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Say"]);
        }
        catch { }
        try
        {
            tbComment.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Comment"]);
        }
        catch { }
        try
        {
            tbScore.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Score"]);
        }
        catch { }

        tbSort.Text = dt.Rows[0]["Sort"].ToString();
        ShoveEL.ControlExt.SetDownListBoxText(ddlPhoto, dt.Rows[0]["Photo"].ToString());
        tbOldImage.Text = dt.Rows[0]["Photo"].ToString().Trim();
        
        if (dt.Rows[0]["Photo"].ToString().Trim() == "")
        {
            cbNoEditImage.Checked = false;
            cbNoEditImage.Visible = false;
        }
        
        cbisAtWinNameList.Checked = ShoveEL._Convert.StrToBool(dt.Rows[0]["isAtWinNameList"].ToString(), true);
    }

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        /*
        if (tbUserName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入用户名。");
            return;
        }
        */

        if (tbTitle.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入标题。");
            return;
        }

        if (tbIntro.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入简介。");
            return;
        }

        if (tbSay.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入语录。");
            return;
        }

        if (tbComment.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入评论。");
            return;
        }

        if (tbScore.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入战绩。");
            return;
        }

        int Sort = ShoveEL._Convert.StrToInt(tbSort.Text, -1);
        if (Sort < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入正确的显示顺序。");
            return;
        }

        string Photo = "";
        if (cbNoEditImage.Checked)
            Photo = tbOldImage.Text;
        else
        {
            if (tbPhoto.Value.Trim() != "")
            {
                if (ShoveEL._IO.File.UploadFile(this.Page, tbPhoto, "../Images/CelebPhoto/", ref Photo, true) != 0)
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "相片文件上传错误！");
                    return;
                }
            }
            else
            {
                if (ddlPhoto.SelectedIndex > 0)
                    Photo = ddlPhoto.SelectedItem.Text;
            }
        }

        if (DAL.Tables.Celeb.Update("[id] = " + tbID.Value, 0, false, tbTitle.Text.Trim(), true, ShoveEL._String.Compress(tbIntro.Text), true, ShoveEL._String.Compress(tbSay.Text), true,
            ShoveEL._String.Compress(tbComment.Text), true, ShoveEL._String.Compress(tbScore.Text), true, Photo, true, Sort, true, cbisAtWinNameList.Checked, true) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("Celeb.aspx", true);
    }
}