﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_Finance01 : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            tbTimeFrom.Text = System.DateTime.Now.ToShortDateString();
            tbTimeTo.Text = System.DateTime.Now.ToShortDateString();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Finance";
        base.OnInit(e);
    }
    #endregion

    protected void btnGO_Click(object sender, System.EventArgs e)
    {
        BindData();
    }

    private void BindData()
    {
        System.DateTime TimeFrom, TimeTo;
        try
        {
            TimeFrom = System.DateTime.Parse(tbTimeFrom.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "开始时间格式输入错误！");
            return;
        }
        try
        {
            TimeTo = System.DateTime.Parse(tbTimeTo.Text.Trim());
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "结束时间格式输入错误！");
            return;
        }
        TimeFrom = DateTime.Parse(TimeFrom.ToShortDateString() + " 0:0:0");
        TimeTo = DateTime.Parse(TimeTo.ToShortDateString() + " 23:59:59");
        if (TimeFrom > TimeTo)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "结束时间应该在开始时间之后！");
            return;
        }

        DataTable dt = MSSQL.Select("select * from V_UsersDetail where OperatorType in (1,2,3) and [Datetime] between @p1 and @p2 order by [Datetime]",
            new MSSQL.Parameter("p1", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeFrom),
            new MSSQL.Parameter("p2", SqlDbType.DateTime, 0, ParameterDirection.Input, TimeTo));

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            double money = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            e.Item.Cells[2].Text = (money == 0) ? "" : money.ToString("N");
        }
    }
}