﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_Finance06 : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            BindDataForLottery();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Finance";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlLottery.Items.Count > 0)
        {
            ddlLottery.SelectedIndex = 0;
            BindDataForIsuse(ddlLottery.Items[0].Value);
        }
    }

    private void BindDataForIsuse(string Lottery_id)
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Finance06_Isuse");

        if (dt == null)
        {
            SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
            if (conn == null)
            {
                GoError();
                return;
            }

            SqlDataAdapter da = new SqlDataAdapter("select * from Isuse where EndTime < GetDate() order by EndTime desc", conn);
            dt = new DataTable();
            try
            {
                da.Fill(dt);
            }
            catch
            {
                conn.Close();
                GoError();
                return;
            }
            conn.Close();

            ShoveEL._Web.Cache.SetCache("Finance06_Isuse", dt);
        }

        DataRow[] dr = dt.Select("Lottery_id=" + Lottery_id);
        ddlIsuse.Items.Clear();
        for (int i = 0; i < dr.Length; i++)
            ddlIsuse.Items.Add(new ListItem(dr[i]["Isuse"].ToString(), dr[i]["id"].ToString()));

        if (ddlIsuse.Items.Count > 0)
            ddlIsuse.SelectedIndex = 0;

        btnGo.Enabled = (ddlIsuse.Items.Count > 0);
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForIsuse(ddlLottery.SelectedValue);
    }

    private void BindData()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Finance06_WinMoney_" + ddlIsuse.SelectedValue);

        if (dt == null)
        {
            SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
            if (conn == null)
            {
                GoError();
                return;
            }

            string strCmd = "select * from V_Scheme where [Isuse_id] = " + ddlIsuse.SelectedValue + " and Quashed = 0 and LotteryBuyed = 1 and WinMoney <> 0 order by id";

            SqlDataAdapter da = new SqlDataAdapter(strCmd, conn);
            dt = new DataTable();
            try
            {
                da.Fill(dt);
            }
            catch
            {
                conn.Close();
                GoError();
                return;
            }
            conn.Close();

            dt.Columns.Add("WinDescription2", System.Type.GetType("System.String"));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                try
                {
                    dt.Rows[i]["WinDescription2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["WinDescription"]);
                }
                catch
                {
                    dt.Rows[i]["WinDescription2"] = "<font color='red'>读取错误！</font>";
                }
                dt.AcceptChanges();
            }

            ShoveEL._Web.Cache.SetCache("Finance06_WinMoney_" + ddlIsuse.SelectedValue, dt);
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void btnGo_Click(object sender, System.EventArgs e)
    {
        BindData();
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            double money = ShoveEL._Convert.StrToDouble(e.Item.Cells[2].Text, 0);
            e.Item.Cells[2].Text = money.ToString("N");
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[4].Text, 0);
            e.Item.Cells[4].Text = money.ToString("N");
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[5].Text, 0);
            e.Item.Cells[5].Text = money.ToString("N");
        }
    }
}