﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_ImportNewLottery : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            btnOK.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信要导入新彩种吗？请谨慎确认！") + "');");
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Option";
        isRequestSuperManagementRights = true;
        base.OnInit(e);
    }
    #endregion

    protected void btnOK_Click(object sender, EventArgs e)
    {
        if (cb1.Checked)
        {
            ImportDate("Lottery.xml");
            return;
        }

        if (upfile.Value.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请选择新彩种文件(Lottery.xml)。");
            return;
        }

        string ShortName = "";
        if (ShoveEL._IO.File.UploadFile(this.Page, upfile, "../Temp/", ref ShortName, true) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "新彩种文件上传失败！");
            return;
        }

        ImportDate(ShortName);
    }

    private void ImportDate(string FileName)
    {
        DataSet ds_New = new DataSet("Lotterys");
        try
        {
            ds_New.ReadXml(this.Server.MapPath("../Temp/" + FileName));
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "读新彩种文件失败！");
            return;
        }

        if (ds_New == null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "读新彩种文件失败！");
            return;
        }

        if (ds_New.Tables.Count < 3)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "读新彩种文件不完整！");
            return;
        }

        DAL.Tables.LotteryBuyType.Delete("");
        DAL.Tables.LotteryWinType.Delete("");

        DataTable dt_New_Lottery = ds_New.Tables["Lottery"];
        DataTable dt_New_LotteryBuyType = ds_New.Tables["LotteryBuyType"];
        DataTable dt_New_LotteryWinType = ds_New.Tables["LotteryWinType"];

        DataTable dt_Old_Lottery = DAL.Tables.Lottery.Select("", "", "[id]");
        DataTable dt_Old_LotteryBuyType = DAL.Tables.LotteryBuyType.Select("", "", "Lottery_id, [id]");
        DataTable dt_Old_LotteryWinType = DAL.Tables.LotteryWinType.Select("", "", "Lottery_id, [id]");

        foreach (DataRow dr_New in dt_New_Lottery.Rows)
        {
            DataRow[] dr_Old = dt_Old_Lottery.Select("id=" + dr_New["id"].ToString());
            if ((dr_Old == null) || (dr_Old.Length < 1))
            {
                DAL.Tables.Lottery.Insert(
                    int.Parse(dr_New["id"].ToString()), true,
                    dr_New["Name"].ToString(), true,
                    dr_New["Code"].ToString(), true,
                    bool.Parse(dr_New["CanChase"].ToString()), true,
                    int.Parse(dr_New["ChaseBuyType_id"].ToString()), true,
                    int.Parse(dr_New["ChaseExecuteDeferMinute"].ToString()), true,
                    false, true,
                    int.Parse(dr_New["Sort"].ToString()), true,
                    Convert.FromBase64String(dr_New["Agreement"].ToString()), true,
                    Convert.FromBase64String(dr_New["Explain"].ToString()), true,
                    Convert.FromBase64String(dr_New["LotteryExemple"].ToString()), true,
                    Convert.FromBase64String(dr_New["OpenAfficheTemplate"].ToString()), true,
                    dr_New["WinLotteryExemple"].ToString(), true,
                    dr_New["BasePlayPage"].ToString(), true,
                    dr_New["IntervalType"].ToString(), true,
                    int.Parse(dr_New["Type_id"].ToString()), true);
            }
        }

        foreach (DataRow dr_New in dt_New_LotteryBuyType.Rows)
        {
            DataRow[] dr_Old = dt_Old_LotteryBuyType.Select("id=" + dr_New["id"].ToString());
            if ((dr_Old == null) || (dr_Old.Length < 1))
            {
                DAL.Tables.LotteryBuyType.Insert(
                    int.Parse(dr_New["id"].ToString()), true,
                    int.Parse(dr_New["Lottery_id"].ToString()), true,
                    dr_New["Type"].ToString(), true,
                    int.Parse(dr_New["SystemEndAheadMinute"].ToString()), true,
                    dr_New["BuyFileName"].ToString(), true);
            }
        }

        foreach (DataRow dr_New in dt_New_LotteryWinType.Rows)
        {
            DataRow[] dr_Old = dt_Old_LotteryWinType.Select("id=" + dr_New["id"].ToString());
            if ((dr_Old == null) || (dr_Old.Length < 1))
            {
                DAL.Tables.LotteryWinType.Insert(
                    int.Parse(dr_New["id"].ToString()), true,
                    int.Parse(dr_New["Lottery_id"].ToString()), true,
                    dr_New["Name"].ToString(), true,
                    int.Parse(dr_New["Sort"].ToString()), true,
                    double.Parse(dr_New["DefaultMoney"].ToString()), true,
                    double.Parse(dr_New["DefaultMoneyNoWithTax"].ToString()), true);
            }
        }

        ds_New.Dispose();

        ShoveEL._Web.JavaScript.Alert(this.Page, "导入成功，请联系开发商注册新彩种，谢谢！");
    }
}
