﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_Link : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Tables.Links.Select("", "", "[Sort]");
        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();

        g.Columns[1].ValueList.ValueListItems.Clear();
        string[] FileList = ShoveEL._IO.File.GetFileList(this.Server.MapPath("../Images/Links"));
        if (FileList != null)
        {
            for (int i = 0; i < FileList.Length; i++)
                g.Columns[1].ValueList.ValueListItems.Add(FileList[i], FileList[i]);
        }
    }

    protected void g_PageIndexChanged(object sender, Infragistics.WebUI.UltraWebGrid.PageEventArgs e)
    {
        BindData();
        g.DisplayLayout.Pager.CurrentPageIndex = e.NewPageIndex;
    }

    protected void g_UpdateCell(object sender, Infragistics.WebUI.UltraWebGrid.CellEventArgs e)
    {
        if (DAL.Tables.Links.Update("id=" + e.Cell.Row.Cells[6].Text,
            e.Cell.Row.Cells[0].Text.Trim(), true,
            e.Cell.Row.Cells[1].Text.Trim(), true,
            e.Cell.Row.Cells[2].Text.Trim(), true,
            ShoveEL._Convert.StrToInt(e.Cell.Row.Cells[3].Text.Trim(), 0), true,
            (e.Cell.Row.Cells[4].Text.Trim().ToUpper() == "TRUE"), true) < 0)
            GoError();
        else
            BindData();
    }

    protected void g_ClickCellButton(object sender, Infragistics.WebUI.UltraWebGrid.CellEventArgs e)
    {
        if (e.Cell.Column.Header.Caption == "删除")
        {
            if (DAL.Tables.Links.Delete("ID=" + e.Cell.Row.Cells[6].Text) < 0)
                GoError();
            else
                BindData();
        }
    }

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        if (tbLinkName.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入名称。");
            return;
        }

        if (tbHomePage.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入链接网址。");
            return;
        }

        string ShortFileName = "";
        if (tbLogo.Value.Trim() != "")
        {
            if (ShoveEL._IO.File.UploadFile(this.Page, tbLogo, "../Images/Links/", ref ShortFileName, true) != 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "Logo 文件上传错误！");
                return;
            }
        }

        if (DAL.Tables.Links.Insert(
            tbLinkName.Text.Trim(), true,
            ShortFileName, true,
            tbHomePage.Text.Trim(), true,
            -1, false,
            true, false) < 0)

            GoError();
        else
        {
            tbLinkName.Text = "";
            tbHomePage.Text = "";
            BindData();
        }
    }
}