﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Data.OleDb;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_LotteryBuy : AdminPage
{
    protected System.Timers.Timer timer1;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForLottery();
            btnUpload.Attributes.Add("onclick", "return onUploadClick();");
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryBuy";
        InitializeComponent();
        base.OnInit(e);
    }

    /// <summary>
    /// 设计器支持所需的方法 - 不要使用代码编辑器修改
    /// 此方法的内容。
    /// </summary>
    private void InitializeComponent()
    {
        this.timer1 = new System.Timers.Timer();
        ((System.ComponentModel.ISupportInitialize)(this.timer1)).BeginInit();
        // 
        // timer1
        // 
        this.timer1.Interval = 5000;
        this.timer1.Elapsed += new System.Timers.ElapsedEventHandler(this.timer1_Elapsed);
        ((System.ComponentModel.ISupportInitialize)(this.timer1)).EndInit();

    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        object Value = MSSQL.ExecuteScalar("select LotteryBuyRightsList from Users where [id] = " + user.ID.ToString());
        if (Value == null)
        {
            GoError();
            return;
        }

        string LotteryBuyRightsList = Convert.ToString(Value);

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            if ((LotteryBuyRightsList.IndexOf("[-1]") >= 0) || (LotteryBuyRightsList.IndexOf("[" + dt.Rows[i]["id"].ToString() + "]") >= 0))
            {
                ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));
            }
        }

        if (ddlLottery.Items.Count > 0)
        {
            BindDataForIsuse(ddlLottery.Items[0].Value);
        }
    }

    private void BindDataForIsuse(string Lottery_id)
    {
        DataTable dt = DAL.Tables.Isuse.Select("[id], Isuse", "Lottery_id = " + ddlLottery.SelectedValue + " and StartTime < GetDate() and IsOpen = 0", "EndTime");
        if (dt == null)
        {
            GoError();
            return;
        }

        ddlIsuse.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlIsuse.Items.Add(new ListItem(dt.Rows[i]["Isuse"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlIsuse.Items.Count > 0)
        {
            ddlIsuse_SelectedIndexChanged(ddlIsuse, new System.EventArgs());
            g.Visible = true;
        }
        else
            g.Visible = false;
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForIsuse(ddlLottery.SelectedValue);
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindData();
    }

    private void BindData()
    {
        if (ddlLottery.Items.Count < 1)
            return;

        DataTable dt = DAL.Views.V_SchemeSchedule.Select("", "Isuse_id = " + ddlIsuse.SelectedValue + " and Schedule >= 100 and Quashed = 0 and LotteryBuyed = 0", "[Money] desc");
        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("LotteryNumber2", System.Type.GetType("System.String"));
        dt.Columns.Add("LocateWaysAndMultiples", System.Type.GetType("System.String"));

        string BuyContent = "";
        string CnLocateWaysAndMultiples = "";
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            dt.Rows[i]["Money"] = double.Parse(dt.Rows[i]["Money"].ToString()).ToString("N");
            if (new Lottery()[Lottery.ZCDC.sID].CheckBuyType(int.Parse(dt.Rows[i]["Type_id"].ToString())))
            {
                dt.Rows[i]["Multiple"] = 0;
                try
                {
                    BuyContent = "";
                    CnLocateWaysAndMultiples = "";
                    if (new Lottery()[Lottery.ZCDC.sID].GetSchemeSplit(ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]), ref BuyContent, ref CnLocateWaysAndMultiples))
                    {
                        dt.Rows[i]["LotteryNumber2"] = BuyContent;
                        dt.Rows[i]["LocateWaysAndMultiples"] = CnLocateWaysAndMultiples;
                    }
                    else
                    {
                        dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                        dt.Rows[i]["LocateWaysAndMultiples"] = "<font color='red'>读取错误！</font>";
                    }
                }
                catch
                {
                    dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                    dt.Rows[i]["LocateWaysAndMultiples"] = "<font color='red'>读取错误！</font>";
                }
            }
            else
            {
                try
                {
                    dt.Rows[i]["LotteryNumber2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]);
                }
                catch
                {
                    dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                }
            } 
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();

        btnDownload.Enabled = (dt.Rows.Count > 0);
        btnDownload_txt.Enabled = (dt.Rows.Count > 0);

        // 可以不输入彩票标识号的时候，此按钮有效
        btnBuyAll.Visible = ((dt.Rows.Count > 0) && !PublicFunction.GetOptionsAsBoolean("LotteryBuyRequestCode", true));

        fileUp.Disabled = (dt.Rows.Count < 1);
        btnUpload.Enabled = (dt.Rows.Count > 0);
    }

    protected void btnRefresh_Click(object sender, System.EventArgs e)
    {
        BindData();
    }

    protected void cbAutoRefresh_CheckedChanged(object sender, System.EventArgs e)
    {
        btnRefresh.Enabled = !cbAutoRefresh.Checked;
        timer1.Enabled = cbAutoRefresh.Checked;
    }

    private void timer1_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
    {
        BindData();
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
    {
        if (e.CommandName == "btnBuy")
        {
            string LotteryCode = ((TextBox)e.Item.FindControl("tbLotteryCode")).Text.Trim();
            if (LotteryCode == "")
            {
                if (PublicFunction.GetOptionsAsBoolean("LotteryBuyRequestCode", true))
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "请输入彩票标识码。");
                    return;
                }
                else
                {
                    LotteryCode = PublicFunction.GetOptionsAsString("LotteryBuyDefaultCode");
                }
            }

            string Return = "";
            if (DAL.Procedures.P_SchemeBuyed.Call(ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbID")).Value, 0),
                ShoveEL._String.Compress(LotteryCode),
                PublicFunction.GetOptionsAsInt("ScoringOfSelfBuy", 0),
                PublicFunction.GetOptionsAsInt("ScoringOfCommendBuy", 0),
                user.ID,
                ref Return) < 0)
            {
                GoError("数据读写错误");
                return;
            }

            if (Return != "")
            {
                GoError(Return);
                return;
            }

            user.GetUserBalance(ref Return);
            BindData();
            return;
        }
    }

    protected void btnBuyAll_Click(object sender, EventArgs e)
    {
        if (PublicFunction.GetOptionsAsBoolean("LotteryBuyRequestCode", true))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "系统需要在出票的时候输入彩票标识码，不能批量出票。");
            return;
        }

        if (g.Items.Count < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "没有数据。");
            return;
        }

        int ScoringOfSelfBuy = PublicFunction.GetOptionsAsInt("ScoringOfSelfBuy", 0);
        int ScoringOfCommendBuy = PublicFunction.GetOptionsAsInt("ScoringOfCommendBuy", 0);

        string LotteryCode = PublicFunction.GetOptionsAsString("LotteryBuyDefaultCode");
        
        string Return = "";
        int Fail = 0, OK = 0;
        
        foreach (DataListItem item in g.Items)
        {
            int _ID = ShoveEL._Convert.StrToInt(((HtmlInputHidden)item.FindControl("tbID")).Value, 0);

            if (_ID < 1)
            {
                Fail++;
                continue;
            }

            Return = "";
            int Result = DAL.Procedures.P_SchemeBuyed.Call(_ID,
                ShoveEL._String.Compress(LotteryCode),
                ScoringOfSelfBuy,
                ScoringOfCommendBuy,
                user.ID,
                ref Return);

            if ((Result < 0) || (Return != ""))
            {
                Fail++;
                continue;
            }

            OK++;
        }


        Return = "";
        user.GetUserBalance(ref Return);

        BindData();

        ShoveEL._Web.JavaScript.Alert(this.Page, String.Format("操作完成，其中成功出票 {0} 个方案，失败 {1} 个方案。", OK, Fail));
    }

    protected void btnUpload_Click(object sender, System.EventArgs e)
    {
        string NewFileName = "";
        if (ShoveEL._IO.File.UploadFile(this.Page, fileUp, "../Temp/", ref NewFileName) != 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "文件上传失败。");
            return;
        }

        string strConn = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + this.Server.MapPath("../Temp/" + NewFileName) + ";Extended Properties=Excel 8.0;";
        OleDbConnection oleconn = new OleDbConnection(strConn);
        try
        {
            oleconn.Open();
        }
        catch
        {
            GoError();
            return;
        }

        DataTable schemaTable = oleconn.GetOleDbSchemaTable(System.Data.OleDb.OleDbSchemaGuid.Tables, null);
        OleDbCommand Cmd = new OleDbCommand("select 内部编号 as [id], 彩票标识号 as LotteryCode from [" + schemaTable.Rows[0][2].ToString().Trim() + "]", oleconn);
        OleDbDataReader dr = null;
        try
        {
            dr = Cmd.ExecuteReader();
        }
        catch
        {
            oleconn.Close();
            GoError();
            return;
        }

        int ScoringOfSelfBuy = PublicFunction.GetOptionsAsInt("ScoringOfSelfBuy", 0);
        int ScoringOfCommendBuy = PublicFunction.GetOptionsAsInt("ScoringOfCommendBuy", 0);

        string Return = "";
        int OK = 0, Fail = 0;

        while (dr.Read())
        {
            int _ID = ShoveEL._Convert.StrToInt(dr["id"].ToString(), -1);
            string LotteryCode = dr["LotteryCode"].ToString().Trim();

            if (_ID < 1)
            {
                Fail++;
                continue;
            }

            if ((LotteryCode == "") || (LotteryCode == "<请输入标识号>"))
            {
                if (PublicFunction.GetOptionsAsBoolean("LotteryBuyRequestCode", true))
                {
                    Fail++;
                    continue;
                }
                else
                {
                    LotteryCode = PublicFunction.GetOptionsAsString("LotteryBuyDefaultCode");
                }
            }

            Return = "";
            int Result = DAL.Procedures.P_SchemeBuyed.Call(_ID,
                ShoveEL._String.Compress(LotteryCode),
                ScoringOfSelfBuy,
                ScoringOfCommendBuy,
                user.ID,
                ref Return);

            if ((Result < 0) || (Return != ""))
            {
                Fail++;
                continue;
            }

            OK++;
        }

        dr.Close();
        oleconn.Close();

        Return = "";
        user.GetUserBalance(ref Return);

        BindData();

        System.IO.File.Delete(this.Page.Server.MapPath("../Temp/" + NewFileName));
        ShoveEL._Web.JavaScript.Alert(this.Page, String.Format("操作完成，其中成功出票 {0} 个方案，失败 {1} 个方案。", OK, Fail));
    }

    protected void btnDownload_Click(object sender, EventArgs e)
    {
        DataTable dt = DAL.Views.V_Isuse.Select("", "[id] = " + ddlIsuse.SelectedValue, "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        string FileName = dt.Rows[0]["Code"].ToString() + dt.Rows[0]["Isuse"].ToString() + ".xls";

        dt = DAL.Views.V_SchemeSchedule.Select("", "Isuse_id = " + ddlIsuse.SelectedValue + " and Schedule >= 100 and Quashed = 0 and LotteryBuyed = 0", "[Money] desc");
        if (dt == null)
        {
            GoError();
            return;
        }

        if (dt.Rows.Count < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "没有数据。");
            return;
        }

        HttpResponse response;
        response = Page.Response;
        response.AppendHeader("Content-Disposition", "attachment;filename=" + FileName);
        Response.ContentType = "application/ms-excel";
        response.ContentEncoding = System.Text.Encoding.GetEncoding("gb2312");
        response.Write("内部编号\t方案编号\t类别\t购买内容\t倍数\t金额\t彩票标识号\n");

        foreach (DataRow dr in dt.Rows)
        {
            string LotteryNumber = "";
            try
            {
                LotteryNumber = "| " + ShoveEL._String.Decompress((byte[])dr["LotteryNumber"]).Replace("\r\n", " | ") + " |";
            }
            catch { }
            response.Write(dr["ID"].ToString() + "\t" + dr["SchemeNumber"].ToString() + "\t" + dr["Type"].ToString() + "\t" + LotteryNumber + "\t" + dr["Multiple"].ToString() + "\t" + dr["Money"].ToString() + "\t<请输入标识号>\n");
        }
        response.End();
    }

    protected void btnDownload_txt_Click(object sender, EventArgs e)
    {
        DataTable dt = DAL.Views.V_Isuse.Select("", "[id] = " + ddlIsuse.SelectedValue, "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        string FileName = dt.Rows[0]["Code"].ToString() + dt.Rows[0]["Isuse"].ToString() + ".txt";

        dt = DAL.Views.V_SchemeSchedule.Select("", "Isuse_id = " + ddlIsuse.SelectedValue + " and Schedule >= 100 and Quashed = 0 and LotteryBuyed = 0", "[Money] desc");
        if (dt == null)
        {
            GoError();
            return;
        }

        if (dt.Rows.Count < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "没有数据。");
            return;
        }

        HttpResponse response;
        response = Page.Response;
        response.AppendHeader("Content-Disposition", "attachment;filename=" + FileName);
        Response.ContentType = "application/ms-txt";
        response.ContentEncoding = System.Text.Encoding.GetEncoding("utf-8");

        foreach (DataRow dr in dt.Rows)
        {
            string LotteryNumber = "";
            try
            {
                LotteryNumber = ShoveEL._String.Decompress((byte[])dr["LotteryNumber"]);
            }
            catch { }

            response.Write("***********************************************\r\n");
            response.Write("方案编号: " + dr["SchemeNumber"].ToString() + "\t内部编号:" + dr["ID"].ToString() + "\r\n");
            response.Write("方案类别: " + dr["Type"].ToString() + "\r\n");
            response.Write("方案倍数: " + dr["Multiple"].ToString() + "\t方案金额:" + double.Parse(dr["Money"].ToString()).ToString("N") + "\r\n");
            response.Write("***********************************************\r\n");
            response.Write(LotteryNumber);
            response.Write("\r\n\r\n\r\n");
        }
        response.End();
     }
}