﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_LotteryInfo : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForLottery();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlLottery.Items.Count > 0)
        {
            ddlLottery_SelectedIndexChanged(ddlLottery, new System.EventArgs());
        }
        else
        {
            tbExplain.ReadOnly = true;
            tbLotteryExemple.ReadOnly = true;
            tbAgreement.ReadOnly = true;
            tbOpenAfficheTemplate.ReadOnly = true;
            btnOK.Enabled = false;
        }
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, EventArgs e)
    {
        DataTable dt = DAL.Tables.Lottery.Select("", "[id]=" + ddlLottery.SelectedValue, "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        try
        {
            tbExplain.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Explain"]);
        }
        catch
        {
            tbExplain.Text = "";
        }

        try
        {
            tbLotteryExemple.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["LotteryExemple"]);
        }
        catch
        {
            tbLotteryExemple.Text = "";
        }

        try
        {
            tbAgreement.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Agreement"]);
        }
        catch
        {
            tbAgreement.Text = "";
        }

        try
        {
            tbOpenAfficheTemplate.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["OpenAfficheTemplate"]);
        }
        catch
        {
            tbOpenAfficheTemplate.Text = "";
        }

        tbExplain.ReadOnly = false;
        tbLotteryExemple.ReadOnly = false;
        tbAgreement.ReadOnly = false;
        tbOpenAfficheTemplate.ReadOnly = false;
        btnOK.Enabled = true;
    }

    protected void btnOK_Click(object sender, EventArgs e)
    {
        if (MSSQL.ExecuteNonQuery("update Lottery set Explain = @Explain where [id] = " + ddlLottery.SelectedValue,
            new MSSQL.Parameter("Explain", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbExplain.Text))) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
            return;
        }

        if (MSSQL.ExecuteNonQuery("update Lottery set LotteryExemple = @LotteryExemple where [id] = " + ddlLottery.SelectedValue,
            new MSSQL.Parameter("LotteryExemple", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbLotteryExemple.Text))) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
            return;
        }

        if (MSSQL.ExecuteNonQuery("update Lottery set Agreement = @Agreement where [id] = " + ddlLottery.SelectedValue,
            new MSSQL.Parameter("Agreement", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbAgreement.Text))) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
            return;
        }

        if (MSSQL.ExecuteNonQuery("update Lottery set OpenAfficheTemplate = @OpenAfficheTemplate where [id] = " + ddlLottery.SelectedValue,
            new MSSQL.Parameter("OpenAfficheTemplate", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbOpenAfficheTemplate.Text))) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "保存失败。");
            return;
        }

        ShoveEL._Web.JavaScript.Alert(this.Page, "保存成功。");
    }
}