﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_LotteryIsuse : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int Lottery_id = ShoveEL._Convert.StrToInt(this.Request["Lottery_id"], 1);

            BindDataForLottery();
            if (new Lottery().ValidID(Lottery_id))
            {
                ShoveEL.ControlExt.SetDownListBoxTextFromValue(ddlLottery, Lottery_id.ToString());
            }

            BindData();

            if (int.Parse(ddlLottery.SelectedValue) == Lottery.ZCDC.ID)
            {
                pl_ZCDC.Visible = true;

                DataListZCDCTypeBindData();
            }
            else
            {
                pl_ZCDC.Visible = false;
            }
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryIsuse";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindData();

        if (int.Parse(ddlLottery.SelectedValue) == Lottery.ZCDC.ID)
        {
            pl_ZCDC.Visible = true;

            DataListZCDCTypeBindData();
        }
        else
        {
            pl_ZCDC.Visible = false;
        }
    }

    private void BindData()
    {
        if (ddlLottery.Items.Count < 1)
            return;

        DataTable dt = DAL.Tables.Isuse.Select("", "Lottery_id = " + ddlLottery.SelectedValue + " and EndTime > GetDate()", "EndTime");
        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();

        // 读最后一期期号，以提示用户该继续输入哪一期
        DataTable dtLastIsuse = MSSQL.Select("select top 1 Isuse, StartTime, EndTime from Isuse where Lottery_id = " + ddlLottery.SelectedValue + " order by EndTime desc");
        if (dtLastIsuse == null)
        {
            GoError();
            return;
        }

        if (dtLastIsuse.Rows.Count < 1)
        {
            labLastIsuseTip.Text = "此彩种还没有添加过任何期号。";
        }
        else
        {
            labLastIsuseTip.Text = "已添加的最后期号：" + dtLastIsuse.Rows[0]["Isuse"].ToString() + "，开始时间：" + dtLastIsuse.Rows[0]["StartTime"].ToString() + "，截止时间：" + dtLastIsuse.Rows[0]["EndTime"].ToString() + "。";
        }
    }

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        if (ddlLottery.Items.Count < 1)
            return;
        this.Response.Redirect("LotteryIsuseAdd.aspx?Lottery_id=" + ddlLottery.SelectedValue, true);
    }

    protected void btnAddDCType_Click(object sender, EventArgs e)
    {
        string TypeName = tbTypeName.Text.Trim();
        if (TypeName == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page,"联赛类别不能为空！");
            return;
        }

        int TypeId = 0;
        string return_str = "";
        if (DAL.Procedures.P_AddForLeagueTypeForZCDC.Call(TypeName, selectColorAdd.Value.ToString(), ref TypeId, ref return_str) == 0)
        {
            if (TypeId < 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, return_str);
                return;
            }
        }
        else
        {
            GoError();
            return;
        }

        DataListZCDCTypeBindData();
    }

    protected void DataListZCDCType_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            if (e.CommandName == "btEdit")
            {
                this.DataListZCDCType.EditItemIndex = e.Item.ItemIndex;
            }

            if (e.CommandName == "btUpdate")
            {
                TextBox tbLeagueTypeName = (TextBox)(DataListZCDCType.Items[e.Item.ItemIndex].FindControl("tbLeagueTypeName"));
                TextBox tbLeagueColor = (TextBox)(DataListZCDCType.Items[e.Item.ItemIndex].FindControl("tbLeagueColor"));
                HiddenField hfId = (HiddenField)(DataListZCDCType.Items[e.Item.ItemIndex].FindControl("hfId"));
                DropDownList ddlLeagueColor = (DropDownList)(DataListZCDCType.Items[e.Item.ItemIndex].FindControl("ddlLeagueColor"));

                //if ((tbLeagueTypeName.Text.Trim() == "") || (tbLeagueColor.Text.Trim() == ""))
                if (tbLeagueTypeName.Text.Trim() == "")
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "请输入联赛类别名称！");
                    return;
                }

                int id = int.Parse(hfId.Value);
                int returnInt = 0;
                string returnStr = "";
                if (DAL.Procedures.P_UpdateForLeagueTypeForZCDC.Call(id, tbLeagueTypeName.Text.Trim(), ddlLeagueColor.SelectedValue.ToString(), ref returnInt, ref returnStr) == 0)
                {
                    if (returnInt < 0)
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, returnStr);
                        return;
                    }
                    else
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, "更新成功!");
                    }                    
                }
                else
                {
                    GoError();
                    return;
                }

                this.DataListZCDCType.EditItemIndex = -1;
            }

            DataListZCDCTypeBindData();
        }
    }

    private void DataListZCDCTypeBindData()
    {
        DataTable dt = DAL.Tables.LeagueTypeForZCDC.Select("", "", "");
        if (dt == null)
        {
            GoError();
            return;
        }

        DataListZCDCType.DataSource = dt;
        DataListZCDCType.DataBind();
    }

    protected void DataListZCDCType_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.EditItem)
        {
            DropDownList ddlLeagueColor = (DropDownList)(e.Item.FindControl("ddlLeagueColor"));
            TextBox tbLeagueColor = (TextBox)(e.Item.FindControl("tbLeagueColor"));
            DropDownListDefault(ddlLeagueColor, tbLeagueColor.Text.ToString());
        }
    }

    private void DropDownListDefault(DropDownList ddl, string defaultValue)
    {
        foreach (ListItem item in ddl.Items)
        {
            if (item.Value == defaultValue)
            {
                item.Selected = true;
            }
        }
    }
}