﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;

using ShoveEL.Database;

public partial class Admin_LotteryIsuseAdd : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int Lottery_id = ShoveEL._Convert.StrToInt(this.Request["Lottery_id"], -1);
            if (!new Lottery().ValidID(Lottery_id))
            {
                GoError();
                return;
            }
            tbLottery_id.Text = Lottery_id.ToString();

            string IntervalType = new Lottery().GetIntervalType(Lottery_id);
            if (IntervalType.StartsWith("分"))
            {
                this.Response.Redirect("LotteryIsuseAdd_JN.aspx?Lottery_id=" + Lottery_id.ToString(), true);
                return;
            }

            if (Lottery_id == Lottery.SFC.ID)
            {
                pSFC.Visible = true;
            }

            if (Lottery_id == Lottery.JQC.ID)
            {
                pJQC.Visible = true;
            }

            if (Lottery_id == Lottery.LCBQC.ID)
            {
                pLCBQC.Visible = true;
            }

            if (Lottery_id == Lottery.LCDC.ID)
            {
                pLCDC.Visible = true;
            }

            if (Lottery_id == Lottery.ZCDC.ID)
            {
                ZCDC.Visible = true;

                btnAdd.Enabled = false;
            }

            cbAutoNext10Isuse.Visible = (IntervalType == "天");
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryIsuse";
        base.OnInit(e);
    }
    #endregion

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        string Isuse = "";
        try
        {
            Isuse = tbIsuse.Text.Trim();
        }
        catch
        { }
        if (Isuse == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "期号不能为空！");
            return;
        }

        DataTable t_dt = DAL.Tables.Isuse.Select("[id]", "Isuse='" + Isuse + "' and Lottery_id=" + tbLottery_id.Text, "");
        if (t_dt == null)
        {
            GoError();
            return;
        }
        if (t_dt.Rows.Count > 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "期号已经存在，请不要输入重名期号！");
            return;
        }

        System.DateTime StartTime, EndTime;

        object dt = PublicFunction.ValidLotteryTime(tbStartTime.Text);
        if (dt == null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "开始时间格式输入错误！");
            return;
        }
        StartTime = (DateTime)dt;

        dt = PublicFunction.ValidLotteryTime(tbEndTime.Text);
        if (dt == null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "截止时间格式输入错误！");
            return;
        }
        EndTime = (DateTime)dt;

        if (EndTime <= StartTime)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "截止时间应该在开始时间之后！");
            return;
        }

        if (tbLottery_id.Text == Lottery.SFC.sID)
        {
            btnAdd_ClickForSFC();
            return;
        }

        if (tbLottery_id.Text == Lottery.JQC.sID)
        {
            btnAdd_ClickForJQC();
            return;
        }

        if (tbLottery_id.Text == Lottery.LCBQC.sID)
        {
            btnAdd_ClickForLCBQC();
            return;
        }

        if (tbLottery_id.Text == Lottery.LCDC.sID)
        {
            btnAdd_ClickForLCDC();
            return;
        }

        if (tbLottery_id.Text == Lottery.ZCDC.sID)
        {
            btnAdd_ClickForZCDC();
            return;
        }

        int Lottery_id = int.Parse(tbLottery_id.Text);

        if (DAL.Tables.Isuse.Insert(Lottery_id, true, Isuse, true, StartTime, true, EndTime, true, false, false, "", false, null, false, false, false) < 0)
        {
            GoError();
            return;
        }

        if (cbAutoNext10Isuse.Visible && cbAutoNext10Isuse.Checked)
        {
            string IsuseYear = Isuse.Substring(0, Isuse.Length - 3);
            int IsuseNum = ShoveEL._Convert.StrToInt(Isuse.Substring(Isuse.Length - 3, 3), 0);
            for (int i = 1; i <= 9; i++)
            {
                IsuseNum++;
                string NextIsuse = IsuseYear + IsuseNum.ToString().PadLeft(3, '0');
                StartTime = StartTime.AddDays(1);
                EndTime = EndTime.AddDays(1);
                if (DAL.Tables.Isuse.Insert(Lottery_id, true, NextIsuse, true, StartTime, true, EndTime, true, false, false, "", false, null, false, false, false) < 0)
                    break;
            }
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnAdd_ClickForSFC()
    {
        TextBox[] tb = new TextBox[14];
        TextBox[] tb_1 = new TextBox[14];
        TextBox[] tb_2 = new TextBox[14];

        for (int i = 0; i < 14; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString());
            tb_1[i] = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString() + "_1");
            tb_2[i] = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString() + "_2");
            if ((tb[i].Text.Trim() == "") || (tb_1[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseAddForSFC.Call(int.Parse(tbLottery_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_1[0].Text.Trim(), tb_2[0].Text.Trim(),
            tb[1].Text.Trim(), tb_1[1].Text.Trim(), tb_2[1].Text.Trim(),
            tb[2].Text.Trim(), tb_1[2].Text.Trim(), tb_2[2].Text.Trim(),
            tb[3].Text.Trim(), tb_1[3].Text.Trim(), tb_2[3].Text.Trim(),
            tb[4].Text.Trim(), tb_1[4].Text.Trim(), tb_2[4].Text.Trim(),
            tb[5].Text.Trim(), tb_1[5].Text.Trim(), tb_2[5].Text.Trim(),
            tb[6].Text.Trim(), tb_1[6].Text.Trim(), tb_2[6].Text.Trim(),
            tb[7].Text.Trim(), tb_1[7].Text.Trim(), tb_2[7].Text.Trim(),
            tb[8].Text.Trim(), tb_1[8].Text.Trim(), tb_2[8].Text.Trim(),
            tb[9].Text.Trim(), tb_1[9].Text.Trim(), tb_2[9].Text.Trim(),
            tb[10].Text.Trim(), tb_1[10].Text.Trim(), tb_2[10].Text.Trim(),
            tb[11].Text.Trim(), tb_1[11].Text.Trim(), tb_2[11].Text.Trim(),
            tb[12].Text.Trim(), tb_1[12].Text.Trim(), tb_2[12].Text.Trim(),
            tb[13].Text.Trim(), tb_1[13].Text.Trim(), tb_2[13].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnAdd_ClickForJQC()
    {
        TextBox[] tb = new TextBox[8];
        TextBox[] tb_2 = new TextBox[8];

        for (int i = 0; i < 8; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbJQC" + (i + 1).ToString());
            tb_2[i] = (TextBox)this.FindControl("tbJQC" + (i + 1).ToString() + "_2");
            if (tb[i].Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 个球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseAddForJQC.Call(int.Parse(tbLottery_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_2[0].Text.Trim(),
            tb[1].Text.Trim(), tb_2[1].Text.Trim(),
            tb[2].Text.Trim(), tb_2[2].Text.Trim(),
            tb[3].Text.Trim(), tb_2[3].Text.Trim(),
            tb[4].Text.Trim(), tb_2[4].Text.Trim(),
            tb[5].Text.Trim(), tb_2[5].Text.Trim(),
            tb[6].Text.Trim(), tb_2[6].Text.Trim(),
            tb[7].Text.Trim(), tb_2[7].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnAdd_ClickForLCBQC()
    {
        TextBox[] tb = new TextBox[6];
        TextBox[] tb_1 = new TextBox[6];
        TextBox[] tb_2 = new TextBox[6];

        for (int i = 0; i < 6; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString());
            tb_1[i] = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString() + "_1");
            tb_2[i] = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString() + "_2");
            if ((tb[i].Text.Trim() == "") || (tb_1[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseAddForLCBQC.Call(int.Parse(tbLottery_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_1[0].Text.Trim(), tb_2[0].Text.Trim(),
            tb[1].Text.Trim(), tb_1[1].Text.Trim(), tb_2[1].Text.Trim(),
            tb[2].Text.Trim(), tb_1[2].Text.Trim(), tb_2[2].Text.Trim(),
            tb[3].Text.Trim(), tb_1[3].Text.Trim(), tb_2[3].Text.Trim(),
            tb[4].Text.Trim(), tb_1[4].Text.Trim(), tb_2[4].Text.Trim(),
            tb[5].Text.Trim(), tb_1[5].Text.Trim(), tb_2[5].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnAdd_ClickForLCDC()
    {
        TextBox[] tb = new TextBox[1];
        TextBox[] tb_1 = new TextBox[1];
        TextBox[] tb_2 = new TextBox[1];

        for (int i = 0; i < 1; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString());
            tb_1[i] = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString() + "_1");
            tb_2[i] = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString() + "_2");
            if ((tb[i].Text.Trim() == "") || (tb_1[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseAddForLCDC.Call(int.Parse(tbLottery_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_1[0].Text.Trim(), tb_2[0].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnAdd_ClickForZCDC()
    {
        int CompetitionCount = ShoveEL._Convert.StrToInt(CompetitionNum.Text.Trim(), 0);
        if (CompetitionCount < 16)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入的本期比赛总场数输入有误！");
            return;
        }        

        TextBox[] tb1 = new TextBox[CompetitionCount];
        TextBox[] tb2 = new TextBox[CompetitionCount];
        TextBox[] tb3 = new TextBox[CompetitionCount];
        DropDownList[] ddlLetBall = new DropDownList[CompetitionCount];
        DropDownList[] ddlLeagueType  = new DropDownList[CompetitionCount];

        string ScreeningsAndTime = "";    //构建格式：类别,主场,客场,比赛时间|类别,主场,客场,比赛时间|类别,主场,客场,比赛时间
        int DataCount = DataListZCDC.Items.Count;
        for (int i = 0; i < DataCount; i++)
        {
            tb1[i] = (TextBox)(DataListZCDC.Items[i].FindControl("tb1ZCDC"));
            tb2[i] = (TextBox)(DataListZCDC.Items[i].FindControl("tb2ZCDC"));
            tb3[i] = (TextBox)(DataListZCDC.Items[i].FindControl("tb3ZCDC"));
            ddlLetBall[i] = (DropDownList)(DataListZCDC.Items[i].FindControl("ddlLetBall"));
            ddlLeagueType[i] = (DropDownList)(DataListZCDC.Items[i].FindControl("ddlLeagueType"));

            if ((tb1[i].Text.Trim() == "") || (tb2[i].Text.Trim() == "") || (tb3[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }

            object dt = PublicFunction.ValidLotteryTime(tb3[i].Text.Trim());
            if (dt == null)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队时间输入不正确！(格式：0000-00-00 00:00:00)");
                return;
            }

            ScreeningsAndTime += ddlLeagueType[i].SelectedValue + "," + tb1[i].Text.Trim() + "," + tb2[i].Text.Trim() + "," + dt.ToString() + "," + ddlLetBall[i].SelectedValue + "|";
        }
        ScreeningsAndTime = ScreeningsAndTime.Substring(0, (ScreeningsAndTime.Length - 1));

        int Isuse_id = 0;
        string return_str = "";

        try
        {
            DAL.Procedures.P_IsuseAddForZCDC.Call(int.Parse(tbLottery_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()), int.Parse(CompetitionNum.Text.Trim()), ScreeningsAndTime, ref Isuse_id, ref return_str);
            if (Isuse_id < 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, return_str);
                return;
            }
        }
        catch
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    protected void btCompetitionNum_Click(object sender, EventArgs e)
    {
        if (CompetitionNum.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入本期比赛的总场数！");
            return;
        }

        int AddCompetitionNum = ShoveEL._Convert.StrToInt(CompetitionNum.Text.Trim(), 0);
        if (AddCompetitionNum < 16)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "输入的本期比赛总场数输入有误！");
            return;
        }

        DataListZCDC.Visible = true;
        tableCompetitionNum.Visible = false;

        DataTable dt = new DataTable();
        DataColumn newDC;

        newDC = new DataColumn("ID", System.Type.GetType("System.Int32"));
        dt.Columns.Add(newDC);

        newDC = new DataColumn("HostTeam", System.Type.GetType("System.String"));
        dt.Columns.Add(newDC);

        newDC = new DataColumn("QuestTeam", System.Type.GetType("System.String"));
        dt.Columns.Add(newDC);

        newDC = new DataColumn("Time", System.Type.GetType("System.String"));
        dt.Columns.Add(newDC);

        for (int i = 0; i < AddCompetitionNum; i++)
        {
            DataRow dr = dt.NewRow();            
            dr[0] = i + 1;
            dt.Rows.Add(dr);
        }

        DataListZCDC.DataSource = dt.DefaultView;
        DataListZCDC.DataBind();

        btnAdd.Enabled = true;
    }

    protected void btnBack_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    protected void DataListZCDC_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            DropDownList ddlLeagueType = (DropDownList)e.Item.FindControl("ddlLeagueType");
            ddlLeagueTypeDataBind(ddlLeagueType);
        }
    }

    private void ddlLeagueTypeDataBind(DropDownList ddl)
    {
        DataTable dt = MSSQL.Select("select * from LeagueTypeForZCDC");
        if (dt == null || dt.Rows.Count == 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page,"请先添加联赛类别！");
            return;
        }
        ddl.DataTextField = "LeagueTypeName";
        ddl.DataValueField = "id";

        ddl.DataSource = dt;
        ddl.DataBind();
    }
}