﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_LotteryIsuseAdd_JN : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int Lottery_id = ShoveEL._Convert.StrToInt(this.Request["Lottery_id"], -1);
            if (!new Lottery().ValidID(Lottery_id))
            {
                GoError();
                return;
            }
            tbLottery_id.Text = Lottery_id.ToString();

            string IntervalType = new Lottery().GetIntervalType(Lottery_id);
            if (!IntervalType.StartsWith("分"))
            {
                this.Response.Redirect("LotteryIsuseAdd.aspx?Lottery_id=" + Lottery_id.ToString(), true);
                return;
            }

            object oLastDate = MSSQL.ExecuteScalar("SELECT ISNULL(MAX(EndTime), DATEADD([day], - 1, GETDATE())) AS LastDate from Isuse where Lottery_id = " + Lottery_id.ToString());
            if (oLastDate == null)
            {
                GoError();
                return;
            }

            DateTime dtLastDate = DateTime.Parse(oLastDate.ToString()).AddDays(1);
            tbDate.Text = dtLastDate.Year.ToString() + "-" + dtLastDate.Month.ToString() + "-" + dtLastDate.Day.ToString();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryIsuse";
        base.OnInit(e);
    }
    #endregion

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        DateTime StartDate;
        try
        {
            StartDate = DateTime.Parse(tbDate.Text);
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "开始日期输入错误。");
            return;
        }

        int Days = ShoveEL._Convert.StrToInt(tbDays.Text, 0);
        if (Days < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入要连续增加的天数。");
            return;
        }

        string IntervalType = new Lottery().GetIntervalType(int.Parse(tbLottery_id.Text));
        int Interval = int.Parse(IntervalType.Substring(1, IntervalType.IndexOf(";") - 1));
        string FirstEndTime = IntervalType.Substring(IntervalType.IndexOf(";") + 1, 8);
        int Degree = int.Parse(IntervalType.Substring(IntervalType.LastIndexOf(";") + 1));

        for (int i = 0; i < Days; i++)
        {
            string sDate = StartDate.Date.ToShortDateString();
            DataTable dt = DAL.Tables.Isuse.Select("[id]", "StartTime between '" + sDate + " 0:0:0' and '" + sDate + " 23:59:59' and Lottery_id = " + tbLottery_id.Text, "");
            if (dt == null)
            {
                GoError();
                return;
            }
            if (dt.Rows.Count > 0)
            {
                StartDate = StartDate.AddDays(1);
                continue;
            }

            DateTime IsuseStartTime = DateTime.Parse(StartDate.Date.ToShortDateString() + " 0:0:0");
            DateTime IsuseEndTime = DateTime.Parse(StartDate.Date.ToShortDateString() + " " + FirstEndTime);
            string Isuse = StartDate.Year.ToString() + StartDate.Month.ToString().PadLeft(2, '0') + StartDate.Day.ToString().PadLeft(2, '0') + "-01";

            DAL.Tables.Isuse.Insert(int.Parse(tbLottery_id.Text), true,
                Isuse, true,
                IsuseStartTime, true,
                IsuseEndTime, true,
                false, false,
                "", false,
                null, false,
                false, false);

            for (int j = 2; j <= Degree; j++)
            {
                IsuseStartTime = IsuseEndTime;
                IsuseEndTime = IsuseEndTime.AddMinutes(Interval);
                Isuse = StartDate.Year.ToString() + StartDate.Month.ToString().PadLeft(2, '0') + StartDate.Day.ToString().PadLeft(2, '0') + "-" + j.ToString().PadLeft(2, '0');

                DAL.Tables.Isuse.Insert(int.Parse(tbLottery_id.Text), true,
                    Isuse, true,
                    IsuseStartTime, true,
                    IsuseEndTime, true,
                    false, false,
                    "", false,
                    null, false,
                    false, false);
            }

            StartDate = StartDate.AddDays(1);
        }        
        
        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    protected void btnBack_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }
}
