﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;

using ShoveEL.Database;

public partial class Admin_LotteryIsuseEdit : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            int Isuse_id = ShoveEL._Convert.StrToInt(this.Request["Isuse_id"], -1);
            if (Isuse_id < 0)
            {
                GoError();
                return;
            }

            int Lottery_id = ShoveEL._Convert.StrToInt(this.Request["Lottery_id"], -1);
            if (!new Lottery().ValidID(Lottery_id))
            {
                GoError();
                return;
            }

            tbIsuse_id.Text = Isuse_id.ToString();
            tbLottery_id.Text = Lottery_id.ToString();

            if (Lottery_id == Lottery.SFC.ID)
                pSFC.Visible = true;

            if (Lottery_id == Lottery.JQC.ID)
                pJQC.Visible = true;

            if (Lottery_id == Lottery.LCBQC.ID)
                pLCBQC.Visible = true;

            if (Lottery_id == Lottery.LCDC.ID)
                pLCDC.Visible = true;

            if (Lottery_id == Lottery.ZCDC.ID)
                ZCDC.Visible = true;

            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryIsuse";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Tables.Isuse.Select("", "[id]=" + tbIsuse_id.Text, "");
        if ((dt == null) || (dt.Rows.Count < 1))
        {
            GoError();
            return;
        }

        tbIsuse.Text = dt.Rows[0]["Isuse"].ToString();
        tbStartTime.Text = dt.Rows[0]["StartTime"].ToString();
        tbEndTime.Text = dt.Rows[0]["EndTime"].ToString();

        if (tbLottery_id.Text == Lottery.SFC.sID)
        {
            dt = DAL.Tables.IsuseForSFC.Select("", "Isuse_id = " + tbIsuse_id.Text, "[No]");
            if ((dt == null) || (dt.Rows.Count < 14))
            {
                GoError();
                return;
            }

            for (int i = 0; i < 14; i++)
            {
                TextBox tb = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString());
                TextBox tb_1 = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString() + "_1");
                TextBox tb_2 = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString() + "_2");
                tb.Text = dt.Rows[i]["HostTeam"].ToString();
                tb_1.Text = dt.Rows[i]["QuestTeam"].ToString();
                tb_2.Text = dt.Rows[i]["DateTime"].ToString();
            }
        }

        if (tbLottery_id.Text == Lottery.JQC.sID)
        {
            dt = DAL.Tables.IsuseForJQC.Select("", "Isuse_id = " + tbIsuse_id.Text, "[No]");
            if ((dt == null) || (dt.Rows.Count < 8))
            {
                GoError();
                return;
            }

            for (int i = 0; i < 8; i++)
            {
                TextBox tb = (TextBox)this.FindControl("tbJQC" + (i + 1).ToString());
                TextBox tb_2 = (TextBox)this.FindControl("tbJQC" + (i + 1).ToString() + "_2");
                tb.Text = dt.Rows[i]["Team"].ToString();
                tb_2.Text = dt.Rows[i]["DateTime"].ToString();
            }
        }

        if (tbLottery_id.Text == Lottery.LCBQC.sID)
        {
            dt = DAL.Tables.IsuseForLCBQC.Select("", "Isuse_id = " + tbIsuse_id.Text, "[No]");
            if ((dt == null) || (dt.Rows.Count < 6))
            {
                GoError();
                return;
            }

            for (int i = 0; i < 6; i++)
            {
                TextBox tb = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString());
                TextBox tb_1 = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString() + "_1");
                TextBox tb_2 = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString() + "_2");
                tb.Text = dt.Rows[i]["HostTeam"].ToString();
                tb_1.Text = dt.Rows[i]["QuestTeam"].ToString();
                tb_2.Text = dt.Rows[i]["DateTime"].ToString();
            }
        }

        if (tbLottery_id.Text == Lottery.LCDC.sID)
        {
            dt = DAL.Tables.IsuseForLCDC.Select("", "Isuse_id = " + tbIsuse_id.Text, "[No]");
            if ((dt == null) || (dt.Rows.Count < 1))
            {
                GoError();
                return;
            }

            for (int i = 0; i < 1; i++)
            {
                TextBox tb = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString());
                TextBox tb_1 = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString() + "_1");
                TextBox tb_2 = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString() + "_2");
                tb.Text = dt.Rows[i]["HostTeam"].ToString();
                tb_1.Text = dt.Rows[i]["QuestTeam"].ToString();
                tb_2.Text = dt.Rows[i]["DateTime"].ToString();
            }
        }

        if (tbLottery_id.Text == Lottery.ZCDC.sID)
        {
            dt = DAL.Tables.IsuseForZCDC.Select("", "Isuse_id = " + tbIsuse_id.Text, "[No]");
            if ((dt == null) || (dt.Rows.Count < 1))
            {
                GoError();
                return;
            }

            DataListZCDC.DataSource = dt.DefaultView;
            DataListZCDC.DataBind();
        }

    }

    protected void btnEdit_Click(object sender, System.EventArgs e)
    {
        string Isuse = "";
        try
        {
            Isuse = tbIsuse.Text.Trim();
        }
        catch
        { }
        if (Isuse == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "期号不能为空！");
            return;
        }

        DataTable t_dt = DAL.Tables.Isuse.Select("[id]", "Isuse='" + Isuse + "' and Lottery_id=" + tbLottery_id.Text + " and [id] <> " + tbIsuse_id.Text, "");
        if (t_dt == null)
        {
            GoError();
            return;
        }
        if (t_dt.Rows.Count > 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "期号已经存在，请不要输入重名期号！");
            return;
        }

        System.DateTime StartTime, EndTime;

        object dt = PublicFunction.ValidLotteryTime(tbStartTime.Text);
        if (dt == null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "开始时间格式输入错误！");
            return;
        }
        StartTime = (DateTime)dt;

        dt = PublicFunction.ValidLotteryTime(tbEndTime.Text);
        if (dt == null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "截止时间格式输入错误！");
            return;
        }
        EndTime = (DateTime)dt;

        if (EndTime <= StartTime)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "截止时间应该在开始时间之后！");
            return;
        }

        if (tbLottery_id.Text == Lottery.SFC.sID)
        {
            btnEdit_ClickForSFC();
            return;
        }

        if (tbLottery_id.Text == Lottery.JQC.sID)
        {
            btnEdit_ClickForJQC();
            return;
        }

        if (tbLottery_id.Text == Lottery.LCBQC.sID)
        {
            btnEdit_ClickForLCBQC();
            return;
        }

        if (tbLottery_id.Text == Lottery.LCDC.sID)
        {
            btnEdit_ClickForLCDC();
            return;
        }

        if (tbLottery_id.Text == Lottery.ZCDC.sID)
        {
            btnAdd_ClickForZCDC();
            return;
        }

        int Lottery_id = int.Parse(tbLottery_id.Text);

        if (DAL.Tables.Isuse.Update("id=" + tbIsuse_id.Text, 0, false, Isuse, true, StartTime, true, EndTime, true, false, false, "", false, null, false, false, false) < 0)
            GoError();
        else
            this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnEdit_ClickForSFC()
    {
        TextBox[] tb = new TextBox[14];
        TextBox[] tb_1 = new TextBox[14];
        TextBox[] tb_2 = new TextBox[14];

        for (int i = 0; i < 14; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString());
            tb_1[i] = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString() + "_1");
            tb_2[i] = (TextBox)this.FindControl("tbSFC" + (i + 1).ToString() + "_2");
            if ((tb[i].Text.Trim() == "") || (tb_1[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseEditForSFC.Call(int.Parse(tbIsuse_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_1[0].Text.Trim(), tb_2[0].Text.Trim(),
            tb[1].Text.Trim(), tb_1[1].Text.Trim(), tb_2[1].Text.Trim(),
            tb[2].Text.Trim(), tb_1[2].Text.Trim(), tb_2[2].Text.Trim(),
            tb[3].Text.Trim(), tb_1[3].Text.Trim(), tb_2[3].Text.Trim(),
            tb[4].Text.Trim(), tb_1[4].Text.Trim(), tb_2[4].Text.Trim(),
            tb[5].Text.Trim(), tb_1[5].Text.Trim(), tb_2[5].Text.Trim(),
            tb[6].Text.Trim(), tb_1[6].Text.Trim(), tb_2[6].Text.Trim(),
            tb[7].Text.Trim(), tb_1[7].Text.Trim(), tb_2[7].Text.Trim(),
            tb[8].Text.Trim(), tb_1[8].Text.Trim(), tb_2[8].Text.Trim(),
            tb[9].Text.Trim(), tb_1[9].Text.Trim(), tb_2[9].Text.Trim(),
            tb[10].Text.Trim(), tb_1[10].Text.Trim(), tb_2[10].Text.Trim(),
            tb[11].Text.Trim(), tb_1[11].Text.Trim(), tb_2[11].Text.Trim(),
            tb[12].Text.Trim(), tb_1[12].Text.Trim(), tb_2[12].Text.Trim(),
            tb[13].Text.Trim(), tb_1[13].Text.Trim(), tb_2[13].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnEdit_ClickForJQC()
    {
        TextBox[] tb = new TextBox[8];
        TextBox[] tb_2 = new TextBox[8];

        for (int i = 0; i < 8; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbJQC" + (i + 1).ToString());
            tb_2[i] = (TextBox)this.FindControl("tbJQC" + (i + 1).ToString() + "_2");
            if (tb[i].Text.Trim() == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 个球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseEditForJQC.Call(int.Parse(tbIsuse_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_2[0].Text.Trim(),
            tb[1].Text.Trim(), tb_2[1].Text.Trim(),
            tb[2].Text.Trim(), tb_2[2].Text.Trim(),
            tb[3].Text.Trim(), tb_2[3].Text.Trim(),
            tb[4].Text.Trim(), tb_2[4].Text.Trim(),
            tb[5].Text.Trim(), tb_2[5].Text.Trim(),
            tb[6].Text.Trim(), tb_2[6].Text.Trim(),
            tb[7].Text.Trim(), tb_2[7].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnEdit_ClickForLCBQC()
    {
        TextBox[] tb = new TextBox[6];
        TextBox[] tb_1 = new TextBox[6];
        TextBox[] tb_2 = new TextBox[6];

        for (int i = 0; i < 6; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString());
            tb_1[i] = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString() + "_1");
            tb_2[i] = (TextBox)this.FindControl("tbLCBQC" + (i + 1).ToString() + "_2");
            if ((tb[i].Text.Trim() == "") || (tb_1[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseEditForLCBQC.Call(int.Parse(tbIsuse_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_1[0].Text.Trim(), tb_2[0].Text.Trim(),
            tb[1].Text.Trim(), tb_1[1].Text.Trim(), tb_2[1].Text.Trim(),
            tb[2].Text.Trim(), tb_1[2].Text.Trim(), tb_2[2].Text.Trim(),
            tb[3].Text.Trim(), tb_1[3].Text.Trim(), tb_2[3].Text.Trim(),
            tb[4].Text.Trim(), tb_1[4].Text.Trim(), tb_2[4].Text.Trim(),
            tb[5].Text.Trim(), tb_1[5].Text.Trim(), tb_2[5].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnEdit_ClickForLCDC()
    {
        TextBox[] tb = new TextBox[1];
        TextBox[] tb_1 = new TextBox[1];
        TextBox[] tb_2 = new TextBox[1];

        for (int i = 0; i < 1; i++)
        {
            tb[i] = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString());
            tb_1[i] = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString() + "_1");
            tb_2[i] = (TextBox)this.FindControl("tbLCDC" + (i + 1).ToString() + "_2");
            if ((tb[i].Text.Trim() == "") || (tb_1[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }
        }

        if (DAL.Procedures.P_IsuseEditForLCDC.Call(int.Parse(tbIsuse_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()),
            tb[0].Text.Trim(), tb_1[0].Text.Trim(), tb_2[0].Text.Trim()) < 0)
        {
            GoError();
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    private void btnAdd_ClickForZCDC()
    {
        int DataCount = DataListZCDC.Items.Count;
        if (DataCount < 16)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "本期比赛的总场数输入有误！");
            return;
        }

        TextBox[] tb1 = new TextBox[DataCount];
        TextBox[] tb2 = new TextBox[DataCount];
        TextBox[] tb3 = new TextBox[DataCount];
        DropDownList[] ddlLetBall = new DropDownList[DataCount];
        DropDownList[] ddlLeagueType = new DropDownList[DataCount];

        string ScreeningsAndTime = "";    //构建格式：主场,客场,比赛时间|主场,客场,比赛时间|主场,客场,比赛时间
        
        for (int i = 0; i < DataCount; i++)
        {
            tb1[i] = (TextBox)(DataListZCDC.Items[i].FindControl("tb1ZCDC"));
            tb2[i] = (TextBox)(DataListZCDC.Items[i].FindControl("tb2ZCDC"));
            tb3[i] = (TextBox)(DataListZCDC.Items[i].FindControl("tb3ZCDC"));
            ddlLetBall[i] = (DropDownList)(DataListZCDC.Items[i].FindControl("ddlLetBall"));
            ddlLeagueType[i] = (DropDownList)(DataListZCDC.Items[i].FindControl("ddlLeagueType"));

            if ((tb1[i].Text.Trim() == "") || (tb2[i].Text.Trim() == "") || (tb3[i].Text.Trim() == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队名称输入不完整！");
                return;
            }

            object dt = PublicFunction.ValidLotteryTime(tb3[i].Text.Trim());
            if (dt == null)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "第 " + (i + 1).ToString() + " 场比赛球队时间输入不正确！(格式：0000-00-00 00:00:00)");
                return;
            }

            ScreeningsAndTime += ddlLeagueType[i].SelectedValue + "," + tb1[i].Text.Trim() + "," + tb2[i].Text.Trim() + "," + dt.ToString() + "," + ddlLetBall[i].SelectedValue + "|";
        }
        ScreeningsAndTime = ScreeningsAndTime.Substring(0, (ScreeningsAndTime.Length - 1));

        int Isuse_id = int.Parse(tbIsuse_id.Text);
        int return_int = 0;
        string return_str = "";
        DAL.Procedures.P_IsuseEditForZCDC.Call(int.Parse(tbLottery_id.Text), tbIsuse.Text.Trim(), System.DateTime.Parse(tbStartTime.Text.Trim()), System.DateTime.Parse(tbEndTime.Text.Trim()), DataCount, ScreeningsAndTime, Isuse_id, ref Isuse_id, ref return_str);
        if (return_int < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, return_str);
            return;
        }

        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    protected void btnBack_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("LotteryIsuse.aspx?Lottery_id=" + tbLottery_id.Text, true);
    }

    protected void DataListZCDC_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            if (e.CommandName == "btEdit")
            {
                this.DataListZCDC.EditItemIndex = e.Item.ItemIndex;
            }
            if (e.CommandName == "btUpdate")
            {
                try
                {
                    TextBox tb1 = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tb1ZCDC"));
                    TextBox tb2 = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tb2ZCDC"));
                    TextBox tb3 = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tb3ZCDC"));
                    DropDownList ddlLetBall = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlLetBall"));
                    DropDownList ddlLeagueType = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlLeagueType"));
                    HiddenField hf1 = (HiddenField)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("hfId"));

                    if ((tb1.Text.Trim() == "") || (tb2.Text.Trim() == "") || (tb3.Text.Trim() == ""))
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, "本场比赛球队名称输入不完整！");
                        return;
                    }

                    object dt = PublicFunction.ValidLotteryTime(tb3.Text.Trim());
                    if (dt == null)
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, "本场比赛球队时间输入不正确！(格式：0000-00-00 00:00:00)");
                        return;
                    }

                    int id = int.Parse(hf1.Value);
                    int Isuse_id = int.Parse(tbIsuse_id.Text);
                    int return_int = 0;
                    string return_str = "";
                    DAL.Procedures.P_IsuseEditOneForZCDC.Call(id, int.Parse(ddlLeagueType.SelectedValue), tb1.Text.Trim(), tb2.Text.Trim(), tb3.Text.Trim(), Isuse_id, ddlLeagueType.SelectedValue, ref return_int, ref return_str);
                    if (return_int < 0)
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, return_str);
                        return;
                    }

                    ShoveEL._Web.JavaScript.Alert(this.Page, "更新成功!");
                }
                catch
                {
                    GoError();
                    return;
                }

                this.DataListZCDC.EditItemIndex = -1;
            }

            BindData();
        }
    }

    protected void DataListZCDC_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            HiddenField hfTypeid = (HiddenField)(e.Item.FindControl("hfTypeid"));
            DropDownList ddlLeagueType = (DropDownList)(e.Item.FindControl("ddlLeagueType"));           

            ddlLeagueTypeDataBind(ddlLeagueType);
            DropDownListDefault(ddlLeagueType, hfTypeid.Value);

            HiddenField hfLetBall = (HiddenField)(e.Item.FindControl("hfLetBall"));
            DropDownList ddlLetBall = (DropDownList)(e.Item.FindControl("ddlLetBall"));
            DropDownListDefault(ddlLetBall, hfLetBall.Value);
        }
    }

    private void ddlLeagueTypeDataBind(DropDownList ddl)
    {
        DataTable dt = MSSQL.Select("select * from LeagueTypeForZCDC");
        if (dt == null || dt.Rows.Count == 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请先添加联赛类别！");
            return;
        }
        ddl.DataTextField = "LeagueTypeName";
        ddl.DataValueField = "id";

        ddl.DataSource = dt;
        ddl.DataBind();
    }

    private void DropDownListDefault(DropDownList ddl, string defaultValue)
    {
        foreach (ListItem item in ddl.Items)
        {
            if (item.Value == defaultValue)
            {
                item.Selected = true;
            }
        }
    }
}