﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_LotterySchemeAtTop : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindDataForLottery();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotterySchemeAtTop";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlLottery.Items.Count > 0)
            BindDataForIsuse(ddlLottery.Items[0].Value);
    }

    private void BindDataForIsuse(string Lottery_id)
    {
        DataTable dt = DAL.Tables.Isuse.Select("", "StartTime < GetDate() and Lottery_id = " + Lottery_id, "EndTime desc");

        if (dt == null)
        {
            GoError();
            return;
        }

        ddlIsuse.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlIsuse.Items.Add(new ListItem(dt.Rows[i]["Isuse"].ToString(), dt.Rows[i]["id"].ToString()));

        BindData();
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForIsuse(ddlLottery.SelectedValue);
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindData();
    }

    protected void cbUserApplication_CheckedChanged(object sender, System.EventArgs e)
    {
        BindData();
    }

    private void BindData()
    {
        if (ddlIsuse.Items.Count < 1)
            return;

        string Cmd;
        if (cbUserApplication.Checked)
            Cmd = "select * from V_SchemeSchedule where Isuse_id = " + ddlIsuse.SelectedValue + " and Quashed = 0 and LotteryBuyed = 0 and AtTopApplication = 1 order by [Money] desc";
        else
            Cmd = "select * from V_SchemeSchedule where Isuse_id = " + ddlIsuse.SelectedValue + " and Quashed = 0 and LotteryBuyed = 0 order by [Money] desc";

        DataTable dt = MSSQL.Select(Cmd);
        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[6].FindControl("cbAtTop");
            cb.CheckedChanged += new System.EventHandler(this.g_ItemCheckedChanged);
        }
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[6].FindControl("cbAtTop");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[8].Text, true);
        }
    }

    protected void g_ItemCheckedChanged(object sender, System.EventArgs e)
    {
        CheckBox cb = (CheckBox)sender;
        DataGridItem item = (DataGridItem)cb.Parent.Parent;
        int id = ShoveEL._Convert.StrToInt(item.Cells[7].Text, 0);
        bool AtTop = cb.Checked;

        if (MSSQL.ExecuteNonQuery("update Scheme set AtTop = " + (AtTop ? "1" : "0") + " where id = " + id.ToString()) < 0)
        {
            GoError();
            return;
        }

        //BindData();
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}