﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_LotterySchemeQuash : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForLottery();
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotterySchemeQuash";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindData();
    }

    private void BindData()
    {
        if (ddlLottery.Items.Count < 1)
            return;

        DataTable dt = DAL.Views.V_SchemeSchedule.Select("", "Lottery_id = " + ddlLottery.SelectedValue + " and Quashed = 0 and LotteryBuyed = 0 and (GetDate() Between StartTime and EndTime)", "[Money] desc");

        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("LotteryNumber2", System.Type.GetType("System.String"));
        dt.Columns.Add("LocateWaysAndMultiples", System.Type.GetType("System.String"));
        
        string BuyContent = "";
        string CnLocateWaysAndMultiples = "";
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            dt.Rows[i]["Money"] = double.Parse(dt.Rows[i]["Money"].ToString()).ToString("N");
            if (new Lottery()[Lottery.ZCDC.sID].CheckBuyType(int.Parse(dt.Rows[i]["Type_id"].ToString())))
            {
                dt.Rows[i]["Multiple"] = 0;
                try
                {
                    BuyContent = "";
                    CnLocateWaysAndMultiples = "";
                    if (new Lottery()[Lottery.ZCDC.sID].GetSchemeSplit(ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]), ref BuyContent, ref CnLocateWaysAndMultiples))
                    {
                        dt.Rows[i]["LotteryNumber2"] = BuyContent;
                        dt.Rows[i]["LocateWaysAndMultiples"] = CnLocateWaysAndMultiples;
                    }
                    else
                    {
                        dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                        dt.Rows[i]["LocateWaysAndMultiples"] = "<font color='red'>读取错误！</font>";
                    }
                }
                catch
                {
                    dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                    dt.Rows[i]["LocateWaysAndMultiples"] = "<font color='red'>读取错误！</font>";
                }
            }
            else
            {                    
                try
                {
                    dt.Rows[i]["LotteryNumber2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]);
                }
                catch
                {
                    dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                }
            } 
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void btnRefresh_Click(object sender, System.EventArgs e)
    {
        BindData();
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
    {
        if (e.CommandName == "btnQuash")
        {
            int InitiateUser_id = ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbInitiateUser_id")).Value, -1);
            int Scheme_id = ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbScheme_id")).Value, -1);
            if ((InitiateUser_id < 0) || (Scheme_id < 0))
            {
                GoError();
                return;
            }

            Users tu = new Users();
            tu.ID = InitiateUser_id;
            int Result = tu.GetUserInfoByID();
            if ((Result != 0) && (Result != -3))
                GoError();

            string Return = "";
            Result = tu.QuashScheme(Scheme_id, true, ref Return);
            if ((Return != "") || (Result != 0))
            {
                GoError(Return);
                return;
            }

            if (tu.ID == user.ID)
                user.GetUserBalance(ref Return);

            BindData();
            return;
        }
    }
}