﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_LotterySchemeQuery : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindDataForUser();
            BindDataForLottery();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryIsuse";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForUser()
    {
        DataTable dt = DAL.Tables.Users.Select("[id], [Name]", "SuperManagementRights = 1 or (ManagementRights = 1 and charindex('[LotteryBuy]', ManagementRightsList) >= 1)", "[id]");

        ddlUser.Items.Add(new ListItem("全部操作员", "-1"));

        foreach (DataRow dr in dt.Rows)
        {
            ddlUser.Items.Add(new ListItem(dr["Name"].ToString(), dr["id"].ToString()));
        }
    }

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused] = 1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ListLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            ListLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));
        }

        if (ListLottery.Items.Count > 0)
        {
            ListLottery.SelectedIndex = 0;
            BindDataForIsuse();
        }
    }

    private void BindDataForIsuse()
    {

        if (ListLottery.Items.Count < 1)
        {
            return;
        }

        DataTable dt = DAL.Tables.Isuse.Select("", "Lottery_id = " + ListLottery.SelectedValue + " and StartTime <= GetDate()", "EndTime desc");
        if (dt == null)
        {
            GoError();
            return;
        }

        listIsuse.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            listIsuse.Items.Add(new ListItem(dt.Rows[i]["Isuse"].ToString(), dt.Rows[i]["id"].ToString()));
        }

        if (listIsuse.Items.Count > 0)
        {
            listIsuse.SelectedIndex = 0;
            BindData();
        }
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForIsuse();
    }

    protected void listIsuse_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindData();
    }

    protected void ddlUser_SelectedIndexChanged(object sender, EventArgs e)
    {
        BindData();
    }

    private void BindData()
    {
        if (listIsuse.Items.Count < 1)
        {
            return;
        }

        int Type = 1;
        try
        {
            Type = int.Parse(this.ViewState[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "Admin_LotterySchemeQuery_Type"].ToString());
        }
        catch
        {
            Type = 1;
        }

        if ((Type < 1) || (Type > 7))
        {
            GoError();
            return;
        }

        DataTable dt = null;
        string Condition = " Isuse_id = " + listIsuse.SelectedValue;

        if (ddlUser.Enabled)
        {
            int Operator_id = int.Parse(ddlUser.SelectedValue);
            if (Operator_id >= 0)
            {
                Condition += " and BuyOperator_id = " + ddlUser.SelectedValue;
            }
        }

        switch (Type)
        {
            case 1:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " order by  [DateTime] desc");
                break;
            case 2:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and LotteryBuyed=1 order by [Money] desc");
                break;
            case 3:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and LotteryBuyed=0 order by [DateTime] desc");
                break;
            case 4:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and Quashed=1 order by [DateTime] desc");
                break;
            case 5:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and isSystemQuashed = 1 order by [DateTime] desc");
                break;
            case 6:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and WinMoney > 0 and LotteryBuyed=1 order by [DateTime] desc");
                break;
            case 7:
                dt = MSSQL.Select("select * from V_SchemeScheduleWithQuashed where " + Condition + " and WinMoney > 0 and LotteryBuyed=0 order by [DateTime] desc");
                break;
        }

        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("LotteryNumber2", typeof(System.String));

        for (int i = 0; i < dt.Rows.Count; i++)
        {
            try
            {
                dt.Rows[i]["LotteryNumber2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]);
            }
            catch
            {
                dt.Rows[i]["LotteryNumber2"] = "";
            }
            dt.AcceptChanges();
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void RadTypeClick(object sender, System.EventArgs e)
    {
        int Type = ShoveEL._Convert.StrToInt(((RadioButton)sender).ID.Substring(8, 1), 1);
        this.ViewState[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "Admin_LotterySchemeQuery_Type"] = Type;

        ddlUser.Enabled = (Type == 2);

        BindData();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            e.Item.Attributes["onmouseover"] = "this.name=this.style.backgroundColor;this.style.backgroundColor='MistyRose'";
            e.Item.Attributes["onmouseout"] = "this.style.backgroundColor=this.name;";

            e.Item.Cells[1].Text = "<a href='../Scheme.aspx?id=" + e.Item.Cells[11].Text + "' target='_blank'>" + e.Item.Cells[1].Text + "</a>";

            e.Item.Cells[2].Text = "<a href='../Score.aspx?id=" + e.Item.Cells[12].Text + "&LotteryType=" + ListLottery.SelectedValue + "' target='_blank'>" + e.Item.Cells[2].Text + "</a>";
            if (ShoveEL._Convert.StrToDouble(e.Item.Cells[10].Text, 0) > 0)
                e.Item.Cells[2].Text += "<font color=\'red\'>(保)</font>";

            double money;
            money = ShoveEL._Convert.StrToDouble(e.Item.Cells[4].Text, 0);
            e.Item.Cells[4].Text = (money == 0) ? "" : money.ToString("N");

            e.Item.ToolTip = e.Item.Cells[5].Text.Trim();
            string str = e.Item.Cells[5].Text;
            if (ShoveEL._String.StringAt(str, '\n') >= PublicFunction.GetOptionsAsInt("SchemeGridMaxLotteryNumberRows", 0))
                e.Item.Cells[5].Text = "<a href='../DownLoadSchemeFile.aspx?id=" + e.Item.Cells[11].Text + "' target='_blank'>下载方案</a>";
            else
            {
                str = e.Item.Cells[5].Text.Replace("\r\n", ", ");
                if (str.Length > 25)
                    str = str.Substring(0, 23) + "..";
                e.Item.Cells[5].Text = str;
            }
       
            int Share = ShoveEL._Convert.StrToInt(e.Item.Cells[6].Text, 1);
            e.Item.Cells[7].Text = Math.Round(money / Share, 2).ToString("N");
            e.Item.Cells[8].Text += "%";
            bool Quashed = ShoveEL._Convert.StrToBool(e.Item.Cells[13].Text, false);
            if (Quashed)
            {
                bool isSystemQuashed = ShoveEL._Convert.StrToBool(e.Item.Cells[14].Text, false);
                if (isSystemQuashed)
                    e.Item.Cells[9].Text = "<font color='blue'>系统撤单</font>";
                else
                    e.Item.Cells[9].Text = "已撤单";
            }
            else
            {
                bool isBuyed = ShoveEL._Convert.StrToBool(e.Item.Cells[18].Text, false);
                if (isBuyed)
                {
                    e.Item.Cells[9].Text = "<Font color=\'Red\'>已成功</font>";
                }
                else
                {
                    if (e.Item.Cells[8].Text == "100%")
                    {
                        e.Item.Cells[9].Text = "<Font color=\'Red\'>满员</font>";
                    }
                    else
                    {
                        e.Item.Cells[9].Text = "未满";
                    }
                }
            }
        }
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}
