﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_LotteryTimeSet : AdminPage
{
    public int PreLotteryID = -1;
    public Color PreLotteryColor = Color.Linen;

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryIsuse";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = DAL.Views.V_LotteryBuyType.Select("", "[isUsed]=1", "[Sort],[id]");
        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            TextBox tb1 = (TextBox)e.Item.Cells[2].FindControl("tbSystemEndAheadMinute");
            tb1.Text = e.Item.Cells[8].Text;

            TextBox tb2 = (TextBox)e.Item.Cells[3].FindControl("tbChaseExecuteDeferMinute");
            tb2.Text = e.Item.Cells[9].Text;

            bool CanChase = ShoveEL._Convert.StrToBool(e.Item.Cells[7].Text, false);
            if ((!CanChase) || (e.Item.Cells[1].Text.IndexOf("追号") < 0))
                tb2.Visible = false;

            int RowLotteryID = ShoveEL._Convert.StrToInt(e.Item.Cells[6].Text, -1);
            if (RowLotteryID != PreLotteryID)
            {
                PreLotteryID = RowLotteryID;
                if (PreLotteryColor.Name == Color.Linen.Name)
                    PreLotteryColor = Color.White;
                else
                    PreLotteryColor = Color.Linen;
            }

            e.Item.BackColor = PreLotteryColor;
            tb1.BackColor = PreLotteryColor;
            tb2.BackColor = PreLotteryColor;
        }
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
    {
        if (e.CommandName == "btnOK")
        {
            int id = ShoveEL._Convert.StrToInt(e.Item.Cells[5].Text, -1);
            int Lottery_id = ShoveEL._Convert.StrToInt(e.Item.Cells[6].Text, -1);

            int SystemEndAheadMinute = ShoveEL._Convert.StrToInt(((TextBox)e.Item.Cells[2].FindControl("tbSystemEndAheadMinute")).Text, -1);
            int ChaseExecuteDeferMinute = ShoveEL._Convert.StrToInt(((TextBox)e.Item.Cells[3].FindControl("tbChaseExecuteDeferMinute")).Text, -1);

            if (SystemEndAheadMinute < 2)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "用户提前截止分钟数最少必须 2 分钟，否则系统执行可能会因时间过短而不能及时处理，导致数据错误！");
                return;
            }

            bool CanChase = ShoveEL._Convert.StrToBool(e.Item.Cells[7].Text, false);

            if (CanChase && (e.Item.Cells[1].Text.IndexOf("追号") >= 0))
            {
                if (ChaseExecuteDeferMinute < 1)
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "追号任务自动执行必须在开始时间后最少 1 分钟！");
                    return;
                }
            }

            if (DAL.Tables.LotteryBuyType.Update("[id] = " + id.ToString(), -1, false, -1, false, "", false, SystemEndAheadMinute, true, "", false) < 0)
            {
                GoError();
                return;
            }

            if (CanChase && (e.Item.Cells[1].Text.IndexOf("追号") >= 0))
            {
                if (MSSQL.ExecuteNonQuery("update Lottery set ChaseExecuteDeferMinute = " + ChaseExecuteDeferMinute.ToString() + " where [id] = " + Lottery_id.ToString()) < 0)
                {
                    GoError();
                    return;
                }
            }

            BindData();

            return;
        }
    }
}