﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_LotteryWinAfficheEdit : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            BindDataForLottery();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryWin";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlLottery.Items.Count > 0)
            BindDataForIsuse(ddlLottery.Items[0].Value);
    }

    private void BindDataForIsuse(string Lottery_id)
    {
        DataTable dt = DAL.Tables.Isuse.Select("[id], Isuse", "Lottery_id = " + ddlLottery.SelectedValue + " and EndTime < GetDate() and IsOpen = 1", "EndTime");

        if (dt == null)
        {
            GoError();
            return;
        }

        ddlIsuse.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlIsuse.Items.Add(new ListItem(dt.Rows[i]["Isuse"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlIsuse.Items.Count > 0)
        {
            ddlIsuse_SelectedIndexChanged(ddlIsuse, new System.EventArgs());

            btnOK.Enabled = true;
            tbOpenAffiche.ReadOnly = false;
        }
        else
        {
            btnOK.Enabled = false;
            tbOpenAffiche.ReadOnly = true;
        }
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForIsuse(ddlLottery.SelectedValue);
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        object oValue = MSSQL.ExecuteScalar("select OpenAffiche from Isuse where [id] = " + ddlIsuse.SelectedValue);

        if (oValue == null)
        {
            tbOpenAffiche.Text = new Lottery().GetOpenAfficheTemplate(int.Parse(ddlLottery.SelectedValue));
            return;
        }

        string str = "";
        try
        {
            str = ShoveEL._String.Decompress((byte[])oValue);
        }
        catch { }

        if (str == "")
        {
            tbOpenAffiche.Text = new Lottery().GetOpenAfficheTemplate(int.Parse(ddlLottery.SelectedValue));
        }
        else
        {
            tbOpenAffiche.Text = str;
        }
    }

    protected void btnOK_Click(object sender, EventArgs e)
    {
        ShoveEL.Database.MSSQL.ExecuteNonQuery("update Isuse set OpenAffiche = @p1 where [id] = " + ddlIsuse.SelectedValue,
            new ShoveEL.Database.MSSQL.Parameter("p1", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbOpenAffiche.Text)));
    }
}
