﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_LotteryWinImageUpLoad : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    protected void btnGO_Click(object sender, System.EventArgs e)
    {
        if (fileImage.Value.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请选择一个图片文件！");
            return;
        }

        if (tbSchemeNumber.Text.Trim() != "")
        {
            GO_Click_2();
            return;
        }

        string Photo = "";
        if (ShoveEL._IO.File.UploadFile(this.Page, fileImage, "../Images/Lottery/Win/", ref Photo, true) != 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "文件上传错误！");
            return;
        }
        else
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "文件上传成功。");
            return;
        }
    }

    private void GO_Click_2()
    {
        string SchemeNumber = tbSchemeNumber.Text.Trim();
        string LotteryCode = tbLotteryCode.Text.Trim();

        if (LotteryCode == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "您指定了该彩票图片文件所属的方案号，但没有输入其标识号。");
            return;
        }

        DataTable dt = DAL.Tables.Scheme.Select("", "SchemeNumber='" + SchemeNumber + "'", "");
        if (dt == null)
        {
            GoError();
            return;
        }

        if (dt.Rows.Count < 1)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "方案号不存在。");
            return;
        }

        DataRow dr = dt.Rows[0];
        if (!ShoveEL._Convert.StrToBool(dr["LotteryBuyed"].ToString(), false))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "该方案号没有出票。");
            return;
        }

        if (ShoveEL._IO.File.UploadFile(this.Page, fileImage, "../Images/Lottery/Win/", LotteryCode + ".jpg", true) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "文件上传错误。");
            return;
        }

        ShoveEL.Database.MSSQL.ExecuteNonQuery("update Scheme set LotteryCode = @p1 where [SchemeNumber] = @p2",
            new ShoveEL.Database.MSSQL.Parameter("p1", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(LotteryCode)),
            new ShoveEL.Database.MSSQL.Parameter("p2", SqlDbType.VarChar, 0, ParameterDirection.Input, SchemeNumber));

        ShoveEL._Web.JavaScript.Alert(this.Page, "文件上传成功！");
    }
}