﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_LotteryWinManual : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForLottery();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "LotteryWin";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));
        }

        if (ddlLottery.Items.Count > 0)
        {
            BindDataForIsuse(ddlLottery.Items[0].Value);
        }
    }

    private void BindDataForIsuse(string Lottery_id)
    {
        DataTable dt = DAL.Tables.Isuse.Select("[id], Isuse", "Lottery_id = " + ddlLottery.SelectedValue + " and EndTime < GetDate() and IsOpen = 0", "EndTime");
        if (dt == null)
        {
            GoError();
            return;
        }

        ddlIsuse.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
            ddlIsuse.Items.Add(new ListItem(dt.Rows[i]["Isuse"].ToString(), dt.Rows[i]["id"].ToString()));

        if (ddlIsuse.Items.Count > 0)
        {
            ddlIsuse_SelectedIndexChanged(ddlIsuse, new System.EventArgs());

            if (ddlIsuse.SelectedValue == Lottery.ZCDC.sID)
            {
                Label1.Visible = false;
                tbWinLotteryNumber.Visible = false;
                lbTipLotteryNumber.Visible = false;
                tbWinLotteryNumber.Enabled = true;
                lbTipLotteryNumber.Visible = true;
                btnEnd.Enabled = true;
                tbOpenAffiche.ReadOnly = false;
            }
            else
            {
                Label1.Visible = true;
                tbWinLotteryNumber.Visible = true;
                lbTipLotteryNumber.Visible = true;
                tbWinLotteryNumber.Enabled = true;
                lbTipLotteryNumber.Visible = true;
                btnEnd.Enabled = true;
                tbOpenAffiche.ReadOnly = false;
            }
        }
        else
        {
            Label1.Visible = true;
            tbWinLotteryNumber.Visible = true;
            lbTipLotteryNumber.Visible = true;
            tbWinLotteryNumber.Enabled = false;
            lbTipLotteryNumber.Visible = false;
            btnEnd.Enabled = false;
            tbOpenAffiche.ReadOnly = true;
        }
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindDataForIsuse(ddlLottery.SelectedValue);
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindData();

        // 填充下面的开奖结束的内容

        string WinLotteryNumber = "";
        try
        {
            WinLotteryNumber = Convert.ToString(MSSQL.ExecuteScalar("select WinLotteryNumber from Isuse where [id] = " + ddlIsuse.SelectedValue));
        }
        catch
        { }

        tbWinLotteryNumber.Text = WinLotteryNumber;
        lbTipLotteryNumber.Text = "格式：" + GetWinLotteryNumberTip(int.Parse(ddlLottery.SelectedValue));
        tbOpenAffiche.Text = new Lottery().GetOpenAfficheTemplate(int.Parse(ddlLottery.SelectedValue));
    }

    private void BindData()
    {
        if ((ddlLottery.Items.Count < 1) || (ddlIsuse.Items.Count < 1))
            return;

        DataTable dt = DAL.Views.V_Scheme.Select("", "Isuse_id = " + ddlIsuse.SelectedValue + " and LotteryBuyed = 1 and WinMoney = 0", "");
        if (dt == null)
        {
            GoError();
            return;
        }

        dt.Columns.Add("LotteryNumber2", System.Type.GetType("System.String"));
        dt.Columns.Add("LocateWaysAndMultiples", System.Type.GetType("System.String"));

        if (ddlIsuse.SelectedValue == Lottery.ZCDC.sID)
        {            
            string BuyContent = "";
            string CnLocateWaysAndMultiples = "";

            for (int i = 0; i < dt.Rows.Count; i++)
            {
                dt.Rows[i]["Money"] = double.Parse(dt.Rows[i]["Money"].ToString()).ToString("N");
                dt.Rows[i]["Multiple"] = 0;
                try
                {
                    BuyContent = "";
                    CnLocateWaysAndMultiples = "";

                    if (new Lottery()[Lottery.ZCDC.sID].GetSchemeSplit(ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]), ref BuyContent, ref CnLocateWaysAndMultiples))
                    {
                        dt.Rows[i]["LotteryNumber2"] = BuyContent;
                        dt.Rows[i]["LocateWaysAndMultiples"] = CnLocateWaysAndMultiples;
                    }
                    else
                    {
                        dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                        dt.Rows[i]["LocateWaysAndMultiples"] = "<font color='red'>读取错误！</font>";
                    }
                }
                catch
                {
                    dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                    dt.Rows[i]["LocateWaysAndMultiples"] = "<font color='red'>读取错误！</font>";
                }
                
                dt.AcceptChanges();
            }
        }
        else
        {
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                dt.Rows[i]["Money"] = double.Parse(dt.Rows[i]["Money"].ToString()).ToString("N");
                try
                {
                    dt.Rows[i]["LotteryNumber2"] = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]);
                }
                catch
                {
                    dt.Rows[i]["LotteryNumber2"] = "<font color='red'>读取错误！</font>";
                }
                dt.AcceptChanges();
            }
        }

        g.DataSource = dt.DefaultView;
        g.DataBind();
    }

    protected void g_PageIndexChanged(object sender, System.EventArgs e)
    {
        BindData();
    }

    private string GetWinLotteryNumberTip(int Lottery_id)
    {
        return DAL.Functions.F_GetWinLotteryExemple.Call(Lottery_id);
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataListCommandEventArgs e)
    {
        if (e.CommandName == "btnWin")
        {
            double WinMoney = ShoveEL._Convert.StrToDouble(((TextBox)e.Item.FindControl("tbWinMoney")).Text, 0);
            double WinMoneyNoWithTax = ShoveEL._Convert.StrToDouble(((TextBox)e.Item.FindControl("tbWinMoneyNoWithTax")).Text, 0);
            string WinDescription = ((TextBox)e.Item.FindControl("tbWinDescription")).Text.Trim();
            int Scheme_id = ShoveEL._Convert.StrToInt(((HtmlInputHidden)e.Item.FindControl("tbScheme_id")).Value, -1);

            if (Scheme_id < 1)
            {
                GoError();
                return;
            }

            if ((WinMoney <= 0) || (WinMoneyNoWithTax <= 0) || (WinDescription == ""))
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "输入不完整。");
                return;
            }

            string Return = "";
            DataSet ds = DAL.Procedures.P_SchemeWinDispense.Open(Scheme_id, WinMoney, WinMoneyNoWithTax,
                PublicFunction.GetOptionsAsInt("InitiateSchemeCommissionScale", 0), ShoveEL._String.Compress(WinDescription), user.ID, ref Return);

            if ((ds == null) || (ds.Tables.Count < 1))
            {
                GoError("数据读写错误");
                return;
            }
            if (Return != "")
            {
                GoError(Return);
                return;
            }

            BindData();

            DataTable dt = ds.Tables[0];
            if (dt.Rows.Count < 1)
                return;

            //发邮件、短信、信使等
            bool isWinSendEmail = PublicFunction.GetOptionsAsBoolean("isWinSendEmail", false);
            bool isWinSendMobileMessage = PublicFunction.GetOptionsAsBoolean("isWinSendMobileMessage", false);
            bool isWinSendMessage = PublicFunction.GetOptionsAsBoolean("isWinSendMessage", false);

            if ((!isWinSendEmail) && (!isWinSendMobileMessage) && (!isWinSendMessage))
                return;

            string Old_EmailSubject = "", Old_EmailBody = "";
            if (isWinSendEmail)
                PublicFunction.GetEmailTemplate("../Template/Email/Win.txt", ref Old_EmailSubject, ref Old_EmailBody);

            string Old_MobileMessageBody = "";
            if (isWinSendMobileMessage)
                Old_MobileMessageBody = PublicFunction.GetMobileMessageTemplate("../Template/MobileMessage/Win.txt");

            string Old_MessageBody = "";
            if (isWinSendMessage)
                Old_MessageBody = PublicFunction.GetMessageTemplate("../Template/Message/Win.txt");

            for (int j = 0; j < dt.Rows.Count; j++)
            {
                DataRow dr = dt.Rows[j];
                Users tu = new Users();
                tu.ID = int.Parse(dr["User_id"].ToString());
                int Result = tu.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                    continue;

                //Send Email...
                if ((isWinSendEmail) && (tu.isAcceptEmail) && (tu.Email != "") && (Old_EmailSubject != "") && (Old_EmailBody != ""))
                {
                    string EmailSubject = Old_EmailSubject.Replace("[UserName]", tu.Name);
                    string EmailBody = Old_EmailBody.Replace("[UserName]", tu.Name).
                        Replace("[Scheme_id]", dr["Scheme_id"].ToString()).
                        Replace("[Money]", double.Parse(dr["WinMoney"].ToString()).ToString("N"));
                    PublicFunction.SendEmail(tu.Email, EmailSubject, EmailBody);
                }

                //Send MobileMessage.......................
                if (isWinSendMobileMessage && (tu.Mobile != "") && tu.MobileValid && tu.isAcceptMobileMessage && tu.GetIsAcceptMobileMessage("Win") && (Old_MobileMessageBody != ""))
                {
                    string MobileMessageBody = Old_MobileMessageBody.Replace("[UserName]", tu.Name).
                        Replace("[Scheme_id]", dr["Scheme_id"].ToString()).
                        Replace("[Money]", double.Parse(dr["WinMoney"].ToString()).ToString("N"));
                    new JL_ISP().SendMessage(tu.Mobile, MobileMessageBody, "", tu.ID);
                }

                //Send Message.......................
                if (isWinSendMessage && tu.isAcceptMessage && (Old_MessageBody != ""))
                {
                    string MessageBody = Old_MessageBody.Replace("[UserName]", tu.Name).
                        Replace("[Scheme_id]", dr["Scheme_id"].ToString()).
                        Replace("[Money]", double.Parse(dr["WinMoney"].ToString()).ToString("N"));

                    DAL.Tables.Message.Insert(1, true, tu.ID, true, 1, true, ShoveEL._String.Compress(MessageBody), true, System.DateTime.Now, false, true, false);
                }
            }

            return;
        }
    }

    protected void btnEnd_Click(object sender, System.EventArgs e)
    {
        string WinLotteryNumber = tbWinLotteryNumber.Text.Trim();
        if (ddlIsuse.SelectedValue != Lottery.ZCDC.sID)
        {
            if (WinLotteryNumber == "")
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "请输入开奖号码。");
                return;
            }
        }

        //if (!new Lottery()[int.Parse(ddlLottery.SelectedValue)].AnalyseWinNumber(WinLotteryNumber))
        //{
        //    ShoveEL._Web.JavaScript.Alert(this.Page, "开奖号码不正确！");
        //    return;
        //}

        ShoveEL.Database.MSSQL.ExecuteNonQuery("update Isuse set IsOpen = 1, WinLotteryNumber = @p1, OpenAffiche = @p2 where [id] = " + ddlIsuse.SelectedValue,
            new ShoveEL.Database.MSSQL.Parameter("p1", SqlDbType.VarChar, 0, ParameterDirection.Input, WinLotteryNumber),
            new ShoveEL.Database.MSSQL.Parameter("p2", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbOpenAffiche.Text)));

        BindDataForIsuse(ddlLottery.SelectedValue);
    }
}