﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using System.Text.RegularExpressions;
using ShoveEL.Database;


public partial class Admin_LotteryWinNumber : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            BindDataForLottery();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindDataForLottery()
    {
        DataTable dt = ShoveEL._Web.Cache.GetCacheAsDataTable("Lottery");

        if (dt == null)
        {
            dt = DAL.Tables.Lottery.Select("", "[Isused]=1", "[Sort]");
            if (dt == null)
            {
                GoError();
                return;
            }

            ShoveEL._Web.Cache.SetCache("Lottery", dt);
        }

        ddlLottery.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            ddlLottery.Items.Add(new ListItem(dt.Rows[i]["Name"].ToString(), dt.Rows[i]["id"].ToString()));
        }

        if (ddlLottery.Items.Count > 0)
        {
            ddlLottery_SelectedIndexChanged(ddlLottery, new System.EventArgs());
        }
        else
        {
            btnGO.Enabled = false;
            tbWinNumber.Enabled = false;
        }
    }

    private void BindDataForIsuse()
    {
        DataTable dt;
        if (ddlLottery.SelectedValue == Lottery.ZCDC.sID)
        {
            dt = DAL.Tables.Isuse.Select("[id], [Isuse]", "Lottery_id = " + ddlLottery.SelectedValue + " and IsOpen = 0", "EndTime");
        }
        else
        {
            dt = DAL.Tables.Isuse.Select("[id], [Isuse]", "Lottery_id = " + ddlLottery.SelectedValue + " and EndTime < GetDate() and IsOpen = 0", "EndTime");
        }

        if (dt == null)
        {
            GoError();
            return;
        }

        ddlIsuse.Items.Clear();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            ddlIsuse.Items.Add(new ListItem(dt.Rows[i]["Isuse"].ToString(), dt.Rows[i]["id"].ToString()));
        }

        if (ddlIsuse.Items.Count > 0)
        {
            if (ddlLottery.SelectedValue == Lottery.ZCDC.sID)
            {
                BindData();

                WinNumberZCDC.Visible = true;
                WinNumberOther.Visible = false;
                btnGO.Visible = false;
                btnGO.Enabled = false;
            }
            else
            {
                WinNumberZCDC.Visible = false;
                WinNumberOther.Visible = true;
                btnGO.Visible = true;
                btnGO.Enabled = true;
                tbWinNumber.Enabled = true;
            }
        }
        else
        {
            WinNumberZCDC.Visible = false;
            WinNumberOther.Visible = true;
            btnGO.Visible = true;
            btnGO.Enabled = false;
            tbWinNumber.Enabled = false;
        }
    }

    protected void ddlLottery_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        string WinLotteryExemple = "格式：" + DAL.Functions.F_GetWinLotteryExemple.Call(int.Parse(ddlLottery.SelectedValue));
        labTip.Text = WinLotteryExemple;
        tbWinNumber.MaxLength = WinLotteryExemple.Length - 3;

        BindDataForIsuse();
    }

    protected void ddlIsuse_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        //Check is OpenWined
        bool IsOpen = true;
        try
        {
            IsOpen = Convert.ToBoolean(MSSQL.ExecuteScalar("select IsOpen from Isuse where [id] = " + ddlIsuse.SelectedValue));
        }
        catch { }

        if (IsOpen)
        {
            btnGO.Enabled = false;
            tbWinNumber.Enabled = false;
            GoError("此期已经开奖了，不能修改中奖号码。");
            return;
        }

        if (ddlLottery.SelectedValue == Lottery.ZCDC.sID)
        {
            BindData();

            WinNumberZCDC.Visible = true;
            WinNumberOther.Visible = false;
            btnGO.Visible = false;
            btnGO.Enabled = false;
        }
        else
        {
            WinNumberZCDC.Visible = false;
            WinNumberOther.Visible = true;
            btnGO.Visible = true;
            btnGO.Enabled = true;
            tbWinNumber.Enabled = true;
        }
    }

    protected void btnGO_Click(object sender, System.EventArgs e)
    {
        tbWinNumber.Text = tbWinNumber.Text.Trim();

        if (!new Lottery()[int.Parse(ddlLottery.SelectedValue)].AnalyseWinNumber(tbWinNumber.Text))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "中奖号码不正确！");
            return;
        }

        if (DAL.Tables.Isuse.Update("[id] = " + ddlIsuse.SelectedValue, -1, false, "", false, System.DateTime.Now, false,
            System.DateTime.Now, false, false, false, tbWinNumber.Text, true, null, false, false, false) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "数据读写失败。");
            return;
        }

        ShoveEL._Web.JavaScript.Alert(this.Page, "中奖号码填写成功。");
    }

    protected void DataListZCDC_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            if (e.CommandName == "btEdit")
            {
                this.DataListZCDC.EditItemIndex = e.Item.ItemIndex;
            }

            if (e.CommandName == "btUpdate")
            {
                if (e.Item.ItemType == ListItemType.EditItem)
                {
                    string GameResult = "";
                    string HalftimeResult = "";
                    string TmpGameResult = "";
                    string TmpHalftimeResult = "";
                    string TmpBQCResult = "";
                    string LetBall = "0";
                    string SPFResult = "";
                    string ZJQResult = "";
                    string SXDSResult = "";
                    string ZQBFResult = "";
                    string BQCSPFResult = "";
                    double SPFSpResult = 0;
                    double ZJQSpResult = 0;
                    double SXDSSpResult = 0;
                    double ZQBFSpResult = 0;
                    double BQCSPFSpResult = 0;
                    int TmpZJQ = 0;

                    CheckBox cbResultDelay = (CheckBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("cbResultDelay"));
                    HiddenField hfId = (HiddenField)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("hfId"));

                    if (cbResultDelay.Checked)
                    {
                        GameResult = "*";
                        HalftimeResult = "*";
                        SPFResult = "*";
                        ZJQResult = "*";
                        SXDSResult = "*";
                        ZQBFResult = "*";
                        BQCSPFResult = "*";
                        SPFSpResult = 1;
                        ZJQSpResult = 1;
                        SXDSSpResult = 1;
                        ZQBFSpResult = 1;
                        BQCSPFSpResult = 1;
                    }
                    else
                    {
                        DropDownList ddlLetBall = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlLetBall"));
                        DropDownList ddlGame1 = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlGame1"));
                        DropDownList ddlGame2 = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlGame2"));
                        DropDownList ddlHalftime1 = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlHalftime1"));
                        DropDownList ddlHalftime2 = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlHalftime2"));
                        DropDownList ddlZQBF = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlZQBF"));
                        DropDownList ddlBQCSPF = (DropDownList)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("ddlBQCSPF"));
                        TextBox tbSPFSp = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tbSPFSp"));
                        TextBox tbZJQSp = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tbZJQSp"));
                        TextBox tbSXDSSp = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tbSXDSSp"));
                        TextBox tbZQBFSp = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tbZQBFSp"));
                        TextBox tbBQCSPFSp = (TextBox)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("tbBQCSPFSp"));


                        GameResult = ddlGame1.SelectedValue + ":" + ddlGame2.SelectedValue;
                        HalftimeResult = ddlHalftime1.SelectedValue + ":" + ddlHalftime2.SelectedValue;
                        LetBall = ddlLetBall.SelectedValue;

                        if ((int.Parse(ddlGame1.SelectedValue) - int.Parse(ddlLetBall.SelectedValue)) > int.Parse(ddlGame2.SelectedValue))
                        {
                            SPFResult = "3";
                        }
                        else if ((int.Parse(ddlGame1.SelectedValue) - int.Parse(ddlLetBall.SelectedValue)) == int.Parse(ddlGame2.SelectedValue))
                        {
                            SPFResult = "1";
                        }
                        else
                        {
                            SPFResult = "0";
                        }

                        TmpZJQ = int.Parse(ddlGame1.SelectedValue) + int.Parse(ddlGame2.SelectedValue);

                        if (TmpZJQ >= 7)
                        {
                            ZJQResult = "7";
                        }
                        else
                        {
                            ZJQResult = TmpZJQ.ToString();
                        }

                        if (TmpZJQ >= 3)
                        {
                            if ((TmpZJQ % 2) != 0)
                            {
                                SXDSResult = "1";
                            }
                            else
                            {
                                SXDSResult = "2";
                            }
                        }
                        else
                        {
                            if ((TmpZJQ % 2) != 0)
                            {
                                SXDSResult = "3";
                            }
                            else
                            {
                                SXDSResult = "4";
                            }
                        }

                        if (int.Parse(ddlGame1.SelectedValue) > int.Parse(ddlGame2.SelectedValue))
                        {
                            if (int.Parse(ddlGame1.SelectedValue) > 4)
                            {
                                if (ShoveEL._Convert.StrToInt(ddlZQBF.SelectedValue, -1) != 10)
                                {
                                    ShoveEL._Web.JavaScript.Alert(this.Page, "请正确选择本场比赛的正确比分结果！");
                                    return;
                                }

                                ZQBFResult = ddlZQBF.SelectedValue;
                            }
                            else
                            {
                                if (ddlZQBF.SelectedItem.Text != GameResult)
                                {
                                    ShoveEL._Web.JavaScript.Alert(this.Page, "请正确选择本场比赛的正确比分结果！");
                                    return;
                                }

                                ZQBFResult = ddlZQBF.SelectedValue;
                            }
                        }
                        else if (int.Parse(ddlGame1.SelectedValue) == int.Parse(ddlGame2.SelectedValue))
                        {
                            if (int.Parse(ddlGame1.SelectedValue) > 3)
                            {
                                if (ShoveEL._Convert.StrToInt(ddlZQBF.SelectedValue, -1) != 15)
                                {
                                    ShoveEL._Web.JavaScript.Alert(this.Page, "请正确选择本场比赛的正确比分结果！");
                                    return;
                                }

                                ZQBFResult = ddlZQBF.SelectedValue;
                            }
                            else
                            {
                                if (ddlZQBF.SelectedItem.Text != GameResult)
                                {
                                    ShoveEL._Web.JavaScript.Alert(this.Page, "请正确选择本场比赛的正确比分结果！");
                                    return;
                                }

                                ZQBFResult = ddlZQBF.SelectedValue;
                            }
                        }
                        else
                        {
                            if (int.Parse(ddlGame2.SelectedValue) > 4)
                            {
                                if (ShoveEL._Convert.StrToInt(ddlZQBF.SelectedValue, -1) != 25)
                                {
                                    ShoveEL._Web.JavaScript.Alert(this.Page, "请正确选择本场比赛的正确比分结果！");
                                    return;
                                }

                                ZQBFResult = ddlZQBF.SelectedValue;
                            }
                            else
                            {
                                if (ddlZQBF.SelectedItem.Text != GameResult)
                                {
                                    ShoveEL._Web.JavaScript.Alert(this.Page, "请正确选择本场比赛的正确比分结果！");
                                    return;
                                }

                                ZQBFResult = ddlZQBF.SelectedValue;
                            }
                        }

                        if (int.Parse(ddlHalftime1.SelectedValue) > int.Parse(ddlHalftime2.SelectedValue))
                        {
                            TmpHalftimeResult = "胜";
                        }
                        else if (int.Parse(ddlHalftime1.SelectedValue) == int.Parse(ddlHalftime2.SelectedValue))
                        {
                            TmpHalftimeResult = "平";
                        }
                        else
                        {
                            TmpHalftimeResult = "负";
                        }

                        if (int.Parse(ddlGame1.SelectedValue) > int.Parse(ddlGame2.SelectedValue))
                        {
                            TmpGameResult = "胜";
                        }
                        else if (int.Parse(ddlGame1.SelectedValue) == int.Parse(ddlGame2.SelectedValue))
                        {
                            TmpGameResult = "平";
                        }
                        else
                        {
                            TmpGameResult = "负";
                        }

                        TmpBQCResult = TmpHalftimeResult + "-" + TmpGameResult;

                        if (ddlBQCSPF.SelectedItem.Text != TmpBQCResult)
                        {
                            ShoveEL._Web.JavaScript.Alert(this.Page, "请正确选择本场比赛半全场胜平负的结果！");
                            return;
                        }

                        BQCSPFResult = ddlBQCSPF.SelectedValue;

                        if (ShoveEL._Convert.StrToDouble(tbSPFSp.Text.Trim(), -1) < 0)
                        {
                            ShoveEL._Web.JavaScript.Alert(this.Page, "请正确输入全场比赛胜平负的SP结果值！");
                            return;
                        }

                        if (ShoveEL._Convert.StrToDouble(tbZJQSp.Text.Trim(), -1) < 0)
                        {
                            ShoveEL._Web.JavaScript.Alert(this.Page, "请正确输入全场比赛总进球的SP结果值！");
                            return;
                        }

                        if (ShoveEL._Convert.StrToDouble(tbSXDSSp.Text.Trim(), -1) < 0)
                        {
                            ShoveEL._Web.JavaScript.Alert(this.Page, "请正确输入全场比赛上下单双的SP结果值！");
                            return;
                        }

                        if (ShoveEL._Convert.StrToDouble(tbZQBFSp.Text.Trim(), -1) < 0)
                        {
                            ShoveEL._Web.JavaScript.Alert(this.Page, "请正确输入全场比赛正确比分的SP结果值！");
                            return;
                        }

                        if (ShoveEL._Convert.StrToDouble(tbBQCSPFSp.Text.Trim(), -1) < 0)
                        {
                            ShoveEL._Web.JavaScript.Alert(this.Page, "请正确输入本场比赛半全场胜平负的SP结果值！");
                            return;
                        }

                        SPFSpResult = ShoveEL._Convert.StrToDouble(tbSPFSp.Text.Trim(), 0);
                        ZJQSpResult = ShoveEL._Convert.StrToDouble(tbZJQSp.Text.Trim(), 0);
                        SXDSSpResult = ShoveEL._Convert.StrToDouble(tbSXDSSp.Text.Trim(), 0);
                        ZQBFSpResult = ShoveEL._Convert.StrToDouble(tbZQBFSp.Text.Trim(), 0);
                        BQCSPFSpResult = ShoveEL._Convert.StrToDouble(tbBQCSPFSp.Text.Trim(), 0);
                    }

                    int id = int.Parse(hfId.Value);
                    int return_int = 0;
                    string return_str = "";
                    DAL.Procedures.P_IsuseInsertOneResultForZCDC.Call(id, HalftimeResult, GameResult, LetBall, SPFResult, SPFSpResult, ZJQResult, ZJQSpResult, SXDSResult, SXDSSpResult, ZQBFResult, ZQBFSpResult, BQCSPFResult, BQCSPFSpResult, ref return_int, ref return_str);
                    if (return_int < 0)
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, return_str);
                        return;
                    }

                    ShoveEL._Web.JavaScript.Alert(this.Page, "更新成功!");
                }

                this.DataListZCDC.EditItemIndex = -1;
            }

            if (e.CommandName == "btOpenWin")
            {
                if (e.Item.ItemType == ListItemType.EditItem)
                {
                    Label lbZCDC = (Label)(DataListZCDC.Items[e.Item.ItemIndex].FindControl("lbZCDC"));

                    DataTable dtCompetitionCount = MSSQL.Select("select * from IsuseForZCDC where Isuse_id = " + ddlIsuse.SelectedValue + " order by [NO]");

                    if ((dtCompetitionCount == null) || (dtCompetitionCount.Rows.Count < 1))
                    {
                        GoError();
                        return;
                    }

                    int CompetitionCount = dtCompetitionCount.Rows.Count;

                    DataTable dtWinNumber = MSSQL.Select("select * from IsuseForZCDC where Isuse_id = " + ddlIsuse.SelectedValue + " and [NO] <= " + lbZCDC.Text + " order by [NO]");
                    if ((dtWinNumber == null) || (dtWinNumber.Rows.Count < 1))
                    {
                        GoError();
                        return;
                    }

                    int NowCompetitionCount = dtWinNumber.Rows.Count;
                    #region     构建开奖号码串
                    string WinNumberList = "";  //最终开奖号码

                    string WinNumberSPFList = "";
                    string WinNumberZJQList = "";
                    string WinNumberSXDSList = "";
                    string WinNumberZQBFList = "";
                    string WinNumberBQCSPFList = "";
                    for (int i = 0; i < NowCompetitionCount; i++)
                    {
                        if (dtWinNumber.Rows[i]["Result"].ToString() == "" || dtWinNumber.Rows[i]["SPFResult"].ToString() == "" || dtWinNumber.Rows[i]["SPFSp"].ToString() == "")
                        {
                            ShoveEL._Web.JavaScript.Alert(this.Page, "第" + dtWinNumber.Rows[i]["No"].ToString() + "场比赛的彩果没有输入！请先输入！！");
                            return;
                        }

                        WinNumberSPFList += dtWinNumber.Rows[i]["No"].ToString() + "(" + dtWinNumber.Rows[i]["SPFResult"].ToString() + "," + dtWinNumber.Rows[i]["SPFSp"].ToString() + ")|";
                        WinNumberZJQList += dtWinNumber.Rows[i]["No"].ToString() + "(" + dtWinNumber.Rows[i]["ZJQResult"].ToString() + "," + dtWinNumber.Rows[i]["ZJQSp"].ToString() + ")|";
                        WinNumberSXDSList += dtWinNumber.Rows[i]["No"].ToString() + "(" + dtWinNumber.Rows[i]["SXDSResult"].ToString() + "," + dtWinNumber.Rows[i]["SXDSSp"].ToString() + ")|";
                        WinNumberZQBFList += dtWinNumber.Rows[i]["No"].ToString() + "(" + dtWinNumber.Rows[i]["ZQBFResult"].ToString() + "," + dtWinNumber.Rows[i]["ZQBFSp"].ToString() + ")|";
                        WinNumberBQCSPFList += dtWinNumber.Rows[i]["No"].ToString() + "(" + dtWinNumber.Rows[i]["BQCSPFResult"].ToString() + "," + dtWinNumber.Rows[i]["BQCSPFSp"].ToString() + ")|";
                    }
                    WinNumberSPFList = WinNumberSPFList.Substring(0, WinNumberSPFList.Length - 1);
                    WinNumberZJQList = WinNumberZJQList.Substring(0, WinNumberZJQList.Length - 1);
                    WinNumberSXDSList = WinNumberSXDSList.Substring(0, WinNumberSXDSList.Length - 1);
                    WinNumberZQBFList = WinNumberZQBFList.Substring(0, WinNumberZQBFList.Length - 1);
                    WinNumberBQCSPFList = WinNumberBQCSPFList.Substring(0, WinNumberBQCSPFList.Length - 1);

                    WinNumberList = WinNumberSPFList + ";" + WinNumberZJQList + ";" + WinNumberSXDSList + ";" + WinNumberZQBFList + ";" + WinNumberBQCSPFList;
                    #endregion

                    if (!new Lottery()[int.Parse(ddlLottery.SelectedValue)].AnalyseWinNumber(WinNumberList, dtWinNumber.Rows.Count))
                    {
                        ShoveEL._Web.JavaScript.Alert(this.Page, "开奖号码不正确！");
                        return;
                    }

                    DataTable dt = MSSQL.Select("select a.[id], a.Type_id, a.LotteryNumber, a.Multiple, b.BuyType_id from Scheme a left join V_ChaseDetail b on a.id = b.Scheme_id where (a.Isuse_id = " + ddlIsuse.SelectedValue + " and a.SchemeIsOpen = 0)");
                    if (dt == null)
                    {
                        GoError();
                        return;
                    }

                    int Fail = 0, Win = 0, WinNoBuy = 0;
                    //  成功数  失败数    中奖数   未买的中奖数
                    int SchemeOpenCount = 0; //开奖方案个数
                    DataSet ds = new DataSet();
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        string LotteryNumber = "";
                        try
                        {
                            LotteryNumber = ShoveEL._String.Decompress((byte[])dt.Rows[i]["LotteryNumber"]);
                        }
                        catch
                        {
                        }

                        string strBuyType = LotteryNumber.Trim().Split(';')[0].ToString();
                        int BuyType = ShoveEL._Convert.StrToInt(strBuyType, 0);

                        //拆分方案，得到方案的最大场次
                        string BuyNumber = LotteryNumber.Trim().Split(';')[1].ToString();
                        string Numbers = BuyNumber.Substring(1, BuyNumber.Length - 1).Substring(0, BuyNumber.Length - 2).ToString().Trim();

                        string[] TeamContent = Numbers.Split('|');

                        string MaxTeam = TeamContent[TeamContent.Length - 1].Substring(0, (TeamContent[TeamContent.Length - 1].IndexOf('(')));
                        //拆分结束

                        if (NowCompetitionCount >= ShoveEL._Convert.StrToInt(MaxTeam, 0))
                        {
                            string Description = "";
                            double WinMoneyNoWithTax = 0;
                            double WinMoney = 0;
                            //LotteryNumber = "4501;[1(3)];[120]";

                            //[Use Lottery_id]
                            WinMoney = new Lottery()[int.Parse(ddlLottery.SelectedValue)].ComputeWin(LotteryNumber, WinNumberList, ref Description, ref WinMoneyNoWithTax, BuyType, NowCompetitionCount, "");

                            string Return = "";
                            DataSet ds_2 = DAL.Procedures.P_SchemeWinDispense.Open(int.Parse(dt.Rows[i]["id"].ToString()),
                                WinMoney, WinMoneyNoWithTax, PublicFunction.GetOptionsAsInt("InitiateSchemeCommissionScale", 0),
                                ShoveEL._String.Compress(Description), user.ID,
                                ref Return);

                            if (Return != "")
                            {
                                Fail++;
                                continue;
                            }

                            if ((ds_2 == null) || (ds_2.Tables.Count == 0))
                            {
                                WinNoBuy++;
                                continue;
                            }

                            if (ds_2.Tables[0].Rows.Count == 0)
                            {
                                continue;
                            }

                            Win++;

                            DataTable temp_table = ds_2.Tables[0].Copy();
                            temp_table.TableName = "temp_table_" + i.ToString();

                            ds.Tables.Add(temp_table);
                            ds_2.Dispose();
                        }
                    }


                    if (CompetitionCount == NowCompetitionCount)
                    {
                        DAL.Tables.Isuse.Update("[id] = " + ddlIsuse.SelectedValue, -1, false, "", false, System.DateTime.Now, false,
                            System.DateTime.Now, false, false, false, tbWinNumber.Text, true, ShoveEL._String.Compress("无开奖模板"), true, true, true);
                    }

                    SendEmail_Message_MobileMessage(ds);
                    BindDataForIsuse();

                    user.GetUserInfoByID();

                    ShoveEL._Web.JavaScript.Alert(this.Page, String.Format("截至本场比赛为止：开奖成功，目前总方案 {0} 个，成功处理 {1} 个， 处理失败 {2} 个。其中：中奖方案 {3} 个，未成功但中奖方案 {4} 个。", dt.Rows.Count, dt.Rows.Count - Fail, Fail, Win, WinNoBuy));
                }

                this.DataListZCDC.EditItemIndex = -1;
            }

            BindData();
        }
    }

    private void BindData()
    {
        if (ShoveEL._Convert.StrToInt(ddlIsuse.SelectedValue, -1) > 0)
        {
            DataTable dt = DAL.Tables.Isuse.Select("", "[id]=" + ddlIsuse.SelectedValue, "");
            if ((dt == null) || (dt.Rows.Count < 1))
            {
                GoError();
                return;
            }

            dt = DAL.Views.V_ZCDCLeagueType.Select("", "Isuse_id = " + ddlIsuse.SelectedValue, "[No]");
            if ((dt == null) || (dt.Rows.Count < 1))
            {
                GoError();
                return;
            }

            DataListZCDC.DataSource = dt.DefaultView;
            DataListZCDC.DataBind();
        }
    }

    protected void DataListZCDC_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.EditItem)
        {
            TextBox tbResult = (TextBox)(e.Item.FindControl("tbResult"));
            TextBox tbHalftimeResult = (TextBox)(e.Item.FindControl("tbHalftimeResult"));
            TextBox tbLetBall = (TextBox)(e.Item.FindControl("tbLetBall"));
            TextBox tbSPFResult = (TextBox)(e.Item.FindControl("tbSPFResult"));
            TextBox tbZJQResult = (TextBox)(e.Item.FindControl("tbZJQResult"));
            TextBox tbSXDSResult = (TextBox)(e.Item.FindControl("tbSXDSResult"));
            TextBox tbZQBFResult = (TextBox)(e.Item.FindControl("tbZQBFResult"));
            TextBox tbBQCSPFResult = (TextBox)(e.Item.FindControl("tbBQCSPFResult"));

            DropDownList ddlLetBall = (DropDownList)(e.Item.FindControl("ddlLetBall"));
            DropDownList ddlGame1 = (DropDownList)(e.Item.FindControl("ddlGame1"));
            DropDownList ddlGame2 = (DropDownList)(e.Item.FindControl("ddlGame2"));
            DropDownList ddlHalftime1 = (DropDownList)(e.Item.FindControl("ddlHalftime1"));
            DropDownList ddlHalftime2 = (DropDownList)(e.Item.FindControl("ddlHalftime2"));
            DropDownList ddlSPF = (DropDownList)(e.Item.FindControl("ddlSPF"));
            DropDownList ddlZJQ = (DropDownList)(e.Item.FindControl("ddlZJQ"));
            DropDownList ddlSXDS = (DropDownList)(e.Item.FindControl("ddlSXDS"));
            DropDownList ddlZQBF = (DropDownList)(e.Item.FindControl("ddlZQBF"));
            DropDownList ddlBQCSPF = (DropDownList)(e.Item.FindControl("ddlBQCSPF"));

            Button btOpenWin = (Button)(e.Item.FindControl("btOpenWin"));

            CheckBox cbResultDelay = (CheckBox)(e.Item.FindControl("cbResultDelay"));

            if (tbResult.Text != "")
            {
                if (tbResult.Text != "*")
                {
                    string[] TmpResult = tbResult.Text.Split(':');
                    DropDownListDefault(ddlGame1, TmpResult[0], true);
                    DropDownListDefault(ddlGame2, TmpResult[1], true);
                }
                else
                {
                    cbResultDelay.Checked = true;
                }

                btOpenWin.Enabled = true;
            }
            else
            {
                btOpenWin.Enabled = false;
            }

            if (tbHalftimeResult.Text != "")
            {
                if (tbHalftimeResult.Text != "*")
                {
                    string[] TmpHalftimeResult = tbHalftimeResult.Text.Split(':');
                    DropDownListDefault(ddlHalftime1, TmpHalftimeResult[0], true);
                    DropDownListDefault(ddlHalftime2, TmpHalftimeResult[1], true);
                }
            }

            if (tbLetBall.Text != "")
            {
                DropDownListDefault(ddlLetBall, tbLetBall.Text, true);
            }

            if (tbSPFResult.Text != "")
            {
                DropDownListDefault(ddlSPF, tbSPFResult.Text, false);
            }

            if (tbZJQResult.Text != "")
            {
                DropDownListDefault(ddlZJQ, tbZJQResult.Text, false);
            }

            if (tbSXDSResult.Text != "")
            {
                DropDownListDefault(ddlSXDS, tbSXDSResult.Text, false);
            }

            if (tbZQBFResult.Text != "")
            {
                DropDownListDefault(ddlZQBF, tbZQBFResult.Text, true);
            }

            if (tbBQCSPFResult.Text != "")
            {
                DropDownListDefault(ddlBQCSPF, tbBQCSPFResult.Text, true);
            }
        }
    }

    private void DropDownListDefault(DropDownList ddl, string defaultValue, bool UserEnabled)
    {
        if (!ddl.Enabled)
        {
            ddl.Enabled = true;
        }

        foreach (ListItem item in ddl.Items)
        {
            if (item.Value == defaultValue)
            {
                item.Selected = true;
            }
        }

        ddl.Enabled = UserEnabled;
    }

    private void SendEmail_Message_MobileMessage(DataSet ds)
    {
        bool isWinSendEmail = PublicFunction.GetOptionsAsBoolean("isWinSendEmail", false);
        bool isWinSendMobileMessage = PublicFunction.GetOptionsAsBoolean("isWinSendMobileMessage", false);
        bool isWinSendMessage = PublicFunction.GetOptionsAsBoolean("isWinSendMessage", false);

        if ((!isWinSendEmail) && (!isWinSendMobileMessage) && (!isWinSendMessage))
        {
            ds.Dispose();
            return;
        }

        string Old_EmailSubject = "", Old_EmailBody = "";
        if (isWinSendEmail)
            PublicFunction.GetEmailTemplate("../Template/Email/Win.txt", ref Old_EmailSubject, ref Old_EmailBody);

        string Old_MobileMessageBody = "";
        if (isWinSendMobileMessage)
            Old_MobileMessageBody = PublicFunction.GetMobileMessageTemplate("../Template/MobileMessage/Win.txt");

        string Old_MessageBody = "";
        if (isWinSendMessage)
            Old_MessageBody = PublicFunction.GetMessageTemplate("../Template/Message/Win.txt");

        for (int i = 0; i < ds.Tables.Count; i++)
        {
            DataTable dt = ds.Tables[i];
            for (int j = 0; j < dt.Rows.Count; j++)
            {
                DataRow dr = dt.Rows[j];
                Users tu = new Users();
                tu.ID = int.Parse(dr["User_id"].ToString());
                int Result = tu.GetUserInfoByID();
                if ((Result != 0) && (Result != -3))
                    continue;

                //Send Email...
                if ((isWinSendEmail) && (tu.isAcceptEmail) && (tu.Email != "") && (Old_EmailSubject != "") && (Old_EmailBody != ""))
                {
                    string EmailSubject = Old_EmailSubject.Replace("[UserName]", tu.Name);
                    string EmailBody = Old_EmailBody.Replace("[UserName]", tu.Name).
                                                    Replace("[Scheme_id]", dr["Scheme_id"].ToString()).
                                                    Replace("[Money]", double.Parse(dr["WinMoney"].ToString()).ToString("N"));
                    PublicFunction.SendEmail(tu.Email, EmailSubject, EmailBody);
                }

                //Send MobileMessage.......................
                if (isWinSendMobileMessage && (tu.Mobile != "") && tu.MobileValid && tu.isAcceptMobileMessage && tu.GetIsAcceptMobileMessage("Win") && (Old_MobileMessageBody != ""))
                {
                    string MobileMessageBody = Old_MobileMessageBody.Replace("[UserName]", tu.Name).
                                                Replace("[Scheme_id]", dr["Scheme_id"].ToString()).
                                                Replace("[Money]", double.Parse(dr["WinMoney"].ToString()).ToString("N"));
                    new JL_ISP().SendMessage(tu.Mobile, MobileMessageBody, "", tu.ID);
                }

                //Send Message.......................
                if (isWinSendMessage && tu.isAcceptMessage && (Old_MessageBody != ""))
                {
                    string MessageBody = Old_MessageBody.Replace("[UserName]", tu.Name).
                        Replace("[Scheme_id]", dr["Scheme_id"].ToString()).
                        Replace("[Money]", double.Parse(dr["WinMoney"].ToString()).ToString("N"));

                    DAL.Tables.Message.Insert(1, true, tu.ID, true, 1, true, ShoveEL._String.Compress(MessageBody), true, System.DateTime.Now, false, true, false);
                }
            }
        }
        ds.Dispose();
    }
}