﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_MobileAccount : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        Single Balance = 0, Price = 0;
        string Type = "";
        DateTime RegTime = DateTime.Now;
        DateTime DenyTime = DateTime.Now;

        JL_ISP isp = new JL_ISP();
        int Result = isp.GetAccountInfo(ref Balance, ref Price, ref Type, ref RegTime, ref DenyTime);
        if (Result != 0)
        {
            GoError();
            return;
        }

        Label1.Text = Balance.ToString("N") + " 元";
        Label2.Text = Price.ToString("N") + " 元/条";
        Label3.Text = RegTime.ToString();
        Label4.Text = DenyTime.ToString();
        Label5.Text = Type;

        int SendCount = 0, CountWaitSend = 0, CountTestSend = 0;
        Result = isp.GetAccountUseCount(RegTime, System.DateTime.Now, ref SendCount, ref CountWaitSend, ref CountTestSend);
        if (Result != 0)
        {
            GoError();
            return;
        }
        Label6.Text = String.Format("使用以来，总计发送了 {0} 条短信。等待发送 {1} 条，测试发送 {2} 条。", SendCount, CountWaitSend, CountTestSend);
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "SendMobileMessage";
        base.OnInit(e);
    }
    #endregion
}