﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_MobileMessageReceive : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        JL_ISP isp = new JL_ISP();
        int Result = isp.ReceiveMessage();
        labTip.Text = "接收到 " + Result.ToString() + " 条新短信。";

        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "SendMobileMessage";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        int days = int.Parse(ddlDateTime.SelectedValue);
        string CmdStr;
        if (days == -1)
            CmdStr = "select * from MobileMessage where MsgID <> -1 order by [DateTime] desc";
        else
            CmdStr = "select * from MobileMessage where Datediff(day, [DateTime], GetDate()) <= " + days.ToString() + " and MsgID <> -1 order by [DateTime] desc";

        DataTable dt = MSSQL.Select(CmdStr);

        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }

    protected void ddlDateTime_SelectedIndexChanged(object sender, System.EventArgs e)
    {
        BindData();
    }
}