﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_News : AdminPage
{
    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            string Type = "";
            Type = this.Request["Type"];
            if (Type == null)
                Type = "";
            Type = Type.Trim();
            if (Type == "")
            {
                GoError("参数不正确");
                return;
            }
            tbType.Text = Type;

            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        DataTable dt = MSSQL.Select("select * from " + tbType.Text + " order by [DateTime] desc");
        if (dt == null)
            GoError();

        g.DataSource = dt;
        g.DataBind();
        gPager.Visible = (dt.Rows.Count > 0);
    }

    protected void g_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.EditItem)
        {
            CheckBox cb = (CheckBox)e.Item.Cells[2].FindControl("cbisShow");
            cb.Checked = ShoveEL._Convert.StrToBool(e.Item.Cells[6].Text, true);

            LinkButton lbdel = (LinkButton)e.Item.Cells[4].FindControl("btnDel");
            lbdel.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信要删除此条新闻资料吗？") + "');");
        }
    }

    protected void g_ItemCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
    {
        if (e.CommandName == "Edit")
        {
            this.Response.Redirect("NewsEdit.aspx?Type=" + tbType.Text + "&id=" + e.Item.Cells[5].Text, true);
            return;
        }
        if (e.CommandName == "Del")
        {
            if (MSSQL.ExecuteNonQuery("delete from " + tbType.Text + " where id=" + e.Item.Cells[5].Text) < 0)
            {
                GoError();
                return;
            }

            BindData();
            return;
        }
    }

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        this.Response.Redirect("NewsAdd.aspx?Type=" + tbType.Text, true);
    }

    protected void gPager_PageWillChange(object Sender, DragonWebControls.PageChangeEventArgs e)
    {
        BindData();
    }

    protected void gPager_SortBefore(object source, System.Web.UI.WebControls.DataGridSortCommandEventArgs e)
    {
        BindData();
    }
}