﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_NewsAdd : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            string Type = this.Request["Type"];
            if (Type == null)
                Type = "";
            Type = Type.Trim();
            if (Type == "")
            {
                GoError();
                return;
            }
            tbType.Text = Type;

            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        tbDateTime.Text = System.DateTime.Now.ToString();

        ddlImage.Items.Clear();
        ddlImage.Items.Add("--选择图片--");
        string[] FileList = ShoveEL._IO.File.GetFileList(this.Server.MapPath("../Images/NewsImage"));
        if (FileList != null)
        {
            for (int i = 0; i < FileList.Length; i++)
                ddlImage.Items.Add(FileList[i]);
        }
    }

    protected void btnAdd_Click(object sender, System.EventArgs e)
    {
        DateTime dt = System.DateTime.Now;
        try
        {
            dt = System.DateTime.Parse(tbDateTime.Text);
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "时间格式错误，请输入如“" + dt.ToString() + "”的时间格式。");
            return;
        }

        string Title = tbTitle.Text.Trim();
        if (Title == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入标题。");
            return;
        }

        string Image = "";
        if (tbImage.Value.Trim() != "")
        {
            if (ShoveEL._IO.File.UploadFile(this.Page, tbImage, "../Images/NewsImage/", ref Image, true) != 0)
            {
                ShoveEL._Web.JavaScript.Alert(this.Page, "图片文件上传错误！");
                return;
            }
        }
        else
        {
            if (ddlImage.SelectedIndex > 0)
                Image = ddlImage.SelectedItem.Text;
        }

        if (MSSQL.ExecuteNonQuery("insert into " + tbType.Text + " ([DateTime],[Title],[Content],isShow,[Image]) values (@p1,@p2,@p3,@p4,@p5)",
            new MSSQL.Parameter("p1", SqlDbType.DateTime, 0, ParameterDirection.Input, dt),
            new MSSQL.Parameter("p2", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
            new MSSQL.Parameter("p3", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbContent.Text)),
            new MSSQL.Parameter("p4", SqlDbType.Bit, 0, ParameterDirection.Input, cbisShow.Checked),
            new MSSQL.Parameter("p5", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)
            ) < 0)
            GoError();

        this.Response.Redirect("News.aspx?Type=" + tbType.Text, true);
    }
}