﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using ShoveEL.Database;

public partial class Admin_NewsEdit : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
        {
            string Type = this.Request["Type"];
            if (Type == null)
                Type = "";
            Type = Type.Trim();
            if (Type == "")
            {
                GoError();
                return;
            }
            tbType.Text = Type;

            int id = -1;
            id = ShoveEL._Convert.StrToInt(this.Request["id"], -1);
            if (id < 0)
            {
                GoError();
                return;
            }
            tbID.Text = id.ToString();

            BindData();
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "FillContent";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        ddlImage.Items.Clear();
        ddlImage.Items.Add("--选择图片--");
        string[] FileList = ShoveEL._IO.File.GetFileList(this.Server.MapPath("../Images/NewsImage"));
        if (FileList != null)
        {
            for (int i = 0; i < FileList.Length; i++)
                ddlImage.Items.Add(FileList[i]);
        }

        DataTable dt = MSSQL.Select("select * from " + tbType.Text + " where [id] = " + tbID.Text);
        if (dt == null)
            GoError();

        tbDateTime.Text = dt.Rows[0]["DateTime"].ToString();
        cbisShow.Checked = ShoveEL._Convert.StrToBool(dt.Rows[0]["isShow"].ToString(), true);
        tbTitle.Text = dt.Rows[0]["Title"].ToString();
        try
        {
            tbContent.Text = ShoveEL._String.Decompress((byte[])dt.Rows[0]["Content"]);
        }
        catch { }

        ShoveEL.ControlExt.SetDownListBoxText(ddlImage, dt.Rows[0]["Image"].ToString());
        tbOldImage.Text = dt.Rows[0]["Image"].ToString().Trim();

        if (dt.Rows[0]["Image"].ToString().Trim() == "")
        {
            cbNoEditImage.Checked = false;
            cbNoEditImage.Visible = false;
        }
    }

    protected void btnSave_Click(object sender, System.EventArgs e)
    {
        DateTime dt = System.DateTime.Now;
        try
        {
            dt = System.DateTime.Parse(tbDateTime.Text);
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "时间格式错误，请输入如“" + dt.ToString() + "”的时间格式。");
            return;
        }

        string Title = tbTitle.Text.Trim();
        if (Title == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入标题。");
            return;
        }

        string Image = "";
        if (cbNoEditImage.Checked)
            Image = tbOldImage.Text;
        else
        {
            if (tbImage.Value.Trim() != "")
            {
                if (ShoveEL._IO.File.UploadFile(this.Page, tbImage, "../Images/NewsImage/", ref Image, true) != 0)
                {
                    ShoveEL._Web.JavaScript.Alert(this.Page, "图片文件上传错误！");
                    return;
                }
            }
            else
            {
                if (ddlImage.SelectedIndex > 0)
                    Image = ddlImage.SelectedItem.Text;
            }
        }

        if (MSSQL.ExecuteNonQuery("update " + tbType.Text + " set [DateTime] = @p1, [Title] = @p2, [Content] = @p3, isShow = @p4, [Image] = @p5 where [id] = " + tbID.Text,
            new MSSQL.Parameter("p1", SqlDbType.DateTime, 0, ParameterDirection.Input, dt),
            new MSSQL.Parameter("p2", SqlDbType.VarChar, 0, ParameterDirection.Input, Title),
            new MSSQL.Parameter("p3", SqlDbType.Image, 0, ParameterDirection.Input, ShoveEL._String.Compress(tbContent.Text)),
            new MSSQL.Parameter("p4", SqlDbType.Bit, 0, ParameterDirection.Input, cbisShow.Checked),
            new MSSQL.Parameter("p5", SqlDbType.VarChar, 0, ParameterDirection.Input, Image)) < 0)
        {
            GoError();
            return;
        }

        //ShoveEL._Web.JavaScript.Alert(this.Page, "保存成功！");
        this.Response.Redirect("News.aspx?Type=" + tbType.Text, true);
    }
}