﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_OptionDataBackup : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            btnOK.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信要备份数据表吗？") + "');");
            btnOK_2.Attributes.Add("onclick", "return confirm('" + System.Web.HttpUtility.HtmlEncode("您确信要备份整个数据库吗？") + "');");
        }
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Option";
        isRequestSuperManagementRights = true;
        base.OnInit(e);
    }
    #endregion

    protected void btnOK_Click(object sender, EventArgs e)
    {
        byte[] Result = ShoveEL.Database.MSSQL.BackupDataToZipStream();

        if (Result == null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "数据表备份失败！");
            return;
        }

        HttpResponse response;
        response = Page.Response;
        response.AppendHeader("Content-Disposition", "attachment;filename=ShoveLottery_DataBackup_" + System.DateTime.Now.ToString().Replace("-", "_").Replace(" ", "_").Replace(":", "_") + ".zip");
        Response.ContentType = "application/octet-stream";
        Response.BinaryWrite(Result);
        Response.Flush();
        response.End();
    }

    protected void btnOK_2_Click(object sender, EventArgs e)
    {
        SqlConnection conn = ShoveEL.Database.MSSQL.CreateDataConnection();
        if (conn == null)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "数据库备份失败！");
            return;
        }

        string DatabaseName = this.Server.MapPath("../Database/" + conn.Database + ".bak");
        string ShortName = conn.Database + ".zip";

        conn.Close();

        if (ShoveEL.Database.MSSQL.BackupDatabase(DatabaseName, true, true) < 0)
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "数据库备份失败！");
            return;
        }

        HttpResponse response;
        response = Page.Response;
        response.AppendHeader("Content-Disposition", "attachment;filename=" + ShortName);
        Response.ContentType = "application/octet-stream";
        Response.WriteFile(DatabaseName + ".zip");
        Response.Flush();
        response.End();
    }
}
