﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_OptionMemberSharing : AdminPage
{
    public static bool MemberSharing_Alipay_Status_ON = false;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindData();
        }

        tb20006.Attributes.Add("value", tb20006.Text);
    }

    private void BindData()
    {
        MemberSharing_Alipay_Status_ON = PublicFunction.GetOptionsAsBoolean("MemberSharing_Alipay_Status_ON", false);

        cb20002.Checked = PublicFunction.GetOptionsAsBoolean("MemberSharing_Alipay_Status_ON", false);
        tb20004.Text = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_UserNumber");
        tb20006.Text = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_MD5");
        tb20007.Text = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_ON_Cert");

        tbMemberSharingNum.Text = PublicFunction.GetMID();
        tbMemberSharingNum.ReadOnly = true;

        if (!MemberSharing_Alipay_Status_ON)
        {
            int AYearLater = DateTime.Now.Year + 1;
            string strAYearLater = AYearLater.ToString() + "-" + DateTime.Now.Month.ToString() + "-" + DateTime.Now.Day.ToString();

            tbMaturity.Text = strAYearLater;
        }
        else
        {
            tbMaturity.Text = PublicFunction.GetOptionsAsString("MemberSharing_Alipay_Maturity");
        }
    }

    protected void btnOK_Click(object sender, EventArgs e)
    {
        PublicFunction.SetOptions("MemberSharing_Alipay_Status_ON", cb20002.Checked);
        PublicFunction.SetOptions("MemberSharing_Alipay_UserNumber", tb20004.Text.Trim());
        PublicFunction.SetOptions("MemberSharing_Alipay_MD5", tb20006.Text.Trim());
        PublicFunction.SetOptions("MemberSharing_Alipay_ON_Cert", tb20007.Text.Trim());
        PublicFunction.SetOptions("MemberSharing_Alipay_Maturity", tbMaturity.Text.Trim());

        ShoveEL._Web.JavaScript.Alert(this.Page, "设置成功。");
    }
}
