﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_OptionMobileCheck : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Option";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        int MobileCheckCharset = PublicFunction.GetOptionsAsInt("MobileCheckCharset", 4);
        int MobileCheckStringLength = PublicFunction.GetOptionsAsInt("MobileCheckStringLength", 6);
        
        if ((MobileCheckCharset < 1) || (MobileCheckCharset > 4))
        {
            MobileCheckCharset = 4;
        }

        if ((MobileCheckStringLength < 1) || (MobileCheckStringLength > 70))
        {
            MobileCheckCharset = 6;
        }

        ddlCharset.SelectedIndex = MobileCheckCharset - 1;
        tbLen.Text = MobileCheckStringLength.ToString();
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        PublicFunction.SetOptions("MobileCheckCharset", ddlCharset.SelectedValue);
        PublicFunction.SetOptions("MobileCheckStringLength", tbLen.Text);

        ShoveEL._Web.JavaScript.Alert(this.Page, "设置成功。");
    }
}