﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

public partial class Admin_OptionMobileMessage : AdminPage
{

    protected void Page_Load(object sender, System.EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();

        tb4.Attributes.Add("value", tb4.Text);
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Option";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        tb1.Text = PublicFunction.GetOptionsAsString("ISP_HostName");
        tb2.Text = PublicFunction.GetOptionsAsString("ISP_HostPort");
        tb3.Text = PublicFunction.GetOptionsAsString("ISP_UserID");
        tb4.Text = PublicFunction.GetOptionsAsString("ISP_UserPassword");
        tb5.Text = PublicFunction.GetOptionsAsString("ISP_RegCode");
        tb6.Text = PublicFunction.GetOptionsAsString("ISP_ServiceNumber");

        cb1.Checked = PublicFunction.GetOptionsAsBoolean("isRegisterSendMobileMessage", false);
        cb2.Checked = PublicFunction.GetOptionsAsBoolean("isRegisterAdvSendMobileMessage", false);
        cb3.Checked = PublicFunction.GetOptionsAsBoolean("isForgetPasswordSendMobileMessage", false);
        cb4.Checked = PublicFunction.GetOptionsAsBoolean("isUserEditSendMobileMessage", false);
        cb5.Checked = PublicFunction.GetOptionsAsBoolean("isUserEditAdvSendMobileMessage", false);
        cb6.Checked = PublicFunction.GetOptionsAsBoolean("isBuy_InitiateSendMobileMessage", false);
        cb7.Checked = PublicFunction.GetOptionsAsBoolean("isBuy_DSendMobileMessage", false);
        cb8.Checked = PublicFunction.GetOptionsAsBoolean("isBuy_JoinSendMobileMessage", false);
        cb9.Checked = PublicFunction.GetOptionsAsBoolean("isChaseSendMobileMessage", false);
        cb10.Checked = PublicFunction.GetOptionsAsBoolean("isChaseExecSendMobileMessage", false);
        cb11.Checked = PublicFunction.GetOptionsAsBoolean("isDistillSendMobileMessage", false);
        cb12.Checked = PublicFunction.GetOptionsAsBoolean("isDistillAcceptSendMobileMessage", false);
        cb13.Checked = PublicFunction.GetOptionsAsBoolean("isDistillNoAcceptSendMobileMessage", false);
        cb14.Checked = PublicFunction.GetOptionsAsBoolean("isQuashSendMobileMessage", false);
        cb15.Checked = PublicFunction.GetOptionsAsBoolean("isQuashSchemeSendMobileMessage", false);
        cb16.Checked = PublicFunction.GetOptionsAsBoolean("isQuashChaseSendMobileMessage", false);
        cb17.Checked = PublicFunction.GetOptionsAsBoolean("isQuashChaseAllSendMobileMessage", false);
        cb18.Checked = PublicFunction.GetOptionsAsBoolean("isWinSendMobileMessage", false);

        tb7.Text = PublicFunction.GetOptionsAsString("MobileMessagePrice");
        if (PublicFunction.GetOptionsAsInt("MobileMessagePayType", 2) == 1)
        {
            rb1.Checked = true;
            rb2.Checked = false;
        }
        else
        {
            rb1.Checked = false;
            rb2.Checked = true;
        }
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        PublicFunction.SetOptions("ISP_HostName", tb1.Text.Trim());
        PublicFunction.SetOptions("ISP_HostPort", tb2.Text.Trim());
        PublicFunction.SetOptions("ISP_UserID", tb3.Text.Trim());
        PublicFunction.SetOptions("ISP_UserPassword", tb4.Text.Trim());
        PublicFunction.SetOptions("ISP_RegCode", tb5.Text.Trim());
        PublicFunction.SetOptions("ISP_ServiceNumber", tb6.Text.Trim());

        PublicFunction.SetOptions("isRegisterSendMobileMessage", cb1.Checked);
        PublicFunction.SetOptions("isRegisterAdvSendMobileMessage", cb2.Checked);
        PublicFunction.SetOptions("isForgetPasswordSendMobileMessage", cb3.Checked);
        PublicFunction.SetOptions("isUserEditSendMobileMessage", cb4.Checked);
        PublicFunction.SetOptions("isUserEditAdvSendMobileMessage", cb5.Checked);
        PublicFunction.SetOptions("isBuy_InitiateSendMobileMessage", cb6.Checked);
        PublicFunction.SetOptions("isBuy_DSendMobileMessage", cb7.Checked);
        PublicFunction.SetOptions("isBuy_JoinSendMobileMessage", cb8.Checked);
        PublicFunction.SetOptions("isChaseSendMobileMessage", cb9.Checked);
        PublicFunction.SetOptions("isChaseExecSendMobileMessage", cb10.Checked);
        PublicFunction.SetOptions("isDistillSendMobileMessage", cb11.Checked);
        PublicFunction.SetOptions("isDistillAcceptSendMobileMessage", cb12.Checked);
        PublicFunction.SetOptions("isDistillNoAcceptSendMobileMessage", cb13.Checked);
        PublicFunction.SetOptions("isQuashSendMobileMessage", cb14.Checked);
        PublicFunction.SetOptions("isQuashSchemeSendMobileMessage", cb15.Checked);
        PublicFunction.SetOptions("isQuashChaseSendMobileMessage", cb16.Checked);
        PublicFunction.SetOptions("isQuashChaseAllSendMobileMessage", cb17.Checked);
        PublicFunction.SetOptions("isWinSendMobileMessage", cb18.Checked);

        PublicFunction.SetOptions("MobileMessagePrice", ShoveEL._Convert.StrToDouble(tb7.Text.Trim(), 0.1));
        PublicFunction.SetOptions("MobileMessagePayType", rb1.Checked ? 1 : 2);

        ShoveEL._Web.JavaScript.Alert(this.Page, "设置成功。");
    }
}