﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using ShoveEL.Database;

public partial class Admin_OptionRegister : AdminPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
            BindData();
    }

    #region Web 窗体设计器生成的代码
    override protected void OnInit(EventArgs e)
    {
        //
        // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
        //
        RequestManagementRightsType = "Option";
        base.OnInit(e);
    }
    #endregion

    private void BindData()
    {
        tbMID.Text = PublicFunction.GetMID();
        tbSN.Text = PublicFunction.GetOptionsAsString("SystemRegisterInformation_SN");
        string Ver = PublicFunction.GetOptionsAsString("SystemRegisterInformation_VersionType");
        if ((Ver != "1") && (Ver != "2") && (Ver != "3") && (Ver != "4"))
        {
            Ver = "1";
        }

        ((RadioButton)this.Page.FindControl("rbVer" + Ver)).Checked = true;

        DataTable dt = DAL.Tables.Lottery.Select("[id],[Name],[Sort]", "", "[id]");
        if (dt == null)
        {
            GoError();
            return;
        }

        g.DataSource = dt.DefaultView;
        g.DataBind();
    }

    protected void g_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            DataKey key = g.DataKeys[g.DataKeys.Count - 1];

            string Lottery_id = "," + key.Values[0].ToString() + ",";
            string LotteryList = "," + PublicFunction.GetOptionsAsString("SystemRegisterInformation_LotteryList") + ",";
            ((CheckBox)e.Row.Cells[1].FindControl("cbisUsed")).Checked = (LotteryList.IndexOf(Lottery_id) >= 0);
        }
    }

    protected void btnOK_Click(object sender, System.EventArgs e)
    {
        if (tbSN.Text.Trim() == "")
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "请输入注册码。");
            return;
        }

        string LotteryList = "";
        for (int i = 0; i < g.Rows.Count; i++)
        {
            if (((CheckBox)g.Rows[i].Cells[1].FindControl("cbisUsed")).Checked)
            {
                DataKey key = g.DataKeys[i];

                string Lottery_id = key.Values[0].ToString();
                LotteryList += (LotteryList == "" ? "" : ",") + Lottery_id;
            }
        }

        string Version = rbVer1.Checked ? "1" : (rbVer2.Checked ? "2" : (rbVer3.Checked ? "3" : "4"));
        if (!PublicFunction.ValidSN(tbMID.Text, LotteryList, Version, tbSN.Text.Trim(), ""))
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "注册码错误，请重新输入！");
            return;
        }

        try
        {
            PublicFunction.SetOptions("SystemRegisterInformation_LotteryList", LotteryList);
            PublicFunction.SetOptions("SystemRegisterInformation_SN", tbSN.Text.Trim());
            PublicFunction.SetOptions("SystemRegisterInformation_VersionType", Version);

            DAL.Procedures.P_SetIsUsedLotteryList.Call(LotteryList);

            // 写新的彩种顺序
            WriteLotteryOrder();


            // 部分机器在 Global.asax.cs 中取的机器码不同，这里写入第2注册信息。
            string MID_2 = "";
            try
            {
                MID_2 = Application[ShoveEL._Web.WebConfig.GetAppSettingsString("SystemPreFix") + "MID"].ToString();
            }
            catch { }

            if ((MID_2 != "") && (MID_2 != tbMID.Text))
            {
                string SN_2 = ShoveEL._Security.Encrypt.NoUnEncryptString("CherySoft CO.,Ltd -- by Shove 20050709 深圳宝安", MID_2 + Version + LotteryList + "!(&(!!#)", "SSL" + Version + "-", 5, 5, 0);
                PublicFunction.SetOptions("SystemRegisterInformation_SN_2", SN_2);
            }
            // 写入第2注册信息结束


            ShoveEL._Web.JavaScript.Alert(this.Page, "设置成功。系统将在重新登陆时校验注册是否正确，谢谢。");
        }
        catch
        {
            ShoveEL._Web.JavaScript.Alert(this.Page, "文件不能写入，可能是服务器目录没有写权限。");
        }
    }

    private void WriteLotteryOrder()
    {
        for (int i = 0; i < g.Rows.Count; i++)
        {
            int Order = ShoveEL._Convert.StrToInt(((TextBox)g.Rows[i].Cells[2].FindControl("tbOrder")).Text, 0);

            DataKey key = g.DataKeys[i];
            string Lottery_id = key.Values[0].ToString();

            MSSQL.ExecuteNonQuery("Update Lottery set [Sort] = " + Order.ToString() + " where [id] = " + Lottery_id);
        }
    }
}